/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.editor.TexEditorTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexHardLineWrapAction
implements IEditorActionDelegate {
    private IEditorPart targetEditor;
    private int tabWidth = 2;
    private int lineLength = 80;
    private TexEditorTools tools = new TexEditorTools();
    private static Set environmentsToProcess = new HashSet();

    static {
        environmentsToProcess.add("document");
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void run(IAction action) {
        this.lineLength = TexlipsePlugin.getDefault().getPreferenceStore().getInt("lineLength");
        this.tabWidth = TexlipsePlugin.getDefault().getPreferenceStore().getInt("tabWidth");
        TexSelections selection = new TexSelections((ITextEditor)this.getTexEditor());
        try {
            this.doWrapB(selection);
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexCorrectIndentationAction.run", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof TextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.targetEditor instanceof ITextEditor);
    }

    private TexEditor getTexEditor() {
        if (this.targetEditor instanceof TexEditor) {
            return (TexEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    private void doWrap(TexSelections selection) throws BadLocationException {
        boolean itemFound = false;
        IDocument document = selection.getDocument();
        selection.selectParagraph();
        String delimiter = document.getLineDelimiter(selection.getStartLineIndex());
        String[] lines = selection.getCompleteSelection().split(delimiter);
        if (lines.length == 0) {
            return;
        }
        int index = 0;
        StringBuffer buff = new StringBuffer();
        boolean fix = true;
        String selectedLine = "";
        String correctIndentation = "";
        while (index < lines.length) {
            if (this.tools.isLineCommandLine(lines[index]) || this.tools.isLineCommentLine(lines[index]) || lines[index].trim().length() == 0) {
                buff.append(lines[index]);
                if (lines[index].trim().length() == 0 || this.isList(lines[index])) {
                    fix = true;
                }
                if (++index >= lines.length) continue;
                buff.append(delimiter);
                continue;
            }
            if (fix) {
                correctIndentation = this.tools.getIndentation(lines[index], this.tabWidth);
                fix = false;
            }
            StringBuffer temp = new StringBuffer();
            boolean end = false;
            while (index < lines.length && !end) {
                if (!this.tools.isLineCommandLine(lines[index]) && !this.tools.isLineCommentLine(lines[index]) && lines[index].trim().length() > 0) {
                    if (lines[index].trim().startsWith("\\item") && !itemFound) {
                        end = true;
                        itemFound = true;
                        continue;
                    }
                    temp.append(String.valueOf(lines[index].trim()) + " ");
                    itemFound = false;
                    if (lines[index].trim().endsWith("\\\\")) {
                        end = true;
                    }
                    ++index;
                    continue;
                }
                end = true;
            }
            int wsLast = 0;
            selectedLine = temp.toString().trim();
            while (selectedLine.length() > 0) {
                wsLast = this.tools.getLastWSPosition(selectedLine, this.lineLength - correctIndentation.length()) + 1;
                if (wsLast == 0) {
                    wsLast = this.tools.getFirstWSPosition(selectedLine, this.lineLength - correctIndentation.length()) + 1;
                }
                if (wsLast == 0 || wsLast > selectedLine.length() || selectedLine.length() < this.lineLength - correctIndentation.length()) {
                    wsLast = selectedLine.length();
                }
                buff.append(correctIndentation);
                buff.append(selectedLine.substring(0, wsLast));
                selectedLine = selectedLine.substring(wsLast);
                selectedLine = this.tools.trimBegin(selectedLine);
                if (index >= lines.length && selectedLine.length() <= 0) continue;
                buff.append(delimiter);
            }
        }
        document.replace(document.getLineOffset(selection.getStartLineIndex()), selection.getSelLength(), buff.toString());
    }

    private boolean isList(String txt) {
        String end;
        String env;
        boolean rv = false;
        int bi = -1;
        bi = txt.indexOf("\\begin");
        if (bi != -1 && ((env = this.tools.getEnvironment(end = this.tools.getEndLine(txt.substring(bi), "\\begin"))).equals("itemize") || env.equals("enumerate") || env.equals("description"))) {
            rv = true;
        }
        return rv;
    }

    private void doWrapB(TexSelections selection) throws BadLocationException {
        selection.selectParagraph();
        String delimiter = this.tools.getLineDelimiter(selection.getDocument());
        IDocument document = selection.getDocument();
        String[] lines = document.get(document.getLineOffset(selection.getStartLineIndex()), selection.getSelLength()).split(delimiter);
        if (lines.length == 0) {
            return;
        }
        String endNewlines = this.tools.getNewlinesAtEnd(document.get(document.getLineOffset(selection.getStartLineIndex()), selection.getSelLength()), delimiter);
        StringBuffer newText = new StringBuffer();
        TextWrapper wrapper = new TextWrapper(this.tools, delimiter);
        boolean inEnvironment = false;
        String environment = "";
        String indentation = "";
        int index = 0;
        while (index < lines.length) {
            String trimmedLine = lines[index].trim();
            if (this.tools.isLineCommandLine(trimmedLine) || inEnvironment) {
                newText.append(wrapper.loadWrapped(indentation));
                newText.append(lines[index]);
                newText.append(delimiter);
                String[] command = this.tools.getEnvCommandArg(trimmedLine);
                if (!environmentsToProcess.contains(command[1])) {
                    if ("begin".equals(command[0]) && !inEnvironment) {
                        inEnvironment = true;
                        environment = command[1];
                    } else if ("end".equals(command[0]) && inEnvironment && environment.equals(command[0])) {
                        inEnvironment = false;
                        environment = "";
                    }
                }
            } else if (trimmedLine.length() == 0) {
                newText.append(wrapper.loadWrapped(indentation));
                newText.append(lines[index]);
                newText.append(delimiter);
            } else {
                String newIndentation;
                if (this.tools.isLineCommentLine(trimmedLine)) {
                    newIndentation = this.tools.getIndentationWithComment(lines[index]);
                    trimmedLine = trimmedLine.substring(1).trim();
                } else {
                    newIndentation = this.tools.getIndentation(lines[index], this.tabWidth);
                }
                if (!indentation.equals(newIndentation)) {
                    newText.append(wrapper.loadWrapped(indentation));
                }
                indentation = newIndentation;
                wrapper.storeUnwrapped(trimmedLine);
                if (trimmedLine.endsWith("\\\\") || trimmedLine.endsWith(".") || trimmedLine.endsWith(":")) {
                    newText.append(wrapper.loadWrapped(indentation));
                }
            }
            ++index;
        }
        newText.append(wrapper.loadWrapped(indentation));
        newText.delete(newText.length() - delimiter.length(), newText.length());
        newText.append(endNewlines);
        document.replace(document.getLineOffset(selection.getStartLineIndex()), selection.getSelLength(), newText.toString());
    }

    private class TextWrapper {
        private StringBuffer tempBuf = new StringBuffer();
        private TexEditorTools tools;
        private String delimiter;

        TextWrapper(TexEditorTools tet, String delim) {
            this.tools = tet;
            this.delimiter = delim;
        }

        private void storeUnwrapped(String s) {
            this.tempBuf.append(s);
            this.tempBuf.append(" ");
        }

        private String loadWrapped(String indentation) {
            String wrapped = this.tools.wrapWordString(this.tempBuf.toString(), indentation, TexHardLineWrapAction.this.lineLength, this.delimiter);
            this.tempBuf = new StringBuffer();
            return wrapped;
        }
    }
}

