/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.ColorManager;
import net.sourceforge.texlipse.editor.TeXSpellingReconcileStrategy;
import net.sourceforge.texlipse.editor.TexAnnotationHover;
import net.sourceforge.texlipse.editor.TexAutoIndentStrategy;
import net.sourceforge.texlipse.editor.TexCompletionProcessor;
import net.sourceforge.texlipse.editor.TexEditor;
import net.sourceforge.texlipse.editor.TexMathCompletionProcessor;
import net.sourceforge.texlipse.editor.hover.TexHover;
import net.sourceforge.texlipse.editor.partitioner.FastLaTeXPartitionScanner;
import net.sourceforge.texlipse.editor.scanner.TexArgScanner;
import net.sourceforge.texlipse.editor.scanner.TexCommentScanner;
import net.sourceforge.texlipse.editor.scanner.TexMathScanner;
import net.sourceforge.texlipse.editor.scanner.TexOptArgScanner;
import net.sourceforge.texlipse.editor.scanner.TexScanner;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class TexSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private TexEditor editor;
    private TexMathScanner mathScanner;
    private TexScanner scanner;
    private TexCommentScanner commentScanner;
    private TexArgScanner argumentScanner;
    private TexOptArgScanner optArgumentScanner;
    private RuleBasedScanner verbatimScanner;
    private ColorManager colorManager;
    private TexAnnotationHover annotationHover;
    private ContentAssistant assistant;
    private TexHover textHover;
    private IAutoEditStrategy autoIndentStrategy;
    private static final DefaultInformationControl.IInformationPresenter presenter = new DefaultInformationControl.IInformationPresenter(){

        public String updatePresentation(Display display, String infoText, TextPresentation presentation, int maxWidth, int maxHeight) {
            int cstart = -1;
            int gstart = -1;
            int i = 0;
            while (i < infoText.length()) {
                switch (infoText.charAt(i)) {
                    case '{': {
                        if (cstart >= 0 && infoText.charAt(i - 1) != '\\') {
                            this.boldRange(cstart, i - cstart, presentation, false);
                            cstart = -1;
                            gstart = i;
                            break;
                        }
                        if (cstart >= 0) break;
                        gstart = i;
                        break;
                    }
                    case '}': {
                        if (cstart >= 0 && infoText.charAt(i - 1) != '\\') {
                            this.boldRange(cstart, i - cstart, presentation, true);
                            cstart = -1;
                            if (gstart < 0) break;
                            this.italicizeRange(gstart, cstart - gstart + 1, presentation);
                            gstart = -1;
                            break;
                        }
                        if (gstart < 0) break;
                        this.italicizeRange(gstart, i - gstart + 1, presentation);
                        gstart = -1;
                        break;
                    }
                    case '\\': {
                        if (cstart >= 0 || gstart >= 0) break;
                        cstart = i;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (cstart < 0) break;
                        if (gstart >= 0) {
                            this.italicizeRange(gstart, cstart - gstart, presentation);
                            this.boldRange(cstart, i - cstart, presentation, true);
                            gstart = i;
                        } else {
                            this.boldRange(cstart, i - cstart, presentation, false);
                        }
                        cstart = -1;
                    }
                }
                ++i;
            }
            if (gstart >= 0) {
                this.italicizeRange(gstart, infoText.length() - gstart, presentation);
            }
            if (cstart >= 0) {
                this.boldRange(cstart, infoText.length() - cstart, presentation, false);
            }
            return infoText;
        }

        private void boldRange(int start, int length, TextPresentation presentation, boolean doItalic) {
            int fontStyle = doItalic ? 3 : 1;
            StyleRange range = new StyleRange(start, length, null, null, fontStyle);
            presentation.addStyleRange(range);
        }

        private void italicizeRange(int start, int length, TextPresentation presentation) {
            StyleRange range = new StyleRange(start, length, null, null, 2);
            presentation.addStyleRange(range);
        }
    };

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        if (!TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("eclipseBuildInSpellChecker")) {
            return null;
        }
        PreferenceStore store = new PreferenceStore();
        store.setValue("spellingEngine", "net.sourceforge.texlipse.LaTeXSpellEngine");
        store.setValue("spellingEnabled", true);
        SpellingService spellingService = new SpellingService((IPreferenceStore)store);
        if (spellingService.getActiveSpellingEngineDescriptor((IPreferenceStore)store) == null) {
            return null;
        }
        TeXSpellingReconcileStrategy strategy = new TeXSpellingReconcileStrategy(sourceViewer, spellingService);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, true);
        reconciler.setDelay(500);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        return reconciler;
    }

    public TexSourceViewerConfiguration(TexEditor editor) {
        super(EditorsUI.getPreferenceStore());
        this.editor = editor;
        this.colorManager = new ColorManager();
        this.annotationHover = new TexAnnotationHover();
        TexlipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (TexSourceViewerConfiguration.this.assistant == null) {
                    return;
                }
                String property = event.getProperty();
                if ("texCompletion".equals(property)) {
                    TexSourceViewerConfiguration.this.assistant.enableAutoActivation(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("texCompletion"));
                } else if ("texDelay".equals(property)) {
                    TexSourceViewerConfiguration.this.assistant.setAutoActivationDelay(TexlipsePlugin.getDefault().getPreferenceStore().getInt("texDelay"));
                }
            }
        });
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.annotationHover;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.autoIndentStrategy == null) {
            this.autoIndentStrategy = new TexAutoIndentStrategy();
        }
        return new IAutoEditStrategy[]{this.autoIndentStrategy};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__tex_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return FastLaTeXPartitionScanner.TEX_PARTITION_TYPES;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.assistant = new ContentAssistant();
        this.assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        TexCompletionProcessor tcp = new TexCompletionProcessor(this.editor.getDocumentModel(), sourceViewer);
        TexMathCompletionProcessor tmcp = new TexMathCompletionProcessor(this.editor.getDocumentModel(), sourceViewer);
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)tcp, "__dftl_partition_content_type");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)tmcp, "__tex_mathPartition");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)tcp, "__tex_curlyBracketPartition");
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)tcp, "__tex_squareBracketPartition");
        this.assistant.enableAutoActivation(TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("texCompletion"));
        this.assistant.enableAutoInsert(true);
        this.assistant.setAutoActivationDelay(TexlipsePlugin.getDefault().getPreferenceStore().getInt("texDelay"));
        this.assistant.setProposalPopupOrientation(10);
        this.assistant.setContextInformationPopupOrientation(20);
        this.assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return this.assistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = null;
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTexVerbatimScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tex_VerbatimPartition");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tex_VerbatimPartition");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTeXMathScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tex_mathPartition");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tex_mathPartition");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTexCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tex_commentPartition");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tex_commentPartition");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTexArgScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tex_curlyBracketPartition");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tex_curlyBracketPartition");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTexOptArgScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tex_squareBracketPartition");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tex_squareBracketPartition");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getTexScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    protected TexScanner getTexScanner() {
        if (this.scanner == null) {
            this.scanner = new TexScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("def.TexColor"), null, this.colorManager.getStyle("def.TexStyle"))));
        }
        return this.scanner;
    }

    protected TexMathScanner getTeXMathScanner() {
        if (this.mathScanner == null) {
            this.mathScanner = new TexMathScanner(this.colorManager);
            this.mathScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("equ.TexColor"), null, this.colorManager.getStyle("equ.TexStyle"))));
        }
        return this.mathScanner;
    }

    protected TexCommentScanner getTexCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new TexCommentScanner(this.colorManager);
            this.commentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("com.TexColor"), null, this.colorManager.getStyle("com.TexStyle"))));
        }
        return this.commentScanner;
    }

    protected TexArgScanner getTexArgScanner() {
        if (this.argumentScanner == null) {
            this.argumentScanner = new TexArgScanner(this.colorManager);
            this.argumentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("crl.TexColor"), null, this.colorManager.getStyle("crl.TexStyle"))));
        }
        return this.argumentScanner;
    }

    protected TexOptArgScanner getTexOptArgScanner() {
        if (this.optArgumentScanner == null) {
            this.optArgumentScanner = new TexOptArgScanner(this.colorManager);
            this.optArgumentScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("sqr.TexColor"), null, this.colorManager.getStyle("sqr.TexStyle"))));
        }
        return this.optArgumentScanner;
    }

    protected RuleBasedScanner getTexVerbatimScanner() {
        if (this.verbatimScanner == null) {
            this.verbatimScanner = new RuleBasedScanner();
            this.verbatimScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("verb.TexColor"), null, this.colorManager.getStyle("verb.TexStyle"))));
        }
        return this.verbatimScanner;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new TexHover(this.editor);
        }
        return this.textHover;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, presenter);
            }
        };
    }
}

