## -*-Tcl-*-
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "alphaMenus.tcl"
 #                                    created: 98-04-07 07.36.22 
 #                                last update: 1999-09-04T13:47:58Z 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.santafe.edu/~vince/>
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # Description:
 # 
 #  Initialises variables which contain the global menus.  If you 
 #  use the smarterSource package, you can over-ride these quite
 #  easily.  This file is sourced by the procedure 'menu::buildSome'
 #  which handles menu building.
 # ###################################################################
 ##
#  File menu  #
set menu::items(File) {
	"/Nnew"
	"/Oopen"
	"<S/Wclose"
	"<S<O<U/WcloseFloat"
	"<S<I<O/WcloseAll"
	"(-"
	"<S/Ssave"
	"<S<B<O/SsaveUnmodified"
	"<S<I<O/SsaveAll"
	"<SsaveACopyAs"
	"<S<UrenameTo"
	"<SsaveAs"
	"<E<SrevertToBackup"
	"<Srevert"
	"(-"
	{Menu -n fileUtils -p menu::fileUtils {}}
	"(-"
	"pageSetup"
	"/P<Sprint"
	"printAll"
	"(-"
	"/Qquit"
}
lappend menu::which_subs(File) "fileUtils"
set menu::proc(File) menu::fileProc

#  Edit menu  #
set menu::items(Edit) {
	"/Zundo"
	"/Z<I<Oredo"
	"(-"
	"/X<Scut"
	"/C<Scopy"
	"/V<Spaste"
	"/A<SselectAll"
	"/A<S<I<OselectParagraph"
	"clear"
	"(-"
	"/`<Stwiddle"
	"/`<S<I<OtwiddleWords" 
	"(-" 
	{/[<SshiftLeft} 
	{/[<S<I<OshiftLeftSpace} 
	{/]<SshiftRight} 
	{/]<S<I<OshiftRightSpace} 
	"/Bbalance" 
}

#  Text menu  #
set menu::items(Text) {
	"/I<SfillParagraph"
	"/I<S<O<IwrapParagraph"
	"/I<S<O<I<UsentenceParagraph"
	"/U<S<OfillRegion"
	"/U<S<I<OwrapRegion"
	"/U<S<O<I<UsentenceRegion"
	"<E<SparagraphToLine"
	"<SlineToParagraph"
	"(-"
	"<SreverseSort"
	"<S<UsortParagraphs"
	"<SsortLines"
	"(-"
	"zapInvisibles"
	"<SspacesToTabs"
	"<StabsToSpaces"
	"<S<EindentSelection"
	"<SIndentLine"
	"<E<SdowncaseRegion"
	"<SupcaseRegion"
	"(-"
	{Menu -n Strings {
		"<SremovePrefix"
		"<SinsertPrefix"
		"<S<EremoveSuffix"
		"<SinsertSuffix"
		"setPrefix"
		"setSuffix"
		}}
	"/D<ScommentLine"
	"/D<S<I<OuncommentLine"
	"<SuncommentBox"
	"<ScommentBox"
	"<S<EuncommentParagraph"
	"<ScommentParagraph"
}
set menu::proc(Text) menu::textProc

proc menu::textProc {menu item} {
    switch -- $item {
	indentLine bind::IndentLine
	"Goto Func" gotoFunc
	"Goto File Mark" gotoFileMark
	"Mark Hilite" markHilite
	default {eval $item}
    }
}

#  Search menu  #
set menu::items(Search) {
	"/F<Sfind"
	"/F<S<I<OsearchStart"
	"/G<SfindAgain"
	"/G<S<I<OfindAgainBackward"
	"/MfindInNextFile"
	"/E<SenterSearchString"
	"/E<S<I<OenterReplaceString"
	"(-"
	"/S<S<BquickFind"
	"/S<S<B<IquickFindRegexp"
	"/R<BreverseQuickFind"
	"(-"
	"/Rreplace"
	"/Hreplace&FindAgain"
	"<S/R<O<IreplaceAll"
	"<S/R<O<I<BreplaceInFileset"
	"(-"
	"/,<BplaceBookmark"
	"/.<BreturnToBookmark"
	"/G<IgotoLine"
	"(-"
	"/M<I<OmatchingLines" 
	"gotoMatch" 
	"/M<BnextMatch"
	"(-"
	"/K<I<OgotoFunc"
	"/K<O<BgotoFileMark"
	"/=markHilite"
	{Menu -n namedMarks -p namedMarkProc {
		"/K<Oset"
		"goto"
		"remove"
		"(-"
		"sort"
		"sortByPosition"}}
	{Menu -n unnamedMarks -p unnamedMarkproc {
		"set"
		"exchangePointAndMark"}}
}
set menu::proc(Search) ""

#  Utils menu  #
set menu::proc(fileUtils) menu::fileUtils
set menu::proc(winUtils) menu::fileUtils
set menu::items(fileUtils) {
	"fileRemove"
	"fileInfo"
	"textToAlpha"
	"showInFinder"
}
set menu::items(winUtils) {
	"insertPathName"
	"insertFile"
}

set menu::items(Utils) {
	{Menu -n winUtils -p menu::fileUtils {}}
	{Menu -n asciiEtc {
		"quoteChar"
		"(-"
		"keyCode"
		"keyAscii"
		"getAscii"
		"insertAscii"}
	}
	"(-"
	"<S/Y<Oshell"
	"<S/Y<U<Ocalculator"
	"<S/Y<B<OtoolserverShell"
	"<S/L<O<IspellcheckWindow"
	"<S/L<O<I<BspellcheckSelection"
	"wordCount"
	"(-" 
	"sendUrl"
	"/jcmdDoubleClick"
}
set menu::proc(Utils) ""
lappend menu::which_subs(Utils) "winUtils"

#  Config menu  #

# 	"helperApps"

set menu::items(Config) {
	{Menu -n preferences {}} 
	{Menu -n packages -p menu::packagesProc {}}
	{Menu -n "Mode Prefs" -p mode::menuProc {}}
	"(-"
	"/lsetFontsTabs"
	"specialKeys" 
	"/kdescribeBinding"
	"listPackages" 
	"<SlistGlobalBindings" 
	"<SlistAllBindings" 
	"listFunctions" "(-" 
	"viewSavedSetting"
	"removeSavedSetting"
	"(-"
	{Menu -n redefineColors -p menu::colorProc {
		foreground
		background
		"(-"
		blue
		cyan
		green
		magenta
		red
		white
		yellow
		"(-"
		color_9
		color_10
		color_11
		color_12
		color_13
		color_14
		color_15}}
}
set menu::proc(Config) "menu::globalProc"
lappend menu::which_subs(Config) mode packages preferences


