/* gethtype.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

unsigned long _rsxnt_get_ht_type(HANDLE h)
{
    DWORD type;

    type = GetFileType(h);

    switch (type) {
	case FILE_TYPE_DISK:
	    type = HT_FILE;
	    break;

	case FILE_TYPE_CHAR:
	    type = HT_DEV_CON;
	    break;

	case FILE_TYPE_PIPE:
	{
	    TCHAR name[260];

	    if (GetNamedPipeHandleState(h, NULL,
		NULL, NULL, NULL, name, 260) == FALSE)
		type = HT_UPIPE;
	    else
		type = HT_NPIPE;
	    break;
	}

	case FILE_TYPE_UNKNOWN:
	    if (GetLastError() != ERROR_INVALID_HANDLE)
		type = HT_DEV_OTHER;
	    else
		type = 0xffffffff;
	    break;

	default:
	    type = 0xffffffff;
	    break;
    }
    return type;
}
