/* st2gmt.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

#define MINUTE 60L
#define HOUR (60L*MINUTE)
#define DAY (24L*HOUR)
#define YEAR (365L*DAY)

/*
    Converts struct SYSTEMTIME to Unix format
*/
unsigned long _rsxnt_st2gmt(SYSTEMTIME *st)
{
    static long month[12] =
    {
	0L,
	DAY * (long) (31),
	DAY * (long) (31 + 29),
	DAY * (long) (31 + 29 + 31),
	DAY * (long) (31 + 29 + 31 + 30),
	DAY * (long) (31 + 29 + 31 + 30 + 31),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31),
	DAY * (long) (31 + 29 + 31 + 30 + 31 + 30 + 31 + 31 + 30 + 31 + 30)
    };

    unsigned long res;
    unsigned long year;

    /* calc date */
    year = st->wYear - 1970L;
    res = YEAR * year + DAY * ((year + 1) / 4);
    res += month[st->wMonth - 1];
    if (st->wMonth > 2 && ((year + 2) % 4))
	res -= DAY;
    res += DAY * (st->wDay - 1);

    /* calc time */
    res += HOUR * (st->wHour);
    res += MINUTE * (st->wMinute);
    res += (st->wSecond);

    return res;
}
