/* getsocko.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include <rsxnt.h>
#include <rsxntso.h>

int __getsockopt (int fd, int level, int optname, void *optval, int *poptlen)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();

    if (!_rsxnt_socket_inited)
      return _rsxnt_errno(ENETDOWN);

    if (fd >= N_FILES || fd < 0)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);
    if (p->file[fd].f_mode != HT_SOCKET)
        return _rsxnt_errno(EBADF);
    else {
        if ((*wsa_getsockopt) ((int)p->file[fd].f_handle,
                level, optname, optval, poptlen) == SOCKET_ERROR)
            return _rsxnt_socket_errno();
        return 0;
    }
}
