/* sleep.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

unsigned __sleep(unsigned sec)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD start, end, sleepsec;
    int retv;

    p->p_status = PS_SLEEP;
    start = GetTickCount();
    retv = WaitForSingleObject(p->hEventSignal, sec*1000);
    end = GetTickCount();
    p->p_status = PS_RUN;

#ifdef EMX_SYS_LIB
    if (retv != WAIT_TIMEOUT)
        _rsxnt_check_signals();
#endif

    if (end < start)
        return 0;

    sleepsec = (end-start)/1000;

    if (sleepsec >= sec)
        return 0;
    else
        return (sec - sleepsec);
}
