/***************************************************************************\
*									    *
*   WINFILES.H								    *
*									    *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINFILES_H)
#define _WINFILES_H

#ifdef __cplusplus
extern "C" {
#endif

#define GENERIC_READ	0x80000000
#define GENERIC_WRITE	0x40000000
#define GENERIC_EXECUTE 	0x20000000
#define GENERIC_ALL		0x10000000

#define FILE_ATTRIBUTE_DIRECTORY	0x00000010
#define FILE_ATTRIBUTE_NORMAL	0x00000080
#define FILE_ATTRIBUTE_READONLY 	0x00000001
#define FILE_ATTRIBUTE_ARCHIVE         0x00000020  
#define FILE_SHARE_READ 		0x00000001
#define FILE_SHARE_WRITE		0x00000002

#define CREATE_NEW	    	1
#define CREATE_ALWAYS	2
#define OPEN_EXISTING	3
#define OPEN_ALWAYS	    	4
#define TRUNCATE_EXISTING	5

#define OF_READ 	    0x00000000
#define OF_WRITE	    0x00000001
#define OF_READWRITE	    0x00000002
#define OF_SHARE_COMPAT     0x00000000
#define OF_SHARE_EXCLUSIVE  0x00000010
#define OF_SHARE_DENY_WRITE 0x00000020
#define OF_SHARE_DENY_READ  0x00000030
#define OF_SHARE_DENY_NONE  0x00000040
#define OF_PARSE	    0x00000100
#define OF_DELETE	    0x00000200
#define OF_VERIFY	    0x00000400
#define OF_CANCEL	    0x00000800
#define OF_CREATE	    0x00001000
#define OF_PROMPT	    0x00002000
#define OF_EXIST	    0x00004000
#define OF_REOPEN	    0x00008000

#define OFS_MAXPATHNAME 128
typedef struct {
    BYTE cBytes;
    BYTE fFixedDisk;
    WORD nErrCode;
    WORD Reserved1;
    WORD Reserved2;
    CHAR szPathName[OFS_MAXPATHNAME];
} OFSTRUCT, *POFSTRUCT, *LPOFSTRUCT;

HFILE WINAPI OpenFile(LPCSTR lpFileName, LPOFSTRUCT lpReOpenBuff,
	UINT uStyle);

#define HANDLE_FLAG_INHERIT                 0x00000001
#define HANDLE_FLAG_PROTECT_FROM_CLOSE      0x00000002
#define FILE_FLAG_WRITE_THROUGH             0x80000000
#define FILE_FLAG_OVERLAPPED                0x40000000
#define FILE_FLAG_NO_BUFFERING              0x20000000
#define FILE_FLAG_RANDOM_ACCESS             0x10000000
#define FILE_FLAG_SEQUENTIAL_SCAN           0x08000000
#define FILE_FLAG_DELETE_ON_CLOSE           0x04000000
#define FILE_FLAG_BACKUP_SEMANTICS          0x02000000
#define FILE_FLAG_POSIX_SEMANTICS           0x01000000

#define CreateFile TFUNCT(CreateFile)
HANDLE WINAPI CreateFile(LPCTSTR lpFileName, DWORD dwDesiredAccess,
	DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes,
	DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes,
	HANDLE hTemplateFile);

DWORD WINAPI CloseHandle (HANDLE);

#define FILE_TYPE_UNKNOWN   0x0000
#define FILE_TYPE_DISK	    0x0001
#define FILE_TYPE_CHAR	    0x0002
#define FILE_TYPE_PIPE	    0x0003

DWORD WINAPI GetFileType(HANDLE);

#define INVALID_FILE_SIZE	((DWORD) 0xFFFFFFFFL)

DWORD WINAPI GetFileSize(HANDLE hFile, LPDWORD lpFileSizeHigh);

BOOL WINAPI GetFileTime(HANDLE hFile, LPFILETIME lpCreationTime,
	LPFILETIME lpLastAccessTime, LPFILETIME lpLastWriteTime);
BOOL WINAPI SetFileTime(HANDLE hFile,CONST FILETIME *lpCreationTime,
	CONST FILETIME *lpLastAccessTime, CONST FILETIME *lpLastWriteTime);
BOOL WINAPI SystemTimeToFileTime(CONST SYSTEMTIME *lpSystemTime,LPFILETIME lpFileTime);
BOOL WINAPI FileTimeToLocalFileTime(CONST FILETIME *lpFileTime,LPFILETIME lpLocalFileTime);
BOOL WINAPI FileTimeToSystemTime(CONST FILETIME *lpFileTime,LPSYSTEMTIME lpSystemTime);
BOOL WINAPI LocalFileTimeToFileTime(CONST FILETIME *lpLocalFileTime,LPFILETIME lpFileTime);
BOOL WINAPI FileTimeToDosDateTime(CONST FILETIME *, LPWORD, LPWORD);

#define SetFileAttributes TFUNCT(SetFileAttributes)
BOOL WINAPI SetFileAttributes(LPCTSTR,DWORD);
#define GetFileAttributes TFUNCT(GetFileAttributes)
DWORD WINAPI GetFileAttributes(LPCTSTR lpName);
#define GetSystemDirectory TFUNCT(GetSystemDirectory)
UINT WINAPI GetSystemDirectory(LPTSTR lpBuffer, UINT uSize);
#define CreateDirectory TFUNCT(CreateDirectory)
BOOL WINAPI CreateDirectory(LPCTSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
#define RemoveDirectory TFUNCT(RemoveDirectory)
BOOL WINAPI RemoveDirectory(LPCTSTR lpName);
#define GetCurrentDirectory TFUNCT(GetCurrentDirectory)
DWORD WINAPI GetCurrentDirectory(DWORD nSize, LPTSTR lpBuffer);
#define SetCurrentDirectory TFUNCT(SetCurrentDirectory)
BOOL WINAPI SetCurrentDirectory(LPCTSTR lpName);
#define GetFullPathName TFUNCT(GetFullPathName)
DWORD WINAPI GetFullPathName(LPCTSTR,DWORD,LPTSTR,LPTSTR *);
#define GetVolumeInformation TFUNCT(GetVolumeInformation)
BOOL WINAPI GetVolumeInformation(LPCTSTR,LPTSTR,DWORD,LPDWORD,LPDWORD,LPDWORD, LPTSTR,DWORD);

#define MoveFile TFUNCT(MoveFile)
BOOL WINAPI MoveFile(LPCTSTR lpFrom, LPCTSTR lpTo);

#define MOVEFILE_REPLACE_EXISTING   1
#define MOVEFILE_COPY_ALLOWED	    2
#define MOVEFILE_DELAY_UNTIL_REBOOT 4

#define MoveFileEx TFUNCT(MoveFileEx)
BOOL WINAPI MoveFileEx(LPCTSTR lpFrom, LPCTSTR lpTo, DWORD dwflags);
#define CopyFile TFUNCT(CopyFile)
BOOL WINAPI CopyFile(LPCTSTR lpExistingFileName, LPCTSTR lpNewFileName,
	BOOL bFailIfExists);
#define DeleteFile TFUNCT(DeleteFile)
BOOL WINAPI DeleteFile(LPCTSTR lpName);

typedef struct {
  DWORD Internal;
  DWORD InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
} OVERLAPPED, *LPOVERLAPPED;

BOOL WINAPI WriteFile(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToWrite,
	LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);
BOOL WINAPI ReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead,
	LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
BOOL WINAPI GetOverlappedResult(HANDLE hFile, LPOVERLAPPED lpOverlapped,
	LPDWORD lpNumberOfBytesTransferred, BOOL bWait);


BOOL WINAPI CreatePipe(PHANDLE hReadPipe, PHANDLE hWritePipe,
	LPSECURITY_ATTRIBUTES lpPipeAttributes, DWORD nSize);
BOOL WINAPI ConnectNamedPipe(HANDLE hNamedPipe, LPOVERLAPPED lpOverlapped);
BOOL WINAPI DisconnectNamedPipe(HANDLE hNamedPipe);
BOOL WINAPI SetNamedPipeHandleState(HANDLE hNamedPipe, LPDWORD lpMode,
	LPDWORD lpMaxCollectionCount, LPDWORD lpCollectDataTimeout);
BOOL WINAPI GetNamedPipeInfo(HANDLE hNamedPipe, LPDWORD lpFlags,
	LPDWORD lpOutBufferSize, LPDWORD lpInBufferSize, LPDWORD lpMaxInstances);
BOOL WINAPI PeekNamedPipe(HANDLE hNamedPipe, LPVOID lpBuffer,
	DWORD nBufferSize, LPDWORD lpBytesRead, LPDWORD lpTotalBytesAvail,
	LPDWORD lpBytesLeftThisMessage);
BOOL WINAPI TransactNamedPipe(HANDLE hNamedPipe, LPVOID lpInBuffer,
	DWORD nInBufferSize, LPVOID lpOutBuffer, DWORD nOutBufferSize,
	LPDWORD lpBytesRead, LPOVERLAPPED lpOverlapped);
BOOL WINAPI GetNamedPipeInfo(HANDLE,LPDWORD,LPDWORD,LPDWORD,LPDWORD);
#define GetNamedPipeHandleState TFUNCT(GetNamedPipeHandleState)
BOOL WINAPI GetNamedPipeHandleState(HANDLE,LPDWORD,LPDWORD,LPDWORD,LPDWORD,LPTSTR,DWORD);


#define CreateMailslot TFUNCT(CreateMailslot)
HANDLE WINAPI CreateMailslot(LPCTSTR lpName, DWORD nMaxMessageSize,
	DWORD lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
BOOL WINAPI GetMailslotInfo(HANDLE hMailslot, LPDWORD lpMaxMessageSize,
	LPDWORD lpNextSize, LPDWORD lpMessageCount, LPDWORD lpReadTimeout);
BOOL WINAPI SetMailslotInfo(HANDLE hMailslot, DWORD lReadTimeout);


#define FILE_MAP_COPY       SECTION_QUERY
#define FILE_MAP_WRITE      SECTION_MAP_WRITE
#define FILE_MAP_READ       SECTION_MAP_READ
#define FILE_MAP_ALL_ACCESS SECTION_ALL_ACCESS

#define CreateFileMapping TFUNCT(CreateFileMapping)
HANDLE WINAPI CreateFileMapping(HANDLE hFile, LPSECURITY_ATTRIBUTES lpFileMappingAttributes,
	DWORD flProtect, DWORD dwMaximumSizeHigh, 
	DWORD dwMaximumSizeLow, LPCTSTR lpName);
LPVOID WINAPI MapViewOfFile(HANDLE hFileMappingObject,
	DWORD dwDesiredAccess, DWORD dwFileOffsetHigh,
	DWORD dwFileOffsetLow, DWORD dwNumberOfBytesToMap);
LPVOID WINAPI MapViewOfFileEx(HANDLE hFileMappingObject,
	DWORD dwDesiredAccess, DWORD dwFileOffsetHigh,
	DWORD dwFileOffsetLow, DWORD dwNumberOfBytesToMap,
	LPVOID lpBaseAddress);
#define OpenFileMapping TFUNCT(OpenFileMapping)
HANDLE WINAPI OpenFileMapping(DWORD dwDesiredAccess,
	BOOL bInheritHandle, LPCTSTR lpName);
BOOL WINAPI FlushViewOfFile(LPCVOID lpBaseAddress, DWORD dwNumberOfBytesToFlush);
BOOL WINAPI UnmapViewOfFile(LPCVOID lpBaseAddress);


typedef struct {
    DWORD	dwFileAttributes;
    FILETIME	ftCreationTime;
    FILETIME	ftLastAccessTime;
    FILETIME	ftLastWriteTime;
    DWORD	dwVolumeSerialNumber;
    DWORD	nFileSizeHigh;
    DWORD	nFileSizeLow;
    DWORD	nNumberOfLinks;
    DWORD	nFileIndexHigh;
    DWORD	nFileIndexLow;
} BY_HANDLE_FILE_INFORMATION,
* PBY_HANDLE_FILE_INFORMATION,
* LPBY_HANDLE_FILE_INFORMATION;

DWORD WINAPI GetFileInformationByHandle(HANDLE, BY_HANDLE_FILE_INFORMATION *);

typedef struct {
    DWORD	dwFileAttributes;
    FILETIME	ftCreationTime;
    FILETIME	ftLastAccessTime;
    FILETIME	ftLastWriteTime;
    DWORD	nFileSizeHigh;
    DWORD	nFileSizeLow;
    DWORD	dwReserved0;
    DWORD	dwReserved1;
    TCHAR    cFileName[MAX_PATH];
    TCHAR    cAlternateFileName[14];
} WIN32_FIND_DATA, *PWIN32_FIND_DATA, *LPWIN32_FIND_DATA;

BOOL WINAPI FindClose (HANDLE);
#define FindFirstFile TFUNCT(FindFirstFile)
HANDLE WINAPI FindFirstFile(LPTSTR, LPWIN32_FIND_DATA);
#define FindNextFile TFUNCT(FindNextFile)
BOOL WINAPI FindNextFile(HANDLE, LPWIN32_FIND_DATA);

#define FILE_BEGIN		0
#define FILE_CURRENT		1
#define FILE_END		2

DWORD WINAPI SetFilePointer(HANDLE hFile, LONG lDistanceToMove,
	PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod);

#define DUPLICATE_CLOSE_SOURCE              0x00000001
#define DUPLICATE_SAME_ACCESS               0x00000002

BOOL WINAPI DuplicateHandle(HANDLE,HANDLE,HANDLE,HANDLE *,DWORD,BOOL,DWORD);

BOOL WINAPI GetHandleInformation(HANDLE, LPDWORD);
BOOL WINAPI SetEndOfFile(HANDLE);
UINT WINAPI SetHandleCount(UINT);
BOOL WINAPI FlushFileBuffers(HANDLE);

#define STD_INPUT_HANDLE    -10
#define STD_OUTPUT_HANDLE   -11
#define STD_ERROR_HANDLE    -12

HANDLE WINAPI GetStdHandle(DWORD);
BOOL WINAPI SetStdHandle(DWORD, HANDLE);


/* new apps shouldn't use these according to doc
I had some problems with \r\n handling with lwrite.*/
HFILE WINAPI _lopen(LPCSTR lpPathName, int iReadWrite);
HFILE WINAPI _lcreat(LPCSTR lpPathName, int  iAttribute);
UINT WINAPI _lread(HFILE hFile, LPVOID lpBuffer, UINT uBytes);
UINT WINAPI _lwrite(HFILE hFile, LPCSTR lpBuffer, UINT uBytes);
HFILE WINAPI _lclose(HFILE hFile);
LONG WINAPI _llseek(HFILE hFile, LONG lOffset, int iOrigin);
LONG WINAPI _hread(HFILE hFile, LPVOID lpBuffer, LONG lBytes);
LONG WINAPI _hwrite(HFILE hFile, LPCSTR lpBuffer, LONG lBytes);

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINFILES_H) */
