/*
 * Decompiled with CFR 0.152.
 */
package nts.hyph;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import nts.hyph.ArrayHyphens;
import nts.hyph.HashHyphenation;
import nts.hyph.HyphNode;
import nts.hyph.WordMap;
import nts.node.Hyphens;
import nts.node.Language;

public class HyphLanguage
extends Language {
    private final HashHyphenation hashHyph;
    private final WordMap patterns;
    private final Map nodeMap;
    private final int[] nodeStats;

    public Hyphens getHyphens(String word) {
        int size = word.length();
        if (size >= this.leftHyphenMin + this.rightHyphenMin) {
            int[] hyphens = this.hashHyph.getPositions(word);
            if (hyphens != null) {
                return ArrayHyphens.forPositions(hyphens, this.leftHyphenMin, size - this.rightHyphenMin);
            }
            char[] codes = new char[size + 2];
            word.getChars(0, size, codes, 1);
            codes[size + 1] = '\u0000';
            codes[0] = '\u0000';
            int[] values = new int[size + 3];
            WordMap.Seeker seeker = this.patterns.seeker();
            int right = size - this.rightHyphenMin + 2;
            int i = 0;
            while (i < right) {
                int l = i;
                while (l < codes.length) {
                    seeker.seek(codes[l]);
                    if (!seeker.isValid()) break;
                    HyphNode hyph = (HyphNode)seeker.get();
                    int k = i;
                    while (hyph != null) {
                        if (values[k += hyph.offset] < hyph.value) {
                            values[k] = hyph.value;
                        }
                        hyph = hyph.next;
                        ++k;
                    }
                    ++l;
                }
                seeker.reset();
                ++i;
            }
            i = 1;
            while (i <= this.leftHyphenMin) {
                values[i] = 0;
                ++i;
            }
            int k = size - this.rightHyphenMin + 1;
            while (k > 0 && (values[k] & 1) == 0) {
                --k;
            }
            if (k > 0) {
                boolean[] array = new boolean[k];
                do {
                    boolean bl = array[k] = (values[--k + 1] & 1) != 0;
                } while (k > 0);
                return new ArrayHyphens(array);
            }
        }
        return ArrayHyphens.EMPTY;
    }

    public void setHyphException(String word, int[] positions) {
        this.hashHyph.setPositions(word, positions);
    }

    public boolean setHyphPattern(String patt, int[] values) {
        HyphNode hyph = this.makeHyphNodes(values);
        HyphNode old = (HyphNode)this.patterns.put(patt, hyph);
        return old == null || old.isZero();
    }

    /*
     * Unable to fully structure code
     */
    private HyphNode makeHyphNodes(int[] values) {
        hyph = null;
        n = values.length;
        while (--n >= 0 && values[n] == 0) {
        }
        if (n >= 0) ** GOTO lbl19
        return HyphNode.ZERO;
lbl-1000:
        // 1 sources

        {
            i = n;
            while (--i >= 0 && values[i] == 0) {
            }
            hashed = (HyphNode)this.nodeMap.get(hyph = new HyphNode(n - i - 1, values[n], hyph));
            if (hashed == null) {
                this.nodeMap.put(hyph, hyph);
            } else {
                hyph = hashed;
                this.nodeStats[1] = this.nodeStats[1] + 1;
            }
            n = i;
            this.nodeStats[0] = this.nodeStats[0] + 1;
lbl19:
            // 2 sources

            ** while (n >= 0)
        }
lbl20:
        // 1 sources

        return hyph;
    }

    public static String toString(String patt, HyphNode hyph) {
        StringBuffer buf = new StringBuffer(2 * patt.length());
        int h = hyph != null ? hyph.offset : -1;
        int i = 0;
        while (i < patt.length()) {
            char code = patt.charAt(i);
            if (code == '\u0000') {
                code = '.';
            }
            if (i == h) {
                if (hyph.value != 0) {
                    buf.append(hyph.value);
                }
                h = (hyph = hyph.next) != null ? h + hyph.offset + 1 : -1;
            } else if (Character.isDigit(code)) {
                buf.append('0');
            }
            buf.append(code);
            ++i;
        }
        if (i == h && hyph.value != 0) {
            buf.append(hyph.value);
        }
        return buf.toString();
    }

    public static void dumpPatterns(PrintWriter writer, WordMap patterns) throws IOException {
        Enumeration entries = patterns.entries();
        while (entries.hasMoreElements()) {
            Map.Entry entry = (Map.Entry)entries.nextElement();
            if (entry == null) continue;
            String key = (String)entry.getKey();
            HyphNode value = (HyphNode)entry.getValue();
            if (value == null) continue;
            writer.println(HyphLanguage.toString(key, value));
        }
    }

    public HyphLanguage(int ln, int lhm, int rhm, HashHyphenation hashHyph, WordMap patterns, Map nodeMap, int[] nodeStats) {
        super(ln, lhm, rhm);
        this.hashHyph = hashHyph;
        this.patterns = patterns;
        this.nodeMap = nodeMap;
        this.nodeStats = nodeStats;
    }
}

