/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.io.Serializable;
import nts.base.Dimen;
import nts.base.Glue;
import nts.io.Log;
import nts.io.Loggable;

public class GlueSetting
implements Serializable,
Loggable {
    public static final byte RIGID = 0;
    public static final byte STRETCHING = 1;
    public static final byte SHRINKING = 2;
    public static final GlueSetting NATURAL = new GlueSetting(0, 0, 0.0);
    protected final byte sign;
    protected final byte order;
    protected final double ratio;

    public Dimen set(Glue glue, boolean limited) {
        Dimen dimen = glue.getDimen();
        switch (this.sign) {
            case 1: {
                if (glue.getStrOrder() != this.order) break;
                dimen = limited ? dimen.plus(glue.getStretch().limitedTimes(this.ratio)) : dimen.plus(glue.getStretch().times(this.ratio));
                break;
            }
            case 2: {
                if (glue.getShrOrder() != this.order) break;
                dimen = limited ? dimen.minus(glue.getShrink().limitedTimes(this.ratio)) : dimen.minus(glue.getShrink().times(this.ratio));
                break;
            }
        }
        return dimen;
    }

    public boolean makesElastic(Glue glue) {
        switch (this.sign) {
            case 1: {
                return glue.getStrOrder() == this.order && !glue.getStretch().isZero();
            }
            case 2: {
                return glue.getShrOrder() == this.order && !glue.getShrink().isZero();
            }
        }
        return false;
    }

    public void addOn(Log log) {
        if (this.sign != 0 && this.ratio != 0.0) {
            log.add(", glue set ");
            if (this.sign == 2) {
                log.add("- ");
            }
            if (Math.abs(this.ratio) > 20000.0) {
                log.add(this.ratio > 0.0 ? ">" : "< -").add(Glue.toString(Dimen.MAX_FROM_DOUBLE, this.order));
            } else {
                log.add(Glue.toString(Dimen.valueOf(this.ratio), this.order));
            }
        }
    }

    public GlueSetting(byte sign, byte order, double ratio) {
        this.sign = sign;
        this.order = order;
        this.ratio = ratio;
    }
}

