/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.io.CharCode;
import nts.io.Name;
import nts.node.DiscretionaryNode;
import nts.node.FontMetric;
import nts.node.Hyphens;
import nts.node.InsetedNodeEnum;
import nts.node.Language;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.TreatNode;
import nts.node.WordRebuilder;

public abstract class HyphenNodeEnum
extends InsetedNodeEnum {
    private final boolean ucHyph;
    private Language currLang;
    private boolean spaceBreaking = true;
    private boolean wordBlock = false;

    private Node getNextNode() {
        Node node = super.nextNode();
        if (node.allowsSpaceBreaking()) {
            this.spaceBreaking = true;
        } else if (node.forbidsSpaceBreaking()) {
            this.spaceBreaking = false;
        }
        Language altLang = node.alteringLanguage();
        if (altLang != null) {
            this.currLang = altLang;
        }
        return node;
    }

    public Node nextNode() {
        Node node;
        NodeList block;
        if (this.wordBlock && !(block = this.nextWordBlock()).isEmpty()) {
            this.inseted = block.nodes();
        }
        this.wordBlock = (node = this.getNextNode()).startsWordBlock() && this.spaceBreaking;
        return node;
    }

    protected NodeList nextWordBlock() {
        Node node;
        byte r;
        NodeList list = new NodeList();
        do {
            if (!this.hasMoreNodes()) {
                return list;
            }
            node = this.getNextNode();
            list.append(node);
            r = node.beforeWord();
            if (r != 0) continue;
            return list;
        } while (r != 2);
        Name.Buffer word = new Name.Buffer();
        FontMetric wordMetric = null;
        int beg = list.length() - 1;
        Language lang = null;
        CharCode hyphCode = null;
        int count = 0;
        while (node.canBePartOfWord()) {
            FontMetric metric = node.uniformMetric();
            if (metric != null) {
                if (wordMetric == null) {
                    hyphCode = this.hyphenChar(metric);
                    if (hyphCode == null) {
                        return list;
                    }
                    wordMetric = metric;
                } else if (!metric.equals(wordMetric)) break;
            }
            node.contributeCharCodes(word);
            int cnt = word.length();
            if (cnt >= 64) break;
            count = cnt;
            lang = this.currLang;
            if (!this.hasMoreNodes()) {
                return this.hyphenated(word, count, wordMetric, lang, hyphCode, list, beg, list.length());
            }
            node = this.getNextNode();
            list.append(node);
        }
        int end = list.length() - 1;
        byte r2;
        while ((r2 = node.afterWord()) != 0) {
            if (r2 == 2 || !this.hasMoreNodes()) {
                return this.hyphenated(word, count, wordMetric, lang, hyphCode, list, beg, end);
            }
            node = this.getNextNode();
            list.append(node);
        }
        return list;
    }

    protected NodeList hyphenated(Name.Buffer buf, int count, FontMetric metric, Language lang, CharCode hyphCode, NodeList list, int beg, int end) {
        if (count > 0 && metric != null) {
            CharCode[] word = new CharCode[count];
            buf.getCodes(0, count, word, 0);
            if (this.ucHyph || word[0].toCanonicalLetter() == word[0].toChar()) {
                char[] canon = new char[count];
                int i = 0;
                while (i < count) {
                    canon[i] = word[i].toCanonicalLetter();
                    ++i;
                }
                Hyphens hyphens = lang.getHyphens(new String(canon));
                if (!hyphens.isEmpty()) {
                    HyphenNodeEnum hyphenNodeEnum = this;
                    if (hyphenNodeEnum == null) {
                        throw null;
                    }
                    return hyphenNodeEnum.new Hyphenator(word, metric, hyphens, hyphCode, list, beg, end).hyphenated();
                }
            }
        }
        return list;
    }

    protected abstract CharCode hyphenChar(FontMetric var1);

    protected abstract void complain(FontMetric var1, CharCode var2);

    public HyphenNodeEnum(NodeEnum in, Language lang, boolean ucHyph) {
        super(in);
        this.currLang = lang;
        this.ucHyph = ucHyph;
    }

    private static class Appender
    implements TreatNode {
        private NodeList list = new NodeList();

        public void execute(Node node) {
            this.list.append(node);
        }

        public void clear() {
            if (!this.list.isEmpty()) {
                this.list = new NodeList();
            }
        }

        public NodeList takeList() {
            if (this.list.isEmpty()) {
                return NodeList.EMPTY;
            }
            NodeList curr = this.list;
            this.list = new NodeList();
            return curr;
        }

        public String toString() {
            return this.list.toString();
        }

        Appender() {
        }
    }

    private class Hyphenator {
        private final CharCode[] word;
        private final FontMetric metric;
        private final Hyphens hyphens;
        private final CharCode hyphCode;
        private final NodeList source;
        private final int beg;
        private final int end;
        private int hyphenDone;
        private int passed;
        private CharCode boundary = null;
        private boolean rightHit = false;

        /*
         * Unable to fully structure code
         */
        public NodeList hyphenated() {
            this.findBoundary();
            result = new NodeList();
            result.append(this.source.nodes(0, this.replaceFrom()));
            pre = new Appender();
            post = new Appender();
            list = new Appender();
            n = this.word.length;
            this.hyphenDone = -1;
            j = -1;
            while (j < n) {
                l = j;
                j = this.passingReconstitute(j, n, list);
                if (this.passed < 0) {
                    result.append(list.takeList());
                    if (this.hyphenAt(j)) {
                        l = j;
                        this.passed = j;
                    }
                }
                while (this.passed >= 0) {
                    this.hyphenDone = this.passed;
                    this.hyphenReconstitute(l, this.passed, pre);
                    bound = true;
                    i = this.passed;
                    do lbl-1000:
                    // 3 sources

                    {
                        i = this.reconstitute(i, n, post, bound);
                        bound = false;
                        if (i < j) ** GOTO lbl-1000
                        while (j < i) {
                            j = this.reconstitute(j, n, list, false);
                        }
                    } while (i < j);
                    main = list.takeList();
                    if (main.length() > 127) {
                        result.append(main);
                        pre.clear();
                        post.clear();
                    } else {
                        result.append(new DiscretionaryNode(pre.takeList(), post.takeList(), main));
                    }
                    this.passed = this.hyphenAt(j) != false ? j : -1;
                    l = j;
                }
            }
            return result.append(this.source.nodes(this.end));
        }

        private int passingReconstitute(int j, int n, TreatNode proc) {
            WordRebuilder reb;
            if (j >= 0) {
                WordRebuilder wordRebuilder = this.metric.getWordRebuilder(proc, false);
            } else {
                j = 0;
                reb = this.firstRebuilder(proc);
            }
            this.passed = -1;
            while (true) {
                block10: {
                    block9: {
                        block8: {
                            if (this.passed < 0 && this.hyphenAt(j) && reb.prolongsCut(this.hyphCode)) {
                                this.passed = j;
                            }
                            if (j < n) break block8;
                            this.finalClose(reb);
                            break block9;
                        }
                        byte how = reb.addIfBelongsToCut(this.word[j]);
                        if (this.passed < 0 && how != 0 && this.hyphenAt(j)) {
                            this.passed = j;
                        }
                        if (how == 2) break block10;
                    }
                    return j;
                }
                ++j;
            }
        }

        private void hyphenReconstitute(int j, int n, TreatNode proc) {
            WordRebuilder reb;
            if (j >= 0) {
                WordRebuilder wordRebuilder = this.metric.getWordRebuilder(proc, false);
            } else {
                j = 0;
                reb = this.firstRebuilder(proc);
            }
            while (j < n) {
                reb.add(this.word[j++]);
            }
            if (!reb.add(this.hyphCode)) {
                HyphenNodeEnum.this.complain(this.metric, this.hyphCode);
            }
            reb.close(true);
        }

        private int reconstitute(int j, int n, TreatNode proc, boolean bound) {
            WordRebuilder reb = this.metric.getWordRebuilder(proc, bound);
            while (true) {
                if (j >= n) {
                    this.finalClose(reb);
                    return j;
                }
                byte code = reb.addIfBelongsToCut(this.word[j]);
                if (code != 2) {
                    return j;
                }
                ++j;
            }
        }

        private boolean hyphenAt(int pos) {
            return pos > this.hyphenDone && this.hyphens.hyphenAt(pos);
        }

        private int replaceFrom() {
            return this.beg > 0 && this.metric.equals(this.source.nodeAt(this.beg - 1).uniformMetric()) ? this.beg - 1 : this.beg;
        }

        private WordRebuilder firstRebuilder(TreatNode proc) {
            if (this.beg > 0) {
                FontMetric prevMetric = this.source.nodeAt(this.beg - 1).uniformMetric();
                if (prevMetric == null) {
                    return this.source.nodeAt(this.beg).makeRebuilder(proc, false);
                }
                if (this.metric.equals(prevMetric)) {
                    return this.source.nodeAt(this.beg - 1).makeRebuilder(proc, true);
                }
            }
            return this.metric.getWordRebuilder(proc, true);
        }

        private void findBoundary() {
            Node node;
            if (this.end < this.source.length() && this.metric.equals((node = this.source.nodeAt(this.end)).uniformMetric())) {
                Name.Buffer buf = new Name.Buffer();
                node.contributeCharCodes(buf);
                if (buf.length() > 0) {
                    this.boundary = buf.codeAt(0);
                }
            }
            if (this.boundary == null) {
                this.rightHit = this.source.nodeAt(this.end - 1).rightBoundary();
            }
        }

        private void finalClose(WordRebuilder reb) {
            if (this.boundary != null) {
                reb.close(this.boundary);
            } else {
                reb.close(this.rightHit);
            }
        }

        public Hyphenator(CharCode[] word, FontMetric metric, Hyphens hyphens, CharCode hyphCode, NodeList source, int beg, int end) {
            this.word = word;
            this.metric = metric;
            this.hyphens = hyphens;
            this.hyphCode = hyphCode;
            this.source = source;
            this.beg = beg;
            this.end = end;
        }
    }
}

