/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Point;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetWindowOrg
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_Y = 0;
    private static final int POS_X = 1;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Point p = this.getScaledTarget();
        state.setWindowOrg(p.x, p.y);
    }

    public MfCmd getInstance() {
        return new MfCmdSetWindowOrg();
    }

    public void setRecord(MfRecord record) {
        int y = record.getParam(0);
        int x = record.getParam(1);
        this.setTarget(x, y);
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        Point p = this.getTarget();
        record.setParam(1, p.x);
        record.setParam(0, p.y);
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_WINDOW_ORG] target=");
        b.append(this.getTarget());
        return b.toString();
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public void setTarget(int x, int y) {
        this.x = x;
        this.y = y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public int getFunction() {
        return 523;
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }
}

