/*
 * Decompiled with CFR 0.152.
 */
package megamek.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import megamek.client.CloseClientListener;
import megamek.client.TimerSingleton;
import megamek.client.bot.BotClient;
import megamek.client.commands.AddBotCommand;
import megamek.client.commands.ClientCommand;
import megamek.client.commands.DeployCommand;
import megamek.client.commands.FireCommand;
import megamek.client.commands.HelpCommand;
import megamek.client.commands.MoveCommand;
import megamek.client.commands.RulerCommand;
import megamek.client.commands.ShowEntityCommand;
import megamek.client.commands.ShowTileCommand;
import megamek.client.ui.IClientCommandHandler;
import megamek.common.Board;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.Game;
import megamek.common.GameLog;
import megamek.common.GameTurn;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.MapSettings;
import megamek.common.MechFileParser;
import megamek.common.MechSummaryCache;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.PlanetaryConditions;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.actions.AttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.IConnection;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
implements IClientCommandHandler {
    public static final String CLIENT_COMMAND = "#";
    private String name;
    private IConnection connection;
    private Hashtable<String, ClientCommand> commandsHash = new Hashtable();
    private boolean connected = false;
    public int local_pn = -1;
    private String host;
    private int port;
    public IGame game = new Game();
    private MapSettings mapSettings;
    public String phaseReport;
    public String roundReport;
    private Vector<CloseClientListener> closeClientListeners = new Vector();
    private GameLog log;
    private Vector<Coords> artilleryAutoHitHexes = null;
    private boolean disconnectFlag = false;
    private Hashtable<String, Integer> duplicateNameHash = new Hashtable();
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            Client.this.disconnected();
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            Client.this.handlePacket(packetReceivedEvent.getPacket());
        }
    };

    public Client(String string, String string2, int n) {
        this.name = string;
        this.host = string2;
        this.port = n;
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new MoveCommand(this));
        this.registerCommand(new RulerCommand(this));
        this.registerCommand(new ShowEntityCommand(this));
        this.registerCommand(new FireCommand(this));
        this.registerCommand(new DeployCommand(this));
        this.registerCommand(new ShowTileCommand(this));
        this.registerCommand(new AddBotCommand(this));
        TimerSingleton timerSingleton = TimerSingleton.getInstance();
        final Runnable runnable = new Runnable(){

            public void run() {
                Client.this.updateConnection();
            }
        };
        TimerTask timerTask = new TimerTask(){

            public void run() {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        timerSingleton.schedule(timerTask, 500L, 100L);
    }

    protected void updateConnection() {
        if (this.connection != null) {
            this.connection.update();
        }
    }

    public boolean connect() {
        this.connection = ConnectionFactory.getInstance().createClientConnection(this.host, this.port, 1);
        boolean bl = this.connection.open();
        if (bl) {
            this.connection.addConnectionListener(this.connectionListener);
        }
        return bl;
    }

    public void die() {
        if (this.connected) {
            this.send(new Packet(0));
            this.flushConn();
        }
        this.connected = false;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        for (int i = 0; i < this.closeClientListeners.size(); ++i) {
            this.closeClientListeners.elementAt(i).clientClosed();
        }
        if (this.log != null) {
            try {
                this.log.close();
            }
            catch (IOException iOException) {
                System.err.print("Exception closing logfile: ");
                iOException.printStackTrace();
            }
        }
        System.out.println("client: died");
        System.out.flush();
    }

    protected void disconnected() {
        if (!this.disconnectFlag) {
            this.disconnectFlag = true;
            if (this.connected) {
                this.connected = false;
                this.die();
            }
            if (!this.host.equals("localhost")) {
                this.game.processGameEvent(new GamePlayerDisconnectedEvent((Object)this, this.getLocalPlayer()));
            }
        }
    }

    public Vector<Coords> getArtilleryAutoHit() {
        return this.artilleryAutoHitHexes;
    }

    private void initGameLog() {
        this.log = new GameLog(PreferenceManager.getClientPreferences().getGameLogFilename());
    }

    private boolean keepGameLog() {
        return PreferenceManager.getClientPreferences().keepGameLog() && !(this instanceof BotClient);
    }

    public Enumeration<Player> getPlayers() {
        return this.game.getPlayers();
    }

    public Entity getEntity(int n) {
        return this.game.getEntity(n);
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    public Player getLocalPlayer() {
        return this.getPlayer(this.local_pn);
    }

    public Enumeration<Entity> getSelectedEntities(EntitySelector entitySelector) {
        return this.game.getSelectedEntities(entitySelector);
    }

    public int getFirstEntityNum() {
        return this.game.getFirstEntityNum(this.getMyTurn());
    }

    public int getNextEntityNum(int n) {
        return this.game.getNextEntityNum(this.getMyTurn(), n);
    }

    public int getFirstDeployableEntityNum() {
        return this.game.getFirstDeployableEntityNum();
    }

    public int getNextDeployableEntityNum(int n) {
        return this.game.getNextDeployableEntityNum(n);
    }

    public IBoard getBoard() {
        return this.game.getBoard();
    }

    public Enumeration<Entity> getEntities() {
        return this.game.getEntities();
    }

    public MapSettings getMapSettings() {
        return this.mapSettings;
    }

    public void changePhase(IGame.Phase phase) {
        this.game.setPhase(phase);
        switch (phase) {
            case PHASE_STARTING_SCENARIO: {
                this.sendDone(true);
                break;
            }
            case PHASE_EXCHANGE: {
                this.sendDone(true);
                break;
            }
            case PHASE_DEPLOYMENT: {
                MechSummaryCache.dispose();
                MechFileParser.dispose();
                this.memDump("entering deployment phase");
                break;
            }
            case PHASE_TARGETING: {
                this.memDump("entering targeting phase");
                break;
            }
            case PHASE_MOVEMENT: {
                this.memDump("entering movement phase");
                break;
            }
            case PHASE_OFFBOARD: {
                this.memDump("entering offboard phase");
                break;
            }
            case PHASE_FIRING: {
                this.memDump("entering firing phase");
                break;
            }
            case PHASE_PHYSICAL: {
                this.memDump("entering physical phase");
                break;
            }
            case PHASE_LOUNGE: {
                MechSummaryCache.getInstance();
                this.duplicateNameHash.clear();
            }
        }
    }

    public void addCloseClientListener(CloseClientListener closeClientListener) {
        this.closeClientListeners.addElement(closeClientListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveServerInfo() {
        this.updateConnection();
        int n = 50;
        while (n-- > 0 && !this.connected) {
            Client client = this;
            synchronized (client) {
                this.flushConn();
                this.updateConnection();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isMyTurn() {
        if (this.game.isPhaseSimultaneous()) {
            return this.game.getTurnForPlayer(this.local_pn) != null;
        }
        return this.game.getTurn() != null && this.game.getTurn().isValid(this.local_pn, this.game);
    }

    public GameTurn getMyTurn() {
        if (this.game.isPhaseSimultaneous()) {
            return this.game.getTurnForPlayer(this.local_pn);
        }
        return this.game.getTurn();
    }

    public boolean canUnloadStranded() {
        return this.game.getTurn() instanceof GameTurn.UnloadStrandedTurn && this.game.getTurn().isValid(this.local_pn, this.game);
    }

    public void sendUnloadStranded(int[] nArray) {
        Object[] objectArray = new Object[]{nArray};
        this.send(new Packet(450, objectArray));
    }

    protected void changeTurnIndex(int n) {
        this.game.setTurnIndex(n);
    }

    public void sendModeChange(int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        this.send(new Packet(150, objectArray));
    }

    public void sendSystemModeChange(int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        this.send(new Packet(170, objectArray));
    }

    public void sendAmmoChange(int n, int n2, int n3) {
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        this.send(new Packet(160, objectArray));
    }

    public void moveEntity(int n, MovePath movePath) {
        Object[] objectArray = new Object[]{new Integer(n), movePath};
        this.send(new Packet(110, objectArray));
    }

    public void deploy(int n, Coords coords, int n2) {
        this.deploy(n, coords, n2, new Vector<Entity>(), false);
    }

    public void deploy(int n, Coords coords, int n2, Vector<Entity> vector, boolean bl) {
        int n3 = 5 + vector.size();
        int n4 = 0;
        Object[] objectArray = new Object[n3];
        objectArray[n4++] = new Integer(n);
        objectArray[n4++] = coords;
        objectArray[n4++] = new Integer(n2);
        objectArray[n4++] = new Integer(vector.size());
        objectArray[n4++] = new Boolean(bl);
        Enumeration<Entity> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n4++] = new Integer(enumeration.nextElement().getId());
        }
        this.send(new Packet(120, objectArray));
        this.flushConn();
    }

    public void sendAttackData(int n, Vector<EntityAction> vector) {
        Object[] objectArray = new Object[]{new Integer(n), vector};
        this.send(new Packet(130, objectArray));
        this.flushConn();
    }

    public void sendGameOptions(String string, Vector<IBasicOption> vector) {
        Object[] objectArray = new Object[]{string, vector};
        this.send(new Packet(350, objectArray));
    }

    public void sendMapSettings(MapSettings mapSettings) {
        this.send(new Packet(360, mapSettings));
    }

    public void sendPlanetaryConditions(PlanetaryConditions planetaryConditions) {
        this.send(new Packet(530, planetaryConditions));
    }

    public void sendMapQuery(MapSettings mapSettings) {
        this.send(new Packet(370, mapSettings));
    }

    public void sendChat(String string) {
        this.send(new Packet(80, string));
        this.flushConn();
    }

    public synchronized void sendDone(boolean bl) {
        this.send(new Packet(70, new Boolean(bl)));
        this.flushConn();
    }

    public void sendRerollInitiativeRequest() {
        this.send(new Packet(440));
    }

    public void sendPlayerInfo() {
        Player player = this.game.getPlayer(this.local_pn);
        PreferenceManager.getClientPreferences().setLastPlayerColor(player.getColorIndex());
        PreferenceManager.getClientPreferences().setLastPlayerCategory(player.getCamoCategory());
        PreferenceManager.getClientPreferences().setLastPlayerCamoName(player.getCamoFileName());
        this.send(new Packet(60, player));
    }

    public void sendAddEntity(Entity entity) {
        this.checkDuplicateNamesDuringAdd(entity);
        this.send(new Packet(90, entity));
    }

    public void sendAddSquadron(Vector<Entity> vector) {
        this.send(new Packet(540, vector));
    }

    public void sendDeployMinefields(Vector<Minefield> vector) {
        this.send(new Packet(390, vector));
    }

    public void sendArtyAutoHitHexes(Vector<Coords> vector) {
        this.artilleryAutoHitHexes = vector;
        this.send(new Packet(460, vector));
    }

    public void sendUpdateEntity(Entity entity) {
        this.send(new Packet(140, entity));
    }

    public void sendCustomInit(Player player) {
        this.send(new Packet(520, player));
    }

    public void sendDeleteEntity(int n) {
        this.checkDuplicateNamesDuringDelete(n);
        this.send(new Packet(100, new Integer(n)));
    }

    public void sendLoadGame(File file) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.send(new Packet(506, new Object[]{file, objectInputStream.readObject()}));
        }
        catch (Exception exception) {
            System.out.println("Can't find local savegame " + file);
        }
    }

    protected void receivePlayerInfo(Packet packet) {
        int n = packet.getIntValue(0);
        Player player = (Player)packet.getObject(1);
        if (this.getPlayer(player.getId()) == null) {
            this.game.addPlayer(n, player);
        } else {
            this.game.setPlayer(n, player);
        }
        PreferenceManager.getClientPreferences().setLastPlayerColor(player.getColorIndex());
        PreferenceManager.getClientPreferences().setLastPlayerCategory(player.getCamoCategory());
        PreferenceManager.getClientPreferences().setLastPlayerCamoName(player.getCamoFileName());
    }

    protected void receiveTurns(Packet packet) {
        this.game.setTurnVector((Vector)packet.getObject(0));
    }

    protected void receiveBoard(Packet packet) {
        Board board = (Board)packet.getObject(0);
        this.game.setBoard(board);
    }

    protected void receiveEntities(Packet packet) {
        Vector vector = (Vector)packet.getObject(0);
        Vector vector2 = (Vector)packet.getObject(1);
        this.game.setEntitiesVector(vector);
        if (vector2 != null) {
            this.game.setOutOfGameEntitiesVector(vector2);
        }
    }

    protected void receiveEntityUpdate(Packet packet) {
        int n = packet.getIntValue(0);
        Entity entity = (Entity)packet.getObject(1);
        Vector vector = (Vector)packet.getObject(2);
        this.game.setEntity(n, entity, vector);
    }

    protected void receiveEntityAdd(Packet packet) {
        int n = packet.getIntValue(0);
        Entity entity = (Entity)packet.getObject(1);
        this.game.addEntity(n, entity);
    }

    protected void receiveEntityRemove(Packet packet) {
        int n = packet.getIntValue(0);
        int n2 = packet.getIntValue(1);
        this.game.removeEntity(n, n2);
    }

    protected void receiveEntityVisibilityIndicator(Packet packet) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        if (entity != null) {
            entity.setSeenByEnemy(packet.getBooleanValue(1));
            entity.setVisibleToEnemy(packet.getBooleanValue(2));
            this.game.processGameEvent(new GameEntityChangeEvent((Object)this, entity));
        }
    }

    protected void receiveDeployMinefields(Packet packet) {
        this.game.addMinefields((Vector)packet.getObject(0));
    }

    protected void receiveSendingMinefields(Packet packet) {
        this.game.setMinefields((Vector)packet.getObject(0));
    }

    protected void receiveRevealMinefield(Packet packet) {
        this.game.addMinefield((Minefield)packet.getObject(0));
    }

    protected void receiveRemoveMinefield(Packet packet) {
        this.game.removeMinefield((Minefield)packet.getObject(0));
    }

    protected void receiveUpdateMinefields(Packet packet) {
        Vector<Minefield> vector = new Vector<Minefield>();
        for (Minefield minefield : (Vector)packet.getObject(0)) {
            if (!this.getLocalPlayer().containsMinefield(minefield)) continue;
            vector.add(minefield);
        }
        if (vector.size() > 0) {
            this.game.resetMinefieldDensity(vector);
        }
    }

    protected void receiveBuildingUpdateCF(Packet packet) {
        this.game.getBoard().updateBuildingCF((Vector)packet.getObject(0));
    }

    protected void receiveBuildingCollapse(Packet packet) {
        this.game.getBoard().collapseBuilding((Vector)packet.getObject(0));
    }

    protected void receiveAttack(Packet packet) {
        Vector vector = (Vector)packet.getObject(0);
        int n = packet.getIntValue(1);
        boolean bl = true;
        for (EntityAction entityAction : vector) {
            RoundUpdated roundUpdated;
            Serializable serializable;
            int n2 = entityAction.getEntityId();
            if (entityAction instanceof TorsoTwistAction && this.game.hasEntity(n2)) {
                serializable = (TorsoTwistAction)entityAction;
                roundUpdated = this.game.getEntity(n2);
                ((Entity)roundUpdated).setSecondaryFacing(((TorsoTwistAction)serializable).getFacing());
            } else if (entityAction instanceof FlipArmsAction && this.game.hasEntity(n2)) {
                serializable = (FlipArmsAction)entityAction;
                roundUpdated = this.game.getEntity(n2);
                ((Entity)roundUpdated).setArmsFlipped(((FlipArmsAction)serializable).getIsFlipped());
            } else if (entityAction instanceof DodgeAction && this.game.hasEntity(n2)) {
                serializable = this.game.getEntity(n2);
                ((Entity)serializable).dodging = true;
                bl = false;
            } else if (entityAction instanceof AttackAction && entityAction instanceof ClubAttackAction) {
                serializable = (ClubAttackAction)entityAction;
                roundUpdated = ((ClubAttackAction)serializable).getClub();
                ((Mounted)roundUpdated).restore();
            }
            if (!bl) continue;
            if (n == 0) {
                this.game.addAction(entityAction);
                continue;
            }
            if (n != 1) continue;
            this.game.addCharge((AttackAction)entityAction);
        }
    }

    public String receiveReport(Vector<Report> vector) {
        int n;
        boolean bl = false;
        if (vector == null) {
            return "[null report vector]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < vector.size(); ++n) {
            stringBuffer.append(vector.elementAt(n).getText());
        }
        while (this.game.getOptions().booleanOption("supress_all_double_blind_messages") && stringBuffer.indexOf("????") != -1) {
            bl = true;
            n = stringBuffer.indexOf("????");
            int n2 = stringBuffer.indexOf("\n", n);
            if (stringBuffer.lastIndexOf("\n", n) != -1) {
                n = stringBuffer.lastIndexOf("\n", n);
            }
            if (n2 <= 0) {
                n2 = stringBuffer.length();
            }
            if (n < 0) {
                n = 0;
            }
            stringBuffer.delete(n, n2);
        }
        String string = stringBuffer.toString();
        while (string.indexOf("\n\n") != -1 && bl) {
            string = string.replaceAll("\n\n", "\n");
        }
        return string;
    }

    private void saveEntityStatus(String string) {
        try {
            String string2 = PreferenceManager.getClientPreferences().getLogDirectory();
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdir();
            }
            String string3 = "entitystatus.txt";
            if (PreferenceManager.getClientPreferences().stampFilenames()) {
                string3 = StringUtil.addDateTimeStamp(string3);
            }
            FileWriter fileWriter = new FileWriter(string2 + File.separator + string3);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void send(Packet packet) {
        this.connection.send(packet);
    }

    protected void flushConn() {
        this.connection.flush();
    }

    protected void handlePacket(Packet packet) {
        if (packet == null) {
            System.out.println("client: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 0: {
                this.disconnected();
                break;
            }
            case 5: {
                this.disconnected();
                this.connect();
                break;
            }
            case 10: {
                this.connected = true;
                this.send(new Packet(20, this.name));
                break;
            }
            case 490: {
                this.correctName(packet);
                break;
            }
            case 30: {
                this.local_pn = packet.getIntValue(0);
                break;
            }
            case 60: {
                this.receivePlayerInfo(packet);
                break;
            }
            case 70: {
                this.getPlayer(packet.getIntValue(0)).setDone(packet.getBooleanValue(1));
                break;
            }
            case 40: {
                this.receivePlayerInfo(packet);
                break;
            }
            case 50: {
                this.game.removePlayer(packet.getIntValue(0));
                break;
            }
            case 80: {
                if (this.log == null) {
                    this.initGameLog();
                }
                if (this.log != null && this.keepGameLog()) {
                    this.log.append((String)packet.getObject(0));
                }
                this.game.processGameEvent(new GamePlayerChatEvent((Object)this, null, (String)packet.getObject(0)));
                break;
            }
            case 90: {
                this.receiveEntityAdd(packet);
                break;
            }
            case 140: {
                this.receiveEntityUpdate(packet);
                break;
            }
            case 100: {
                this.receiveEntityRemove(packet);
                break;
            }
            case 180: {
                this.receiveEntityVisibilityIndicator(packet);
                break;
            }
            case 420: {
                this.receiveSendingMinefields(packet);
                break;
            }
            case 430: {
                this.receiveUpdateMinefields(packet);
                break;
            }
            case 390: {
                this.receiveDeployMinefields(packet);
                break;
            }
            case 400: {
                this.receiveRevealMinefield(packet);
                break;
            }
            case 410: {
                this.receiveRemoveMinefield(packet);
                break;
            }
            case 190: {
                this.game.getBoard().setHex((Coords)packet.getObject(0), (IHex)packet.getObject(1));
                break;
            }
            case 220: {
                this.receiveBuildingUpdateCF(packet);
                break;
            }
            case 230: {
                this.receiveBuildingCollapse(packet);
                break;
            }
            case 240: {
                this.changePhase((IGame.Phase)((Object)packet.getObject(0)));
                break;
            }
            case 250: {
                this.changeTurnIndex(packet.getIntValue(0));
                break;
            }
            case 260: {
                this.game.setRoundCount(packet.getIntValue(0));
                break;
            }
            case 300: {
                this.receiveTurns(packet);
                break;
            }
            case 270: {
                this.receiveBoard(packet);
                break;
            }
            case 280: {
                this.receiveEntities(packet);
                break;
            }
            case 310: 
            case 330: {
                this.phaseReport = this.receiveReport((Vector)packet.getObject(0));
                if (this.keepGameLog()) {
                    if (this.log == null && this.game.getRoundCount() == 1) {
                        this.initGameLog();
                    }
                    if (this.log != null) {
                        this.log.append(this.phaseReport);
                    }
                }
                this.game.addReports((Vector)packet.getObject(0));
                this.roundReport = this.receiveReport(this.game.getReports(this.game.getRoundCount()));
                if (packet.getCommand() != 330) break;
                this.game.processGameEvent(new GameReportEvent((Object)this, null));
                break;
            }
            case 320: {
                this.game.processGameEvent(new GameReportEvent((Object)this, this.receiveReport((Vector)packet.getObject(0))));
                break;
            }
            case 340: {
                Vector vector = (Vector)packet.getObject(0);
                this.game.setAllReports(vector);
                if (this.keepGameLog()) {
                    this.initGameLog();
                    if (this.log != null) {
                        for (int i = 0; i < vector.size(); ++i) {
                            this.log.append(this.receiveReport((Vector)vector.elementAt(i)));
                        }
                    }
                }
                this.phaseReport = this.roundReport = this.receiveReport(this.game.getReports(this.game.getRoundCount()));
                break;
            }
            case 130: {
                this.receiveAttack(packet);
                break;
            }
            case 350: {
                this.game.setOptions((GameOptions)packet.getObject(0));
                break;
            }
            case 360: {
                this.mapSettings = (MapSettings)packet.getObject(0);
                this.game.processGameEvent(new GameSettingsChangeEvent(this));
                break;
            }
            case 530: {
                this.game.setPlanetaryConditions((PlanetaryConditions)packet.getObject(0));
                this.game.processGameEvent(new GameSettingsChangeEvent(this));
                break;
            }
            case 370: {
                this.game.processGameEvent(new GameMapQueryEvent((Object)this, (MapSettings)packet.getObject(0)));
                break;
            }
            case 380: {
                String string = (String)packet.getObject(0);
                this.game.end(packet.getIntValue(1), packet.getIntValue(2));
                this.saveEntityStatus(string);
                break;
            }
            case 470: {
                Vector vector = (Vector)packet.getObject(0);
                this.game.setArtilleryVector(vector);
                break;
            }
            case 480: {
                Vector vector = (Vector)packet.getObject(0);
                this.game.setFlares(vector);
                break;
            }
            case 500: {
                Object object;
                String string = (String)packet.getObject(0);
                String string2 = "savegames" + File.separator + string;
                try {
                    object = new File("savegames");
                    if (!((File)object).exists()) {
                        ((File)object).mkdir();
                    }
                }
                catch (Exception exception) {
                    System.err.println("Unable to create savegames directory");
                }
                try {
                    object = new ObjectOutputStream(new FileOutputStream(string2));
                    ((ObjectOutputStream)object).writeObject(packet.getObject(1));
                    ((ObjectOutputStream)object).flush();
                    ((ObjectOutputStream)object).close();
                }
                catch (Exception exception) {
                    System.err.println("Unable to save file: " + string);
                    exception.printStackTrace();
                }
                break;
            }
            case 505: {
                String string = (String)packet.getObject(0);
                try {
                    File file = new File("savegames", string);
                    this.sendLoadGame(file);
                }
                catch (Exception exception) {
                    System.err.println("Unable to find the file: " + string);
                }
                break;
            }
            case 510: {
                this.game.getBoard().setSpecialHexDisplayTable((Hashtable)packet.getObject(0));
            }
        }
    }

    private void memDump(String string) {
        if (PreferenceManager.getClientPreferences().memoryDumpOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().freeMemory();
            long l3 = l - l2;
            stringBuffer.append("Memory dump ").append(string);
            for (int i = string.length(); i < 25; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(": used (").append(l3).append(") + free (").append(l2).append(") = ").append(l);
            System.out.println(stringBuffer.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    private void correctName(Packet packet) {
        this.setName((String)packet.getObject(0));
    }

    public void setName(String string) {
        this.name = string;
    }

    private void checkDuplicateNamesDuringAdd(Entity entity) {
        if (this.duplicateNameHash.get(entity.getShortName()) == null) {
            this.duplicateNameHash.put(entity.getShortName(), new Integer(1));
        } else {
            int n = this.duplicateNameHash.get(entity.getShortName());
            this.duplicateNameHash.put(entity.getShortName(), new Integer(++n));
            entity.duplicateMarker = n;
            entity.generateShortName();
            entity.generateDisplayName();
        }
    }

    private void checkDuplicateNamesDuringDelete(int n) {
        Entity entity = this.game.getEntity(n);
        Integer n2 = this.duplicateNameHash.get(entity.getShortNameRaw());
        if (n2 != null) {
            int n3 = n2;
            if (n3 > 1) {
                ArrayList<Entity> arrayList = this.game.getPlayerEntities(this.game.getPlayer(this.local_pn), false);
                for (int i = 0; i < arrayList.size(); ++i) {
                    Entity entity2 = arrayList.get(i);
                    if (!entity2.getShortNameRaw().equals(entity.getShortNameRaw()) || entity2.duplicateMarker <= entity.duplicateMarker) continue;
                    --entity2.duplicateMarker;
                    entity2.generateShortName();
                    entity2.generateDisplayName();
                    this.sendUpdateEntity(entity2);
                }
                this.duplicateNameHash.put(entity.getShortNameRaw(), new Integer(n3 - 1));
            } else {
                this.duplicateNameHash.remove(entity.getShortNameRaw());
            }
        }
    }

    public String runCommand(String string) {
        string = string.substring(CLIENT_COMMAND.length());
        return this.runCommand(string.split("\\s+"));
    }

    public String runCommand(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && this.commandsHash.containsKey(stringArray[0])) {
            return this.commandsHash.get(stringArray[0]).run(stringArray);
        }
        return "Unknown Client Command.";
    }

    @Override
    public void registerCommand(ClientCommand clientCommand) {
        this.commandsHash.put(clientCommand.getName(), clientCommand);
    }

    @Override
    public ClientCommand getCommand(String string) {
        return this.commandsHash.get(string);
    }

    @Override
    public Enumeration<String> getAllCommandNames() {
        return this.commandsHash.keys();
    }
}

