/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlamerHeatHandler
extends WeaponHandler {
    private static final long serialVersionUID = -7785915075211288648L;

    public FlamerHeatHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity instanceof Mech && this.game.getOptions().booleanOption("flamer_heat")) {
            HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
            if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
                this.r = new Report(3460);
                this.r.subject = this.subjectId;
                this.r.add(entity.getShortName());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                this.r.indent(2);
                vector.addElement(this.r);
                this.missed = true;
                return;
            }
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.add(2);
            this.r.newlines = 0;
            this.r.choose(true);
            vector.addElement(this.r);
            entity.heatFromExternal += 2;
        } else {
            super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        }
    }

    @Override
    protected int calcDamagePerHit() {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                n = Compute.d6(3);
            }
            n = Compute.d6(4);
            if (this.bDirect) {
                n += this.toHit.getMoS() / 3;
            }
            if (((Entity)this.target).getCrew().getOptions().booleanOption("pain_shunt")) {
                n = (int)Math.floor((double)n / 2.0);
            }
            if (this.bGlancing) {
                n = (int)Math.floor((double)n / 2.0);
            }
        } else {
            n = super.calcDamagePerHit();
        }
        return n;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 3, vector);
        }
        this.server.checkExplodeIndustrialZone(this.target.getPosition(), vector);
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    @Override
    protected void handleIgnitionDamage(Vector<Report> vector, Building building, boolean bl, int n) {
        TargetRoll targetRoll;
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if ((targetRoll = new TargetRoll(this.wtype.getFireTN(), this.wtype.getName())).getValue() != Integer.MAX_VALUE) {
            Report.addNewline(vector);
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, targetRoll, true, -1, vector);
        }
    }

    @Override
    protected void handleClearDamage(Vector<Report> vector, Building building, int n, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3385);
        this.r.indent();
        this.r.subject = this.subjectId;
        this.r.add(n);
        vector.addElement(this.r);
        if (building != null && this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, true, false, new TargetRoll(this.wtype.getFireTN(), this.wtype.getName()), 5, vector)) {
            return;
        }
        vector.addAll(this.server.tryClearHex(this.target.getPosition(), n, this.subjectId));
    }
}

