/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.response;

import com.jgoodies.app.response.HttpStatus;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.validation.ValidationResult;

public final class ResponseError {
    private String id;
    private HttpStatus status;
    private String code;
    private String title;
    private String detail;
    private Object source;
    private Object meta;

    private ResponseError() {
    }

    public String getId() {
        return this.id;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetail() {
        return this.detail;
    }

    public Object getSource() {
        return this.source;
    }

    public Object getMeta() {
        return this.meta;
    }

    public boolean isValidationResult() {
        return this.meta instanceof ValidationResult;
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.getMeta();
    }

    public static class Builder {
        private final ResponseError target = new ResponseError();

        public Builder id(String id) {
            this.target.id = id;
            return this;
        }

        public Builder status(HttpStatus status) {
            this.target.status = status;
            return this;
        }

        public Builder badRequest() {
            return this.status(HttpStatus.BAD_REQUEST);
        }

        public Builder forbidden() {
            return this.status(HttpStatus.FORBIDDEN);
        }

        public Builder notFound() {
            return this.status(HttpStatus.NOT_FOUND);
        }

        public Builder internalServerError() {
            return this.status(HttpStatus.INTERNAL_SERVER_ERROR);
        }

        public Builder code(String code) {
            this.target.code = code;
            return this;
        }

        public Builder title(String str, Object ... args) {
            this.target.title = Strings.get(str, args);
            return this;
        }

        public Builder detail(String str, Object ... args) {
            this.target.detail = Strings.get(str, args);
            return this;
        }

        public Builder source(Object source) {
            this.target.source = source;
            return this;
        }

        public Builder meta(Object meta) {
            this.target.meta = meta;
            return this;
        }

        public Builder validationResult(ValidationResult result) {
            this.badRequest();
            this.meta(result);
            return this;
        }

        public ResponseError build() {
            Preconditions.checkNotNull(this.target.status, "The %s must not be null.", "status");
            return this.target;
        }
    }
}

