/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.MnemonicUtils;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public final class Actions {
    public static final String ACCESSIBLE_NAME_KEY = "AccessibleNameKey";
    public static final String ACCESSIBLE_DESCRIPTION_KEY = "AccessibleDescriptionKey";
    private static final String TEXT = ".Action.text";
    private static final String MNEMONIC = ".Action.mnemonic";
    private static final String ACCELERATOR = ".Action.accelerator";
    private static final String COMMAND = ".Action.command";
    private static final String ICON = ".Action.icon";
    private static final String SMALL_ICON = ".Action.smallIcon";
    private static final String LARGE_ICON = ".Action.largeIcon";
    private static final String SHORT_DESCRIPTION = ".Action.shortDescription";
    private static final String LONG_DESCRIPTION = ".Action.longDescription";
    private static final String ACCESSIBLE_NAME = ".Action.accessibleName";
    private static final String ACCESSIBLE_DESCRIPTION = ".Action.accessibleDescription";
    private static final Character NO_MNEMONIC = Character.valueOf('0');

    private Actions() {
    }

    public static void configure(Action action, ResourceMap map, String prefix) {
        Actions.configure(action, map, prefix, null);
    }

    public static void configure(Action action, ResourceMap map, String prefix, String configurationExceptionMessageDetails) {
        Integer mnemonic;
        Preconditions.checkNotNull(action, "The %s must not be null.", "Action");
        String markedText = Actions.getString(map, prefix + TEXT);
        String command = Actions.getString(map, prefix + COMMAND);
        String shortDescription = Actions.getString(map, prefix + SHORT_DESCRIPTION);
        String longDescription = Actions.getString(map, prefix + LONG_DESCRIPTION);
        String accessibleName = Actions.getString(map, prefix + ACCESSIBLE_NAME);
        String accessibleDescription = Actions.getString(map, prefix + ACCESSIBLE_DESCRIPTION);
        Icon smallIcon = Actions.getIcon(map, prefix + SMALL_ICON);
        Icon largeIcon = Actions.getIcon(map, prefix + LARGE_ICON);
        if (smallIcon == null) {
            smallIcon = Actions.getIcon(map, prefix + ICON);
        }
        KeyStroke accelerator = Actions.getObject(map, prefix + ACCELERATOR, KeyStroke.class, null);
        Character mnemonicChar = Actions.getObject(map, prefix + MNEMONIC, Character.class, NO_MNEMONIC);
        Integer n = mnemonic = mnemonicChar == null ? null : Integer.valueOf(Character.toUpperCase(mnemonicChar.charValue()));
        if (markedText == null) {
            Actions.checkConfiguration(smallIcon != null || largeIcon != null, map, prefix, configurationExceptionMessageDetails, "You must provide either the action text or action icon.\ntext key=%1$s\nicon key=%2$s");
        } else {
            Actions.checkConfiguration(Strings.isNotBlank(markedText), map, prefix, configurationExceptionMessageDetails, "The action text must not be empty or whitespace.\ntext key=%1$s");
        }
        MnemonicUtils.configure(action, markedText);
        if (mnemonicChar != NO_MNEMONIC) {
            Actions.configureMnemonicAndIndexFromMnemonic(action, mnemonic);
        }
        action.putValue("AcceleratorKey", accelerator);
        action.putValue("ShortDescription", shortDescription);
        action.putValue("LongDescription", longDescription);
        action.putValue("SmallIcon", smallIcon);
        action.putValue("SwingLargeIconKey", largeIcon);
        action.putValue("ActionCommandKey", command);
        action.putValue(ACCESSIBLE_NAME_KEY, accessibleName);
        action.putValue(ACCESSIBLE_DESCRIPTION_KEY, accessibleDescription);
    }

    private static void configureMnemonicAndIndexFromMnemonic(Action action, Integer mnemonic) {
        if (mnemonic == null) {
            action.putValue("MnemonicKey", null);
            action.putValue("SwingDisplayedMnemonicIndexKey", null);
            return;
        }
        action.putValue("MnemonicKey", mnemonic);
        String text = (String)action.getValue("Name");
        if (text == null) {
            return;
        }
        int computedMnemonicIndex = text.indexOf(mnemonic);
        if (computedMnemonicIndex == -1) {
            computedMnemonicIndex = text.indexOf(Character.toLowerCase(mnemonic));
        }
        action.putValue("SwingDisplayedMnemonicIndexKey", computedMnemonicIndex);
    }

    private static <T> T getObject(ResourceMap map, String key, Class<T> type, T defaultValue) {
        try {
            return map.getObject(key, type);
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    private static String getString(ResourceMap map, String key) {
        return Actions.getObject(map, key, String.class, null);
    }

    private static Icon getIcon(ResourceMap map, String key) {
        return Actions.getObject(map, key, Icon.class, null);
    }

    private static void checkConfiguration(boolean expression, ResourceMap map, String keyPrefix, String configurationExceptionMessageDetails, String rawMessageFormat) {
        if (!expression) {
            String messageFormat = configurationExceptionMessageDetails != null ? rawMessageFormat + configurationExceptionMessageDetails : rawMessageFormat + "\nbundle  =%3$s";
            String message = String.format(messageFormat, keyPrefix + TEXT, keyPrefix + SMALL_ICON, map.getBaseName());
            throw new Exceptions.ActionConfigurationException(message);
        }
    }
}

