/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.selection;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class AbstractRowSelectionManager
extends Bean {
    public static final String PROPERTY_LOOPING = "looping";
    public static final String PROPERTY_PAGE_INCREMENT = "pageIncrement";
    public static final String PROPERTY_SELECT_FIRST_ON_EMPTY_SELECTION = "selectFirstOnEmptySelection";
    protected static final int DEFAULT_PAGE_INCREMENT = 10;
    private static final String SELECTION_UP = "row-selection-up";
    private static final String SELECTION_DOWN = "row-selection-down";
    private static final String SELECTION_PAGE_UP = "row-selection-page-up";
    private static final String SELECTION_PAGE_DOWN = "row-selection-page-down";
    private static final String SELECTION_HOME = "row-selection-home";
    private static final String SELECTION_END = "row-selection-end";
    private int pageIncrement = 10;
    private boolean looping = false;
    private boolean selectFirstOnEmptySelection = true;

    protected AbstractRowSelectionManager() {
    }

    public void registerKeyboardActions(JComponent ... components) {
        Preconditions.checkNotNull(components, "The %s must not be null.", "components");
        for (JComponent c : components) {
            this.registerKeyboardActions0(c);
        }
    }

    public static final void unregisterKeyboardActions(JComponent c) {
        c.setInputMap(0, c.getInputMap().getParent());
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1);

    protected abstract int getRowCount();

    public final boolean isLooping() {
        return this.looping;
    }

    public final void setLooping(boolean newValue) {
        boolean oldValue = this.isLooping();
        this.looping = newValue;
        this.firePropertyChange(PROPERTY_LOOPING, oldValue, newValue);
    }

    public final int getPageIncrement() {
        return this.pageIncrement;
    }

    public final void setPageIncrement(int newValue) {
        int oldValue = this.getPageIncrement();
        this.pageIncrement = newValue;
        this.firePropertyChange(PROPERTY_PAGE_INCREMENT, oldValue, newValue);
    }

    public final boolean getSelectFirstOnEmptySelection() {
        return this.selectFirstOnEmptySelection;
    }

    public final void setSelectFirstOnEmptySelection(boolean newValue) {
        boolean oldValue = this.getSelectFirstOnEmptySelection();
        this.selectFirstOnEmptySelection = newValue;
        this.firePropertyChange(PROPERTY_SELECT_FIRST_ON_EMPTY_SELECTION, oldValue, newValue);
    }

    protected final boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    protected final boolean isSelectionEmpty() {
        return this.getSelectedIndex() == -1;
    }

    protected final void changeIndex(int increment, boolean loop) {
        int firstIndex = 0;
        if (this.isSelectionEmpty()) {
            if (this.getSelectFirstOnEmptySelection() && !this.isEmpty()) {
                this.setSelectedIndex(firstIndex);
            }
            return;
        }
        int newIndex = this.getSelectedIndex() + increment;
        int lastIndex = this.getRowCount() - 1;
        if (newIndex < firstIndex) {
            newIndex = loop ? lastIndex : firstIndex;
        } else if (newIndex > lastIndex) {
            newIndex = loop ? firstIndex : lastIndex;
        }
        this.setSelectedIndex(newIndex);
    }

    private void registerKeyboardActions0(JComponent c) {
        InputMap oldInputMap = c.getInputMap(0);
        InputMap newInputMap = new InputMap();
        newInputMap.setParent(oldInputMap);
        c.setInputMap(0, newInputMap);
        this.registerKeyboardAction(c, SELECTION_UP, KeyStroke.getKeyStroke(38, 0));
        this.registerKeyboardAction(c, SELECTION_DOWN, KeyStroke.getKeyStroke(40, 0));
        this.registerKeyboardAction(c, SELECTION_PAGE_UP, KeyStroke.getKeyStroke(33, 0));
        this.registerKeyboardAction(c, SELECTION_PAGE_DOWN, KeyStroke.getKeyStroke(34, 0));
        this.registerKeyboardAction(c, SELECTION_HOME, KeyStroke.getKeyStroke(36, 128));
        this.registerKeyboardAction(c, SELECTION_END, KeyStroke.getKeyStroke(35, 128));
    }

    private void registerKeyboardAction(JComponent c, String command, KeyStroke keyStroke) {
        c.getInputMap().put(keyStroke, command);
        c.getActionMap().put(command, new DispatchingSelectionAction(this, command));
    }

    private static final class DispatchingSelectionAction
    extends AbstractAction {
        private final AbstractRowSelectionManager manager;

        private DispatchingSelectionAction(AbstractRowSelectionManager manager, String name) {
            super(name);
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object name = this.getValue("Name");
            if (name == AbstractRowSelectionManager.SELECTION_UP) {
                this.manager.changeIndex(-1, this.manager.isLooping());
            } else if (name == AbstractRowSelectionManager.SELECTION_DOWN) {
                this.manager.changeIndex(1, this.manager.isLooping());
            } else if (name == AbstractRowSelectionManager.SELECTION_PAGE_UP) {
                this.manager.changeIndex(-this.manager.getPageIncrement(), false);
            } else if (name == AbstractRowSelectionManager.SELECTION_PAGE_DOWN) {
                this.manager.changeIndex(this.manager.getPageIncrement(), false);
            } else if (name == AbstractRowSelectionManager.SELECTION_HOME) {
                if (!this.manager.isEmpty()) {
                    this.manager.setSelectedIndex(0);
                }
            } else if (name == AbstractRowSelectionManager.SELECTION_END) {
                if (!this.manager.isEmpty()) {
                    this.manager.setSelectedIndex(this.manager.getRowCount() - 1);
                }
            } else {
                throw new IllegalStateException("Unknown action " + name);
            }
        }
    }
}

