/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.core.PCTemplate;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RacesubtypeToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "RACESUBTYPE";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate template, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String aType = tok.nextToken();
            if (aType.startsWith(".REMOVE.")) {
                String substring = aType.substring(8);
                if (substring.length() == 0) {
                    return new ParseResult.Fail("Invalid .REMOVE. in " + this.getTokenName() + " requires an argument", context);
                }
                context.getObjectContext().addToList((CDOMObject)template, ListKey.REMOVED_RACESUBTYPE, (Object)RaceSubType.getConstant((String)substring));
                continue;
            }
            context.getObjectContext().addToList((CDOMObject)template, ListKey.RACESUBTYPE, (Object)RaceSubType.getConstant((String)aType));
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes addedChanges = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.RACESUBTYPE);
        Changes removedChanges = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.REMOVED_RACESUBTYPE);
        Collection added = addedChanges.getAdded();
        Collection removed = removedChanges.getAdded();
        if (added == null && removed == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean needPipe = false;
        if (removed != null) {
            for (RaceSubType rst : removed) {
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(".REMOVE.").append(rst.toString());
                needPipe = true;
            }
        }
        if (added != null) {
            for (RaceSubType rst : added) {
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(rst.toString());
                needPipe = true;
            }
        }
        return new String[]{sb.toString()};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

