/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.IdentityList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.BonusContainer;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.AbilitySelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.content.Processor;
import pcgen.cdom.content.RollMethod;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.Handed;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.PCStringKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.SkillFilter;
import pcgen.cdom.enumeration.SkillsOutputOrder;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.facet.ActiveSpellsFacet;
import pcgen.cdom.facet.AddedBonusFacet;
import pcgen.cdom.facet.AddedTemplateFacet;
import pcgen.cdom.facet.AppliedBonusFacet;
import pcgen.cdom.facet.AutoEquipmentFacet;
import pcgen.cdom.facet.AutoLanguageGrantedFacet;
import pcgen.cdom.facet.AvailableSpellFacet;
import pcgen.cdom.facet.BonusChangeFacet;
import pcgen.cdom.facet.BonusSkillRankChangeFacet;
import pcgen.cdom.facet.CheckBonusFacet;
import pcgen.cdom.facet.ClassSpellListFacet;
import pcgen.cdom.facet.ConditionalAbilityFacet;
import pcgen.cdom.facet.ConditionallyGrantedAbilityFacet;
import pcgen.cdom.facet.ConditionallyGrantedAvailableSpellFacet;
import pcgen.cdom.facet.ConditionallyGrantedKnownSpellFacet;
import pcgen.cdom.facet.DirectAbilityFacet;
import pcgen.cdom.facet.DomainSpellCountFacet;
import pcgen.cdom.facet.EquipSetFacet;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.EquippedEquipmentFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.GrantedAbilityFacet;
import pcgen.cdom.facet.HitPointFacet;
import pcgen.cdom.facet.KitFacet;
import pcgen.cdom.facet.KnownSpellFacet;
import pcgen.cdom.facet.LevelInfoFacet;
import pcgen.cdom.facet.MasterFacet;
import pcgen.cdom.facet.NoteItemFacet;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.PrimaryWeaponFacet;
import pcgen.cdom.facet.SaveableBonusFacet;
import pcgen.cdom.facet.SavedAbilitiesFacet;
import pcgen.cdom.facet.SecondaryWeaponFacet;
import pcgen.cdom.facet.SkillCostFacet;
import pcgen.cdom.facet.SkillOutputOrderFacet;
import pcgen.cdom.facet.SkillPoolFacet;
import pcgen.cdom.facet.SkillRankFacet;
import pcgen.cdom.facet.SourcedEquipmentFacet;
import pcgen.cdom.facet.SpellBookFacet;
import pcgen.cdom.facet.SpellListFacet;
import pcgen.cdom.facet.SpellProhibitorFacet;
import pcgen.cdom.facet.SpellSupportFacet;
import pcgen.cdom.facet.StartingLanguageFacet;
import pcgen.cdom.facet.StatBonusFacet;
import pcgen.cdom.facet.StatCalcFacet;
import pcgen.cdom.facet.StatValueFacet;
import pcgen.cdom.facet.SubClassFacet;
import pcgen.cdom.facet.SubstitutionClassFacet;
import pcgen.cdom.facet.TargetTrackingFacet;
import pcgen.cdom.facet.TemplateFeatFacet;
import pcgen.cdom.facet.UserEquipmentFacet;
import pcgen.cdom.facet.XPTableFacet;
import pcgen.cdom.facet.analysis.AgeSetFacet;
import pcgen.cdom.facet.analysis.ChangeProfFacet;
import pcgen.cdom.facet.analysis.CharacterSpellResistanceFacet;
import pcgen.cdom.facet.analysis.FavoredClassFacet;
import pcgen.cdom.facet.analysis.FollowerLimitFacet;
import pcgen.cdom.facet.analysis.LegalDeityFacet;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.analysis.LevelTableFacet;
import pcgen.cdom.facet.analysis.LoadFacet;
import pcgen.cdom.facet.analysis.MovementResultFacet;
import pcgen.cdom.facet.analysis.NonAbilityFacet;
import pcgen.cdom.facet.analysis.NonStatStatFacet;
import pcgen.cdom.facet.analysis.NonStatToStatFacet;
import pcgen.cdom.facet.analysis.QualifyFacet;
import pcgen.cdom.facet.analysis.SpecialAbilityFacet;
import pcgen.cdom.facet.analysis.StatLockFacet;
import pcgen.cdom.facet.analysis.UnlockedStatFacet;
import pcgen.cdom.facet.analysis.VariableFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.fact.AgeFacet;
import pcgen.cdom.facet.fact.AllowDebtFacet;
import pcgen.cdom.facet.fact.CharacterTypeFacet;
import pcgen.cdom.facet.fact.ChronicleEntryFacet;
import pcgen.cdom.facet.fact.FactFacet;
import pcgen.cdom.facet.fact.FollowerFacet;
import pcgen.cdom.facet.fact.GenderFacet;
import pcgen.cdom.facet.fact.GoldFacet;
import pcgen.cdom.facet.fact.HandedFacet;
import pcgen.cdom.facet.fact.HeightFacet;
import pcgen.cdom.facet.fact.IgnoreCostFacet;
import pcgen.cdom.facet.fact.PortraitThumbnailRectFacet;
import pcgen.cdom.facet.fact.PreviewSheetFacet;
import pcgen.cdom.facet.fact.RegionFacet;
import pcgen.cdom.facet.fact.SkillFilterFacet;
import pcgen.cdom.facet.fact.SuppressBioFieldFacet;
import pcgen.cdom.facet.fact.WeightFacet;
import pcgen.cdom.facet.fact.XPFacet;
import pcgen.cdom.facet.input.AddLanguageFacet;
import pcgen.cdom.facet.input.AutoEquipmentListFacet;
import pcgen.cdom.facet.input.AutoLanguageListFacet;
import pcgen.cdom.facet.input.AutoListArmorProfFacet;
import pcgen.cdom.facet.input.AutoListShieldProfFacet;
import pcgen.cdom.facet.input.AutoListWeaponProfFacet;
import pcgen.cdom.facet.input.BonusWeaponProfFacet;
import pcgen.cdom.facet.input.CampaignFacet;
import pcgen.cdom.facet.input.DomainInputFacet;
import pcgen.cdom.facet.input.FreeLanguageFacet;
import pcgen.cdom.facet.input.GlobalAddedSkillCostFacet;
import pcgen.cdom.facet.input.LocalAddedSkillCostFacet;
import pcgen.cdom.facet.input.MonsterCSkillFacet;
import pcgen.cdom.facet.input.ProhibitedSchoolFacet;
import pcgen.cdom.facet.input.RaceInputFacet;
import pcgen.cdom.facet.input.TemplateInputFacet;
import pcgen.cdom.facet.input.UserSpecialAbilityFacet;
import pcgen.cdom.facet.model.AlignmentFacet;
import pcgen.cdom.facet.model.ArmorProfProviderFacet;
import pcgen.cdom.facet.model.BioSetFacet;
import pcgen.cdom.facet.model.CheckFacet;
import pcgen.cdom.facet.model.ClassFacet;
import pcgen.cdom.facet.model.CompanionModFacet;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.cdom.facet.model.DomainFacet;
import pcgen.cdom.facet.model.ExpandedCampaignFacet;
import pcgen.cdom.facet.model.LanguageFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.ShieldProfProviderFacet;
import pcgen.cdom.facet.model.SizeFacet;
import pcgen.cdom.facet.model.SkillFacet;
import pcgen.cdom.facet.model.StatFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.cdom.facet.model.WeaponProfModelFacet;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.helper.ClassSource;
import pcgen.cdom.helper.ProfProvider;
import pcgen.cdom.helper.SAProcessor;
import pcgen.cdom.helper.SAtoStringProcessor;
import pcgen.cdom.helper.SpringHelper;
import pcgen.cdom.identifier.SpellSchool;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.inst.ObjectCache;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.ArmorProf;
import pcgen.core.AssociationSupport;
import pcgen.core.BioSet;
import pcgen.core.BonusManager;
import pcgen.core.Campaign;
import pcgen.core.ChronicleEntry;
import pcgen.core.Deity;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.EquipmentUtilities;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.LevelInfo;
import pcgen.core.NoteItem;
import pcgen.core.PCAlignment;
import pcgen.core.PCCheck;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacterUtilities;
import pcgen.core.PointBuyMethod;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SkillUtilities;
import pcgen.core.SpecialAbility;
import pcgen.core.SpellProhibitor;
import pcgen.core.SpellSupportForPCClass;
import pcgen.core.SystemCollections;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessor;
import pcgen.core.VariableProcessorPC;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.ChooseActivation;
import pcgen.core.analysis.DomainApplication;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.analysis.SpellCountCalc;
import pcgen.core.analysis.SpellLevel;
import pcgen.core.analysis.StatAnalysis;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusPair;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.character.Follower;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.SkillDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.ExportHandler;
import pcgen.io.PCGFile;
import pcgen.system.PCGenSettings;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.AttackType;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.View;

public class PlayerCharacter
implements Cloneable,
VariableContainer {
    private static String lastVariable = null;
    private static ObjectCache grantedSpellCache = new ObjectCache();
    private CharID id;
    private final SAtoStringProcessor SA_TO_STRING_PROC;
    private final SAProcessor SA_PROC;
    private final CharacterDisplay display;
    private AllowDebtFacet allowDebtFacet = FacetLibrary.getFacet(AllowDebtFacet.class);
    private ChronicleEntryFacet chronicleEntryFacet = FacetLibrary.getFacet(ChronicleEntryFacet.class);
    private IgnoreCostFacet ignoreCostFacet = FacetLibrary.getFacet(IgnoreCostFacet.class);
    private GenderFacet genderFacet = FacetLibrary.getFacet(GenderFacet.class);
    private HandedFacet handedFacet = FacetLibrary.getFacet(HandedFacet.class);
    private HeightFacet heightFacet = FacetLibrary.getFacet(HeightFacet.class);
    private WeightFacet weightFacet = FacetLibrary.getFacet(WeightFacet.class);
    private AddLanguageFacet addLangFacet = FacetLibrary.getFacet(AddLanguageFacet.class);
    private AutoLanguageListFacet autoLangListFacet = FacetLibrary.getFacet(AutoLanguageListFacet.class);
    private FreeLanguageFacet freeLangFacet = FacetLibrary.getFacet(FreeLanguageFacet.class);
    private CharacterTypeFacet characterTypeFacet = FacetLibrary.getFacet(CharacterTypeFacet.class);
    private SuppressBioFieldFacet suppressBioFieldFacet = FacetLibrary.getFacet(SuppressBioFieldFacet.class);
    private AutoListArmorProfFacet armorProfListFacet = FacetLibrary.getFacet(AutoListArmorProfFacet.class);
    private AutoListShieldProfFacet shieldProfListFacet = FacetLibrary.getFacet(AutoListShieldProfFacet.class);
    private AutoListWeaponProfFacet alWeaponProfFacet = FacetLibrary.getFacet(AutoListWeaponProfFacet.class);
    private RegionFacet regionFacet = FacetLibrary.getFacet(RegionFacet.class);
    private NoteItemFacet noteItemFacet = FacetLibrary.getFacet(NoteItemFacet.class);
    private GlobalAddedSkillCostFacet globalAddedSkillCostFacet = FacetLibrary.getFacet(GlobalAddedSkillCostFacet.class);
    private LocalAddedSkillCostFacet localAddedSkillCostFacet = FacetLibrary.getFacet(LocalAddedSkillCostFacet.class);
    private PreviewSheetFacet previewSheetFacet = FacetLibrary.getFacet(PreviewSheetFacet.class);
    private SkillFilterFacet skillFilterFacet = FacetLibrary.getFacet(SkillFilterFacet.class);
    private AddedTemplateFacet addedTemplateFacet = FacetLibrary.getFacet(AddedTemplateFacet.class);
    private BonusWeaponProfFacet wpBonusFacet = FacetLibrary.getFacet(BonusWeaponProfFacet.class);
    private ClassSpellListFacet classSpellListFacet = FacetLibrary.getFacet(ClassSpellListFacet.class);
    private DomainSpellCountFacet domainSpellCountFacet = FacetLibrary.getFacet(DomainSpellCountFacet.class);
    private LegalDeityFacet legalDeityFacet = FacetLibrary.getFacet(LegalDeityFacet.class);
    private GoldFacet goldFacet = FacetLibrary.getFacet(GoldFacet.class);
    private MonsterCSkillFacet monCSkillFacet = FacetLibrary.getFacet(MonsterCSkillFacet.class);
    private NonAbilityFacet nonAbilityFacet = FacetLibrary.getFacet(NonAbilityFacet.class);
    private QualifyFacet qualifyFacet = FacetLibrary.getFacet(QualifyFacet.class);
    private SkillOutputOrderFacet skillOutputOrderFacet = FacetLibrary.getFacet(SkillOutputOrderFacet.class);
    private SkillPoolFacet skillPoolFacet = FacetLibrary.getFacet(SkillPoolFacet.class);
    private SkillRankFacet skillRankFacet = FacetLibrary.getFacet(SkillRankFacet.class);
    private StartingLanguageFacet startingLangFacet = FacetLibrary.getFacet(StartingLanguageFacet.class);
    private StatCalcFacet statCalcFacet = FacetLibrary.getFacet(StatCalcFacet.class);
    private StatLockFacet statLockFacet = FacetLibrary.getFacet(StatLockFacet.class);
    private StatValueFacet statValueFacet = FacetLibrary.getFacet(StatValueFacet.class);
    private SubClassFacet subClassFacet = FacetLibrary.getFacet(SubClassFacet.class);
    private SubstitutionClassFacet substitutionClassFacet = FacetLibrary.getFacet(SubstitutionClassFacet.class);
    private UnlockedStatFacet unlockedStatFacet = FacetLibrary.getFacet(UnlockedStatFacet.class);
    private NonStatStatFacet nonStatStatFacet = FacetLibrary.getFacet(NonStatStatFacet.class);
    private NonStatToStatFacet nonStatToStatFacet = FacetLibrary.getFacet(NonStatToStatFacet.class);
    private TemplateFeatFacet templateFeatFacet = FacetLibrary.getFacet(TemplateFeatFacet.class);
    private SavedAbilitiesFacet svAbilityFacet = FacetLibrary.getFacet(SavedAbilitiesFacet.class);
    private XPFacet xpFacet = FacetLibrary.getFacet(XPFacet.class);
    private XPTableFacet xpTableFacet = FacetLibrary.getFacet(XPTableFacet.class);
    private AlignmentFacet alignmentFacet = FacetLibrary.getFacet(AlignmentFacet.class);
    private CheckFacet checkFacet = FacetLibrary.getFacet(CheckFacet.class);
    private CompanionModFacet companionModFacet = FacetLibrary.getFacet(CompanionModFacet.class);
    private CampaignFacet campaignFacet = FacetLibrary.getFacet(CampaignFacet.class);
    private ExpandedCampaignFacet expandedCampaignFacet = FacetLibrary.getFacet(ExpandedCampaignFacet.class);
    private AgeSetFacet ageSetFacet = FacetLibrary.getFacet(AgeSetFacet.class);
    private DomainFacet domainFacet = FacetLibrary.getFacet(DomainFacet.class);
    private DomainInputFacet domainInputFacet = FacetLibrary.getFacet(DomainInputFacet.class);
    private TemplateFacet templateFacet = FacetLibrary.getFacet(TemplateFacet.class);
    private TemplateInputFacet templateInputFacet = FacetLibrary.getFacet(TemplateInputFacet.class);
    private DeityFacet deityFacet = FacetLibrary.getFacet(DeityFacet.class);
    private RaceFacet raceFacet = FacetLibrary.getFacet(RaceFacet.class);
    private RaceInputFacet raceInputFacet = FacetLibrary.getFacet(RaceInputFacet.class);
    private StatFacet statFacet = FacetLibrary.getFacet(StatFacet.class);
    private StatBonusFacet statBonusFacet = FacetLibrary.getFacet(StatBonusFacet.class);
    private CheckBonusFacet checkBonusFacet = FacetLibrary.getFacet(CheckBonusFacet.class);
    private SkillFacet skillFacet = FacetLibrary.getFacet(SkillFacet.class);
    private ClassFacet classFacet = FacetLibrary.getFacet(ClassFacet.class);
    private BioSetFacet bioSetFacet = FacetLibrary.getFacet(BioSetFacet.class);
    private UserEquipmentFacet userEquipmentFacet = FacetLibrary.getFacet(UserEquipmentFacet.class);
    private EquipmentFacet equipmentFacet = FacetLibrary.getFacet(EquipmentFacet.class);
    private EquippedEquipmentFacet equippedFacet = FacetLibrary.getFacet(EquippedEquipmentFacet.class);
    private SourcedEquipmentFacet activeEquipmentFacet = FacetLibrary.getFacet(SourcedEquipmentFacet.class);
    private ConditionallyGrantedAbilityFacet cabFacet = FacetLibrary.getFacet(ConditionallyGrantedAbilityFacet.class);
    private ConditionallyGrantedKnownSpellFacet cKnSpellFacet = FacetLibrary.getFacet(ConditionallyGrantedKnownSpellFacet.class);
    private ConditionallyGrantedAvailableSpellFacet cAvSpellFacet = FacetLibrary.getFacet(ConditionallyGrantedAvailableSpellFacet.class);
    private ConditionalAbilityFacet conditionalFacet = FacetLibrary.getFacet(ConditionalAbilityFacet.class);
    private GrantedAbilityFacet grantedAbilityFacet = FacetLibrary.getFacet(GrantedAbilityFacet.class);
    private DirectAbilityFacet directAbilityFacet = FacetLibrary.getFacet(DirectAbilityFacet.class);
    private KitFacet kitFacet = FacetLibrary.getFacet(KitFacet.class);
    private ArmorProfProviderFacet armorProfFacet = FacetLibrary.getFacet(ArmorProfProviderFacet.class);
    private ShieldProfProviderFacet shieldProfFacet = FacetLibrary.getFacet(ShieldProfProviderFacet.class);
    private CharacterSpellResistanceFacet srFacet = FacetLibrary.getFacet(CharacterSpellResistanceFacet.class);
    private WeaponProfModelFacet weaponProfFacet = FacetLibrary.getFacet(WeaponProfModelFacet.class);
    private MasterFacet masterFacet = FacetLibrary.getFacet(MasterFacet.class);
    private AutoEquipmentListFacet autoListEquipmentFacet = FacetLibrary.getFacet(AutoEquipmentListFacet.class);
    private FollowerFacet followerFacet = FacetLibrary.getFacet(FollowerFacet.class);
    private LanguageFacet languageFacet = FacetLibrary.getFacet(LanguageFacet.class);
    private UserSpecialAbilityFacet userSpecialAbilityFacet = FacetLibrary.getFacet(UserSpecialAbilityFacet.class);
    private SpecialAbilityFacet specialAbilityFacet = FacetLibrary.getFacet(SpecialAbilityFacet.class);
    private PrimaryWeaponFacet primaryWeaponFacet = FacetLibrary.getFacet(PrimaryWeaponFacet.class);
    private SecondaryWeaponFacet secondaryWeaponFacet = FacetLibrary.getFacet(SecondaryWeaponFacet.class);
    private AutoLanguageGrantedFacet condLangFacet = FacetLibrary.getFacet(AutoLanguageGrantedFacet.class);
    private SkillCostFacet skillCostFacet = FacetLibrary.getFacet(SkillCostFacet.class);
    private ProhibitedSchoolFacet prohibitedSchoolFacet = FacetLibrary.getFacet(ProhibitedSchoolFacet.class);
    private SpellProhibitorFacet spellProhibitorFacet = FacetLibrary.getFacet(SpellProhibitorFacet.class);
    private ObjectCache cache = new ObjectCache();
    private AssociationSupport assocSupt = new AssociationSupport();
    private BonusManager bonusManager = new BonusManager(this);
    private BonusChangeFacet bonusChangeFacet = FacetLibrary.getFacet(BonusChangeFacet.class);
    private EquipSetFacet equipSetFacet = FacetLibrary.getFacet(EquipSetFacet.class);
    private HitPointFacet hitPointFacet = FacetLibrary.getFacet(HitPointFacet.class);
    private KnownSpellFacet knownSpellFacet = FacetLibrary.getFacet(KnownSpellFacet.class);
    private LevelFacet levelFacet = FacetLibrary.getFacet(LevelFacet.class);
    private LevelTableFacet levelTableFacet = FacetLibrary.getFacet(LevelTableFacet.class);
    private SizeFacet sizeFacet = FacetLibrary.getFacet(SizeFacet.class);
    private FactFacet factFacet = FacetLibrary.getFacet(FactFacet.class);
    private FavoredClassFacet favClassFacet = FacetLibrary.getFacet(FavoredClassFacet.class);
    private VariableFacet variableFacet = FacetLibrary.getFacet(VariableFacet.class);
    private FollowerLimitFacet followerLimitFacet = FacetLibrary.getFacet(FollowerLimitFacet.class);
    private AvailableSpellFacet availSpellFacet = FacetLibrary.getFacet(AvailableSpellFacet.class);
    private MovementResultFacet moveResultFacet = FacetLibrary.getFacet(MovementResultFacet.class);
    private AutoEquipmentFacet autoEquipFacet = FacetLibrary.getFacet(AutoEquipmentFacet.class);
    private SpellBookFacet spellBookFacet = FacetLibrary.getFacet(SpellBookFacet.class);
    private LoadFacet loadFacet = FacetLibrary.getFacet(LoadFacet.class);
    private AppliedBonusFacet appliedBonusFacet = FacetLibrary.getFacet(AppliedBonusFacet.class);
    private AddedBonusFacet addedBonusFacet = FacetLibrary.getFacet(AddedBonusFacet.class);
    private SaveableBonusFacet saveableBonusFacet = FacetLibrary.getFacet(SaveableBonusFacet.class);
    private SpellSupportFacet spellSupportFacet = FacetLibrary.getFacet(SpellSupportFacet.class);
    private AgeFacet ageFacet = FacetLibrary.getFacet(AgeFacet.class);
    private ActiveSpellsFacet activeSpellsFacet = FacetLibrary.getFacet(ActiveSpellsFacet.class);
    private SpellListFacet spellListFacet = FacetLibrary.getFacet(SpellListFacet.class);
    private ChangeProfFacet changeProfFacet = FacetLibrary.getFacet(ChangeProfFacet.class);
    private TargetTrackingFacet astocnasFacet = FacetLibrary.getFacet(TargetTrackingFacet.class);
    private PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private PortraitThumbnailRectFacet portraitThumbnailRectFacet = FacetLibrary.getFacet(PortraitThumbnailRectFacet.class);
    private BonusSkillRankChangeFacet bonusSkillRankChangeFacet = FacetLibrary.getFacet(BonusSkillRankChangeFacet.class);
    private LevelInfoFacet levelInfoFacet = FacetLibrary.getFacet(LevelInfoFacet.class);
    private ClassSource defaultDomainSource;
    private Map<String, Integer> autoEquipOutputOrderCache = new HashMap<String, Integer>();
    private List<Equipment> tempBonusItemList = new ArrayList<Equipment>();
    private String calcEquipSetId = EquipSet.DEFAULT_SET_PATH;
    private String descriptionLst = "EMPTY";
    private boolean autoKnownSpells = true;
    private boolean useHigherKnownSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean useHigherPreppedSlots = SettingsHandler.isUseHigherLevelSlotsDefault();
    private boolean autoLoadCompanion = false;
    private boolean autoSortGear = true;
    private boolean autoResize = PCGenSettings.getInstance().getBoolean("autoResizeEquip", true);
    private String outputSheetHTML = "";
    private String outputSheetPDF = "";
    private boolean[] ageSetKitSelections = new boolean[10];
    private boolean dirtyFlag = false;
    private int serial = 0;
    private boolean displayUpdate = false;
    private boolean importing = false;
    private boolean useTempMods = true;
    private int costPool = 0;
    private int currentEquipSetNumber = 0;
    private int poolAmount = 0;
    private SkillsOutputOrder skillsOutputOrder = SkillsOutputOrder.NAME_ASC;
    private int spellLevelTemp = 0;
    private VariableProcessor variableProcessor;
    private int pointBuyPoints = -1;
    private boolean processLevelAbilities = true;
    private boolean allowInteraction = true;
    private Map<Category<Ability>, BigDecimal> theUserPoolBonuses = null;
    private Integer epicBAB = null;
    private HashMap<PCCheck, Integer> epicCheckMap = new HashMap();
    private CNAbility bonusLanguageAbility = CNAbilityFactory.getCNAbility(AbilityCategory.LANGBONUS, Nature.VIRTUAL, Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Ability.class, AbilityCategory.LANGBONUS, "*LANGBONUS"));
    private int cablInt = 1;
    private int lastCablInt = 0;

    public PlayerCharacter() {
        this(true, Collections.EMPTY_LIST);
    }

    public PlayerCharacter(boolean load, Collection<Campaign> loadedCampaigns) {
        this.id = CharID.getID(Globals.getContext().getDataSetID());
        this.display = new CharacterDisplay(this.id);
        this.SA_TO_STRING_PROC = new SAtoStringProcessor(this);
        this.SA_PROC = new SAProcessor(this);
        this.trackingFacet.associatePlayerCharacter(this.id, this);
        this.variableProcessor = new VariableProcessorPC(this);
        for (int i = 0; i < 10; ++i) {
            this.ageSetKitSelections[i] = false;
        }
        this.bioSetFacet.set(this.id, Globals.getBioSet());
        this.setRace(Globals.s_EMPTYRACE);
        this.statFacet.addAll(this.id, Globals.getContext().getReferenceContext().getOrderSortedCDOMObjects(PCStat.class));
        this.checkFacet.addAll(this.id, Globals.getContext().getReferenceContext().getOrderSortedCDOMObjects(PCCheck.class));
        this.campaignFacet.addAll(this.id, loadedCampaigns);
        this.setGold(new BigDecimal(0));
        this.setXPTable(SettingsHandler.getGame().getDefaultXPTableName());
        this.setCharacterType(SettingsHandler.getGame().getDefaultCharacterType());
        this.setPreviewSheet(SettingsHandler.getGame().getDefaultPreviewSheet());
        this.setName("");
        this.setUserPoolBonus(AbilityCategory.FEAT, BigDecimal.ZERO);
        this.rollStats(SettingsHandler.getGame().getRollMethod());
        this.addSpellBook(new SpellBook(Globals.getDefaultSpellBook(), 1));
        this.addSpellBook(new SpellBook("Innate", 4));
    }

    public String toString() {
        return "PlayerCharacter [name=" + this.getName() + " @ " + this.getFileName() + " serial=" + this.getSerial() + "]";
    }

    public void setAge(int i) {
        if (this.ageFacet.set(this.id, i)) {
            this.setDirty(true);
            this.calcActiveBonuses();
        }
    }

    public void setBio(String bio) {
        this.setStringFor(PCStringKey.BIO, bio);
    }

    public void setBirthday(String birthday) {
        this.setStringFor(PCStringKey.BIRTHDAY, birthday);
    }

    public void setBirthplace(String birthPlace) {
        this.setStringFor(PCStringKey.BIRTHPLACE, birthPlace);
    }

    public void setCalcEquipSetId(String eqSetId) {
        if (this.calcEquipSetId != eqSetId) {
            this.calcEquipSetId = eqSetId;
            EquipSet equipSet = this.getEquipSetByIdPath(eqSetId);
            if (equipSet != null) {
                this.setCurrentEquipSetName(equipSet.getName());
            }
            this.setDirty(true);
        }
    }

    public String getCalcEquipSetId() {
        if (this.equipSetFacet.isEmpty(this.id)) {
            return this.calcEquipSetId;
        }
        if (this.getEquipSetByIdPath(this.calcEquipSetId) == null) {
            for (EquipSet eSet : this.equipSetFacet.getSet(this.id)) {
                if (!eSet.getParentIdPath().equals("0")) continue;
                this.calcEquipSetId = eSet.getIdPath();
                return this.calcEquipSetId;
            }
        }
        return this.calcEquipSetId;
    }

    public void setCalcEquipmentList() {
        this.setCalcEquipmentList(false);
    }

    public void setCalcEquipmentList(boolean useTempBonuses) {
        Equipment anEquip;
        String calcId = this.getCalcEquipSetId();
        EquipSet eSet = this.getEquipSetByIdPath(calcId);
        if (eSet == null) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("No EquipSet has been selected for calculations yet.");
            }
            return;
        }
        this.equipmentFacet.removeAll(this.id);
        ArrayList<EquipSet> pcEquipSetList = new ArrayList<EquipSet>(this.getEquipSet());
        if (pcEquipSetList.isEmpty()) {
            this.equippedFacet.reset(this.id);
            return;
        }
        Collections.sort(pcEquipSetList);
        for (EquipSet es : pcEquipSetList) {
            if (es.getItem() == null || !es.isPartOf(calcId)) continue;
            es.equipItem(this);
            es.addNoteToItem();
            this.addLocalEquipment(es.getItem());
        }
        for (Equipment eq : this.getEquipmentSet()) {
            if (eq.isContainer()) {
                eq.updateContainerContentsString(this);
            }
            if ((anEquip = this.getEquipmentNamed(eq.getName())) == null) continue;
            eq.setOutputIndex(anEquip.getOutputIndex());
        }
        if (useTempBonuses) {
            for (Equipment eq : this.getTempBonusItemList()) {
                anEquip = this.getEquipmentNamed(eq.getName(), this.getEquipmentSet());
                if (anEquip == null) continue;
                eq.setQty(anEquip.getQty());
                eq.setNumberCarried(anEquip.getCarried());
                if (anEquip.isEquipped()) {
                    if (eq.isWeapon()) {
                        eq.put(IntegerKey.SLOTS, 0);
                        eq.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
                        eq.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
                        eq.setLocation(anEquip.getLocation());
                    } else {
                        eq.setLocation(anEquip.getLocation());
                        this.removeLocalEquipment(anEquip);
                        anEquip.setIsEquipped(false, this);
                        anEquip.setLocation(EquipmentLocation.NOT_CARRIED);
                        anEquip.setNumberCarried(Float.valueOf(0.0f));
                    }
                    eq.setIsEquipped(true, this);
                    eq.setNumberEquipped(1);
                } else {
                    eq.put(ObjectKey.CURRENT_COST, BigDecimal.ZERO);
                    eq.put(ObjectKey.WEIGHT, BigDecimal.ZERO);
                    eq.setLocation(EquipmentLocation.EQUIPPED_TEMPBONUS);
                    eq.setIsEquipped(false, this);
                }
                eq.addType(Type.TEMPORARY);
                this.addLocalEquipment(eq);
            }
        }
        this.equippedFacet.reset(this.id);
    }

    public void setCalcFollowerBonus() {
        this.setDirty(true);
        for (Follower aF : this.getFollowerList()) {
            CompanionList cList = aF.getType();
            String rType = cList.getKeyName();
            Race fRace = aF.getRace();
            for (CompanionMod cm : Globals.getContext().getReferenceContext().getManufacturer(CompanionMod.class, cList).getAllObjects()) {
                String aType = cm.getType();
                if (!aType.equalsIgnoreCase(rType) || !cm.appliesToRace(fRace)) continue;
                this.companionModFacet.add(this.id, cm);
            }
        }
    }

    public void setCatchPhrase(String phrase) {
        this.setStringFor(PCStringKey.CATCHPHRASE, phrase);
    }

    public PCClass getClassKeyed(String key) {
        for (PCClass aClass : this.getClassSet()) {
            if (!aClass.getKeyName().equalsIgnoreCase(key)) continue;
            return aClass;
        }
        return null;
    }

    public ArrayList<PCClass> getClassList() {
        return new ArrayList<PCClass>(this.getClassSet());
    }

    public Set<PCClass> getClassSet() {
        return this.classFacet.getSet(this.id);
    }

    public void setCostPool(int i) {
        this.costPool = i;
    }

    public int getCostPool() {
        return this.costPool;
    }

    public void setCurrentEquipSetName(String aName) {
        this.setStringFor(PCStringKey.CURRENT_EQUIP_SET_NAME, aName);
    }

    public Deity getDeity() {
        return (Deity)((AbstractItemFacet)this.deityFacet).get(this.id);
    }

    public void setDescription(String aString) {
        this.setStringFor(PCStringKey.DESCRIPTION, aString);
    }

    public String getDescriptionLst() {
        return this.descriptionLst;
    }

    public void setDirty(boolean dirtyState) {
        if (dirtyState) {
            ++this.serial;
            this.cache = new ObjectCache();
            this.getVariableProcessor().setSerial(this.serial);
            this.cabFacet.update(this.id);
            this.cAvSpellFacet.update(this.id);
            this.cKnSpellFacet.update(this.id);
            this.condLangFacet.update(this.id);
            this.bonusSkillRankChangeFacet.reset(this.id);
        }
        this.dirtyFlag = dirtyState;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public int getSerial() {
        return this.serial;
    }

    public void setDisplayUpdate(boolean update) {
        this.displayUpdate = update;
    }

    public boolean isDisplayUpdate() {
        return this.displayUpdate;
    }

    private Collection<EquipSet> getEquipSet() {
        return this.equipSetFacet.getSet(this.id);
    }

    public EquipSet getEquipSetByIdPath(String path) {
        return this.equipSetFacet.getEquipSetByIdPath(this.id, path);
    }

    public void setEquipSetNumber(int anInt) {
        if (this.currentEquipSetNumber != anInt) {
            this.currentEquipSetNumber = anInt;
            this.setDirty(true);
        }
    }

    public int getEquipSetNumber() {
        return this.currentEquipSetNumber;
    }

    public double getEquipSetWeightDouble(String idPath) {
        if (this.equipSetFacet.isEmpty(this.id)) {
            return 0.0;
        }
        double totalWeight = 0.0;
        for (EquipSet es : this.equipSetFacet.getSet(this.id)) {
            Equipment eqI;
            String abIdPath = idPath + ".";
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(abIdPath) || (eqI = es.getItem()) == null || !(eqI.getCarried().floatValue() > 0.0f) || eqI.getParent() != null) continue;
            if (eqI.getChildCount() > 0) {
                totalWeight += eqI.getWeightAsDouble(this) + (double)eqI.getContainedWeight(this).floatValue();
                continue;
            }
            totalWeight += eqI.getWeightAsDouble(this) * (double)eqI.getCarried().floatValue();
        }
        return totalWeight;
    }

    private Set<Equipment> getEquipmentSet() {
        return this.equipmentFacet.getSet(this.id);
    }

    public Set<Equipment> getEquippedEquipmentSet() {
        return this.equippedFacet.getSet(this.id);
    }

    public List<Equipment> getEquipmentListInOutputOrder() {
        return this.sortEquipmentList(this.getEquipmentSet(), 0);
    }

    public List<Equipment> getEquipmentListInOutputOrder(int merge) {
        return this.sortEquipmentList(this.getEquipmentSet(), merge);
    }

    public List<Equipment> getEquipmentMasterList() {
        Set set = this.userEquipmentFacet.getSet(this.id);
        ArrayList<Equipment> aList = new ArrayList<Equipment>(set);
        aList.addAll(this.autoListEquipmentFacet.getSet(this.id));
        aList.addAll(this.autoEquipFacet.getAutoEquipment(this.id));
        return aList;
    }

    public List<Equipment> getEquipmentMasterListInOutputOrder() {
        List<Equipment> l = this.getEquipmentMasterList();
        Collections.sort(l, CoreUtility.equipmentComparator);
        return l;
    }

    private Equipment getEquipmentNamed(String aString, Collection<Equipment> aList) {
        Equipment match = null;
        for (Equipment eq : aList) {
            if (!aString.equalsIgnoreCase(eq.getName())) continue;
            match = eq;
        }
        return match;
    }

    public Equipment getEquipmentNamed(String name) {
        return this.getEquipmentNamed(name, this.getEquipmentMasterList());
    }

    public void setEyeColor(String aString) {
        this.setStringFor(PCStringKey.EYECOLOR, aString);
    }

    private double getBonusFeatPool() {
        String aString = Globals.getBonusFeatString();
        StringTokenizer aTok = new StringTokenizer(aString, "|", false);
        int startLevel = Integer.parseInt(aTok.nextToken());
        int rangeLevel = Integer.parseInt(aTok.nextToken());
        double pool = this.getTotalBonusTo("FEAT", "POOL");
        double pcpool = this.getTotalBonusTo("FEAT", "PCPOOL");
        double mpool = this.getTotalBonusTo("FEAT", "MONSTERPOOL");
        double bonus = this.getTotalBonusTo("ABILITYPOOL", "FEAT");
        double classLvlBonus = this.getNumFeatsFromLevels();
        if (Logging.isDebugMode()) {
            Logging.debugPrint("");
            Logging.debugPrint("==============");
            Logging.debugPrint("level " + this.totalNonMonsterLevels());
            Logging.debugPrint("POOL:   " + pool);
            Logging.debugPrint("PCPOOL: " + pcpool);
            Logging.debugPrint("MPOOL:  " + mpool);
            Logging.debugPrint("APOOL:  " + bonus);
            Logging.debugPrint("LVLBONUS:  " + classLvlBonus);
        }
        double startAdjust = rangeLevel == 0 ? 0.0 : (double)(startLevel / rangeLevel);
        double nonMonsterAdjustment = this.totalNonMonsterLevels() >= startLevel ? 1.0 + pcpool - startAdjust : pcpool;
        pool += CoreUtility.epsilonFloor(nonMonsterAdjustment);
        pool += CoreUtility.epsilonFloor(mpool);
        pool += CoreUtility.epsilonFloor(bonus);
        pool += CoreUtility.epsilonFloor(classLvlBonus);
        if (Logging.isDebugMode()) {
            Logging.debugPrint("");
            Logging.debugPrint("Total Bonus: " + pool);
            Logging.debugPrint("==============");
            Logging.debugPrint("");
        }
        return pool;
    }

    double getNumFeatsFromLevels() {
        HashMap<String, Double> featByLevelType = new HashMap<String, Double>();
        for (PCClass pcClass : this.getClassSet()) {
            int lvlPerFeat = pcClass.getSafe(IntegerKey.LEVELS_PER_FEAT);
            if (lvlPerFeat == 0) continue;
            double bonus = (double)this.getLevel(pcClass) / (double)lvlPerFeat;
            Double existing = (Double)featByLevelType.get(pcClass.get(StringKey.LEVEL_TYPE));
            if (existing == null) {
                existing = 0.0;
            }
            existing = existing + bonus;
            featByLevelType.put(pcClass.get(StringKey.LEVEL_TYPE), existing);
        }
        double bonus = 0.0;
        for (String lvlType : featByLevelType.keySet()) {
            Double existing = (Double)featByLevelType.get(lvlType);
            bonus += CoreUtility.epsilonFloor(existing);
        }
        return bonus;
    }

    public boolean canLevelUp() {
        return !SettingsHandler.getEnforceSpendingBeforeLevelUp() || this.getSkillPoints() <= 0 && this.getRemainingFeatPoolPoints() <= 0.0;
    }

    public void setFileName(String newFileName) {
        this.setStringFor(PCStringKey.FILE_NAME, newFileName);
    }

    public String getFileName() {
        return this.getSafeStringFor(PCStringKey.FILE_NAME);
    }

    public Collection<Follower> getFollowerList() {
        return this.followerFacet.getSet(this.id);
    }

    public void setGender(Gender g) {
        if (this.genderFacet.getGender(this.id) != g) {
            this.genderFacet.setGender(this.id, g);
            this.setDirty(true);
        }
    }

    public void setGold(String aString) {
        BigDecimal gold = new BigDecimal(aString);
        this.setGold(gold);
    }

    public void setGold(BigDecimal amt) {
        if (amt == null) {
            return;
        }
        BigDecimal oldAmt = (BigDecimal)((AbstractItemFacet)this.goldFacet).get(this.id);
        if (oldAmt == null || amt.compareTo(oldAmt) != 0) {
            this.goldFacet.set(this.id, amt);
            this.setDirty(true);
        }
    }

    public BigDecimal getGold() {
        BigDecimal g = (BigDecimal)((AbstractItemFacet)this.goldFacet).get(this.id);
        return g == null ? BigDecimal.ZERO : g;
    }

    public void setHairColor(String aString) {
        this.setStringFor(PCStringKey.HAIRCOLOR, aString);
    }

    public void setHairStyle(String aString) {
        this.setStringFor(PCStringKey.HAIRSTYLE, aString);
    }

    public void setHanded(Handed h) {
        if (this.handedFacet.setHanded(this.id, h)) {
            this.setDirty(true);
        }
    }

    public void setHeight(int i) {
        if (this.heightFacet.setHeight(this.id, i)) {
            this.setDirty(true);
        }
    }

    public void setImporting(boolean newIsImporting) {
        this.importing = newIsImporting;
    }

    public void setInterests(String aString) {
        this.setStringFor(PCStringKey.INTERESTS, aString);
    }

    public Set<Language> getLanguageSet() {
        return this.languageFacet.getSet(this.id);
    }

    public void setLocation(String aString) {
        this.setStringFor(PCStringKey.LOCATION, aString);
    }

    public int getEffectiveCompanionLevel(CompanionList compList) {
        for (CompanionMod cMod : Globals.getContext().getReferenceContext().getManufacturer(CompanionMod.class, compList).getAllObjects()) {
            Map<String, Integer> varmap = cMod.getMapFor(MapKey.APPLIED_VARIABLE);
            for (String varName : varmap.keySet()) {
                int lvl = this.getVariableValue(varName, "").intValue();
                if (lvl <= 0) continue;
                return lvl;
            }
            Map<CDOMSingleRef<? extends PCClass>, Integer> ac = cMod.getMapFor(MapKey.APPLIED_CLASS);
            for (Map.Entry<CDOMSingleRef<? extends PCClass>, Integer> me : ac.entrySet()) {
                PCClass pcclass = me.getKey().resolvesTo();
                String key = pcclass.getKeyName();
                int lvl = this.getLevel(this.getClassKeyed(key));
                if (lvl <= 0) continue;
                return lvl;
            }
        }
        return 0;
    }

    public void setMaster(Follower aM) {
        this.masterFacet.set(this.id, aM);
        PlayerCharacter mPC = this.getMasterPC();
        if (mPC == null) {
            return;
        }
        if (!aM.getFileName().equals(mPC.getFileName())) {
            aM.setFileName(mPC.getFileName());
            this.setDirty(true);
        }
        if (!aM.getName().equals(mPC.getName())) {
            aM.setName(mPC.getName());
            this.setDirty(true);
        }
        int mTotalLevel = 0;
        int addHD = 0;
        for (PCClass mClass : mPC.getClassSet()) {
            boolean found = false;
            for (CompanionMod cMod : Globals.getContext().getReferenceContext().getManufacturer(CompanionMod.class, aM.getType()).getAllObjects()) {
                if (cMod.getLevelApplied(mClass) <= 0 || found) continue;
                mTotalLevel += this.getLevel(mClass);
                found = true;
            }
        }
        ArrayList<CompanionMod> newCompanionMods = new ArrayList<CompanionMod>();
        Collection oldCompanionMods = this.companionModFacet.removeAll(this.id);
        for (CompanionMod cMod : Globals.getContext().getReferenceContext().getManufacturer(CompanionMod.class, aM.getType()).getAllObjects()) {
            int n;
            for (PCClass mClass : mPC.getClassSet()) {
                int mLev = mPC.getLevel(mClass) + aM.getAdjustment();
                n = cMod.getLevelApplied(mClass);
                if (n < 0 || n > mLev && n > mTotalLevel || !cMod.qualifies(this, cMod)) continue;
                if (!oldCompanionMods.contains(cMod)) {
                    newCompanionMods.add(cMod);
                }
                this.companionModFacet.add(this.id, cMod);
                addHD += cMod.getSafe(IntegerKey.HIT_DIE);
            }
            Map<String, Integer> varmap = cMod.getMapFor(MapKey.APPLIED_VARIABLE);
            for (String varName : varmap.keySet()) {
                n = mPC.getVariableValue(varName, "").intValue() + aM.getAdjustment();
                if (n < cMod.getVariableApplied(varName) || !cMod.qualifies(this, cMod)) continue;
                if (!oldCompanionMods.contains(cMod)) {
                    newCompanionMods.add(cMod);
                }
                this.companionModFacet.add(this.id, cMod);
                addHD += cMod.getSafe(IntegerKey.HIT_DIE);
            }
        }
        LevelCommandFactory lcf = this.getRace().get(ObjectKey.MONSTER_CLASS);
        int usedHD = aM.getUsedHD();
        if (lcf != null && (addHD -= usedHD) != 0) {
            this.incrementClassLevel(addHD, lcf.getPCClass(), true);
            aM.setUsedHD(addHD + usedHD);
            this.setDirty(true);
        }
        if (this.masterFacet.getUseMasterSkill(this.id)) {
            Collection<Skill> mList = mPC.getSkillSet();
            ArrayList<Skill> sKeyList = new ArrayList<Skill>();
            for (Skill skill : this.getSkillSet()) {
                for (Skill mSkill : mList) {
                    Float totalMasterRank;
                    if (mSkill.equals(skill) && (totalMasterRank = SkillRankControl.getTotalRank(mPC, mSkill)).intValue() > this.getRank(skill).intValue()) {
                        SkillRankControl.setZeroRanks(lcf == null ? null : lcf.getPCClass(), this, skill);
                        SkillRankControl.modRanks(totalMasterRank.doubleValue(), null, true, this, skill);
                    }
                    if (this.hasSkill(mSkill) || sKeyList.contains(mSkill)) continue;
                    sKeyList.add(mSkill);
                }
            }
            for (Skill skill : sKeyList) {
                double sr = SkillRankControl.getTotalRank(mPC, skill).doubleValue();
                SkillRankControl.modRanks(sr, null, true, this, skill);
                if (!ChooseActivation.hasNewChooseToken(skill)) continue;
                ChooseInformation<?> chooseInfo = skill.get(ObjectKey.CHOOSE_INFO);
                List<?> selected = chooseInfo.getChoiceActor().getCurrentlySelected(skill, mPC);
                ChoiceManagerList<Language> controller = ChooserUtilities.getConfiguredController(skill, this, null, new ArrayList<String>());
                for (Language lang : selected) {
                    if (controller.conditionallyApply(this, lang)) continue;
                    Logging.errorPrint("Failed to add master's language " + lang + " to companion.");
                }
            }
        }
        oldCompanionMods.removeAll(((AbstractListFacet)this.companionModFacet).getSet(this.id));
        for (CompanionMod cMod : oldCompanionMods) {
            CDOMObjectUtilities.removeAdds(cMod, this);
            CDOMObjectUtilities.restoreRemovals(cMod, this);
        }
        for (CompanionMod cMod : newCompanionMods) {
            CDOMObjectUtilities.addAdds(cMod, this);
            CDOMObjectUtilities.checkRemovals(cMod, this);
            for (CDOMReference<PCTemplate> cDOMReference : cMod.getSafeListFor(ListKey.TEMPLATE)) {
                for (PCTemplate pct : cDOMReference.getContainedObjects()) {
                    this.addTemplate(pct);
                }
            }
            for (CDOMReference<PCTemplate> cDOMReference : cMod.getSafeListFor(ListKey.REMOVE_TEMPLATES)) {
                for (PCTemplate pct : cDOMReference.getContainedObjects()) {
                    this.removeTemplate(pct);
                }
            }
            for (TransitionChoice transitionChoice : cMod.getSafeListFor(ListKey.KIT_CHOICE)) {
                transitionChoice.act(transitionChoice.driveChoice(this), cMod, this);
            }
        }
        this.calcActiveBonuses();
        this.setDirty(true);
    }

    public int getMaxFollowers(CompanionList cList) {
        int ret = this.followerLimitFacet.getMaxFollowers(this.id, cList);
        return ret == -1 ? this.getOldFollowerLimit(cList) : ret;
    }

    private int getOldFollowerLimit(CompanionList cList) {
        for (CompanionMod cMod : Globals.getContext().getReferenceContext().getManufacturer(CompanionMod.class, cList).getAllObjects()) {
            Map<String, Integer> varmap = cMod.getMapFor(MapKey.APPLIED_VARIABLE);
            for (String varName : varmap.keySet()) {
                if (this.getVariableValue(varName, "").intValue() <= 0) continue;
                return -1;
            }
            Map<CDOMSingleRef<? extends PCClass>, Integer> ac = cMod.getMapFor(MapKey.APPLIED_CLASS);
            for (Map.Entry<CDOMSingleRef<? extends PCClass>, Integer> me : ac.entrySet()) {
                PCClass pcclass = me.getKey().resolvesTo();
                String key = pcclass.getKeyName();
                for (PCClass pcClass : this.getClassSet()) {
                    if (!pcClass.getKeyName().equals(key)) continue;
                    return me.getValue();
                }
            }
        }
        return 0;
    }

    public PlayerCharacter getMasterPC() {
        Follower followerMaster = (Follower)this.masterFacet.get(this.id);
        if (followerMaster == null) {
            return null;
        }
        for (PlayerCharacter nPC : Globals.getPCList()) {
            if (!followerMaster.getFileName().equals(nPC.getFileName())) continue;
            return nPC;
        }
        for (PlayerCharacter nPC : Globals.getPCList()) {
            if (!followerMaster.getName().equals(nPC.getName())) continue;
            return nPC;
        }
        return null;
    }

    public void setName(String aString) {
        this.setStringFor(PCStringKey.NAME, aString);
    }

    public String getName() {
        return this.getSafeStringFor(PCStringKey.NAME);
    }

    public List<String> getNamedTempBonusList() {
        return this.bonusManager.getNamedTempBonusList();
    }

    public List<String> getNamedTempBonusDescList() {
        return this.bonusManager.getNamedTempBonusDescList();
    }

    public void setPhobias(String aString) {
        this.setStringFor(PCStringKey.PHOBIAS, aString);
    }

    public void setPlayersName(String aString) {
        this.setStringFor(PCStringKey.PLAYERSNAME, aString);
    }

    public void setPoolAmount(int pool) {
        this.poolAmount = pool;
    }

    public int getPoolAmount() {
        return this.poolAmount;
    }

    public void setPortraitPath(String newPortraitPath) {
        this.setStringFor(PCStringKey.PORTRAIT_PATH, newPortraitPath);
    }

    public void setPortraitThumbnailRect(Rectangle rect) {
        this.portraitThumbnailRectFacet.set(this.id, (Rectangle)rect.clone());
    }

    public Race getRace() {
        return (Race)((AbstractItemFacet)this.raceFacet).get(this.id);
    }

    public void setRegion(Region r) {
        this.regionFacet.setRegion(this.id, r);
    }

    public void setResidence(String aString) {
        this.setStringFor(PCStringKey.RESIDENCE, aString);
    }

    public void setSelectedCharacterHTMLOutputSheet(String aString) {
        this.outputSheetHTML = aString;
    }

    public String getSelectedCharacterHTMLOutputSheet() {
        return this.outputSheetHTML;
    }

    public void setSelectedCharacterPDFOutputSheet(String aString) {
        this.outputSheetPDF = aString;
    }

    public String getSelectedCharacterPDFOutputSheet() {
        return this.outputSheetPDF;
    }

    public Collection<ProfProvider<ShieldProf>> getShieldProfList() {
        return this.shieldProfFacet.getQualifiedSet(this.id);
    }

    public Collection<Skill> getSkillSet() {
        return this.skillFacet.getSet(this.id);
    }

    public int getSkillPoints() {
        int returnValue = 0;
        for (PCLevelInfo li : this.getLevelInfo()) {
            returnValue += li.getSkillPointsGained(this);
        }
        for (Skill aSkill : this.getSkillSet()) {
            for (PCClass pcc : this.getSkillRankClasses(aSkill)) {
                if (pcc == null) continue;
                Double curRank = this.getSkillRankForClass(aSkill, pcc);
                if (curRank == null) {
                    Logging.errorPrint("Got null on ranks for " + aSkill + " in class " + pcc);
                    curRank = 0.0;
                }
                int cost = this.getSkillCostForClass(aSkill, pcc).getCost();
                returnValue -= (int)((double)cost * curRank);
            }
        }
        if (Globals.getGameModeHasPointPool()) {
            returnValue += (int)this.getRemainingFeatPoints(false);
        }
        return returnValue;
    }

    public void setSkinColor(String colour) {
        this.setStringFor(PCStringKey.SKINCOLOR, colour);
    }

    public List<SpecialAbility> getSpecialAbilityList() {
        ArrayList<SpecialAbility> aList = new ArrayList<SpecialAbility>();
        aList.addAll(this.userSpecialAbilityFacet.getAllResolved(this.id, this.SA_PROC));
        aList.addAll(this.specialAbilityFacet.getAllResolved(this.id, this.SA_PROC));
        Collections.sort(aList);
        return aList;
    }

    private List<String> getSpecialAbilityListStrings() {
        ArrayList<String> bList = new ArrayList<String>();
        bList.addAll(this.userSpecialAbilityFacet.getAllResolved(this.id, this.SA_TO_STRING_PROC));
        bList.addAll(this.specialAbilityFacet.getAllResolved(this.id, this.SA_TO_STRING_PROC));
        Collections.sort(bList);
        return bList;
    }

    public ArrayList<String> getSpecialAbilityTimesList() {
        List<String> abilityList = this.getSpecialAbilityListStrings();
        ArrayList<String> sortList = new ArrayList<String>();
        int[] numTimes = new int[abilityList.size()];
        for (int i = 0; i < abilityList.size(); ++i) {
            String ability = abilityList.get(i);
            if (!sortList.contains(ability)) {
                sortList.add(ability);
                numTimes[i] = 1;
                continue;
            }
            for (int j = 0; j < sortList.size(); ++j) {
                String testAbility = (String)sortList.get(j);
                if (!testAbility.equals(ability)) continue;
                int n = j;
                numTimes[n] = numTimes[n] + 1;
            }
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < sortList.size(); ++i) {
            String ability = (String)sortList.get(i);
            if (numTimes[i] > 1) {
                ability = ability + " (" + numTimes[i] + ")";
            }
            retList.add(ability);
        }
        return retList;
    }

    public void setSpeechTendency(String tendency) {
        this.setStringFor(PCStringKey.SPEECHTENDENCY, tendency);
    }

    public void setSpellBookNameToAutoAddKnown(String aString) {
        this.setStringFor(PCStringKey.SPELLBOOK_AUTO_ADD_KNOWN, aString);
    }

    public String getSpellBookNameToAutoAddKnown() {
        return this.getSafeStringFor(PCStringKey.SPELLBOOK_AUTO_ADD_KNOWN);
    }

    public SpellBook getSpellBookByName(String name) {
        return this.spellBookFacet.getBookNamed(this.id, name);
    }

    private List<String> getSpellBookNames() {
        return new ArrayList<String>(this.spellBookFacet.getBookNames(this.id));
    }

    public PObject getSpellClassAtIndex(int ix) {
        List<? extends PObject> aList = this.getSpellClassList();
        if (ix >= 0 && ix < aList.size()) {
            return aList.get(ix);
        }
        return null;
    }

    public void setSpellLevelTemp(int i) {
        this.spellLevelTemp = i;
    }

    public int getSpellLevelTemp() {
        return this.spellLevelTemp;
    }

    public void setSuppressBioField(BiographyField field, boolean suppress) {
        if (this.suppressBioFieldFacet.setSuppressField(this.id, field, suppress)) {
            this.setDirty(true);
        }
    }

    public void setTabName(String name) {
        this.setStringFor(PCStringKey.TABNAME, name);
    }

    private List<Equipment> getTempBonusItemList() {
        return this.tempBonusItemList;
    }

    public Map<BonusObj, BonusManager.TempBonusInfo> getTempBonusMap() {
        return this.bonusManager.getTempBonusMap();
    }

    public Set<String> getTempBonusFilters() {
        return this.bonusManager.getTempBonusFilters();
    }

    public void setTempBonusFilter(String aBonusStr) {
        this.bonusManager.addTempBonusFilter(aBonusStr);
        this.calcActiveBonuses();
    }

    public void unsetTempBonusFilter(String aBonusStr) {
        this.bonusManager.removeTempBonusFilter(aBonusStr);
        this.calcActiveBonuses();
    }

    public Collection<PCTemplate> getTemplateSet() {
        return this.templateFacet.getSet(this.id);
    }

    public void setTrait1(String aString) {
        this.setStringFor(PCStringKey.PERSONALITY1, aString);
    }

    public void setTrait2(String aString) {
        this.setStringFor(PCStringKey.PERSONALITY2, aString);
    }

    public Float getVariable(String variableString, boolean isMax) {
        double value = 0.0;
        boolean found = false;
        if (lastVariable != null && lastVariable.equals(variableString)) {
            if (Logging.isDebugMode()) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("This is a deliberate warning message, not an error - ");
                sb.append("Avoiding infinite loop in getVariable: repeated lookup ");
                sb.append("of \"").append(lastVariable).append("\" at ").append(value);
                Logging.debugPrint(sb.toString());
            }
            lastVariable = null;
            return new Float(value);
        }
        try {
            VariableKey vk = VariableKey.valueOf(variableString);
            Double val = this.variableFacet.getVariableValue(this.id, vk, isMax);
            if (val != null) {
                value = val;
                found = true;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        boolean includeBonus = true;
        if (!found) {
            lastVariable = variableString;
            value = this.getVariableValue(variableString, "").floatValue();
            includeBonus = false;
            found = true;
            lastVariable = null;
        }
        if (found && includeBonus) {
            value += this.getTotalBonusTo("VAR", variableString);
        }
        return new Float(value);
    }

    public void setWeight(int i) {
        if (this.weightFacet.setWeight(this.id, i)) {
            this.setDirty(true);
        }
    }

    public void setPointBuyPoints(int argPointBuyPoints) {
        this.pointBuyPoints = argPointBuyPoints;
    }

    public int getPointBuyPoints() {
        return this.pointBuyPoints;
    }

    public int getTotalPointBuyPoints() {
        return this.pointBuyPoints + (int)this.getTotalBonusTo("POINTBUY", "POINTS");
    }

    public void setXP(int xp) {
        if (this.xpFacet.setXP(this.id, xp)) {
            this.setDirty(true);
        }
    }

    public int getXP() {
        return this.xpFacet.getXP(this.id);
    }

    public void setXPTable(String xpTableName) {
        if (this.xpTableFacet.set(this.id, SettingsHandler.getGame().getLevelInfo(xpTableName))) {
            this.setDirty(true);
        }
    }

    public LevelInfo getXPTableLevelInfo(int level) {
        return this.xpTableFacet.getLevelInfo(this.id, level);
    }

    public void setCharacterType(String characterType) {
        if (this.characterTypeFacet.set(this.id, characterType)) {
            this.setDirty(true);
        }
    }

    public void setPreviewSheet(String previewSheet) {
        if (this.previewSheetFacet.set(this.id, previewSheet)) {
            this.setDirty(true);
        }
    }

    public void addEquipSet(EquipSet set) {
        this.equipSetFacet.add(this.id, set);
    }

    public void addEquipment(Equipment eq) {
        this.equipmentFacet.add(this.id, eq, this);
        this.userEquipmentFacet.add(this.id, eq, this);
    }

    public void cacheOutputIndex(Equipment item) {
        if (item.isAutomatic()) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Caching " + item.getKeyName() + " - " + item.getOutputIndex() + " item");
            }
            this.autoEquipOutputOrderCache.put(item.getKeyName(), item.getOutputIndex());
        }
    }

    public int getCachedOutputIndex(String key) {
        Integer order = this.autoEquipOutputOrderCache.get(key);
        return order != null ? order : -1;
    }

    public void updateEquipmentQty(Equipment eq, double oldQty, double newQty) {
        if (eq.isType("SPELLBOOK")) {
            int i;
            String baseBookname = eq.getName();
            String bookName = eq.getName();
            int old = (int)oldQty;
            int newQ = (int)newQty;
            for (i = old; i < newQ; ++i) {
                SpellBook book;
                if (i > 0) {
                    bookName = baseBookname + " #" + (i + 1);
                }
                if ((book = this.spellBookFacet.getBookNamed(this.id, bookName)) == null) {
                    book = new SpellBook(bookName, 3);
                }
                book.setEquip(eq);
                this.addSpellBook(book);
            }
            for (i = old; i > newQ; --i) {
                if (i > 0) {
                    bookName = baseBookname + " #" + i;
                }
                this.delSpellBook(bookName);
            }
        }
        this.setDirty(true);
    }

    public void addFollower(Follower aFollower) {
        if (this.followerFacet.add(this.id, aFollower)) {
            this.setDirty(true);
        }
    }

    private void addLocalEquipment(Equipment eq) {
        this.equipmentFacet.add(this.id, eq, this);
    }

    public void addNotesItem(NoteItem item) {
        if (this.noteItemFacet.add(this.id, item)) {
            this.setDirty(true);
        }
    }

    public BonusManager.TempBonusInfo addTempBonus(BonusObj aBonus, Object source, Object target) {
        BonusManager.TempBonusInfo tempBonusInfo = this.bonusManager.addTempBonus(aBonus, source, target);
        this.setDirty(true);
        return tempBonusInfo;
    }

    public void addTempBonusItemList(Equipment aEq) {
        this.getTempBonusItemList().add(aEq);
        this.setDirty(true);
    }

    public double calcBonusFromList(List<BonusObj> aList, CDOMObject source) {
        double iBonus = 0.0;
        for (BonusObj bonus : aList) {
            iBonus += bonus.resolve(this, source.getQualifiedKey()).doubleValue();
        }
        return iBonus;
    }

    public boolean checkQualifyList(CDOMObject obj) {
        return this.qualifyFacet.grantsQualify(this.id, obj);
    }

    public boolean hasWeaponProf(WeaponProf wp) {
        return this.weaponProfFacet.containsProf(this.id, wp);
    }

    public boolean delEquipSet(EquipSet eSet) {
        boolean found = this.equipSetFacet.delEquipSet(this.id, eSet);
        this.setDirty(true);
        return found;
    }

    public void delEquipSetItem(Equipment eq) {
        this.equipSetFacet.delEquipSetItem(this.id, eq);
        this.setDirty(true);
    }

    public void delFollower(Follower aFollower) {
        this.followerFacet.remove(this.id, aFollower);
        this.setDirty(true);
    }

    public boolean hasVariable(String variableString) {
        try {
            return this.variableFacet.contains(this.id, VariableKey.valueOf(variableString));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void removeEquipment(Equipment eq) {
        if (eq.isType("SPELLBOOK")) {
            this.delSpellBook(eq.getName());
        }
        this.equipmentFacet.remove(this.id, eq, this);
        this.userEquipmentFacet.remove(this.id, eq, this);
        this.setDirty(true);
    }

    private void removeLocalEquipment(Equipment eq) {
        this.equipmentFacet.remove(this.id, eq, this);
        this.setDirty(true);
    }

    public void setAlignment(PCAlignment align) {
        if (this.alignmentFacet.set(this.id, align)) {
            this.setDirty(true);
        }
    }

    public void setAllowDebt(boolean allowDebt) {
        this.allowDebtFacet.set(this.id, allowDebt);
    }

    public String getAttackString(AttackType at) {
        return this.getAttackString(at, 0);
    }

    public String getAttackString(AttackType at, int bonus) {
        return this.getAttackString(at, bonus, 0);
    }

    public String getAttackString(AttackType at, int TOHITBonus, int BABBonus) {
        String cacheLookup = "AttackString:" + at.getIdentifier() + "," + TOHITBonus + "," + BABBonus;
        String cached = this.getVariableProcessor().getCachedString(cacheLookup);
        if (cached != null) {
            return cached;
        }
        int masterBAB = -9999;
        int masterTotal = -9999;
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC != null && this.masterFacet.getCopyMasterBAB(this.id).length() > 0) {
            masterBAB = nPC.baseAttackBonus();
            String copyMasterBAB = this.replaceMasterString(this.masterFacet.getCopyMasterBAB(this.id), masterBAB);
            masterBAB = this.getVariableValue(copyMasterBAB, "").intValue();
            masterTotal = masterBAB + TOHITBonus;
        }
        int BAB = this.baseAttackBonus();
        int attackCycle = 1;
        int workingBAB = BAB + TOHITBonus;
        int subTotal = BAB;
        int raceBAB = 0;
        ArrayList<Integer> ab = new ArrayList<Integer>(10);
        StringBuilder attackString = new StringBuilder(30);
        for (int total = 0; total < 10; ++total) {
            ab.add(0);
        }
        for (PCClass pcClass : this.getClassSet()) {
            int b = pcClass.baseAttackBonus(this);
            int c = pcClass.attackCycle(at);
            if (c < ab.size()) {
                int d = (Integer)ab.get(c) + b;
                ab.set(c, d);
            }
            if (c == 3) continue;
            raceBAB += b;
        }
        for (int i = 2; i < 10; ++i) {
            int oldAttack;
            int newAttack = (Integer)ab.get(i);
            if (newAttack / i <= (oldAttack = ((Integer)ab.get(attackCycle)).intValue()) / attackCycle) continue;
            attackCycle = i;
        }
        int attackTotal = (Integer)ab.get(attackCycle);
        int defaultAttackCycle = SettingsHandler.getGame().getBabAttCyc();
        if (attackTotal == 0) {
            attackCycle = defaultAttackCycle;
        }
        workingBAB = Math.max(workingBAB, masterTotal);
        subTotal = Math.max(subTotal, masterBAB);
        raceBAB = Math.max(raceBAB, masterBAB);
        if (attackCycle != defaultAttackCycle) {
            if (attackTotal / attackCycle < subTotal / defaultAttackCycle) {
                attackCycle = defaultAttackCycle;
                attackTotal = subTotal;
            } else {
                workingBAB -= raceBAB;
                subTotal -= raceBAB;
            }
        }
        int maxAttacks = SettingsHandler.getGame().getBabMaxAtt();
        int minMultiBab = SettingsHandler.getGame().getBabMinVal();
        attackTotal += BABBonus;
        workingBAB += BABBonus;
        subTotal += BABBonus;
        do {
            if (attackString.length() > 0) {
                attackString.append('/');
            }
            attackString.append(Delta.toString(workingBAB));
            workingBAB -= attackCycle;
        } while (((attackTotal -= attackCycle) >= minMultiBab || (subTotal -= attackCycle) >= minMultiBab) && --maxAttacks > 0);
        this.getVariableProcessor().addCachedString(cacheLookup, attackString.toString());
        return attackString.toString();
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public void setAutoSortGear(boolean autoSortGear) {
        if (this.autoSortGear != autoSortGear) {
            this.autoSortGear = autoSortGear;
            this.setDirty(true);
        }
    }

    public boolean isAutoSortGear() {
        return this.autoSortGear;
    }

    public void setAutoSpells(boolean aBool) {
        if (this.autoKnownSpells != aBool) {
            this.autoKnownSpells = aBool;
            this.setDirty(true);
        }
    }

    public boolean getAutoSpells() {
        return this.autoKnownSpells;
    }

    public void setIgnoreCost(boolean ignoreCost) {
        this.ignoreCostFacet.set(this.id, ignoreCost);
    }

    public boolean getUseHigherKnownSlots() {
        return this.useHigherKnownSlots;
    }

    public void setUseHigherKnownSlots(boolean useHigher) {
        this.useHigherKnownSlots = useHigher;
    }

    public boolean getUseHigherPreppedSlots() {
        return this.useHigherPreppedSlots;
    }

    public void setUseHigherPreppedSlots(boolean useHigher) {
        this.useHigherPreppedSlots = useHigher;
    }

    public int getBaseCheck(PCCheck check) {
        String cacheLookup = "getBaseCheck:" + check.getKeyName();
        Float total = null;
        total = this.epicCheckMap.containsKey(check) ? Float.valueOf(this.epicCheckMap.get(check).floatValue()) : this.getVariableProcessor().getCachedVariable(cacheLookup);
        if (total != null) {
            return total.intValue();
        }
        double bonus = 0.0;
        boolean isEpic = false;
        HashMap<String, Integer> totalLvlMap = null;
        int totalClassLevels = this.totalNonMonsterLevels();
        if (totalClassLevels > SettingsHandler.getGame().getChecksMaxLvl()) {
            isEpic = true;
            Integer epicCheck = this.epicCheckMap.get(check);
            if (epicCheck == null) {
                totalLvlMap = this.getTotalLevelHashMap();
                Map<String, Integer> classLvlMap = this.getCharacterLevelHashMap(SettingsHandler.getGame().getChecksMaxLvl());
                this.getVariableProcessor().pauseCache();
                this.setAllowInteraction(false);
                this.setClassLevelsBrazenlyTo(classLvlMap);
            } else {
                return epicCheck;
            }
        }
        String checkName = check.getKeyName();
        bonus = this.getTotalBonusTo("CHECKS", "BASE." + checkName);
        if (totalLvlMap != null) {
            this.setClassLevelsBrazenlyTo(totalLvlMap);
            this.setAllowInteraction(true);
            this.getVariableProcessor().restartCache();
        }
        bonus += this.getTotalBonusTo("SAVE", "BASE." + checkName);
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC != null && this.masterFacet.getCopyMasterCheck(this.id).length() > 0) {
            int masterBonus = nPC.getBaseCheck(check);
            String copyMasterCheck = this.replaceMasterString(this.masterFacet.getCopyMasterCheck(this.id), masterBonus);
            masterBonus = this.getVariableValue(copyMasterCheck, "").intValue();
            bonus = Math.max(bonus, (double)masterBonus);
        }
        if (isEpic) {
            this.epicCheckMap.put(check, (int)bonus);
        }
        return (int)bonus;
    }

    public int getTotalCheck(PCCheck check) {
        int bonus = this.getBaseCheck(check);
        return bonus + (int)this.getTotalBonusTo("CHECKS", check.getKeyName()) + (int)this.getTotalBonusTo("SAVE", check.getKeyName());
    }

    public double getBonusDueToType(String mainType, String subType, String bonusType) {
        return this.bonusManager.getBonusDueToType(mainType, subType, bonusType);
    }

    public void setDeity(Deity aDeity) {
        if (this.canSelectDeity(aDeity) && this.deityFacet.set(this.id, aDeity)) {
            this.setDirty(true);
        }
    }

    public List<Equipment> getEquipmentOfType(String typeName, int status) {
        return this.getEquipmentOfType(typeName, "", status);
    }

    public List<Equipment> getEquipmentOfType(String typeName, String subtypeName, int status) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        for (Equipment eq : this.getEquipmentSet()) {
            boolean statusOk;
            boolean subTypeOk = "".equals(subtypeName) || eq.typeStringContains(subtypeName);
            boolean bl = statusOk = status == 3 || status == 2 && !eq.isEquipped() || status == 1 && eq.isEquipped();
            if (!eq.typeStringContains(typeName) || !subTypeOk || !statusOk) continue;
            aArrayList.add(eq);
        }
        return aArrayList;
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String typeName, int status) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, status), 0);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String typeName, int status, int merge) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, status), merge);
    }

    public List<Equipment> getEquipmentOfTypeInOutputOrder(String typeName, String subtypeName, int status, int merge) {
        return this.sortEquipmentList(this.getEquipmentOfType(typeName, subtypeName, status), merge);
    }

    public List<Equipment> getExpandedWeapons(int merge) {
        List<Equipment> weapList = this.sortEquipmentList(this.getEquipmentOfType("Weapon", 3), merge);
        for (int idx = 0; idx < weapList.size(); ++idx) {
            Equipment eqm;
            Equipment equip = weapList.get(idx);
            if (equip.isDouble() && equip.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS) {
                eqm = equip.clone();
                eqm.removeType(Type.DOUBLE);
                eqm.addType(Type.HEAD1);
                eqm.setWholeItemName(eqm.getName());
                eqm.setName(EquipmentUtilities.appendToName(eqm.getName(), "Head 1 only"));
                if (eqm.getOutputName().indexOf("Head 1 only") < 0) {
                    eqm.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(eqm.getOutputName(), "Head 1 only"));
                }
                PlayerCharacterUtilities.setProf(equip, eqm);
                weapList.add(idx + 1, eqm);
                eqm = equip.clone();
                String altType = eqm.getType(false);
                if (altType.length() != 0) {
                    eqm.removeListFor(ListKey.TYPE);
                    for (String s : altType.split("\\.")) {
                        eqm.addType(Type.getConstant(s));
                    }
                }
                eqm.removeType(Type.DOUBLE);
                eqm.addType(Type.HEAD2);
                EquipmentHead head = eqm.getEquipmentHead(1);
                String altDamage = eqm.getAltDamage(this);
                if (altDamage.length() != 0) {
                    head.put(StringKey.DAMAGE, altDamage);
                }
                head.put(IntegerKey.CRIT_MULT, eqm.getAltCritMultiplier());
                head.put(IntegerKey.CRIT_RANGE, eqm.getRawCritRange(false));
                head.removeListFor(ListKey.EQMOD);
                head.addAllToListFor(ListKey.EQMOD, eqm.getEqModifierList(false));
                eqm.setWholeItemName(eqm.getName());
                eqm.setName(EquipmentUtilities.appendToName(eqm.getName(), "Head 2 only"));
                if (eqm.getOutputName().indexOf("Head 2 only") < 0) {
                    eqm.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(eqm.getOutputName(), "Head 2 only"));
                }
                PlayerCharacterUtilities.setProf(equip, eqm);
                weapList.add(idx + 2, eqm);
                continue;
            }
            if (!equip.isMelee() || !equip.isRanged()) continue;
            eqm = equip.clone();
            eqm.addType(Type.BOTH);
            eqm.removeType(Type.RANGED);
            eqm.removeType(Type.THROWN);
            eqm.put(IntegerKey.RANGE, 0);
            PlayerCharacterUtilities.setProf(equip, eqm);
            weapList.set(idx, eqm);
            boolean replacedPrimary = this.primaryWeaponFacet.replace(this.id, equip, eqm);
            boolean replacedSecondary = this.secondaryWeaponFacet.replace(this.id, equip, eqm);
            Equipment eqr = equip.clone();
            eqr.addType(Type.RANGED);
            eqr.addType(Type.THROWN);
            eqr.addType(Type.BOTH);
            eqr.removeType(Type.MELEE);
            eqr.setName(EquipmentUtilities.appendToName(eqr.getName(), "Thrown"));
            if (eqr.getOutputName().indexOf("Thrown") < 0) {
                eqr.put(StringKey.OUTPUT_NAME, EquipmentUtilities.appendToName(eqr.getOutputName(), "Thrown"));
            }
            PlayerCharacterUtilities.setProf(equip, eqr);
            weapList.add(++idx, eqr);
            if (replacedPrimary) {
                this.primaryWeaponFacet.addAfter(this.id, eqm, eqr);
                continue;
            }
            if (!replacedSecondary) continue;
            this.secondaryWeaponFacet.addAfter(this.id, eqm, eqr);
        }
        return weapList;
    }

    public double getFeatBonusTo(String aType, String aName) {
        HashMap<String, Ability> aHashMap = new HashMap<String, Ability>();
        for (Ability aFeat : this.getAbilityList(AbilityCategory.FEAT, Nature.NORMAL)) {
            if (aFeat == null) continue;
            aHashMap.put(aFeat.getKeyName(), aFeat);
        }
        this.addUniqueAbilitiesToMap(aHashMap, this.getAbilityList(AbilityCategory.FEAT, Nature.VIRTUAL));
        ArrayList aggregateFeatList = new ArrayList();
        this.addUniqueAbilitiesToMap(aHashMap, this.getAbilityList(AbilityCategory.FEAT, Nature.AUTOMATIC));
        aggregateFeatList.addAll(aHashMap.values());
        return this.getPObjectWithCostBonusTo(aggregateFeatList, aType.toUpperCase(), aName.toUpperCase());
    }

    public Ability getMatchingAbility(Category<Ability> abilityCategory, Ability ability, Nature nature) {
        Collection<CNAbility> cnas = this.grantedAbilityFacet.getPoolAbilities(this.id, abilityCategory, nature);
        for (CNAbility cna : cnas) {
            if (!cna.getAbilityKey().equals(ability.getKeyName())) continue;
            return cna.getAbility();
        }
        return null;
    }

    public void setHasMadeKitSelectionForAgeSet(int index, boolean arg) {
        if (index >= 0 && index < 10) {
            this.ageSetKitSelections[index] = arg;
        }
        this.setDirty(true);
    }

    public Collection<Kit> getKitInfo() {
        return ((AbstractListFacet)this.kitFacet).getSet(this.id);
    }

    public Collection<PCLevelInfo> getLevelInfo() {
        return this.levelInfoFacet.getSet(this.id);
    }

    public Collection<PCLevelInfo> clearLevelInfo() {
        return this.levelInfoFacet.removeAll(this.id);
    }

    public PCLevelInfo getLevelInfo(int index) {
        return this.levelInfoFacet.get(this.id, index);
    }

    public String getLevelInfoClassKeyName(int idx) {
        if (idx >= 0 && idx < this.getLevelInfoSize()) {
            return this.levelInfoFacet.get(this.id, idx).getClassKeyName();
        }
        return "";
    }

    public PCLevelInfo getLevelInfoFor(String classKey, int level) {
        for (PCLevelInfo pcl : this.getLevelInfo()) {
            if (pcl.getClassKeyName().equals(classKey)) {
                --level;
            }
            if (level > 0) continue;
            return pcl;
        }
        return null;
    }

    public int getLevelInfoSize() {
        return this.levelInfoFacet.getCount(this.id);
    }

    public void setLoadCompanion(boolean aBool) {
        if (this.autoLoadCompanion != aBool) {
            this.autoLoadCompanion = aBool;
            this.setDirty(true);
        }
    }

    public boolean getLoadCompanion() {
        return this.autoLoadCompanion;
    }

    public int getMaxCharacterDomains() {
        return (int)this.getTotalBonusTo("DOMAIN", "NUMBER");
    }

    public int getMaxCharacterDomains(PCClass source, PlayerCharacter aPC) {
        int i = this.getMaxCharacterDomains();
        if (i == 0 && !this.hasDefaultDomainSource()) {
            i = (int)source.getBonusTo("DOMAIN", "NUMBER", this.getLevel(source), aPC);
        }
        return i;
    }

    public Float getMaxRank(Skill aSkill, PCClass aClass) {
        BigDecimal maxRanks;
        int levelForSkillPurposes = this.getTotalLevels();
        if (aSkill == null) {
            return Float.valueOf(0.0f);
        }
        if (aSkill.getSafe(ObjectKey.EXCLUSIVE).booleanValue()) {
            levelForSkillPurposes = 0;
            for (PCClass bClass : this.getClassSet()) {
                if (!this.isClassSkill(bClass, aSkill)) continue;
                levelForSkillPurposes += this.getLevel(bClass);
            }
            if (levelForSkillPurposes == 0) {
                levelForSkillPurposes = this.getTotalLevels();
                maxRanks = SkillUtilities.maxCrossClassSkillForLevel(levelForSkillPurposes, this);
            } else {
                maxRanks = SkillUtilities.maxClassSkillForLevel(levelForSkillPurposes, this);
            }
        } else {
            maxRanks = !this.isClassSkill(aSkill) && this.getSkillCostForClass(aSkill, aClass).equals((Object)SkillCost.CLASS) ? new BigDecimal(SkillUtilities.maxCrossClassSkillForLevel(levelForSkillPurposes, this).intValue()) : (!this.isClassSkill(aSkill) ? SkillUtilities.maxCrossClassSkillForLevel(levelForSkillPurposes, this) : SkillUtilities.maxClassSkillForLevel(levelForSkillPurposes, this));
        }
        return new Float(maxRanks.floatValue());
    }

    public boolean isNonAbility(PCStat stat) {
        return this.nonAbilityFacet.isNonAbility(this.id, stat);
    }

    public int getOffHandLightBonus() {
        int div = this.getVariableValue("OFFHANDLIGHTBONUS", "").intValue();
        return div;
    }

    public boolean isProficientWith(Equipment eq) {
        if (eq.isShield()) {
            return this.shieldProfFacet.isProficientWithShield(this.id, eq);
        }
        if (eq.isArmor()) {
            return this.armorProfFacet.isProficientWithArmor(this.id, eq);
        }
        if (eq.isWeapon()) {
            return this.weaponProfFacet.isProficientWithWeapon(this.id, eq);
        }
        return false;
    }

    public boolean setRace(Race newRace) {
        boolean success = newRace == null ? this.raceInputFacet.set(this.id, Globals.s_EMPTYRACE) : this.raceInputFacet.set(this.id, newRace);
        if (success) {
            this.calcActiveBonuses();
        }
        return success;
    }

    public double getRaceBonusTo(String aType, String aName) {
        if (this.getRace() == null) {
            return 0.0;
        }
        List<BonusObj> tempList = BonusUtilities.getBonusFromList(this.getRace().getBonusList(this), aType.toUpperCase(), aName.toUpperCase());
        return this.calcBonusFromList(tempList, this.getRace());
    }

    public int getSR() {
        return this.calcSR(true);
    }

    public double getSizeAdjustmentBonusTo(String aType, String aName) {
        return this.getBonusDueToType(aType.toUpperCase(), aName.toUpperCase(), "SIZE");
    }

    public void setSkillFilter(SkillFilter filter) {
        if (this.skillFilterFacet.set(this.id, filter)) {
            this.setDirty(true);
        }
    }

    public SkillFilter getSkillFilter() {
        SkillFilter filter = (SkillFilter)((Object)this.skillFilterFacet.get(this.id));
        if (filter == null) {
            filter = SkillFilter.getByValue(PCGenSettings.OPTIONS_CONTEXT.initInt("skillsOutputFilter", SkillFilter.Usable.getValue()));
            if (filter == SkillFilter.SkillsTab) {
                filter = SkillFilter.Usable;
            }
            this.setSkillFilter(filter);
        }
        return filter;
    }

    public void setSkillsOutputOrder(SkillsOutputOrder i) {
        if (this.skillsOutputOrder != i) {
            this.skillsOutputOrder = i;
            this.setDirty(true);
        }
    }

    public SkillsOutputOrder getSkillsOutputOrder() {
        return this.skillsOutputOrder;
    }

    public boolean isSpellCaster(int minLevel) {
        return this.isSpellCaster(minLevel, false) > 0;
    }

    public int isSpellCaster(int minLevel, boolean sumOfLevels) {
        return this.isSpellCaster(null, minLevel, sumOfLevels);
    }

    public int isSpellCaster(String spellType, int minLevel, boolean sumLevels) {
        int classTotal = 0;
        int runningTotal = 0;
        for (PCClass pcClass : this.getClassSet()) {
            if (spellType != null && !spellType.equalsIgnoreCase(pcClass.getSpellType())) continue;
            int classLevels = (int)this.getTotalBonusTo("CASTERLEVEL", pcClass.getKeyName());
            if (classLevels == 0 && (this.canCastSpellTypeLevel(pcClass.getSpellType(), 0, 1) || this.canCastSpellTypeLevel(pcClass.getSpellType(), 1, 1))) {
                classLevels = this.getLevel(pcClass);
            }
            classLevels += (int)this.getTotalBonusTo("PCLEVEL", pcClass.getKeyName());
            if (sumLevels) {
                runningTotal += classLevels;
                continue;
            }
            if (classLevels < minLevel) continue;
            ++classTotal;
        }
        if (sumLevels) {
            return runningTotal >= minLevel ? 1 : 0;
        }
        return classTotal;
    }

    public void getSpellList() {
        Race race = this.getRace();
        if (race == null) {
            return;
        }
        this.activeSpellsFacet.process(this.id);
        this.setDirty(true);
    }

    public String getSpellRange(CharacterSpell aSpell, SpellInfo si) {
        String aRange = aSpell.getSpell().getListAsString(ListKey.RANGE);
        String aSpellClass = aSpell.getVariableSource(this);
        int rangeInFeet = 0;
        String aString = Globals.getGameModeSpellRangeFormula(aRange.toUpperCase());
        if (aRange.equalsIgnoreCase("CLOSE") && aString == null) {
            aString = "((CASTERLEVEL/2).TRUNC*5)+25";
        } else if (aRange.equalsIgnoreCase("MEDIUM") && aString == null) {
            aString = "(CASTERLEVEL*10)+100";
        } else if (aRange.equalsIgnoreCase("LONG") && aString == null) {
            aString = "(CASTERLEVEL*40)+400";
        }
        if (aString != null) {
            List<Ability> metaFeats = null;
            if (si != null) {
                metaFeats = si.getFeatList();
            }
            rangeInFeet = this.getVariableValue(aSpell, aString, aSpellClass).intValue();
            if (metaFeats != null && !metaFeats.isEmpty()) {
                for (Ability feat : metaFeats) {
                    rangeInFeet += (int)BonusCalc.charBonusTo(feat, "SPELL", "RANGE", this);
                    int iMult = (int)BonusCalc.charBonusTo(feat, "SPELL", "RANGEMULT", this);
                    if (iMult <= 0) continue;
                    rangeInFeet *= iMult;
                }
            }
            aRange = aRange + " (" + Globals.getGameModeUnitSet().displayDistanceInUnitSet(rangeInFeet) + Globals.getGameModeUnitSet().getDistanceUnit() + ")";
        } else {
            aRange = this.parseSpellString(aSpell, aRange);
        }
        return aRange;
    }

    public int getCasterLevelForClass(PCClass aClass) {
        Spell sp = new Spell();
        CharacterSpell cs = new CharacterSpell(aClass, sp);
        String aSpellClass = "CLASS:" + aClass.getKeyName();
        return this.getVariableValue(cs, "CASTERLEVEL", aSpellClass).intValue();
    }

    public int getCasterLevelForSpell(CharacterSpell aSpell) {
        return this.getVariableValue(aSpell, "CASTERLEVEL", aSpell.getVariableSource(this)).intValue();
    }

    private double getStatBonusTo(String aType, String aName) {
        return this.statBonusFacet.getStatBonusTo(this.id, aType, aName);
    }

    public double getTemplateBonusTo(String aType, String aName) {
        return this.getPObjectWithCostBonusTo(this.templateFacet.getSet(this.id), aType.toUpperCase(), aName.toUpperCase());
    }

    public double getTotalBonusTo(String bonusType, String bonusName) {
        return this.bonusManager.getTotalBonusTo(bonusType, bonusName);
    }

    public int getTotalLevels() {
        return this.levelFacet.getTotalLevels(this.id);
    }

    public int getTotalStatAtLevel(PCStat stat, int level, boolean includePost) {
        int curStat = this.getTotalStatFor(stat);
        for (int idx = this.getLevelInfoSize() - 1; idx >= level; --idx) {
            int statLvlAdjust = this.levelInfoFacet.get(this.id, idx).getTotalStatMod(stat, true);
            curStat -= statLvlAdjust;
        }
        if (!includePost && level > 0) {
            int statLvlAdjust = this.levelInfoFacet.get(this.id, level - 1).getTotalStatMod(stat, true);
            curStat -= (statLvlAdjust -= this.levelInfoFacet.get(this.id, level - 1).getTotalStatMod(stat, false));
        }
        return curStat;
    }

    public int getTwoHandDamageDivisor() {
        int div = this.getVariableValue("TWOHANDDAMAGEDIVISOR", "").intValue();
        if (div == 0) {
            div = 2;
        }
        return div;
    }

    public void setUseTempMods(boolean aBool) {
        this.useTempMods = aBool;
    }

    public boolean getUseTempMods() {
        return this.useTempMods;
    }

    public Float getVariableValue(String aString, String src) {
        return this.getVariableValue(null, aString, src);
    }

    @Override
    public Float getVariableValue(String varName, String src, PlayerCharacter aPC) {
        return this.getVariableValue(null, varName, src);
    }

    private Float getVariableValue(CharacterSpell aSpell, String aString, String src) {
        VariableProcessor vp = this.getVariableProcessor();
        return vp.getVariableValue(aSpell, aString, src, this.getSpellLevelTemp());
    }

    public VariableProcessor getVariableProcessor() {
        return this.variableProcessor;
    }

    public int getTotalCasterLevelWithSpellBonus(CharacterSpell acs, Spell aSpell, String spellType, String classOrRace, int casterLev) {
        String tStr;
        String tType;
        if (aSpell != null && acs.getFixedCasterLevel() != null) {
            return this.getVariableValue(acs.getFixedCasterLevel(), "").intValue();
        }
        int tBonus = casterLev;
        boolean replaceCasterLevel = false;
        ArrayList<CasterLevelSpellBonus> bonuses = new ArrayList<CasterLevelSpellBonus>();
        if (classOrRace != null) {
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", classOrRace);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", classOrRace);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if (!classOrRace.startsWith("RACE.") && (tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = "CLASS." + classOrRace)) > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        if (aSpell == null) {
            return this.tallyCasterlevelBonuses(casterLev, replaceCasterLevel, bonuses);
        }
        if (!spellType.equals("None")) {
            tStr = "TYPE." + spellType;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) > 0) {
                replaceCasterLevel = true;
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = "SPELL." + aSpell.getKeyName())) > 0) {
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) > 0) {
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        for (SpellSchool school : new TreeSet<SpellSchool>(aSpell.getSafeListFor(ListKey.SPELL_SCHOOL))) {
            tStr = "SCHOOL." + school.toString();
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus != 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        for (String subschool : new TreeSet<String>(aSpell.getSafeListFor(ListKey.SPELL_SUBSCHOOL))) {
            tStr = "SUBSCHOOL." + subschool;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        for (String desc : aSpell.getSafeListFor(ListKey.SPELL_DESCRIPTOR)) {
            tStr = "DESCRIPTOR." + desc;
            tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
            if (tBonus > 0) {
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
            if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
            replaceCasterLevel = true;
            tType = this.getSpellBonusType("CASTERLEVEL", tStr);
            bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
        }
        HashMapToList<CDOMList<Spell>, Integer> domainMap = this.getSpellLevelInfo(aSpell);
        if (domainMap != null) {
            for (CDOMList spellList : domainMap.getKeySet()) {
                if (!(spellList instanceof DomainSpellList)) continue;
                tStr = "DOMAIN." + spellList.getKeyName();
                tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr);
                if (tBonus > 0) {
                    tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                    bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
                }
                if ((tBonus = (int)this.getTotalBonusTo("CASTERLEVEL", tStr = tStr + ".RESET")) <= 0) continue;
                replaceCasterLevel = true;
                tType = this.getSpellBonusType("CASTERLEVEL", tStr);
                bonuses.add(new CasterLevelSpellBonus(tBonus, tType));
            }
        }
        int result = this.tallyCasterlevelBonuses(casterLev, replaceCasterLevel, bonuses);
        return result;
    }

    private int tallyCasterlevelBonuses(int casterLev, boolean replaceCasterLevel, List<CasterLevelSpellBonus> bonuses) {
        for (int z = 0; z < bonuses.size() - 1; ++z) {
            CasterLevelSpellBonus zBonus = bonuses.get(z);
            String zType = zBonus.getType();
            if (zBonus.getBonus() == 0 || zType.equals("")) continue;
            boolean zReplace = false;
            boolean zStack = false;
            if (zType.endsWith(".REPLACE")) {
                zType = zType.substring(0, zType.length() - 8);
                zReplace = true;
            } else if (zType.endsWith(".STACK")) {
                zType = zType.substring(0, zType.length() - 6);
                zStack = true;
            }
            for (int k = z + 1; k < bonuses.size(); ++k) {
                CasterLevelSpellBonus kBonus = bonuses.get(k);
                String kType = kBonus.getType();
                if (kBonus.getBonus() == 0 || kType.equals("")) continue;
                boolean kReplace = false;
                boolean kStack = false;
                if (kType.endsWith(".REPLACE")) {
                    kType = kType.substring(0, kType.length() - 8);
                    kReplace = true;
                } else if (kType.endsWith(".STACK")) {
                    kType = kType.substring(0, kType.length() - 6);
                    kStack = true;
                }
                if (!zType.equals(kType)) continue;
                if (zReplace && kReplace) {
                    kBonus.setBonus(zBonus.getBonus() + kBonus.getBonus());
                    zBonus.setBonus(0);
                    continue;
                }
                if (zStack || kStack) continue;
                if (zBonus.getBonus() > kBonus.getBonus()) {
                    kBonus.setBonus(0);
                    continue;
                }
                zBonus.setBonus(0);
            }
        }
        int result = 0;
        if (!replaceCasterLevel) {
            result += casterLev;
        }
        for (CasterLevelSpellBonus resultBonus : bonuses) {
            result += resultBonus.getBonus();
        }
        if (result <= 0) {
            result = 1;
        }
        return result;
    }

    private String getSpellBonusType(String bonusType, String bonusName) {
        return this.bonusManager.getSpellBonusType(bonusType, bonusName);
    }

    public List<Equipment> addEqType(List<Equipment> aList, String aType) {
        for (Equipment eq : this.getEquipmentSet()) {
            if (eq.typeStringContains(aType)) {
                aList.add(eq);
                continue;
            }
            if (!aType.equalsIgnoreCase("CONTAINED") || eq.getParent() == null) continue;
            aList.add(eq);
        }
        return aList;
    }

    public void addKit(Kit aKit) {
        this.kitFacet.add(this.id, aKit);
        this.setDirty(true);
    }

    /*
     * WARNING - void declaration
     */
    public String addSpell(CharacterSpell acs, List<Ability> aFeatList, String classKey, String bookName, int adjSpellLevel, int spellLevel) {
        boolean isEmpty;
        if (acs == null) {
            return "Invalid parameter to add spell";
        }
        PCClass aClass = null;
        Spell aSpell = acs.getSpell();
        if (bookName == null || bookName.length() == 0) {
            return "Invalid spell list/book name.";
        }
        if (!this.hasSpellBook(bookName)) {
            return "Could not find spell list/book " + bookName;
        }
        if (classKey != null && (aClass = this.getClassKeyed(classKey)) == null && classKey.lastIndexOf(40) >= 0) {
            aClass = this.getClassKeyed(classKey.substring(0, classKey.lastIndexOf(40)).trim());
        }
        SpellBook spellBook = this.getSpellBookByName(bookName);
        if (aClass == null && spellBook.getType() == 3 && (aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey)) == null && classKey.lastIndexOf(40) >= 0) {
            aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKey.substring(0, classKey.lastIndexOf(40)).trim());
        }
        if (aClass == null) {
            return "No class keyed " + classKey;
        }
        if (!aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !bookName.equals(Globals.getDefaultSpellBook())) {
            return aClass.getDisplayName() + " can only add to " + Globals.getDefaultSpellBook();
        }
        if (!aSpell.qualifies(this, aSpell)) {
            return "You do not qualify for " + acs.getSpell().getDisplayName() + ".";
        }
        if (spellBook.getType() != 3 && !acs.isSpecialtySpell(this) && SpellCountCalc.isProhibited(aSpell, aClass, this)) {
            return acs.getSpell().getDisplayName() + " is prohibited.";
        }
        int known = this.getSpellSupport(aClass).getKnownForLevel(spellLevel, "null", this);
        int specialKnown = 0;
        int cast = this.getSpellSupport(aClass).getCastForLevel(adjSpellLevel, bookName, true, true, this);
        SpellCountCalc.memorizedSpellForLevelBook(this, aClass, adjSpellLevel, bookName);
        boolean isDefault = bookName.equals(Globals.getDefaultSpellBook());
        if (isDefault) {
            specialKnown = this.getSpellSupport(aClass).getSpecialtyKnownForLevel(spellLevel, this);
        }
        int numPages = 0;
        if (spellBook.getType() == 3) {
            this.setSpellLevelTemp(spellLevel);
            numPages = this.getVariableValue(acs, spellBook.getPageFormula().toString(), "").intValue();
            if (numPages + spellBook.getNumPagesUsed() > spellBook.getNumPages()) {
                return "There are not enough pages left to add this spell to the spell book.";
            }
            spellBook.setNumPagesUsed(numPages + spellBook.getNumPagesUsed());
            spellBook.setNumSpells(spellBook.getNumSpells() + 1);
        } else {
            if (!aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !this.availableSpells(adjSpellLevel, aClass, bookName, true, acs.isSpecialtySpell(this))) {
                int maxAllowed;
                String ret;
                if (!acs.isSpecialtySpell(this) && this.availableSpells(adjSpellLevel, aClass, bookName, true, true)) {
                    ret = "Your remaining slot(s) must be filled with your speciality.";
                    maxAllowed = known;
                } else {
                    ret = "You can only learn " + (known + specialKnown) + " spells for level " + adjSpellLevel + " \nand there are no higher-level slots available.";
                    maxAllowed = known + specialKnown;
                }
                int memTot = SpellCountCalc.memorizedSpellForLevelBook(this, aClass, adjSpellLevel, bookName);
                int spellDifference = maxAllowed - memTot;
                if (spellDifference > 0) {
                    ret = ret + "\n" + spellDifference + " spells from lower levels are using slots for this level.";
                }
                return ret;
            }
            if (aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() && !isDefault && !this.availableSpells(adjSpellLevel, aClass, bookName, false, acs.isSpecialtySpell(this))) {
                String ret;
                if (!acs.isSpecialtySpell(this) && this.availableSpells(adjSpellLevel, aClass, bookName, false, true)) {
                    ret = "Your remaining slot(s) must be filled with your speciality or domain.";
                    int maxAllowed = this.getSpellSupport(aClass).getCastForLevel(adjSpellLevel, bookName, false, true, this);
                } else if (acs.isSpecialtySpell(this) && this.availableSpells(adjSpellLevel, aClass, bookName, false, false)) {
                    ret = "Your remaining slot(s) must be filled with spells not from your speciality or domain.";
                    int maxAllowed = this.getSpellSupport(aClass).getCastForLevel(adjSpellLevel, bookName, false, true, this);
                } else {
                    ret = "You can only prepare " + cast + " spells for level " + adjSpellLevel + " \nand there are no higher-level slots available.";
                    int maxAllowed = cast;
                    int memTot = SpellCountCalc.memorizedSpellForLevelBook(this, aClass, adjSpellLevel, bookName);
                    int spellDifference = maxAllowed - memTot;
                    if (spellDifference > 0) {
                        ret = ret + "\n" + spellDifference + " spells from lower levels are using slots for this level.";
                    }
                }
                return ret;
            }
        }
        SpellInfo si = null;
        List<CharacterSpell> acsList = this.getCharacterSpells(aClass, acs.getSpell(), bookName, adjSpellLevel);
        if (!acsList.isEmpty()) {
            for (int x = acsList.size() - 1; x >= 0; --x) {
                CharacterSpell c = acsList.get(x);
                if (c.equals(acs)) continue;
                acsList.remove(x);
            }
        }
        if (!(isEmpty = acsList.isEmpty())) {
            if (acsList.size() == 1) {
                CharacterSpell tcs = acsList.get(0);
                si = tcs.getSpellInfoFor(bookName, adjSpellLevel, aFeatList);
            } else {
                si = acs.getSpellInfoFor(bookName, adjSpellLevel, aFeatList);
            }
        }
        if (si != null) {
            if (isDefault) {
                return "The Known Spells spellbook contains all spells of this level that you know. You cannot place spells in multiple times.";
            }
            si.setTimes(si.getTimes() + 1);
        } else {
            if (isEmpty && !this.containsCharacterSpell(aClass, acs)) {
                this.addCharacterSpell(aClass, acs);
            } else if (isEmpty) {
                for (CharacterSpell characterSpell : this.getCharacterSpells(aClass)) {
                    if (!characterSpell.equals(acs)) continue;
                    acs = characterSpell;
                }
            }
            si = acs.addInfo(spellLevel, adjSpellLevel, 1, bookName, aFeatList);
            if (Globals.hasSpellPPCost()) {
                void var19_31;
                Spell theSpell = acs.getSpell();
                int n = theSpell.getSafe(IntegerKey.PP_COST);
                for (Ability feat : aFeatList) {
                    var19_31 += (int)BonusCalc.charBonusTo(feat, "PPCOST", theSpell.getKeyName(), this);
                }
                si.setActualPPCost((int)var19_31);
            }
        }
        si.setNumPages(si.getNumPages() + numPages);
        this.setDirty(true);
        return "";
    }

    public boolean addSpellBook(String aName) {
        if (aName != null && aName.length() > 0 && !this.spellBookFacet.containsBookNamed(this.id, aName)) {
            return this.addSpellBook(new SpellBook(aName, 2));
        }
        return false;
    }

    public boolean addSpellBook(SpellBook book) {
        if (!this.spellBookFacet.containsBookNamed(this.id, book.getName())) {
            this.spellBookFacet.add(this.id, book);
            return true;
        }
        return false;
    }

    public boolean addTemplate(PCTemplate inTemplate) {
        boolean added;
        if (inTemplate == null) {
            return false;
        }
        if (this.hasTemplate(inTemplate)) {
            return false;
        }
        int lockMonsterSkillPoints = 0;
        for (PCClass pcClass : this.getClassSet()) {
            if (!pcClass.isMonster()) continue;
            lockMonsterSkillPoints = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            break;
        }
        if (!(added = this.templateInputFacet.add(this.id, inTemplate))) {
            return false;
        }
        this.setDirty(true);
        this.calcActiveBonuses();
        boolean first = true;
        for (PCClass pcClass : this.getClassSet()) {
            Processor<HitDie> dieLock;
            int postLockMonsterSkillPoints;
            if (pcClass.isMonster() && (postLockMonsterSkillPoints = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER")) != lockMonsterSkillPoints && postLockMonsterSkillPoints > 0) {
                for (PCLevelInfo pi : this.getLevelInfo()) {
                    int newSkillPointsGained = this.recalcSkillPointMod(pcClass, pi.getClassLevel());
                    if (!pi.getClassKeyName().equals(pcClass.getKeyName())) continue;
                    int formerGained = pi.getSkillPointsGained(this);
                    pi.setSkillPointsGained(this, newSkillPointsGained);
                    pi.setSkillPointsRemaining(pi.getSkillPointsRemaining() + newSkillPointsGained - formerGained);
                    this.setSkillPool(pcClass, pcClass.getSkillPool(this) + newSkillPointsGained - formerGained);
                }
            }
            if (!this.isImporting() && (dieLock = inTemplate.get(ObjectKey.HITDIE)) != null) {
                for (int level = 1; level <= this.getLevel(pcClass); ++level) {
                    HitDie baseHD = pcClass.getSafe(ObjectKey.LEVEL_HITDIE);
                    if (baseHD.equals(this.getLevelHitDie(pcClass, level))) continue;
                    this.rollHP(pcClass, level, first);
                }
            }
            first = false;
        }
        this.setDirty(true);
        return true;
    }

    public void adjustGold(double delta) {
        this.goldFacet.adjustGold(this.id, delta);
        this.setDirty(true);
    }

    public void adjustMoveRates() {
        this.moveResultFacet.reset(this.id);
    }

    public List<Spell> aggregateSpellList(String school, String subschool, String descriptor, int minLevel, int maxLevel) {
        ArrayList<Spell> retList = new ArrayList<Spell>();
        for (PObject pObject : this.getSpellClassList()) {
            for (int a = minLevel; a <= maxLevel; ++a) {
                for (CharacterSpell cs : this.getCharacterSpells(pObject, a)) {
                    Spell aSpell = cs.getSpell();
                    SpellSchool ss = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(SpellSchool.class, school);
                    if (school.length() != 0 && (ss == null || !aSpell.containsInList(ListKey.SPELL_SCHOOL, ss)) && subschool.length() != 0 && !aSpell.containsInList(ListKey.SPELL_SUBSCHOOL, subschool) && descriptor.length() != 0 && !aSpell.containsInList(ListKey.SPELL_DESCRIPTOR, descriptor)) continue;
                    retList.add(aSpell);
                }
            }
        }
        return retList;
    }

    public int altHP() {
        int i = (int)this.getTotalBonusTo("HP", "ALTHP");
        return i;
    }

    public int baseAttackBonus() {
        String cacheLookup = "BaseAttackBonus";
        Float total = this.epicBAB != null ? Float.valueOf(this.epicBAB.floatValue()) : this.getVariableProcessor().getCachedVariable("BaseAttackBonus");
        if (total != null) {
            return total.intValue();
        }
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC != null && this.masterFacet.getCopyMasterBAB(this.id).length() > 0) {
            int masterBAB = nPC.baseAttackBonus();
            String copyMasterBAB = this.replaceMasterString(this.masterFacet.getCopyMasterBAB(this.id), masterBAB);
            masterBAB = this.getVariableValue(copyMasterBAB, "").intValue();
            this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(masterBAB));
            return masterBAB;
        }
        int totalClassLevels = this.totalNonMonsterLevels();
        HashMap<String, Integer> totalLvlMap = null;
        boolean isEpic = false;
        if (totalClassLevels > SettingsHandler.getGame().getBabMaxLvl()) {
            isEpic = true;
            if (this.epicBAB == null) {
                totalLvlMap = this.getTotalLevelHashMap();
                Map<String, Integer> classLvlMap = this.getCharacterLevelHashMap(SettingsHandler.getGame().getBabMaxLvl());
                this.getVariableProcessor().pauseCache();
                this.setAllowInteraction(false);
                this.setClassLevelsBrazenlyTo(classLvlMap);
            } else {
                return this.epicBAB;
            }
        }
        int bab = (int)this.getTotalBonusTo("COMBAT", "BAB");
        if (isEpic) {
            this.epicBAB = bab;
        }
        if (totalLvlMap != null) {
            this.setClassLevelsBrazenlyTo(totalLvlMap);
            this.setAllowInteraction(true);
            this.getVariableProcessor().restartCache();
        }
        this.getVariableProcessor().addCachedVariable("BaseAttackBonus", Float.valueOf(bab += (int)this.getTotalBonusTo("COMBAT", "BASEAB")));
        return bab;
    }

    public void calcActiveBonuses() {
        if (this.isImporting() || this.getRace() == null) {
            return;
        }
        int count = 0;
        do {
            if (count >= 29) {
                Logging.errorPrint("Active bonus loop exceeded reasonable limit of " + count + ".");
                this.bonusManager.logChangeFromCheckpoint();
                if (count > 31) break;
            }
            this.bonusManager.checkpointBonusMap();
            this.setDirty(true);
            ++count;
            this.calcActiveBonusLoop();
            if (!Globals.checkRule("RETROSKILL")) continue;
            this.checkSkillModChange();
        } while (!this.bonusManager.compareToCheckpoint());
        if (Logging.isDebugMode()) {
            Logging.log(Logging.DEBUG, "Ran " + count + " loops to calc bonuses");
        }
    }

    private void calcActiveBonusLoop() {
        if (this.cablInt == this.lastCablInt) {
            return;
        }
        this.lastCablInt = this.cablInt++;
        this.bonusManager.setActiveBonusList();
        this.bonusManager.buildActiveBonusMap();
        this.bonusChangeFacet.reset(this.id);
    }

    public int calcSR(boolean includeEquipment) {
        int SR = this.srFacet.getSR(this.id);
        if (includeEquipment) {
            for (Equipment eq : this.getEquippedEquipmentSet()) {
                SR = Math.max(SR, eq.getSafe(ObjectKey.SR).getReduction().resolve(this, eq.getQualifiedKey()).intValue());
                for (EquipmentModifier eqMod : eq.getEqModifierList(true)) {
                    SR = Math.max(SR, eqMod.getSR(eq, this));
                }
                for (EquipmentModifier eqMod : eq.getEqModifierList(false)) {
                    SR = Math.max(SR, eqMod.getSR(eq, this));
                }
            }
        }
        SR += (int)this.getTotalBonusTo("MISC", "SR");
        if (!includeEquipment) {
            SR -= (int)this.getEquipmentBonusTo("MISC", "SR");
        }
        return SR;
    }

    private boolean canCastSpellTypeLevel(String spellType, int spellLevel, int minNumSpells) {
        for (PCClass aClass : this.getClassSet()) {
            FactKey fk;
            String classSpellType = (String)aClass.getResolved(fk = FactKey.valueOf("SpellType"));
            if (classSpellType == null || !"Any".equalsIgnoreCase(spellType) && !classSpellType.equalsIgnoreCase(spellType)) continue;
            int knownForLevel = this.getSpellSupport(aClass).getKnownForLevel(spellLevel, "null", this);
            if ((knownForLevel += this.getSpellSupport(aClass).getSpecialtyKnownForLevel(spellLevel, this)) >= minNumSpells) {
                return true;
            }
            if (this.getSpellSupport(aClass).getCastForLevel(spellLevel, this) >= minNumSpells) {
                return true;
            }
            if (aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() || this.getSpellSupport(aClass).hasKnownList() || !this.getSpellSupport(aClass).canCastSpells(this)) continue;
            return true;
        }
        return false;
    }

    public int countSpellCastTypeLevel(String spellType, int spellLevel) {
        int known = 0;
        int cast = 0;
        for (PCClass aClass : this.getClassSet()) {
            FactKey fk;
            String classSpellType = (String)aClass.getResolved(fk = FactKey.valueOf("SpellType"));
            if (classSpellType == null || !"Any".equalsIgnoreCase(spellType) && !classSpellType.equalsIgnoreCase(spellType)) continue;
            int numCastLevel = this.getSpellSupport(aClass).getCastForLevel(spellLevel, this);
            known += this.getSpellSupport(aClass).getKnownForLevel(spellLevel, "null", this);
            if (numCastLevel > 0) {
                known += this.getSpellSupport(aClass).getSpecialtyKnownForLevel(spellLevel, this);
            }
            cast += numCastLevel;
            if (aClass.getSafe(ObjectKey.MEMORIZE_SPELLS).booleanValue() || this.getSpellSupport(aClass).hasKnownList() || !this.getSpellSupport(aClass).canCastSpells(this)) continue;
            return Integer.MAX_VALUE;
        }
        return known == 0 ? cast : known;
    }

    public boolean canSelectDeity(Deity aDeity) {
        return this.legalDeityFacet.allows(this.id, aDeity);
    }

    public String delSpell(SpellInfo si, PCClass aClass, String bookName) {
        SpellBook spellBook;
        if (bookName == null || bookName.length() == 0) {
            return "Invalid spell book name.";
        }
        if (aClass == null) {
            return "Error: Class is null";
        }
        CharacterSpell acs = si.getOwner();
        boolean isDefault = bookName.equals(Globals.getDefaultSpellBook());
        if (isDefault && this.getSpellSupport(aClass).isAutoKnownSpell(acs.getSpell(), si.getActualLevel(), false, this)) {
            Logging.errorPrint("Notice: removing " + acs.getSpell().getDisplayName() + " even though it is an auto known spell");
        }
        if ((spellBook = this.getSpellBookByName(bookName)).getType() == 3) {
            int pagesPerSpell = si.getNumPages() / si.getTimes();
            spellBook.setNumPagesUsed(spellBook.getNumPagesUsed() - pagesPerSpell);
            spellBook.setNumSpells(spellBook.getNumSpells() - 1);
            si.setNumPages(si.getNumPages() - pagesPerSpell);
        }
        si.setTimes(si.getTimes() - 1);
        if (si.getTimes() <= 0) {
            acs.removeSpellInfo(si);
        }
        if (acs.getInfoList().isEmpty()) {
            this.removeCharacterSpell(aClass, acs);
        }
        return "";
    }

    public int calculateSaveBonus(PCCheck check, String tokenString) {
        if (check == null) {
            return 0;
        }
        StringTokenizer aTok = new StringTokenizer(tokenString, ".");
        String[] tokens = new String[aTok.countTokens()];
        int save = 0;
        String saveType = check.toString();
        int i = 0;
        while (aTok.hasMoreTokens()) {
            tokens[i] = aTok.nextToken();
            if ("TOTAL".equals(tokens[i])) {
                save += this.getTotalCheck(check);
            } else if ("BASE".equals(tokens[i])) {
                save += this.getBaseCheck(check);
            } else if ("MISC".equals(tokens[i])) {
                save += (int)this.getTotalBonusTo("CHECKS", saveType);
                save += (int)this.getTotalBonusTo("SAVE", saveType);
            }
            if ("EPIC".equals(tokens[i])) {
                save += (int)this.getBonusDueToType("CHECKS", saveType, "EPIC");
                save += (int)this.getBonusDueToType("SAVE", saveType, "EPIC");
            }
            if ("MAGIC".equals(tokens[i])) {
                save += (int)this.getEquipmentBonusTo("CHECKS", saveType);
                save += (int)this.getEquipmentBonusTo("SAVE", saveType);
            }
            if ("RACE".equals(tokens[i])) {
                save += this.calculateSaveBonusRace(check);
            }
            if ("FEATS".equals(tokens[i])) {
                save += (int)this.getFeatBonusTo("CHECKS", saveType);
                save += (int)this.getFeatBonusTo("SAVE", saveType);
            }
            if ("STATMOD".equals(tokens[i])) {
                save += (int)this.checkBonusFacet.getCheckBonusTo(this.id, "CHECKS", saveType);
                save += (int)this.checkBonusFacet.getCheckBonusTo(this.id, "SAVE", saveType);
            }
            if ("NOEPIC".equals(tokens[i])) {
                save -= (int)this.getBonusDueToType("CHECKS", saveType, "EPIC");
                save -= (int)this.getBonusDueToType("SAVE", saveType, "EPIC");
            }
            if ("NOMAGIC".equals(tokens[i])) {
                save -= (int)this.getEquipmentBonusTo("CHECKS", saveType);
                save -= (int)this.getEquipmentBonusTo("SAVE", saveType);
            }
            if ("NORACE".equals(tokens[i])) {
                save -= this.calculateSaveBonusRace(check);
            }
            if ("NOFEATS".equals(tokens[i])) {
                save -= (int)this.getFeatBonusTo("CHECKS", saveType);
                save -= (int)this.getFeatBonusTo("SAVE", saveType);
            }
            if ("NOSTAT".equals(tokens[i]) || "NOSTATMOD".equals(tokens[i])) {
                save -= (int)this.checkBonusFacet.getCheckBonusTo(this.id, "CHECKS", saveType);
                save -= (int)this.checkBonusFacet.getCheckBonusTo(this.id, "SAVE", saveType);
            }
            ++i;
        }
        return save;
    }

    public boolean delSpellBook(String aName) {
        if (aName.length() > 0 && !aName.equals(Globals.getDefaultSpellBook()) && this.spellBookFacet.containsBookNamed(this.id, aName)) {
            this.processSpellBookRemoval(aName);
            return true;
        }
        return false;
    }

    private void processSpellBookRemoval(String aName) {
        this.spellBookFacet.removeBookNamed(this.id, aName);
        this.setDirty(true);
        for (PCClass pcClass : this.getClassSet()) {
            for (CharacterSpell cs : this.getCharacterSpells((PObject)pcClass, aName)) {
                cs.removeSpellInfo(cs.getSpellInfoFor(aName, -1));
            }
        }
    }

    private void determinePrimaryOffWeapon() {
        this.primaryWeaponFacet.removeAll(this.id);
        this.secondaryWeaponFacet.removeAll(this.id);
        if (!this.hasEquipment()) {
            return;
        }
        ArrayList<Equipment> unequippedPrimary = new ArrayList<Equipment>();
        ArrayList<Equipment> unequippedSecondary = new ArrayList<Equipment>();
        for (Equipment eq : this.getEquipmentSet()) {
            if (!eq.isWeapon() || eq.getSlots(this) < 1) continue;
            boolean isEquipped = eq.isEquipped();
            if (eq.getLocation() == EquipmentLocation.EQUIPPED_PRIMARY || eq.getLocation() == EquipmentLocation.EQUIPPED_BOTH && this.primaryWeaponFacet.isEmpty(this.id) || eq.getLocation() == EquipmentLocation.EQUIPPED_TWO_HANDS) {
                if (isEquipped) {
                    this.primaryWeaponFacet.add(this.id, eq);
                } else {
                    unequippedPrimary.add(eq);
                }
            } else if (eq.getLocation() == EquipmentLocation.EQUIPPED_BOTH && !this.primaryWeaponFacet.isEmpty(this.id)) {
                if (isEquipped) {
                    this.secondaryWeaponFacet.add(this.id, eq);
                } else {
                    unequippedSecondary.add(eq);
                }
            }
            if (eq.getLocation() == EquipmentLocation.EQUIPPED_SECONDARY) {
                if (isEquipped) {
                    this.secondaryWeaponFacet.add(this.id, eq);
                } else {
                    unequippedSecondary.add(eq);
                }
            }
            if (eq.getLocation() != EquipmentLocation.EQUIPPED_TWO_HANDS) continue;
            for (int y = 0; y < eq.getNumberEquipped() - 1; ++y) {
                if (isEquipped) {
                    this.secondaryWeaponFacet.add(this.id, eq);
                    continue;
                }
                unequippedSecondary.add(eq);
            }
        }
        if (Globals.checkRule("EQUIPATTACK")) {
            if (unequippedPrimary.size() != 0) {
                this.primaryWeaponFacet.addAll(this.id, unequippedPrimary);
            }
            if (unequippedSecondary.size() != 0) {
                this.secondaryWeaponFacet.addAll(this.id, unequippedSecondary);
            }
        }
    }

    public boolean hasMadeKitSelectionForAgeSet(int index) {
        return index >= 0 && index < 10 && this.ageSetKitSelections[index];
    }

    public boolean hasSpecialAbility(String abilityKey) {
        for (SpecialAbility sa : this.getSpecialAbilityList()) {
            if (!sa.getKeyName().equalsIgnoreCase(abilityKey)) continue;
            return true;
        }
        return false;
    }

    public int hitPoints() {
        int total = 0;
        String aString = SettingsHandler.getGame().getHPFormula();
        if (aString.length() != 0) {
            int endIdx;
            int startIdx;
            while ((startIdx = aString.indexOf("$$")) >= 0 && (endIdx = aString.indexOf("$$", startIdx + 2)) >= 0) {
                String lookupString = aString.substring(startIdx + 2, endIdx);
                lookupString = ExportHandler.getTokenString(this, lookupString);
                aString = aString.substring(0, startIdx) + lookupString + aString.substring(endIdx + 2);
            }
            total = this.getVariableValue(aString, "").intValue();
        } else {
            double iConMod = this.getStatBonusTo("HP", "BONUS");
            for (PCClass pcClass : this.getClassSet()) {
                total += this.getClassHitPoints(pcClass, (int)iConMod);
            }
        }
        total += (int)this.getTotalBonusTo("HP", "CURRENTMAX");
        PlayerCharacter nPC = this.getMasterPC();
        if (nPC == null) {
            return total;
        }
        if (this.masterFacet.getCopyMasterHP(this.id).length() == 0) {
            return total;
        }
        int masterHP = nPC.hitPoints();
        String copyMasterHP = this.replaceMasterString(this.masterFacet.getCopyMasterHP(this.id), masterHP);
        masterHP = this.getVariableValue(copyMasterHP, "").intValue();
        return masterHP;
    }

    private int getClassHitPoints(PCClass pcClass, int iConMod) {
        int total = 0;
        for (int i = 0; i <= this.getLevel(pcClass); ++i) {
            PCClassLevel pcl = this.getActiveClassLevel(pcClass, i);
            Integer hp = this.getHP(pcl);
            if (hp == null || hp <= 0) continue;
            int iHp = hp + iConMod;
            if (iHp < 1) {
                iHp = 1;
            }
            total += iHp;
        }
        return total;
    }

    public void incrementClassLevel(int mod, PCClass aClass) {
        this.incrementClassLevel(mod, aClass, false);
        this.setDirty(true);
    }

    public int getBonusLanguageCount() {
        int i = Math.max(0, (int)this.getStatBonusTo("LANG", "BONUS"));
        if (this.getRace() != null) {
            i = (int)((double)i + this.getTotalBonusTo("LANGUAGES", "NUMBER"));
        }
        return i;
    }

    public String listBonusesFor(String bonusType, String bonusName) {
        return this.bonusManager.listBonusesFor(bonusType, bonusName);
    }

    public boolean loadDescriptionFilesInDirectory(String aDirectory) {
        new File(aDirectory).list(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean accept(File parentDir, String fileName) {
                File descriptionFile = new File(parentDir, fileName);
                if (PCGFile.isPCGenListFile(descriptionFile)) {
                    BufferedReader descriptionReader = null;
                    try {
                        if (!descriptionFile.exists()) return false;
                        descriptionReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(descriptionFile), "UTF-8"));
                        int length = (int)descriptionFile.length();
                        char[] inputLine = new char[length];
                        descriptionReader.read(inputLine, 0, length);
                        PlayerCharacter.this.setDescriptionLst(PlayerCharacter.this.getDescriptionLst() + new String(inputLine));
                        return false;
                    }
                    catch (IOException exception) {
                        Logging.errorPrint("IOException in PlayerCharacter.loadDescriptionFilesInDirectory", exception);
                        return false;
                    }
                    finally {
                        if (descriptionReader != null) {
                            try {
                                descriptionReader.close();
                            }
                            catch (IOException e) {
                                Logging.errorPrint("Couldn't close descriptionReader in PlayerCharacter.loadDescriptionFilesInDirectory", e);
                            }
                        }
                    }
                }
                if (!parentDir.isDirectory()) return false;
                PlayerCharacter.this.loadDescriptionFilesInDirectory(parentDir.getPath() + File.separator + fileName);
                return false;
            }
        });
        return false;
    }

    public void makeIntoExClass(PCClass fromClass) {
        CDOMSingleRef<PCClass> exc = fromClass.get(ObjectKey.EX_CLASS);
        try {
            int i;
            int toLevel;
            boolean bClassNew;
            PCClass cl = exc.resolvesTo();
            PCClass toClass = this.getClassKeyed(cl.getKeyName());
            if (toClass == null) {
                toClass = cl.clone();
                bClassNew = true;
                toLevel = 0;
            } else {
                bClassNew = false;
                toLevel = this.getLevel(toClass);
            }
            int fromLevel = this.getLevel(fromClass);
            Integer[] hpArray = new Integer[fromLevel];
            for (i = 0; i < fromLevel; ++i) {
                PCClassLevel frompcl = this.getActiveClassLevel(fromClass, i);
                Integer hp = this.getHP(frompcl);
                if (hp == null) {
                    System.err.println("Did not find HP for " + fromClass + " " + (i + 1) + " " + frompcl);
                }
                hpArray[i] = hp;
            }
            for (i = 0; i < fromLevel; ++i) {
                fromClass.doMinusLevelMods(this, fromLevel - i);
            }
            fromClass.setLevel(0, this);
            if (bClassNew) {
                this.classFacet.replaceClass(this.id, fromClass, toClass);
            } else {
                this.classFacet.removeClass(this.id, fromClass);
            }
            toClass.setLevel(toLevel + fromLevel, this);
            for (i = 0; i < fromLevel; ++i) {
                PCClassLevel topcl = this.getActiveClassLevel(toClass, i);
                this.setHP(topcl, hpArray[i]);
            }
            for (int idx = this.getLevelInfoSize() - 1; idx >= 0; --idx) {
                PCLevelInfo li = this.levelInfoFacet.get(this.id, idx);
                if (!li.getClassKeyName().equals(fromClass.getKeyName())) continue;
                li.setClassKeyName(toClass.getKeyName());
            }
            for (Skill skill : this.getSkillSet()) {
                SkillRankControl.replaceClassRank(this, skill, fromClass, cl);
            }
            this.setSkillPool(toClass, fromClass.getSkillPool(this));
        }
        catch (NumberFormatException nfe) {
            ShowMessageDelegate.showMessageDialog(nfe.getMessage(), "PCGen", MessageType.INFORMATION);
        }
    }

    public int minXPForECL() {
        return this.levelTableFacet.minXPForLevel(this.levelFacet.getECL(this.id), this.id);
    }

    public int minXPForNextECL() {
        return this.levelTableFacet.minXPForLevel(this.levelFacet.getECL(this.id) + 1, this.id);
    }

    public int modFromArmorOnWeaponRolls() {
        int bonus = 0;
        for (Equipment eq : this.getEquipmentOfType("Armor", 1)) {
            if (eq == null || this.isProficientWith(eq)) continue;
            bonus += eq.acCheck(this).intValue();
        }
        for (Equipment eq : this.getEquipmentOfType("Shield", 1)) {
            if (eq == null || this.isProficientWith(eq)) continue;
            bonus += eq.acCheck(this).intValue();
        }
        return bonus;
    }

    private Load getHouseRuledLoadType() {
        if (Globals.checkRule("SYS_LDPACSK")) {
            return this.getLoadType();
        }
        return Load.LIGHT;
    }

    public int modToACFromEquipment() {
        int bonus = 0;
        for (Equipment eq : this.getEquippedEquipmentSet()) {
            bonus += eq.getACMod(this).intValue();
        }
        return bonus;
    }

    public int modToACCHECKFromEquipment() {
        Load load = this.getHouseRuledLoadType();
        int bonus = 0;
        int penaltyForLoad = Load.MEDIUM == load ? -3 : (Load.HEAVY == load ? -6 : 0);
        IdentityList vEqList = new IdentityList(this.getTempBonusItemList());
        for (Equipment eq : this.getEquippedEquipmentSet()) {
            if (vEqList.contains((Object)eq)) continue;
            bonus += eq.acCheck(this).intValue();
        }
        bonus = Math.min(bonus, penaltyForLoad);
        return bonus += (int)this.getTotalBonusTo("MISC", "ACCHECK");
    }

    public int modToSpellFailureFromEquipment() {
        int bonus = 0;
        for (Equipment eq : this.getEquippedEquipmentSet()) {
            bonus += eq.spellFailure(this).intValue();
        }
        return bonus += (int)this.getTotalBonusTo("MISC", "SPELLFAILURE");
    }

    public int modToMaxDexFromEquipment() {
        int statBonus = (int)this.getStatBonusTo("MISC", "MAXDEX");
        Load load = this.getHouseRuledLoadType();
        int bonus = load == Load.MEDIUM ? 3 : (load == Load.HEAVY ? 1 : (load == Load.OVERLOAD ? 0 : statBonus));
        boolean useMax = load == Load.LIGHT;
        for (Equipment eq : this.getEquippedEquipmentSet()) {
            int potentialMax = eq.getMaxDex(this);
            if (potentialMax == 100) continue;
            if (useMax || bonus > potentialMax) {
                bonus = potentialMax;
            }
            useMax = false;
        }
        if (useMax) {
            bonus = 100;
        }
        if ((bonus += (int)this.getTotalBonusTo("MISC", "MAXDEX") - statBonus) < 0) {
            bonus = 0;
        } else if (bonus > 100) {
            bonus = 100;
        }
        return bonus;
    }

    public int modToFromEquipment(String typeName) {
        if (typeName.equals("AC")) {
            return this.modToACFromEquipment();
        }
        if (typeName.equals("ACCHECK")) {
            return this.modToACCHECKFromEquipment();
        }
        if (typeName.equals("MAXDEX")) {
            return this.modToMaxDexFromEquipment();
        }
        if (typeName.equals("SPELLFAILURE")) {
            return this.modToSpellFailureFromEquipment();
        }
        return 0;
    }

    public String parseSpellString(CharacterSpell aSpell, String aString) {
        String aSpellClass = aSpell.getVariableSource(this);
        if (aSpellClass.length() == 0) {
            return aString;
        }
        while (aString.lastIndexOf(40) >= 0) {
            boolean found = false;
            int start = aString.indexOf(40);
            int end = 0;
            int level = 0;
            for (int i = start; i < aString.length(); ++i) {
                if (aString.charAt(i) == '(') {
                    ++level;
                    continue;
                }
                if (aString.charAt(i) != ')' || --level != 0) continue;
                end = i;
                break;
            }
            String inCalc = aString.substring(start + 1, end);
            String replacement = "0";
            Float fVal = this.getVariableValue(aSpell, inCalc, aSpellClass);
            if (!CoreUtility.doublesEqual(fVal.floatValue(), 0.0)) {
                found = true;
                replacement = fVal.intValue() + "";
            } else if (inCalc.indexOf("MIN") >= 0 || inCalc.indexOf("MAX") >= 0) {
                found = true;
                replacement = fVal.intValue() + "";
            } else if (inCalc.toUpperCase().indexOf("MIN(") >= 0 || inCalc.toUpperCase().indexOf("MAX(") >= 0) {
                found = true;
                replacement = fVal.intValue() + "";
            }
            if (found) {
                aString = aString.substring(0, start) + replacement + aString.substring(end + 1);
                continue;
            }
            aString = aString.substring(0, start) + "[" + inCalc + "]" + aString.substring(end + 1);
        }
        return aString;
    }

    public void removeTempBonus(BonusObj aBonus) {
        this.bonusManager.removeTempBonus(aBonus);
        this.setDirty(true);
    }

    public void removeTempBonusItemList(Equipment aEq) {
        this.getTempBonusItemList().remove(aEq);
        this.setDirty(true);
    }

    public void removeTemplate(PCTemplate inTmpl) {
        this.templateInputFacet.remove(this.id, inTmpl);
        this.setDirty(true);
    }

    private String replaceMasterString(String aString, int aNum) {
        int x;
        while ((x = aString.indexOf("MASTER")) != -1) {
            String leftString = aString.substring(0, x);
            String rightString = aString.substring(x + 6);
            aString = leftString + Integer.toString(aNum) + rightString;
        }
        return aString;
    }

    public PCLevelInfo addLevelInfo(String classKeyName) {
        PCLevelInfo li = new PCLevelInfo(classKeyName);
        this.addLevelInfo(li);
        return li;
    }

    public void addLevelInfo(PCLevelInfo pli) {
        this.levelInfoFacet.add(this.id, pli);
    }

    public void saveStatIncrease(PCStat stat, int mod, boolean isPreMod) {
        int idx = this.getLevelInfoSize() - 1;
        if (idx >= 0) {
            this.levelInfoFacet.get(this.id, idx).addModifiedStat(stat, mod, isPreMod);
        }
        this.setDirty(true);
    }

    public int getStatIncrease(PCStat stat, boolean includePost) {
        int idx = this.getLevelInfoSize() - 1;
        if (idx >= 0) {
            return this.levelInfoFacet.get(this.id, idx).getTotalStatMod(stat, includePost);
        }
        return 0;
    }

    public int sizeInt() {
        return this.sizeFacet.sizeInt(this.id);
    }

    public int totalHitDice() {
        return this.levelFacet.getMonsterLevelCount(this.id);
    }

    public int totalNonMonsterLevels() {
        return this.levelFacet.getNonMonsterLevelCount(this.id);
    }

    public BigDecimal totalValue() {
        BigDecimal totalValue = BigDecimal.ZERO;
        for (Equipment eq : this.getEquipmentMasterList()) {
            totalValue = totalValue.add(eq.getCost(this).multiply(new BigDecimal(eq.qty())));
        }
        return totalValue;
    }

    public void updateEquipSetItem(Equipment oldItem, Equipment newItem) {
        this.equipSetFacet.updateEquipSetItem(this.id, oldItem, newItem);
        this.setDirty(true);
    }

    public boolean isImporting() {
        return this.importing;
    }

    public void giveClassesAway(PCClass toClass, PCClass fromClass, int iCount) {
        PCClassLevel topcl;
        int i;
        if (toClass == null || fromClass == null) {
            return;
        }
        if (toClass.hasMaxLevel() && this.getLevel(toClass) + iCount > toClass.getSafe(IntegerKey.LEVEL_LIMIT)) {
            iCount = toClass.getSafe(IntegerKey.LEVEL_LIMIT) - this.getLevel(toClass);
        }
        if (this.getLevel(fromClass) <= iCount || iCount < 1) {
            return;
        }
        int fromLevel = this.getLevel(fromClass);
        int iFromLevel = fromLevel - iCount;
        int toLevel = this.getLevel(toClass);
        Integer[] hpArray = new Integer[iCount + toLevel];
        for (i = 0; i < iCount; ++i) {
            PCClassLevel frompcl = this.getActiveClassLevel(fromClass, i + iFromLevel);
            hpArray[i] = this.getHP(frompcl);
        }
        for (i = 0; i < toLevel; ++i) {
            topcl = this.getActiveClassLevel(toClass, i);
            hpArray[i + iCount] = this.getHP(topcl);
        }
        for (i = 0; i < iCount; ++i) {
            fromClass.doMinusLevelMods(this, fromLevel - i);
        }
        fromClass.setLevel(iFromLevel, this);
        toClass.setLevel(toLevel + iCount, this);
        for (i = 0; i < iCount + toLevel; ++i) {
            topcl = this.getActiveClassLevel(toClass, i);
            this.setHP(topcl, hpArray[i]);
        }
        for (PCLevelInfo pcl : this.getLevelInfo()) {
            if (!pcl.getClassKeyName().equals(toClass.getKeyName())) continue;
            int iTo = pcl.getClassLevel() + this.getLevel(toClass) - toLevel;
            pcl.setClassLevel(iTo);
        }
        for (PCLevelInfo pcl : this.getLevelInfo()) {
            if (!pcl.getClassKeyName().equals(fromClass.getKeyName()) || pcl.getClassLevel() <= iFromLevel) continue;
            int iFrom = pcl.getClassLevel() - iFromLevel;
            pcl.setClassKeyName(toClass.getKeyName());
            pcl.setClassLevel(iFrom);
        }
    }

    public void addFreeLanguage(Language aLang, CDOMObject source) {
        this.freeLangFacet.add(this.id, aLang, source);
        this.setDirty(true);
    }

    public void removeFreeLanguage(Language aLang, CDOMObject source) {
        this.freeLangFacet.remove(this.id, aLang, source);
        this.setDirty(true);
    }

    public void addAddLanguage(Language aLang, CDOMObject source) {
        this.addLangFacet.add(this.id, aLang, source);
        this.setDirty(true);
    }

    public void removeAddLanguage(Language aLang, CDOMObject source) {
        this.addLangFacet.remove(this.id, aLang, source);
        this.setDirty(true);
    }

    public void addAutoLanguage(Language l, Object obj) {
        this.autoLangListFacet.add(this.id, l, obj);
    }

    public void removeAutoLanguage(Language l, Object obj) {
        this.autoLangListFacet.remove(this.id, l, obj);
    }

    public void validateCharacterDomains() {
        for (Domain d : new ArrayList<Domain>(this.getDomainSet())) {
            if (this.isDomainValid(d, this.getDomainSource(d))) continue;
            this.removeDomain(d);
        }
    }

    private boolean isDomainValid(Domain domain, ClassSource cs) {
        if (domain == null) {
            return false;
        }
        PCClass aClass = this.getClassKeyed(cs.getPcclass().getKeyName());
        return aClass != null && this.getLevel(aClass) >= cs.getLevel();
    }

    public Collection<BonusObj> getActiveBonusList() {
        return this.bonusManager.getActiveBonusList();
    }

    private synchronized void setClassLevelsBrazenlyTo(Map<String, Integer> lvlMap) {
        for (PCClass pcClass : this.getClassSet()) {
            Integer lvl = lvlMap.get(pcClass.getKeyName());
            int setLevel = lvl == null ? 0 : lvl;
            this.setLevelWithoutConsequence(pcClass, setLevel);
        }
        this.calcActiveBonuses();
    }

    private double getEquipmentBonusTo(String aType, String aName) {
        double bonus = 0.0;
        if (!this.hasEquipment()) {
            return bonus;
        }
        aType = aType.toUpperCase();
        aName = aName.toUpperCase();
        for (Equipment eq : this.getEquippedEquipmentSet()) {
            List<BonusObj> tempList = eq.getBonusListOfType(this, aType, aName, true);
            if (eq.isWeapon() && eq.isDouble()) {
                tempList.addAll(eq.getBonusListOfType(this, aType, aName, false));
            }
            bonus += this.calcBonusFromList(tempList, eq);
        }
        return bonus;
    }

    private Map<String, Integer> getCharacterLevelHashMap(int maxCharacterLevel) {
        HashMap<String, Integer> lvlMap = new HashMap<String, Integer>();
        int characterLevels = 0;
        for (int i = 0; i < this.getLevelInfoSize(); ++i) {
            String classKeyName = this.getLevelInfoClassKeyName(i);
            PCClass aClass = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCClass.class, classKeyName);
            if (aClass.isMonster() || characterLevels < maxCharacterLevel) {
                Integer val = (Integer)lvlMap.get(classKeyName);
                Integer newVal = val == null ? Integer.valueOf(1) : val + 1;
                lvlMap.put(classKeyName, newVal);
            }
            if (aClass.isMonster()) continue;
            ++characterLevels;
        }
        return lvlMap;
    }

    public int getNumAttacks() {
        return Math.min(Math.max(this.baseAttackBonus() / 5, 4), 1);
    }

    private double getPObjectWithCostBonusTo(Collection<? extends CDOMObject> aList, String aType, String aName) {
        double iBonus = 0.0;
        if (aList.isEmpty()) {
            return iBonus;
        }
        for (CDOMObject cDOMObject : aList) {
            List<BonusObj> tempList = BonusUtilities.getBonusFromList(cDOMObject.getBonusList(this), aType, aName);
            iBonus += this.calcBonusWithCostFromList(tempList);
        }
        return iBonus;
    }

    private HashMap<String, Integer> getTotalLevelHashMap() {
        HashMap<String, Integer> lvlMap = new HashMap<String, Integer>();
        for (PCClass aClass : this.getClassSet()) {
            lvlMap.put(aClass.getKeyName(), this.getLevel(aClass));
        }
        return lvlMap;
    }

    public String getClassLevelString(String aClassKey, boolean doReplace) {
        int lvl = 0;
        int idx = aClassKey.indexOf(";BEFORELEVEL=");
        if (idx < 0) {
            idx = aClassKey.indexOf(";BEFORELEVEL.");
        }
        if (idx > 0) {
            lvl = Integer.parseInt(aClassKey.substring(idx + 13));
            aClassKey = aClassKey.substring(0, idx);
        }
        if (doReplace) {
            aClassKey = aClassKey.replace('{', '(').replace('}', ')');
        }
        if (aClassKey.startsWith("TYPE=") || aClassKey.startsWith("TYPE.")) {
            int totalLevels = 0;
            String[] classTypes = aClassKey.substring(5).split("\\.");
            for (PCClass cl : this.getClassSet()) {
                for (String type : classTypes) {
                    if (!cl.isType(type)) break;
                    if (lvl > 0) {
                        totalLevels += this.getLevelBefore(cl.getKeyName(), lvl);
                    }
                    totalLevels += this.getLevel(cl);
                }
            }
            return Integer.toString(totalLevels);
        }
        PCClass aClass = this.getClassKeyed(aClassKey);
        if (aClass != null) {
            if (lvl > 0) {
                return Integer.toString(this.getLevelBefore(aClass.getKeyName(), lvl));
            }
            return Integer.toString(this.getLevel(aClass));
        }
        return "0";
    }

    public int getLevelBefore(String classKey, int charLevel) {
        String thisClassKey;
        int lvl = 0;
        for (int idx = 0; idx < charLevel && (thisClassKey = this.getLevelInfoClassKeyName(idx)).length() != 0; ++idx) {
            if (!thisClassKey.equals(classKey)) continue;
            ++lvl;
        }
        return lvl;
    }

    public List<? extends CDOMObject> getCDOMObjectList() {
        SizeAdjustment sa;
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.expandedCampaignFacet.getSet(this.id));
        PCAlignment align = (PCAlignment)((AbstractItemFacet)this.alignmentFacet).get(this.id);
        if (align != null) {
            list.add(align);
        }
        list.add(this.bioSetFacet.get(this.id));
        list.addAll(((AbstractListFacet)this.checkFacet).getSet(this.id));
        list.addAll(this.classFacet.getSet(this.id));
        list.addAll(((AbstractListFacet)this.companionModFacet).getSet(this.id));
        Deity deity = (Deity)((AbstractItemFacet)this.deityFacet).get(this.id);
        if (deity != null) {
            list.add(deity);
        }
        list.addAll(this.domainFacet.getSet(this.id));
        for (Equipment eq : this.activeEquipmentFacet.getSet(this.id)) {
            list.add(eq);
            for (EquipmentModifier eqMod : eq.getEqModifierList(true)) {
                list.add(eqMod);
            }
            for (EquipmentModifier eqMod : eq.getEqModifierList(false)) {
                list.add(eqMod);
            }
        }
        for (AbilityCategory cat : SettingsHandler.getGame().getAllAbilityCategories()) {
            list.addAll(this.getAggregateAbilityListNoDuplicates(cat));
        }
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(this.id);
        if (race != null) {
            list.add(race);
        }
        if ((sa = this.sizeFacet.get(this.id)) != null) {
            list.add(sa);
        }
        list.addAll(this.skillFacet.getSet(this.id));
        list.addAll(((AbstractListFacet)this.statFacet).getSet(this.id));
        list.addAll(this.templateFacet.getSet(this.id));
        for (PCClass cl : this.getClassSet()) {
            for (int i = 1; i <= this.getLevel(cl); ++i) {
                PCClassLevel classLevel = this.getActiveClassLevel(cl, i);
                list.add(classLevel);
            }
        }
        return list;
    }

    public boolean availableSpells(int level, PCClass aClass, String bookName, boolean knownLearned, boolean isSpecialtySpell) {
        int excNon;
        int excSpec;
        int memNon;
        int memSpec;
        int memTot;
        int knownTot;
        int knownSpec;
        int knownNon;
        int i;
        boolean available = false;
        FactKey fk = FactKey.valueOf("SpellType");
        String spelltype = (String)aClass.getResolved(fk);
        boolean isDivine = "Divine".equalsIgnoreCase(spelltype);
        boolean canUseHigher = knownLearned ? this.getUseHigherKnownSlots() : this.getUseHigherPreppedSlots();
        int lowExcSpec = 0;
        int lowExcNon = 0;
        int goodExcSpec = 0;
        int goodExcNon = 0;
        for (i = 0; i < level; ++i) {
            if (knownLearned) {
                knownNon = this.getSpellSupport(aClass).getKnownForLevel(i, bookName, this);
                knownSpec = this.getSpellSupport(aClass).getSpecialtyKnownForLevel(i, this);
                knownTot = knownNon + knownSpec;
            } else {
                knownTot = this.getSpellSupport(aClass).getCastForLevel(i, bookName, true, true, this);
                knownNon = this.getSpellSupport(aClass).getCastForLevel(i, bookName, false, true, this);
                knownSpec = knownTot - knownNon;
            }
            memTot = SpellCountCalc.memorizedSpellForLevelBook(this, aClass, i, bookName);
            memSpec = SpellCountCalc.memorizedSpecialtiesForLevelBook(i, bookName, this, aClass);
            memNon = memTot - memSpec;
            excSpec = knownSpec - memSpec;
            for (excNon = knownNon - memNon; excNon > 0 && lowExcNon < 0; --excNon, ++lowExcNon) {
            }
            while (excSpec > 0 && lowExcSpec < 0) {
                --excSpec;
                ++lowExcSpec;
            }
            if (!isDivine || knownLearned) {
                while (excNon > 0 && lowExcSpec < 0) {
                    --excNon;
                    ++lowExcSpec;
                }
                while (excNon > 0 && excSpec < 0) {
                    --excNon;
                    ++excSpec;
                }
            }
            if (excSpec < 0) {
                lowExcSpec += excSpec;
            }
            if (excNon >= 0) continue;
            lowExcNon += excNon;
        }
        for (i = level; i <= 25; ++i) {
            if (knownLearned) {
                knownNon = this.getSpellSupport(aClass).getKnownForLevel(i, bookName, this);
                knownSpec = this.getSpellSupport(aClass).getSpecialtyKnownForLevel(i, this);
                knownTot = knownNon + knownSpec;
            } else {
                knownTot = this.getSpellSupport(aClass).getCastForLevel(i, bookName, true, true, this);
                knownNon = this.getSpellSupport(aClass).getCastForLevel(i, bookName, false, true, this);
                knownSpec = knownTot - knownNon;
            }
            if (!canUseHigher && i > level) break;
            memTot = SpellCountCalc.memorizedSpellForLevelBook(this, aClass, i, bookName);
            memSpec = SpellCountCalc.memorizedSpecialtiesForLevelBook(i, bookName, this, aClass);
            memNon = memTot - memSpec;
            excSpec = knownSpec - memSpec;
            for (excNon = knownNon - memNon; excNon > 0 && lowExcNon < 0; --excNon, ++lowExcNon) {
            }
            while (excNon > 0 && goodExcNon < 0) {
                --excNon;
                ++goodExcNon;
            }
            while (excSpec > 0 && lowExcSpec < 0) {
                --excSpec;
                ++lowExcSpec;
            }
            while (excSpec > 0 && goodExcSpec < 0) {
                --excSpec;
                ++goodExcSpec;
            }
            if (!isDivine) {
                while (excNon > 0 && lowExcSpec < 0) {
                    --excNon;
                    ++lowExcSpec;
                }
                while (excNon > 0 && goodExcSpec < 0) {
                    --excNon;
                    ++goodExcSpec;
                }
                while (excNon > 0 && excSpec < 0) {
                    --excNon;
                    ++excSpec;
                }
            }
            if (!isSpecialtySpell && excNon > 0 && excNon + excSpec > 0) {
                available = true;
            }
            if (isDivine) {
                if (isSpecialtySpell && excSpec > 0) {
                    available = true;
                }
            } else if (isSpecialtySpell && excNon + excSpec > 0) {
                available = true;
            }
            if (available) break;
            if (excSpec < 0) {
                goodExcSpec += excSpec;
            }
            if (excNon >= 0) continue;
            goodExcNon += excNon;
        }
        return available;
    }

    private double calcBonusWithCostFromList(List<BonusObj> aList) {
        return this.bonusManager.calcBonusesWithCost(aList);
    }

    private int calculateSaveBonusRace(PCCheck check) {
        String sString = check.toString();
        Race race = this.getRace();
        int save = (int)BonusCalc.charBonusTo(race, "CHECKS", "BASE." + sString, this);
        save += (int)BonusCalc.charBonusTo(race, "CHECKS", sString, this);
        save += (int)BonusCalc.charBonusTo(race, "SAVE", "BASE." + sString, this);
        return save += (int)BonusCalc.charBonusTo(race, "SAVE", sString, this);
    }

    public int countSpellsInBook(String aString) {
        PObject aObject;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int sbookNum = Integer.parseInt(aTok.nextToken());
        if (sbookNum >= this.getSpellBookCount()) {
            return 0;
        }
        int levelNum = aTok.hasMoreTokens() ? Integer.parseInt(aTok.nextToken()) : -1;
        String bookName = Globals.getDefaultSpellBook();
        if (sbookNum > 0) {
            bookName = this.getSpellBookNames().get(sbookNum);
        }
        if ((aObject = this.getSpellClassAtIndex(classNum)) != null) {
            List<CharacterSpell> aList = this.getCharacterSpells(aObject, null, bookName, levelNum);
            return aList.size();
        }
        return 0;
    }

    public SizeAdjustment getSizeAdjustment() {
        return this.sizeFacet.get(this.id);
    }

    public int getSpellClassCount() {
        return this.getSpellClassList().size();
    }

    public List<? extends PObject> getSpellClassList() {
        ArrayList<PObject> aList = new ArrayList<PObject>();
        Race race = this.getRace();
        if (!this.getCharacterSpells(race).isEmpty()) {
            aList.add(race);
        }
        for (PCClass pcClass : this.getClassSet()) {
            if (pcClass.get(FactKey.valueOf("SpellType")) == null) continue;
            aList.add(pcClass);
        }
        return aList;
    }

    public boolean includeSkill(Skill skill, SkillFilter filter) {
        if (skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue() && !this.isClassSkill(skill) && !this.isCrossClassSkill(skill)) {
            return false;
        }
        if (filter == SkillFilter.Ranks) {
            return SkillRankControl.getTotalRank(this, skill).floatValue() > 0.0f;
        }
        if (filter == SkillFilter.NonDefault) {
            return SkillRankControl.getTotalRank(this, skill).floatValue() > 0.0f || (double)SkillModifier.modifier(skill, this).intValue() != (double)SkillModifier.getStatMod(skill, this) + this.getSizeAdjustmentBonusTo("SKILL", skill.getKeyName());
        }
        if (filter == SkillFilter.Usable) {
            return this.qualifySkill(skill) && (SkillRankControl.getTotalRank(this, skill).floatValue() > 0.0f || skill.getSafe(ObjectKey.USE_UNTRAINED) != false);
        }
        return this.qualifySkill(skill);
    }

    private boolean qualifySkill(Skill skill) {
        return skill.qualifies(this, skill);
    }

    public void incrementClassLevel(int numberOfLevels, PCClass globalClass, boolean bSilent) {
        this.incrementClassLevel(numberOfLevels, globalClass, bSilent, false);
    }

    public void incrementClassLevel(int numberOfLevels, PCClass globalClass, boolean bSilent, boolean bypassPrereqs) {
        PCClass pcClassClone;
        if (!this.isImporting()) {
            this.getSpellList();
        }
        if (numberOfLevels > 0) {
            if (!bypassPrereqs && !globalClass.qualifies(this, globalClass)) {
                return;
            }
            Race race = this.getRace();
            if (globalClass.isMonster() && !SettingsHandler.isIgnoreMonsterHDCap() && !race.isAdvancementUnlimited() && this.totalHitDice() + numberOfLevels > race.maxHitDiceAdvancement() && !bSilent) {
                ShowMessageDelegate.showMessageDialog("Cannot increase Monster Hit Dice for this character beyond " + race.maxHitDiceAdvancement() + ". This character's current number of Monster Hit Dice is " + this.totalHitDice(), "PCGen", MessageType.INFORMATION);
                return;
            }
        }
        if ((pcClassClone = this.getClassKeyed(globalClass.getKeyName())) == null) {
            if (numberOfLevels >= 0) {
                pcClassClone = globalClass.clone();
                if (pcClassClone == null) {
                    Logging.errorPrint("PlayerCharacter::incrementClassLevel => Clone of class " + globalClass.getKeyName() + " failed!");
                    return;
                }
                if (!this.isImporting() && this.classFacet.isEmpty(this.id)) {
                    this.adjustAbilities(AbilityCategory.FEAT, new BigDecimal(pcClassClone.getSafe(IntegerKey.START_FEATS)));
                }
                this.classFacet.addClass(this.id, pcClassClone);
            } else {
                return;
            }
        }
        if (numberOfLevels > 0) {
            for (int i = 0; i < numberOfLevels; ++i) {
                int currentLevel = this.getLevel(pcClassClone);
                PCLevelInfo playerCharacterLevelInfo = this.addLevelInfo(pcClassClone.getKeyName());
                if (pcClassClone.addLevel(false, bSilent, this, bypassPrereqs)) continue;
                PCClassLevel failedpcl = this.getActiveClassLevel(pcClassClone, currentLevel + 1);
                this.removeLevelInfo(pcClassClone.getKeyName());
                return;
            }
        } else if (numberOfLevels < 0) {
            for (int i = 0; i < -numberOfLevels; ++i) {
                int currentLevel = this.getLevel(pcClassClone);
                pcClassClone.subLevel(this);
                PCLevelInfo removedLI = this.removeLevelInfo(pcClassClone.getKeyName());
                int pointsToRemove = removedLI.getSkillPointsGained(this) - removedLI.getSkillPointsRemaining();
                SkillRankControl.removeSkillsForTopLevel(this, pcClassClone, currentLevel, pointsToRemove);
            }
        }
        this.calcActiveBonuses();
    }

    private PCLevelInfo removeLevelInfo(String classKeyName) {
        for (int idx = this.getLevelInfoSize() - 1; idx >= 0; --idx) {
            PCLevelInfo li = this.levelInfoFacet.get(this.id, idx);
            if (!li.getClassKeyName().equals(classKeyName)) continue;
            this.levelInfoFacet.remove(this.id, li);
            this.setDirty(true);
            return li;
        }
        return null;
    }

    public void rollStats(int method) {
        int aMethod = method;
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            aMethod = 2;
        }
        this.rollStats(aMethod, ((AbstractListFacet)this.statFacet).getSet(this.id), SettingsHandler.getGame().getCurrentRollingMethod(), false);
    }

    public void rollStats(int method, Collection<PCStat> aStatList, RollMethod rollMethod, boolean aSortedFlag) {
        int i;
        int[] rolls = new int[aStatList.size()];
        block5: for (i = 0; i < rolls.length; ++i) {
            switch (method) {
                case 2: {
                    rolls[i] = SettingsHandler.getGame().getPurchaseModeBaseStatScore(this);
                    continue block5;
                }
                case 1: {
                    rolls[i] = SettingsHandler.getGame().getAllStatsValue();
                    continue block5;
                }
                case 3: {
                    String diceExpression = rollMethod.getMethodRoll();
                    rolls[i] = RollingMethods.roll(diceExpression);
                    continue block5;
                }
                default: {
                    rolls[i] = 0;
                }
            }
        }
        if (aSortedFlag) {
            Arrays.sort(rolls);
        }
        i = rolls.length - 1;
        for (PCStat currentStat : aStatList) {
            int roll;
            this.setStat(currentStat, 0);
            if (!currentStat.getSafe(ObjectKey.ROLLED).booleanValue()) continue;
            if ((roll = rolls[i--] + this.getStat(currentStat)) < currentStat.getSafe(IntegerKey.MIN_VALUE)) {
                roll = currentStat.getSafe(IntegerKey.MIN_VALUE);
            }
            if (roll > currentStat.getSafe(IntegerKey.MAX_VALUE)) {
                roll = currentStat.getSafe(IntegerKey.MAX_VALUE);
            }
            this.setStat(currentStat, roll);
        }
        if (method != 2) {
            this.setPoolAmount(0);
            this.costPool = 0;
        }
        if (method != 2) {
            this.setPoolAmount(0);
        }
    }

    private List<Equipment> sortEquipmentList(Collection<Equipment> unsortedEquip, int merge) {
        if (unsortedEquip.isEmpty()) {
            return new ArrayList<Equipment>();
        }
        List<Equipment> sortedList = CoreUtility.mergeEquipmentList(unsortedEquip, merge);
        Iterator<Equipment> i = sortedList.iterator();
        while (i.hasNext()) {
            Equipment item = i.next();
            if (item.getOutputIndex() != -1) continue;
            i.remove();
        }
        return sortedList;
    }

    private void setDescriptionLst(String descriptionLst) {
        this.descriptionLst = descriptionLst;
    }

    public void preparePCForOutput() {
        this.setCalcEquipmentList(this.getUseTempMods());
        this.getSpellList();
        this.calcActiveBonuses();
        SkillDisplay.resortSelected(this, this.getSkillsOutputOrder());
        this.determinePrimaryOffWeapon();
        this.modFromArmorOnWeaponRolls();
        this.adjustMoveRates();
        this.calcActiveBonuses();
    }

    public int getCharacterLevel(PCLevelInfo info) {
        int i = 1;
        for (PCLevelInfo element : this.getLevelInfo()) {
            if (info == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Set<Language> getLanguageBonusSelectionList() {
        return this.startingLangFacet.getSet(this.id);
    }

    public int getPartialStatFor(PCStat stat, boolean useTemp, boolean useEquip) {
        int partialStatBonus = this.bonusManager.getPartialStatBonusFor(stat, useTemp, useEquip);
        return this.statCalcFacet.getPartialStatFor(this.id, stat, partialStatBonus);
    }

    public int getPartialStatAtLevel(PCStat stat, int level, boolean usePost, boolean useTemp, boolean useEquip) {
        int curStat = StatAnalysis.getPartialStatFor(this, stat, useTemp, useEquip);
        for (int idx = this.getLevelInfoSize() - 1; idx >= level; --idx) {
            int statLvlAdjust = this.levelInfoFacet.get(this.id, idx).getTotalStatMod(stat, usePost);
            curStat -= statLvlAdjust;
        }
        return curStat;
    }

    public PlayerCharacter clone() {
        PlayerCharacter aClone = null;
        aClone = new PlayerCharacter(true, this.campaignFacet.getSet(this.id));
        try {
            aClone.assocSupt = this.assocSupt.clone();
        }
        catch (CloneNotSupportedException e) {
            Logging.errorPrint("PlayerCharacter.clone failed", e);
        }
        Collection<AbstractStorageFacet> beans = SpringHelper.getStorageBeans();
        for (AbstractStorageFacet bean : beans) {
            bean.copyContents(this.id, aClone.id);
        }
        aClone.bonusManager = this.bonusManager.buildDeepClone(aClone);
        for (PCClass cloneClass : aClone.classFacet.getSet(aClone.id)) {
            cloneClass.addFeatPoolBonus(aClone);
        }
        Follower followerMaster = (Follower)this.masterFacet.get(this.id);
        if (followerMaster != null) {
            aClone.masterFacet.set(this.id, followerMaster.clone());
        } else {
            aClone.masterFacet.remove(this.id);
        }
        aClone.equipSetFacet.removeAll(aClone.id);
        for (EquipSet eqSet : this.equipSetFacet.getSet(this.id)) {
            aClone.addEquipSet((EquipSet)eqSet.clone());
        }
        List<Equipment> equipmentMasterList = aClone.getEquipmentMasterList();
        aClone.userEquipmentFacet.removeAll(aClone.id);
        aClone.equipmentFacet.removeAll(aClone.id);
        aClone.equippedFacet.removeAll(aClone.id);
        FacetLibrary.getFacet(SourcedEquipmentFacet.class).removeAll(aClone.id);
        for (Equipment equip : equipmentMasterList) {
            aClone.addEquipment(equip.clone());
        }
        aClone.levelInfoFacet.removeAll(aClone.id);
        for (PCLevelInfo info : this.getLevelInfo()) {
            PCLevelInfo newLvlInfo = info.clone();
            aClone.levelInfoFacet.add(aClone.id, newLvlInfo);
        }
        aClone.spellBookFacet.removeAll(aClone.id);
        for (String book : this.spellBookFacet.getBookNames(this.id)) {
            aClone.addSpellBook((SpellBook)this.spellBookFacet.getBookNamed(this.id, book).clone());
        }
        aClone.calcEquipSetId = this.calcEquipSetId;
        aClone.tempBonusItemList.addAll(this.tempBonusItemList);
        aClone.setDescriptionLst(this.getDescriptionLst());
        aClone.autoKnownSpells = this.autoKnownSpells;
        aClone.autoLoadCompanion = this.autoLoadCompanion;
        aClone.autoSortGear = this.autoSortGear;
        aClone.outputSheetHTML = this.outputSheetHTML;
        aClone.outputSheetPDF = this.outputSheetPDF;
        aClone.ageSetKitSelections = new boolean[10];
        aClone.defaultDomainSource = this.defaultDomainSource;
        System.arraycopy(this.ageSetKitSelections, 0, aClone.ageSetKitSelections, 0, this.ageSetKitSelections.length);
        aClone.displayUpdate = this.displayUpdate;
        aClone.setImporting(false);
        aClone.useTempMods = this.useTempMods;
        aClone.costPool = this.costPool;
        aClone.currentEquipSetNumber = this.currentEquipSetNumber;
        aClone.poolAmount = this.poolAmount;
        aClone.skillsOutputOrder = this.skillsOutputOrder;
        aClone.spellLevelTemp = this.spellLevelTemp;
        aClone.pointBuyPoints = this.pointBuyPoints;
        aClone.adjustMoveRates();
        aClone.calcActiveBonuses();
        aClone.equippedFacet.reset(aClone.id);
        aClone.serial = this.serial;
        return aClone;
    }

    public void setStringFor(PCStringKey key, String s) {
        String currValue = this.factFacet.get(this.id, key);
        if (currValue == null && s != null || currValue != null && !currValue.equals(s)) {
            this.factFacet.set(this.id, key, s);
            this.setDirty(true);
        }
    }

    private Float getEquippedQty(EquipSet eSet, Equipment eqI) {
        return this.equipSetFacet.getEquippedQuantity(this.id, eSet, eqI);
    }

    private String getSingleLocation(Equipment eqI) {
        String loc = this.getNaturalWeaponLocation(eqI);
        if (loc != null) {
            return loc;
        }
        if (eqI.isWeapon() && !eqI.isArmor()) {
            return "";
        }
        List<EquipSlot> eqSlotList = SystemCollections.getUnmodifiableEquipSlotList();
        if (eqSlotList == null || eqSlotList.isEmpty()) {
            return "";
        }
        for (EquipSlot es : eqSlotList) {
            if (!es.canContainType(eqI.getType())) continue;
            return es.getSlotName();
        }
        return "";
    }

    public String getNaturalWeaponLocation(Equipment eqI) {
        if (eqI.isNatural() && eqI.getSlots(this) == 0) {
            if (eqI.isPrimaryNaturalWeapon()) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        return null;
    }

    private boolean canEquipItem(EquipSet eSet, String locName, Equipment eqI, Equipment eqTarget) {
        String abID;
        String esID;
        String idPath = eSet.getIdPath();
        if (eqTarget != null && eqTarget.isContainer()) {
            return true;
        }
        if (locName.startsWith("Carried") || locName.startsWith("Equipped") || locName.startsWith("Not Carried")) {
            return true;
        }
        if (eqI.isUnarmed()) {
            return true;
        }
        if (locName.equals("Natural-Secondary")) {
            return true;
        }
        if (eqI.isWeapon() && eqI.isWeaponOutsizedForPC(this) && !eqI.isNatural()) {
            return false;
        }
        HashMap<String, String> slotMap = new HashMap<String, String>();
        for (EquipSet es : this.getEquipSet()) {
            esID = es.getParentIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".") || !es.getName().equals(locName)) continue;
            Equipment eItem = es.getItem();
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            if (eItem != null) {
                existNum += eItem.getSlots(this);
            }
            slotMap.put(locName, String.valueOf(existNum));
        }
        for (EquipSet es : this.getEquipSet()) {
            esID = es.getParentIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".")) continue;
            if (eqI.isWeapon() && !eqI.isNatural()) {
                if (es.getName().equals(locName)) {
                    return false;
                }
                if ((locName.equals("Both Hands") || locName.equals("Double Weapon")) && (es.getName().equals("Primary Hand") || es.getName().equals("Secondary Hand") || es.getName().equals("Both Hands") || es.getName().equals("Double Weapon"))) {
                    return false;
                }
                if ((locName.equals("Primary Hand") || locName.equals("Secondary Hand")) && (es.getName().equals("Both Hands") || es.getName().equals("Double Weapon"))) {
                    return false;
                }
            }
            if (!es.getName().equals(locName)) continue;
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            existNum += eqI.getSlots(this);
            EquipSlot eSlot = Globals.getEquipSlotByName(locName);
            if (eSlot == null) {
                return true;
            }
            for (String slotType : eSlot.getContainType()) {
                if (!eqI.isType(slotType) || existNum <= eSlot.getSlotCount() + (int)this.getTotalBonusTo("SLOTS", slotType)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public EquipSet getEquipSetForItem(EquipSet eSet, Equipment eqI) {
        String rPath = eSet.getIdPath();
        for (EquipSet es : this.getEquipSet()) {
            String rIdPath;
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(rIdPath = rPath + ".") || !eqI.getName().equals(es.getValue())) continue;
            return es;
        }
        return null;
    }

    private String getNewIdPath(EquipSet eSet) {
        String pid = "0";
        if (eSet != null) {
            pid = eSet.getIdPath();
        }
        int newID = this.getNewChildId(pid);
        return pid + "." + newID;
    }

    public int getNewChildId(String pid) {
        int newID = 0;
        for (EquipSet es : this.getEquipSet()) {
            if (!es.getParentIdPath().equals(pid) || es.getId() <= newID) continue;
            newID = es.getId();
        }
        return ++newID;
    }

    public EquipSet addEquipToTarget(EquipSet eSet, Equipment eqTarget, String locName, Equipment eqI, Float newQty) {
        String singleLoc;
        float tempQty = 1.0f;
        if (newQty != null) {
            tempQty = newQty.floatValue();
        } else {
            newQty = Float.valueOf(tempQty);
        }
        boolean addAll = false;
        boolean mergeItem = false;
        Equipment masterEq = this.getEquipmentNamed(eqI.getName());
        if (masterEq == null) {
            return null;
        }
        float diffQty = masterEq.getQty().floatValue() - this.getEquippedQty(eSet, eqI).floatValue();
        if (newQty.floatValue() < 0.0f) {
            tempQty = diffQty;
            newQty = new Float(tempQty + this.getEquippedQty(eSet, eqI).floatValue());
            addAll = true;
        }
        if (tempQty > diffQty) {
            return null;
        }
        if (eqTarget != null && eqTarget.isContainer()) {
            eqI.setQty(newQty);
            eqI.setNumberCarried(newQty);
            if (eqTarget.canContain(this, eqI) == 1) {
                locName = eqTarget.getName();
                addAll = true;
                mergeItem = true;
            } else {
                return null;
            }
        }
        if (locName == null || locName.length() == 0) {
            locName = this.getSingleLocation(eqI);
            if (locName.length() == 0) {
                return null;
            }
        } else if (locName.equalsIgnoreCase("Equipped") && (singleLoc = this.getSingleLocation(eqI)).length() > 0) {
            locName = singleLoc;
        }
        if (!this.canEquipItem(eSet, locName, eqI, eqTarget)) {
            return null;
        }
        if (eqI.isContainer()) {
            mergeItem = false;
        }
        EquipSet existingSet = this.getEquipSetForItem(eSet, eqI);
        if (addAll && mergeItem && existingSet != null) {
            newQty = new Float(tempQty + this.getEquippedQty(eSet, eqI).floatValue());
            existingSet.setQty(newQty);
            eqI.setQty(newQty);
            eqI.setNumberCarried(newQty);
            this.setDirty(true);
            if (eqTarget != null && eqTarget.isContainer()) {
                eqTarget.updateContainerContentsString(this);
            }
            return existingSet;
        }
        if (eqTarget != null && eqTarget.isContainer()) {
            eqTarget.insertChild(this, eqI);
            eqI.setParent(eqTarget);
        }
        String id = this.getNewIdPath(eSet);
        EquipSet newSet = new EquipSet(id, locName, eqI.getName(), eqI);
        eqI.setQty(newQty);
        newSet.setQty(newQty);
        this.addEquipSet(newSet);
        this.setDirty(true);
        return newSet;
    }

    public void moveEquipSetToNewPath(EquipSet es) {
        String parentPath = es.getParentIdPath();
        EquipSet parent = this.getEquipSetByIdPath(parentPath);
        String newPath = this.getNewIdPath(parent);
        es.setIdPath(newPath);
    }

    public String getSafeStringFor(PCStringKey key) {
        String s = this.factFacet.get(this.id, key);
        if (s == null) {
            s = "";
        }
        return s;
    }

    public void setDoLevelAbilities(boolean yesNo) {
        this.processLevelAbilities = yesNo;
    }

    public boolean doLevelAbilities() {
        return this.processLevelAbilities;
    }

    public void adjustAbilities(Category<Ability> aCategory, BigDecimal arg) {
        BigDecimal userMods;
        if (arg.equals(BigDecimal.ZERO)) {
            return;
        }
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<Category<Ability>, BigDecimal>();
        }
        userMods = (userMods = this.theUserPoolBonuses.get(aCategory)) != null ? userMods.add(arg) : arg;
        this.theUserPoolBonuses.put(aCategory, userMods);
        this.setDirty(true);
    }

    public void setUserPoolBonus(AbilityCategory aCategory, BigDecimal anAmount) {
        if (this.theUserPoolBonuses == null) {
            this.theUserPoolBonuses = new HashMap<Category<Ability>, BigDecimal>();
        }
        this.theUserPoolBonuses.put(aCategory, anAmount);
    }

    public double getUserPoolBonus(AbilityCategory aCategory) {
        BigDecimal userBonus = null;
        if (this.theUserPoolBonuses != null) {
            userBonus = this.theUserPoolBonuses.get(aCategory);
        }
        if (userBonus == null) {
            return 0.0;
        }
        return userBonus.doubleValue();
    }

    public BigDecimal getTotalAbilityPool(AbilityCategory aCategory) {
        Number basePool = this.getBasePool(aCategory);
        double bonus = AbilityCategory.FEAT.equals(aCategory) ? this.getBonusFeatPool() : this.getTotalBonusTo("ABILITYPOOL", aCategory.getKeyName());
        if (!aCategory.allowFractionalPool()) {
            bonus = Math.floor(bonus);
        }
        double userBonus = this.getUserPoolBonus(aCategory);
        return BigDecimal.valueOf((double)basePool.floatValue() + bonus + userBonus);
    }

    private Number getBasePool(AbilityCategory aCategory) {
        Number basePool = aCategory.getPoolFormula().resolve(this, this.getClass().toString());
        if (!aCategory.allowFractionalPool()) {
            basePool = new Float(basePool.intValue());
        }
        return basePool;
    }

    public double getRemainingFeatPoolPoints() {
        if (Globals.getGameModeHasPointPool()) {
            return this.getSkillPoints();
        }
        return this.getRemainingFeatPoints(true);
    }

    public BigDecimal getAvailableAbilityPool(AbilityCategory aCategory) {
        return this.getTotalAbilityPool(aCategory).subtract(this.getAbilityPoolSpent(aCategory));
    }

    public double getRemainingFeatPoints(boolean bIncludeBonus) {
        if (bIncludeBonus) {
            return this.getAvailableAbilityPool(AbilityCategory.FEAT).doubleValue();
        }
        return this.getUserPoolBonus(AbilityCategory.FEAT);
    }

    public BigDecimal getAbilityPoolSpent(AbilityCategory aCategory) {
        double spent = 0.0;
        Collection<CNAbility> abilities = this.getPoolAbilities(aCategory, Nature.NORMAL);
        if (abilities != null) {
            for (CNAbility cna : abilities) {
                Ability ability = cna.getAbility();
                int subfeatCount = this.getSelectCorrectedAssociationCount(cna);
                double cost = ability.getSafe(ObjectKey.SELECTION_COST).doubleValue();
                if (ChooseActivation.hasNewChooseToken(ability)) {
                    spent += Math.ceil((double)subfeatCount * cost);
                    continue;
                }
                int select = ability.getSafe(FormulaKey.SELECT).resolve(this, "").intValue();
                double relativeCost = cost / (double)select;
                if (!aCategory.allowFractionalPool()) {
                    spent += (double)((int)Math.ceil(relativeCost));
                    continue;
                }
                spent += relativeCost;
            }
        }
        if (!aCategory.allowFractionalPool()) {
            return BigDecimal.valueOf((int)Math.ceil(spent));
        }
        return BigDecimal.valueOf(spent);
    }

    public Ability getAbilityKeyed(AbilityCategory aCategory, String aKey) {
        for (Ability ability : this.getAbilityList(aCategory, Nature.NORMAL)) {
            if (!ability.getKeyName().equals(aKey)) continue;
            return ability;
        }
        for (Ability ability : this.getAbilityList(aCategory, Nature.VIRTUAL)) {
            if (!ability.getKeyName().equals(aKey)) continue;
            return ability;
        }
        for (Ability ability : this.getAbilityList(aCategory, Nature.AUTOMATIC)) {
            if (!ability.getKeyName().equals(aKey)) continue;
            return ability;
        }
        return null;
    }

    public boolean hasAbilityKeyed(Category<Ability> cat, String aKey) {
        return this.grantedAbilityFacet.hasAbilityKeyed(this.id, cat, aKey);
    }

    public List<Ability> getAggregateAbilityListNoDuplicates(AbilityCategory aCategory) {
        ArrayList<Ability> aggregate = new ArrayList<Ability>();
        HashMap<String, Ability> aHashMap = new HashMap<String, Ability>();
        for (Ability aFeat : this.getAbilityList(aCategory, Nature.NORMAL)) {
            if (aFeat == null) continue;
            aHashMap.put(aFeat.getKeyName(), aFeat);
        }
        this.addUniqueAbilitiesToMap(aHashMap, this.getAbilityList(aCategory, Nature.VIRTUAL));
        this.addUniqueAbilitiesToMap(aHashMap, this.getAbilityList(aCategory, Nature.AUTOMATIC));
        aggregate.addAll(aHashMap.values());
        return aggregate;
    }

    private void addUniqueAbilitiesToMap(Map<String, Ability> aHashMap, Collection<Ability> abilityList) {
        for (Ability vFeat : abilityList) {
            if (aHashMap.containsKey(vFeat.getKeyName())) continue;
            aHashMap.put(vFeat.getKeyName(), vFeat);
        }
    }

    public boolean hasAbilityVisibleTo(AbilityCategory aCategory, View view) {
        return this.grantedAbilityFacet.hasAbilityVisibleTo(this.id, aCategory, view);
    }

    private void processAbilityListsOnAdd(CDOMObject cdo, CDOMReference<? extends CDOMList<?>> ref) {
        for (CDOMList<?> list : ref.getContainedObjects()) {
            if (!(list instanceof AbilityList)) continue;
            CDOMReference<CDOMList<?>> r = ref;
            this.processAbilityList(cdo, r);
            break;
        }
    }

    private void processAbilityList(CDOMObject cdo, CDOMReference<AbilityList> ref) {
        Collection mods = cdo.getListMods(ref);
        for (CDOMReference objref : mods) {
            Collection objs = objref.getContainedObjects();
            Collection<AssociatedPrereqObject> assoc = cdo.getListAssociations(ref, objref);
            for (Ability ab : objs) {
                if (ab == null) {
                    Logging.log(Logging.LST_ERROR, "Missing object referenced in the ability list for '" + cdo + "' list is " + ref + ". Source " + cdo.getSourceURI());
                    continue;
                }
                for (AssociatedPrereqObject apo : assoc) {
                    Nature nature = apo.getAssociation(AssociationKey.NATURE);
                    CDOMSingleRef<AbilityCategory> acRef = apo.getAssociation(AssociationKey.CATEGORY);
                    AbilityCategory cat = acRef.resolvesTo();
                    if (ab.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                        List<String> choices = apo.getAssociation(AssociationKey.ASSOC_CHOICES);
                        if (choices == null) {
                            CNAbilitySelection cas = new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ab), "");
                            cas.addAllPrerequisites(apo.getPrerequisiteList());
                            this.applyAbility(cas, cdo);
                            continue;
                        }
                        for (String choice : choices) {
                            CNAbilitySelection cas = new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ab), choice);
                            cas.addAllPrerequisites(apo.getPrerequisiteList());
                            this.applyAbility(cas, cdo);
                        }
                        continue;
                    }
                    CNAbilitySelection cas = new CNAbilitySelection(CNAbilityFactory.getCNAbility(cat, nature, ab));
                    cas.addAllPrerequisites(apo.getPrerequisiteList());
                    this.applyAbility(cas, cdo);
                }
            }
        }
        this.cabFacet.update(this.id);
    }

    public void applyAbility(CNAbilitySelection cas, Object source) {
        if (cas.hasPrerequisites()) {
            this.conditionalFacet.add(this.id, cas, source);
        } else {
            this.directAbilityFacet.add(this.id, cas, source);
        }
    }

    private void addTemplatesIfMissing(Collection<PCTemplate> templateList) {
        for (PCTemplate pct : templateList) {
            this.addTemplate(pct);
        }
    }

    public boolean hasSpellInSpellbook(Spell spell, String spellbookname) {
        for (CDOMObject cDOMObject : this.getCDOMObjectList()) {
            List<CharacterSpell> csl = this.getCharacterSpells(cDOMObject, spell, spellbookname, -1);
            if (csl == null || csl.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void resetEpicCache() {
        this.epicBAB = null;
        this.epicCheckMap.clear();
    }

    public int getCritRange(Equipment e, boolean primary) {
        if (!primary && !e.isDouble()) {
            return 0;
        }
        int raw = e.getRawCritRange(primary);
        int add = (int)e.bonusTo(this, "EQMWEAPON", "CRITRANGEADD", primary);
        int dbl = 1 + (int)e.bonusTo(this, "EQMWEAPON", "CRITRANGEDOUBLE", primary);
        return raw * dbl + add;
    }

    public Collection<PCTemplate> getTemplatesAdded(CDOMObject po) {
        return this.addedTemplateFacet.getFromSource(this.id, po);
    }

    public void setTemplatesAdded(CDOMObject po, PCTemplate pct) {
        this.addedTemplateFacet.add(this.id, pct, po);
    }

    public boolean isClassSkill(Skill sk) {
        for (PCClass cl : this.getClassSet()) {
            if (!this.isClassSkill(cl, sk)) continue;
            return true;
        }
        return false;
    }

    private boolean isCrossClassSkill(Skill sk, PCClass pcc) {
        PCClass cl = this.getClassKeyed(pcc.getKeyName());
        if (cl == null) {
            return false;
        }
        return this.skillCostFacet.isCrossClassSkill(this.id, pcc, sk);
    }

    private boolean isCrossClassSkill(Skill sk) {
        for (PCClass cl : this.getClassSet()) {
            if (!this.isCrossClassSkill(sk, cl)) continue;
            return true;
        }
        return false;
    }

    public SkillCost getSkillCostForClass(Skill sk, PCClass cl) {
        if (cl == null) {
            return sk.getSafe(ObjectKey.EXCLUSIVE) != false ? SkillCost.EXCLUSIVE : SkillCost.CROSS_CLASS;
        }
        if ((cl = this.getClassKeyed(cl.getKeyName())) == null) {
            return sk.getSafe(ObjectKey.EXCLUSIVE) != false ? SkillCost.EXCLUSIVE : SkillCost.CROSS_CLASS;
        }
        return this.skillCostFacet.skillCostForPCClass(this.id, sk, cl);
    }

    public boolean containsAssociated(ChooseDriver obj, String o) {
        ChooseInformation<?> info = obj.getChooseInfo();
        return info != null && this.containsAssociated(obj, info, o);
    }

    private <T> boolean containsAssociated(ChooseDriver obj, ChooseInformation<T> info, String o) {
        List<T> selections = info.getChoiceActor().getCurrentlySelected(obj, this);
        if (selections == null || selections.isEmpty()) {
            return false;
        }
        for (T sel : selections) {
            if (!o.equalsIgnoreCase(info.encodeChoice(sel))) continue;
            return true;
        }
        return false;
    }

    public int getSelectCorrectedAssociationCount(ChooseDriver obj) {
        return this.getDetailedAssociationCount(obj) / obj.getSelectFormula().resolve(this, "").intValue();
    }

    public List<String> getAssociationList(ChooseDriver obj) {
        ChooseInformation<?> info = obj.getChooseInfo();
        if (info == null) {
            return Collections.emptyList();
        }
        return this.getExpandedAssociations(obj, info);
    }

    public List<String> getAssociationExportList(ChooseDriver obj) {
        ChooseInformation<?> info = obj.getChooseInfo();
        if (info == null) {
            return Collections.emptyList();
        }
        return this.getExportAssociations(obj, info);
    }

    public boolean hasAssociations(ChooseDriver obj) {
        ChooseInformation<?> info = obj.getChooseInfo();
        if (info == null) {
            return false;
        }
        List<?> selections = info.getChoiceActor().getCurrentlySelected(obj, this);
        return selections != null && !selections.isEmpty();
    }

    public int getDetailedAssociationCount(ChooseDriver obj) {
        ChooseInformation<?> info = obj.getChooseInfo();
        if (info == null) {
            return 0;
        }
        List<?> selections = info.getChoiceActor().getCurrentlySelected(obj, this);
        if (selections == null || selections.isEmpty()) {
            return 0;
        }
        return selections.size();
    }

    private <T> List<String> getExpandedAssociations(ChooseDriver obj, ChooseInformation<T> info) {
        List<T> selections = info.getChoiceActor().getCurrentlySelected(obj, this);
        if (selections == null || selections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(selections.size());
        for (T sel : selections) {
            ret.add(info.encodeChoice(sel));
        }
        return ret;
    }

    private <T> List<String> getExportAssociations(ChooseDriver obj, ChooseInformation<T> info) {
        List<T> selections = info.getChoiceActor().getCurrentlySelected(obj, this);
        if (selections == null || selections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(selections.size());
        for (T sel : selections) {
            ret.add(String.valueOf(sel));
        }
        return ret;
    }

    public <T> void addAssoc(Object obj, AssociationListKey<T> ak, T o) {
        this.assocSupt.addAssoc(obj, ak, o);
    }

    public int getAssocCount(Object obj, AssociationListKey<?> ak) {
        return this.assocSupt.getAssocCount(obj, ak);
    }

    public <T> List<T> getAssocList(Object obj, AssociationListKey<T> ak) {
        return this.assocSupt.getAssocList(obj, ak);
    }

    public <T extends Comparable<T>> void sortAssocList(Object obj, AssociationListKey<T> ak) {
        this.assocSupt.sortAssocList(obj, ak);
    }

    public <T> Collection<T> getSafeAssocList(Object obj, AssociationListKey<T> alk) {
        List<T> list = this.getAssocList(obj, alk);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public <T> List<T> removeAllAssocs(Object obj, AssociationListKey<T> ak) {
        return this.assocSupt.removeAllAssocs(obj, ak);
    }

    public <T> void removeAssoc(Object obj, AssociationListKey<T> ak, T o) {
        this.assocSupt.removeAssoc(obj, ak, o);
    }

    public <T> T getAssoc(Object obj, AssociationKey<T> ak) {
        return this.assocSupt.getAssoc(obj, ak);
    }

    public boolean hasAssocs(Object obj, AssociationKey<?> ak) {
        return this.assocSupt.hasAssocs(obj, ak);
    }

    public <T> void removeAssoc(Object obj, AssociationKey<T> ak) {
        this.assocSupt.removeAssoc(obj, ak);
    }

    public <T> void setAssoc(Object obj, AssociationKey<T> ak, T o) {
        this.assocSupt.setAssoc(obj, ak, o);
    }

    public boolean hasNonStatStat(PCStat stat) {
        return !this.nonStatToStatFacet.contains(this.id, stat) && this.nonStatStatFacet.contains(this.id, stat);
    }

    public boolean hasUnlockedStat(PCStat stat) {
        return this.unlockedStatFacet.contains(this.id, stat);
    }

    public Number getLockedStat(PCStat stat) {
        return this.statLockFacet.getLockedStat(this.id, stat);
    }

    public String getDescription(CNAbility cna) {
        return this.getDescription(Collections.singletonList(cna));
    }

    public String getDescription(PObject pobj) {
        return this.getDescription(Collections.singletonList(pobj));
    }

    public String getDescription(List<? extends Object> objList) {
        PObject cdo;
        if (objList.size() == 0) {
            return "";
        }
        Object b = objList.get(0);
        if (b instanceof PObject) {
            cdo = (PObject)b;
        } else if (b instanceof CNAbility) {
            cdo = ((CNAbility)b).getAbility();
        } else {
            Logging.errorPrint("Unable to resolve Description with object of type: " + b.getClass().getName());
            return "";
        }
        List<Description> theDescriptions = cdo.getListFor(cdo.getDescriptionKey());
        if (theDescriptions == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(250);
        boolean needSpace = false;
        for (Description desc : theDescriptions) {
            String str = desc.getDescription(this, objList);
            if (str.length() <= 0) continue;
            if (needSpace) {
                sb.append(' ');
            }
            sb.append(str);
            needSpace = true;
        }
        return sb.toString();
    }

    public HashMapToList<CDOMList<Spell>, Integer> getSpellLevelInfo(Spell sp) {
        HashMapToList<CDOMList<Spell>, Integer> hml = this.cache.get(MapKey.SPELL_PC_INFO, sp);
        if (hml == null) {
            hml = this.availSpellFacet.getSpellLevelInfo(this.id, sp);
            this.cache.addToMapFor(MapKey.SPELL_PC_INFO, sp, hml);
        }
        HashMapToList newhml = new HashMapToList();
        newhml.addAllLists(hml);
        return newhml;
    }

    public CharacterSpell getCharacterSpellForSpell(PObject po, Spell spell, PObject owner) {
        ArrayList<CharacterSpell> cspells = new ArrayList<CharacterSpell>(this.getCharacterSpells(po));
        this.addBonusKnownSpellsToList(po, cspells);
        for (CharacterSpell cs : cspells) {
            Spell sp = cs.getSpell();
            if (!spell.equals(sp) || !cs.getOwner().equals(owner)) continue;
            return cs;
        }
        return null;
    }

    public final List<CharacterSpell> getCharacterSpells(CDOMObject spellSource, Spell aSpell, String book, int level) {
        ArrayList<CharacterSpell> csList = new ArrayList<CharacterSpell>(this.getCharacterSpells(spellSource));
        this.addBonusKnownSpellsToList(spellSource, csList);
        ArrayList<CharacterSpell> aList = new ArrayList<CharacterSpell>();
        if (csList.size() == 0) {
            return aList;
        }
        for (CharacterSpell cs : csList) {
            SpellInfo si;
            if (aSpell != null && !cs.getSpell().equals(aSpell) || (si = cs.getSpellInfoFor(book, level, null)) == null) continue;
            aList.add(cs);
        }
        return aList;
    }

    public int getDC(Spell sp, CharacterSpell cs, SpellInfo si) {
        CDOMObject ow = null;
        int spellLevel = 0;
        int metaDC = 0;
        spellLevel = si.getActualLevel();
        ow = cs.getOwner();
        String fixedDC = si.getFixedDC();
        if (fixedDC != null && "INNATE".equalsIgnoreCase(si.getBook())) {
            return this.getVariableValue(fixedDC, "").intValue();
        }
        if (fixedDC != null && ow != null && !(ow instanceof PCClass)) {
            return this.getVariableValue(fixedDC, "").intValue();
        }
        if (si.getFeatList() != null) {
            for (Ability metaFeat : si.getFeatList()) {
                spellLevel -= metaFeat.getSafe(IntegerKey.ADD_SPELL_LEVEL);
                metaDC = (int)((double)metaDC + BonusCalc.charBonusTo(metaFeat, "DC", "FEATBONUS", this));
            }
        }
        return this.getDC(sp, null, spellLevel, metaDC, ow);
    }

    public int getDC(Spell sp, PCClass aClass, int spellLevel, int metaDC, CDOMObject ow) {
        CDOMSingleRef<PCStat> stat;
        String bonDomain = "";
        if (ow instanceof Domain) {
            bonDomain = "DOMAIN." + ow.getKeyName();
            ClassSource source = this.getDomainSource((Domain)ow);
            if (source != null) {
                aClass = this.getClassKeyed(source.getPcclass().getKeyName());
            }
        }
        boolean useStatFromSpell = false;
        String bonClass = "";
        String spellType = "";
        String classKey = "";
        if (aClass != null || ow instanceof PCClass) {
            if (aClass == null || ow instanceof PCClass) {
                aClass = (PCClass)ow;
            }
            bonClass = "CLASS." + aClass.getKeyName();
            classKey = "CLASS:" + aClass.getKeyName();
            spellType = aClass.getSpellType();
            useStatFromSpell = aClass.getSafe(ObjectKey.USE_SPELL_SPELL_STAT);
        }
        if (!(ow instanceof PCClass) && !(ow instanceof Domain)) {
            useStatFromSpell = true;
        }
        this.setSpellLevelTemp(spellLevel);
        int dc = this.getVariableValue(SettingsHandler.getGame().getSpellBaseDC(), classKey).intValue() + metaDC;
        dc += (int)this.getTotalBonusTo("DC", "ALLSPELLS");
        if (useStatFromSpell && (stat = sp.get(ObjectKey.SPELL_STAT)) != null) {
            dc += this.getStatModFor(stat.resolvesTo());
        }
        if (sp.getKeyName().length() > 0) {
            dc += (int)this.getTotalBonusTo("DC", "SPELL." + sp.getKeyName());
        }
        if (bonDomain.length() > 0) {
            dc += (int)this.getTotalBonusTo("DC", bonDomain);
        }
        if (bonClass.length() > 0) {
            dc += (int)this.getTotalBonusTo("DC", bonClass);
        }
        dc += (int)this.getTotalBonusTo("DC", "TYPE." + spellType);
        if (spellType.equals("ALL")) {
            for (Type type : sp.getTrueTypeList(false)) {
                dc += (int)this.getTotalBonusTo("DC", "TYPE." + type);
            }
        }
        for (SpellSchool spellSchool : sp.getSafeListFor(ListKey.SPELL_SCHOOL)) {
            dc += (int)this.getTotalBonusTo("DC", "SCHOOL." + spellSchool.toString());
        }
        for (String string : sp.getSafeListFor(ListKey.SPELL_SUBSCHOOL)) {
            dc += (int)this.getTotalBonusTo("DC", "SUBSCHOOL." + string);
        }
        for (String string : sp.getSafeListFor(ListKey.SPELL_DESCRIPTOR)) {
            dc += (int)this.getTotalBonusTo("DC", "DESCRIPTOR." + string);
        }
        this.setSpellLevelTemp(0);
        return dc;
    }

    public int getConcentration(Spell sp, CharacterSpell cs, SpellInfo si) {
        CDOMObject ow = null;
        int spellLevel = 0;
        int metaConcentration = 0;
        spellLevel = si.getActualLevel();
        ow = cs.getOwner();
        if (si.getFeatList() != null) {
            for (Ability metaFeat : si.getFeatList()) {
                spellLevel -= metaFeat.getSafe(IntegerKey.ADD_SPELL_LEVEL);
                metaConcentration = (int)((double)metaConcentration + BonusCalc.charBonusTo(metaFeat, "CONCENTRATION", "FEATBONUS", this));
            }
        }
        return this.getConcentration(sp, cs, null, spellLevel, metaConcentration, ow);
    }

    public int getConcentration(Spell sp, CharacterSpell aSpell, PCClass aClass, int spellLevel, int metaConcentration, CDOMObject ow) {
        CDOMSingleRef<PCStat> stat;
        String bonDomain = "";
        if (ow instanceof Domain) {
            bonDomain = "DOMAIN." + ow.getKeyName();
            ClassSource source = this.getDomainSource((Domain)ow);
            if (source != null) {
                aClass = this.getClassKeyed(source.getPcclass().getKeyName());
            }
        }
        boolean useStatFromSpell = false;
        String bonClass = "";
        String spellType = "";
        String classKey = "";
        if (aClass != null || ow instanceof PCClass) {
            if (aClass == null || ow instanceof PCClass) {
                aClass = (PCClass)ow;
            }
            bonClass = "CLASS." + aClass.getKeyName();
            classKey = "CLASS:" + aClass.getKeyName();
            spellType = aClass.getSpellType();
            useStatFromSpell = aClass.getSafe(ObjectKey.USE_SPELL_SPELL_STAT);
        }
        if (!(ow instanceof PCClass) && !(ow instanceof Domain)) {
            useStatFromSpell = true;
        }
        this.setSpellLevelTemp(spellLevel);
        int concentration = this.getVariableValue(aSpell, SettingsHandler.getGame().getSpellBaseConcentration(), classKey).intValue() + metaConcentration;
        concentration += (int)this.getTotalBonusTo("CONCENTRATION", "ALLSPELLS");
        if (useStatFromSpell && (stat = sp.get(ObjectKey.SPELL_STAT)) != null) {
            concentration += this.getStatModFor(stat.resolvesTo());
        }
        if (sp.getKeyName().length() > 0) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", "SPELL." + sp.getKeyName());
        }
        if (bonDomain.length() > 0) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", bonDomain);
        }
        if (bonClass.length() > 0) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", bonClass);
        }
        concentration += (int)this.getTotalBonusTo("CONCENTRATION", "TYPE." + spellType);
        if (spellType.equals("ALL")) {
            for (Type type : sp.getTrueTypeList(false)) {
                concentration += (int)this.getTotalBonusTo("CONCENTRATION", "TYPE." + type);
            }
        }
        for (SpellSchool spellSchool : sp.getSafeListFor(ListKey.SPELL_SCHOOL)) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", "SCHOOL." + spellSchool.toString());
        }
        for (String string : sp.getSafeListFor(ListKey.SPELL_SUBSCHOOL)) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", "SUBSCHOOL." + string);
        }
        for (String string : sp.getSafeListFor(ListKey.SPELL_DESCRIPTOR)) {
            concentration += (int)this.getTotalBonusTo("CONCENTRATION", "DESCRIPTOR." + string);
        }
        this.setSpellLevelTemp(0);
        return concentration;
    }

    public boolean hasSkill(Skill skill) {
        return this.skillFacet.contains(this.id, skill);
    }

    public boolean hasTemplate(PCTemplate template) {
        return this.templateFacet.contains(this.id, template);
    }

    public Collection<PCStat> getStatSet() {
        return ((AbstractListFacet)this.statFacet).getSet(this.id);
    }

    public boolean hasDefaultDomainSource() {
        return this.defaultDomainSource != null;
    }

    public ClassSource getDefaultDomainSource() {
        return this.defaultDomainSource;
    }

    public void setDefaultDomainSource(ClassSource cs) {
        this.defaultDomainSource = cs;
    }

    public boolean addDomain(Domain domain) {
        return this.addDomain(domain, this.defaultDomainSource);
    }

    public boolean addDomain(Domain domain, ClassSource source) {
        boolean added = this.domainInputFacet.add(this.id, domain, source);
        if (added) {
            this.setDirty(true);
        }
        return added;
    }

    public boolean hasDomain(Domain domain) {
        return this.domainFacet.contains(this.id, domain);
    }

    public void removeDomain(Domain domain) {
        this.domainInputFacet.remove(this.id, domain);
        this.setDirty(true);
    }

    public boolean hasDomains() {
        return !this.domainFacet.isEmpty(this.id);
    }

    public int getDomainCount() {
        return this.domainFacet.getCount(this.id);
    }

    public Set<Domain> getDomainSet() {
        return this.domainFacet.getSet(this.id);
    }

    public ClassSource getDomainSource(Domain d) {
        return (ClassSource)this.domainFacet.getSource(this.id, d);
    }

    public Map<String, String> getBonusStrings(String bonusString, String substring) {
        return this.bonusManager.getBonuses(bonusString, substring);
    }

    public Set<String> getTempBonusNames() {
        return this.bonusManager.getTempBonusDisplayNames();
    }

    public boolean isApplied(BonusObj bonus) {
        return this.appliedBonusFacet.contains(this.id, bonus);
    }

    public SpellSupportForPCClass getSpellSupport(PCClass cl) {
        SpellSupportForPCClass ss = (SpellSupportForPCClass)this.spellSupportFacet.get(this.id, cl);
        if (ss == null) {
            ss = new SpellSupportForPCClass(cl);
            this.spellSupportFacet.set(this.id, cl, ss);
        }
        return ss;
    }

    public Map<BonusObj, BonusManager.TempBonusInfo> getTempBonusMap(String sourceStr, String targetStr) {
        return this.bonusManager.getTempBonusMap(sourceStr, targetStr);
    }

    public String getBonusContext(BonusObj bonus, boolean shortForm) {
        return this.bonusManager.getBonusContext(bonus, shortForm);
    }

    public List<BonusPair> getStringListFromBonus(BonusObj bonus) {
        return this.bonusManager.getStringListFromBonus(bonus);
    }

    public void setApplied(BonusObj bonusObj, boolean bool) {
        if (bool) {
            this.appliedBonusFacet.add(this.id, bonusObj);
        } else {
            this.appliedBonusFacet.remove(this.id, bonusObj);
        }
    }

    public void setSubstitutionLevel(PCClass pcc, PCClassLevel originalClassLevel) {
        try {
            PCClassLevel clvl = originalClassLevel.clone();
            clvl.put(StringKey.QUALIFIED_KEY, pcc.getQualifiedKey());
            this.classFacet.setClassLevel(this.id, pcc, clvl);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public PCClassLevel getActiveClassLevel(PCClass pcc, int lvl) {
        return this.classFacet.getClassLevel(this.id, pcc, lvl);
    }

    public boolean hasLanguage(Language lang) {
        return this.languageFacet.contains(this.id, lang);
    }

    public boolean hasClass() {
        return !this.classFacet.isEmpty(this.id);
    }

    public void removeClass(PCClass pcc) {
        this.classFacet.removeClass(this.id, pcc);
    }

    public void addClass(PCClass pcc) {
        this.classFacet.addClass(this.id, pcc);
    }

    public final int getLevel(PCClass pcc) {
        return this.classFacet.getLevel(this.id, pcc);
    }

    public final void setLevelWithoutConsequence(PCClass pcc, int level) {
        this.classFacet.setLevel(this.id, pcc, level);
        this.cabFacet.update(this.id);
    }

    public boolean hasEquipment() {
        return !this.equipmentFacet.isEmpty(this.id);
    }

    private Set<Ability> getAbilityList(Category<Ability> cat, Nature nature) {
        HashSet<Ability> newSet = new HashSet<Ability>();
        Collection<CNAbility> cnas = this.grantedAbilityFacet.getPoolAbilities(this.id, cat, nature);
        for (CNAbility cna : cnas) {
            newSet.add(cna.getAbility());
        }
        return newSet;
    }

    public boolean containsKit(Kit kit) {
        return this.kitFacet.contains(this.id, kit);
    }

    public void doAfavorForAunitTestThatIgnoresEquippingRules() {
        this.equippedFacet.reset(this.id);
    }

    public void processAddition(CDOMObject cdo) {
        for (CDOMReference<PCTemplate> cDOMReference : cdo.getSafeListFor(ListKey.TEMPLATE)) {
            this.addTemplatesIfMissing(cDOMReference.getContainedObjects());
        }
        for (CDOMReference<PrereqObject> cDOMReference : cdo.getModifiedLists()) {
            this.processAbilityListsOnAdd(cdo, cDOMReference);
        }
    }

    public void processRemoval(CDOMObject cdo) {
        this.conditionalFacet.removeAll(this.id, cdo);
        this.directAbilityFacet.removeAll(this.id, cdo);
    }

    public void addWeaponBonus(CDOMObject owner, WeaponProf choice) {
        this.wpBonusFacet.add(this.id, choice, owner);
    }

    public List<? extends WeaponProf> getBonusWeaponProfs(CDOMObject owner) {
        return this.wpBonusFacet.getSet(this.id, owner);
    }

    public void removeWeaponBonus(CDOMObject owner, WeaponProf choice) {
        this.wpBonusFacet.remove(this.id, choice, owner);
    }

    public void addFavoredClass(PCClass cls, Object source) {
        this.favClassFacet.add(this.id, cls, source);
    }

    public void removeFavoredClass(PCClass cls, Object source) {
        this.favClassFacet.remove(this.id, cls, source);
    }

    public PCClass getLegacyFavoredClass() {
        List list = this.favClassFacet.getSet(this.id, this);
        if (list.isEmpty()) {
            return null;
        }
        return (PCClass)list.get(0);
    }

    public void addWeaponProf(Object owner, WeaponProf choice) {
        this.alWeaponProfFacet.add(this.id, choice, owner);
    }

    public void removeWeaponProf(Object owner, WeaponProf choice) {
        this.alWeaponProfFacet.remove(this.id, choice, owner);
    }

    public CharID getCharID() {
        return this.id;
    }

    public int getSpellBookCount() {
        return this.spellBookFacet.getCount(this.id);
    }

    public boolean hasSpellBook(String bookName) {
        return this.spellBookFacet.containsBookNamed(this.id, bookName);
    }

    private Load getLoadType() {
        return this.loadFacet.getLoadType(this.id);
    }

    public void addArmorProf(Object owner, ArmorProf ap) {
        this.armorProfListFacet.add(this.id, ap, owner);
    }

    public void removeArmorProf(Object owner, ArmorProf ap) {
        this.armorProfListFacet.remove(this.id, ap, owner);
    }

    public void addShieldProf(Object owner, ShieldProf sp) {
        this.shieldProfListFacet.add(this.id, sp, owner);
    }

    public void removeShieldProf(Object owner, ShieldProf sp) {
        this.shieldProfListFacet.remove(this.id, sp, owner);
    }

    public boolean hasFollowers() {
        return !this.followerFacet.isEmpty(this.id);
    }

    public void addAutoEquipment(Equipment e, Object obj) {
        this.autoListEquipmentFacet.add(this.id, e, obj);
    }

    public void removeAutoEquipment(Equipment e, Object obj) {
        this.autoListEquipmentFacet.remove(this.id, e, obj);
    }

    public void addMonCSkill(Skill skill, Object obj) {
        this.monCSkillFacet.add(this.id, skill, obj);
    }

    public void removeMonCSkill(Skill skill, Object obj) {
        this.monCSkillFacet.remove(this.id, skill, obj);
    }

    public Collection<? extends SpellProhibitor> getProhibitedSchools(PCClass source) {
        ArrayList list = new ArrayList();
        list.addAll(this.prohibitedSchoolFacet.getSet(this.id, source));
        list.addAll(this.spellProhibitorFacet.getSet(this.id, source));
        return list;
    }

    public boolean containsProhibitedSchools(Object source) {
        return this.prohibitedSchoolFacet.containsFrom(this.id, source);
    }

    public void addProhibitedSchool(SpellProhibitor prohibSchool, Object source) {
        this.prohibitedSchoolFacet.add(this.id, prohibSchool, source);
    }

    public void removeProhibitedSchools(Object source) {
        this.prohibitedSchoolFacet.removeAll(this.id, source);
    }

    public boolean hasCharacterSpells(CDOMObject cdo) {
        return this.activeSpellsFacet.containsFrom(this.id, cdo);
    }

    public Collection<? extends CharacterSpell> getCharacterSpells(CDOMObject cdo) {
        return this.activeSpellsFacet.getSet(this.id, cdo);
    }

    public Collection<CharacterSpell> getCharacterSpells(PObject spellSource, int level) {
        ArrayList<CharacterSpell> csList = new ArrayList<CharacterSpell>(this.getCharacterSpells(spellSource));
        this.addBonusKnownSpellsToList(spellSource, csList);
        ArrayList<CharacterSpell> aList = new ArrayList<CharacterSpell>();
        for (CharacterSpell cs : csList) {
            if (!cs.hasSpellInfoFor(level)) continue;
            aList.add(cs);
        }
        return aList;
    }

    public Collection<CharacterSpell> getCharacterSpells(PObject spellSource, String bookName) {
        ArrayList<CharacterSpell> csList = new ArrayList<CharacterSpell>(this.getCharacterSpells(spellSource));
        this.addBonusKnownSpellsToList(spellSource, csList);
        ArrayList<CharacterSpell> aList = new ArrayList<CharacterSpell>();
        for (CharacterSpell cs : csList) {
            if (!cs.hasSpellInfoFor(bookName)) continue;
            aList.add(cs);
        }
        return aList;
    }

    public int getCharacterSpellCount(CDOMObject cdo) {
        return this.activeSpellsFacet.getCountFrom(this.id, cdo);
    }

    public void addCharacterSpell(CDOMObject cdo, CharacterSpell cs) {
        this.activeSpellsFacet.add(this.id, cs, cdo);
    }

    public void removeCharacterSpell(CDOMObject cdo, CharacterSpell cs) {
        this.activeSpellsFacet.remove(this.id, cs, cdo);
    }

    private boolean containsCharacterSpell(CDOMObject cdo, CharacterSpell cs) {
        return this.activeSpellsFacet.containsFrom(this.id, cs, cdo);
    }

    public void addBonus(BonusObj bonus, CDOMObject source) {
        this.addedBonusFacet.add(this.id, bonus, source);
    }

    public List<? extends BonusObj> getAddedBonusList(CDOMObject source) {
        return this.addedBonusFacet.getSet(this.id, source);
    }

    public void addSaveableBonus(BonusObj bonus, CDOMObject source) {
        this.saveableBonusFacet.add(this.id, bonus, source);
    }

    public List<? extends BonusObj> getSaveableBonusList(CDOMObject source) {
        return this.saveableBonusFacet.getSet(this.id, source);
    }

    public void removeSaveableBonus(BonusObj bonus, CDOMObject source) {
        this.saveableBonusFacet.remove(this.id, bonus, source);
    }

    public void addGlobalCost(SkillCost sc, Skill skill, Object obj) {
        this.globalAddedSkillCostFacet.add(this.id, sc, skill, obj);
    }

    public void removeGlobalCost(SkillCost sc, Skill skill, Object obj) {
        this.globalAddedSkillCostFacet.remove(this.id, sc, skill, obj);
    }

    public void addLocalCost(PCClass pcc, Skill skill, SkillCost sc, Object owner) {
        this.localAddedSkillCostFacet.add(this.id, pcc, sc, skill, owner);
    }

    public void removeLocalCost(PCClass pcc, Skill skill, SkillCost sc, Object owner) {
        this.localAddedSkillCostFacet.remove(this.id, pcc, sc, skill, owner);
    }

    public String getSubClassName(PCClass cl) {
        return (String)this.subClassFacet.get(this.id, cl);
    }

    public void setSubClassName(PCClass cl, String key) {
        this.subClassFacet.set(this.id, cl, key);
    }

    public boolean hasTempApplied(CDOMObject mod) {
        return this.bonusManager.hasTempBonusesApplied(mod);
    }

    public Collection<BonusContainer> getBonusContainerList() {
        ArrayList<BonusContainer> list = new ArrayList<BonusContainer>(this.getCDOMObjectList());
        list.add((BonusContainer)((AbstractItemFacet)this.ageSetFacet).get(this.id));
        GameMode gm = SettingsHandler.getGame();
        if (gm.isPurchaseStatMode()) {
            PointBuyMethod pbm = gm.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PointBuyMethod.class, gm.getPurchaseModeMethodName());
            list.add(pbm);
        }
        return list;
    }

    public SkillCost skillCostForPCClass(Skill sk, PCClass aClass) {
        PCClass cl = this.getClassKeyed(aClass.getKeyName());
        return this.skillCostFacet.skillCostForPCClass(this.id, sk, cl == null ? aClass : cl);
    }

    public boolean isClassSkill(PCClass aClass, Skill sk) {
        PCClass cl = this.getClassKeyed(aClass.getKeyName());
        return this.skillCostFacet.isClassSkill(this.id, cl == null ? aClass : cl, sk);
    }

    public boolean isQualified(CDOMObject po) {
        return po.qualifies(this, po);
    }

    public void reInheritClassLevels(PCClass pcc) {
        try {
            for (PCClassLevel pcl : pcc.getOriginalClassLevelCollection()) {
                this.classFacet.setClassLevel(this.id, pcc, pcl);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void checkSkillModChange() {
        ArrayList<PCClass> newClasses = this.getClassList();
        Collection<PCLevelInfo> levelInfo = this.getLevelInfo();
        int levelIndex = 1;
        for (PCLevelInfo lvlInfo : levelInfo) {
            HashMap<String, PCClass> classMap = new HashMap<String, PCClass>();
            for (PCClass pcClass : newClasses) {
                classMap.put(pcClass.getKeyName(), pcClass);
            }
            String classKeyName = lvlInfo.getClassKeyName();
            PCClass currClass = (PCClass)classMap.get(classKeyName);
            if (currClass == null) {
                Logging.errorPrint("No PCClass found for '" + classKeyName + "' in character's class list: " + newClasses);
                return;
            }
            PCClassLevel classLevel = this.getActiveClassLevel(currClass, lvlInfo.getClassLevel());
            this.checkSkillModChangeForLevel(currClass, lvlInfo, classLevel, levelIndex++);
        }
    }

    public void checkSkillModChangeForLevel(PCClass pcClass, PCLevelInfo pi, PCClassLevel classLevel, int characterLevel) {
        int formerGained;
        int newSkillPointsGained = pcClass.getSkillPointsForLevel(this, classLevel, characterLevel);
        if (pi.getClassKeyName().equals(pcClass.getKeyName()) && newSkillPointsGained != (formerGained = pi.getSkillPointsGained(this))) {
            pi.setSkillPointsGained(this, newSkillPointsGained);
            newSkillPointsGained = pi.getSkillPointsGained(this);
            pi.setSkillPointsRemaining(pi.getSkillPointsRemaining() + newSkillPointsGained - formerGained);
            this.setSkillPool(pcClass, pcClass.getSkillPool(this) + newSkillPointsGained - formerGained);
        }
    }

    public void addChronicleEntry(ChronicleEntry chronicleEntry) {
        this.chronicleEntryFacet.add(this.id, chronicleEntry);
    }

    public void removeChronicleEntry(ChronicleEntry chronicleEntry) {
        this.chronicleEntryFacet.remove(this.id, chronicleEntry);
    }

    public BioSet getBioSet() {
        return (BioSet)this.bioSetFacet.get(this.id);
    }

    public HitDie getLevelHitDie(PCClass pcClass, int classLevel) {
        return this.hitPointFacet.getLevelHitDie(this.id, pcClass, classLevel);
    }

    public void rollHP(PCClass pcClass, int aLevel, boolean first) {
        this.hitPointFacet.rollHP(this.id, pcClass, aLevel, first);
        this.setDirty(true);
    }

    public void setHP(PCClassLevel pcl, Integer hp) {
        this.hitPointFacet.set(this.id, pcl, hp);
    }

    public Integer getHP(PCClassLevel pcl) {
        return (Integer)this.hitPointFacet.get(this.id, pcl);
    }

    public void removeHP(PCClassLevel pcl) {
        this.hitPointFacet.remove(this.id, pcl);
    }

    public void addClassSpellList(CDOMListObject<Spell> list, PCClass pcClass) {
        this.spellListFacet.add(this.id, (CDOMList<Spell>)list, (Object)pcClass);
    }

    public List<? extends CDOMList<Spell>> getSpellLists(CDOMObject cdo) {
        return this.spellListFacet.getSet(this.id, cdo);
    }

    public boolean hasSpellList(CDOMObject cdo, CDOMList<Spell> list) {
        return this.spellListFacet.containsFrom(this.id, list, cdo);
    }

    public void setSpellLists(PCClass pcClass) {
        this.classSpellListFacet.process(this.id, pcClass);
    }

    public void addDefaultSpellList(PCClass pcc) {
        this.classSpellListFacet.addDefaultSpellList(this.id, pcc);
    }

    double getSizeBonusTo(SizeAdjustment sizeAdjustment, String bonusType, List<String> typeList, double defaultValue) {
        for (String type : typeList) {
            double a = BonusCalc.charBonusTo(sizeAdjustment, bonusType, "TYPE." + type, this);
            if (CoreUtility.doublesEqual(a, 0.0)) continue;
            defaultValue = a;
            break;
        }
        return defaultValue;
    }

    public void addBonusKnownSpellsToList(CDOMObject aClass, List<CharacterSpell> cSpells) {
        if (!(aClass instanceof PCClass)) {
            return;
        }
        ClassSpellList classSpellList = ((PCClass)aClass).get(ObjectKey.CLASS_SPELLLIST);
        for (Integer spellLevel : this.knownSpellFacet.getScopes2(this.id, classSpellList)) {
            for (Spell spell : this.knownSpellFacet.getSet(this.id, classSpellList, spellLevel)) {
                CharacterSpell acs = null;
                Collection<? extends CharacterSpell> characterSpells = this.getCharacterSpells(grantedSpellCache);
                for (CharacterSpell characterSpell : characterSpells) {
                    Spell sp = characterSpell.getSpell();
                    if (!spell.equals(sp) || !characterSpell.getOwner().equals(aClass)) continue;
                    acs = characterSpell;
                    break;
                }
                if (acs == null) {
                    acs = new CharacterSpell(aClass, spell);
                    acs.addInfo(spellLevel, 1, Globals.getDefaultSpellBook());
                    this.addCharacterSpell(grantedSpellCache, acs);
                }
                if (cSpells.contains(acs)) continue;
                cSpells.add(acs);
            }
        }
    }

    public boolean hasBonusWeaponProfs(CDOMObject owner) {
        return this.wpBonusFacet.containsFrom(this.id, owner);
    }

    public void addUserSpecialAbility(SpecialAbility sa, CDOMObject source) {
        this.userSpecialAbilityFacet.add(this.id, sa, source);
    }

    public void removeUserSpecialAbility(SpecialAbility sa, CDOMObject source) {
        this.userSpecialAbilityFacet.remove(this.id, sa, source);
    }

    public CharacterDisplay getDisplay() {
        return this.display;
    }

    public List<WeaponProf> getWeaponProfsInTarget(CDOMGroupRef<WeaponProf> master) {
        return this.changeProfFacet.getWeaponProfsInTarget(this.id, master);
    }

    public void setSubstitutionClassName(PCClassLevel lvl, String subClassKey) {
        this.substitutionClassFacet.set(this.id, lvl, subClassKey);
    }

    public void removeSubstitutionClassName(PCClassLevel lvl) {
        this.substitutionClassFacet.remove(this.id, lvl);
    }

    public void setStat(PCStat stat, int value) {
        this.statValueFacet.set(this.id, stat, value);
    }

    public Integer getStat(PCStat stat) {
        return (Integer)this.statValueFacet.get(this.id, stat);
    }

    public int recalcSkillPointMod(PCClass pcClass, int characterLevel) {
        int spMod = pcClass.getSafe(FormulaKey.START_SKILL_POINTS).resolve(this, pcClass.getQualifiedKey()).intValue();
        spMod += (int)this.getTotalBonusTo("SKILLPOINTS", "NUMBER");
        if (pcClass.isMonster()) {
            int nonSkillHD;
            int monSkillPts;
            int lockedMonsterSkillPoints = (int)this.getTotalBonusTo("MONSKILLPTS", "LOCKNUMBER");
            if (lockedMonsterSkillPoints > 0) {
                spMod = lockedMonsterSkillPoints;
            } else if (characterLevel == 1 && (monSkillPts = (int)this.getTotalBonusTo("MONSKILLPTS", "NUMBER")) != 0) {
                spMod = monSkillPts;
            }
            if (characterLevel != 1 && characterLevel <= (nonSkillHD = (int)this.getTotalBonusTo("MONNONSKILLHD", "NUMBER"))) {
                spMod = 0;
            }
        }
        spMod = this.updateBaseSkillMod(pcClass, spMod);
        if (characterLevel == 1) {
            if (!SettingsHandler.getGame().isPurchaseStatMode()) {
                this.setPoolAmount(0);
            }
            spMod *= this.getRace().getSafe(IntegerKey.INITIAL_SKILL_MULT);
            if (this.ageFacet.getAge(this.id) <= 0) {
                ((BioSet)this.bioSetFacet.get(this.id)).randomize("AGE", this);
            }
        } else {
            spMod *= Globals.getSkillMultiplierForLevel(characterLevel);
        }
        return spMod;
    }

    private int updateBaseSkillMod(PCClass pcClass, int spMod) {
        int skillMin;
        int n = skillMin = spMod > 0 ? 1 : 0;
        if (pcClass.getSafe(ObjectKey.MOD_TO_SKILLS).booleanValue() && (spMod += (int)this.getStatBonusTo("MODSKILLPOINTS", "NUMBER")) < 1) {
            spMod = 1;
        }
        Formula safe = this.getRace().getSafe(FormulaKey.SKILL_POINTS_PER_LEVEL);
        spMod += safe.resolve(this, "").intValue();
        spMod = Math.max(skillMin, spMod);
        for (PCTemplate template : this.getTemplateSet()) {
            spMod += template.getSafe(IntegerKey.BONUS_CLASS_SKILL_POINTS);
        }
        return spMod;
    }

    public void removeDomainSpellCount(PCClass pcc) {
        this.domainSpellCountFacet.remove(this.id, pcc);
    }

    public Integer getDomainSpellCount(PCClass pcc) {
        return (Integer)this.domainSpellCountFacet.get(this.id, pcc);
    }

    public void setDomainSpellCount(PCClass pcc, int i) {
        this.domainSpellCountFacet.set(this.id, pcc, i);
    }

    public Integer getSkillPool(PCClass pcc) {
        return (Integer)this.skillPoolFacet.get(this.id, pcc);
    }

    public void setSkillPool(PCClass pcc, int skillPool) {
        this.skillPoolFacet.set(this.id, pcc, skillPool);
        this.setDirty(true);
    }

    public void setSkillOrder(Skill skill, int outputindex) {
        this.skillOutputOrderFacet.set(this.id, skill, outputindex);
    }

    public Integer getSkillOrder(Skill skill) {
        return (Integer)this.skillOutputOrderFacet.get(this.id, skill);
    }

    public int getBaseStatFor(PCStat stat) {
        return this.statCalcFacet.getBaseStatFor(this.id, stat);
    }

    public int getTotalStatFor(PCStat stat) {
        return this.statCalcFacet.getTotalStatFor(this.id, stat);
    }

    public int getStatModFor(PCStat stat) {
        return this.statCalcFacet.getStatModFor(this.id, stat);
    }

    public int getModForNumber(int aNum, PCStat stat) {
        return this.statCalcFacet.getModFornumber(this.id, aNum, stat);
    }

    public void removeNote(NoteItem note) {
        this.noteItemFacet.remove(this.id, note);
        this.setDirty(true);
    }

    public void removeSkillRankValue(Skill sk, PCClass cl) {
        PCClass localClass = cl == null ? null : this.getClassKeyed(cl.getKeyName());
        this.removeSkillRankForLocalClass(sk, localClass);
    }

    public void removeSkillRankForLocalClass(Skill sk, PCClass localClass) {
        this.skillRankFacet.remove(this.id, sk, localClass);
    }

    public void setSkillRankValue(Skill sk, PCClass pcc, double value) {
        PCClass localClass = pcc == null ? null : this.getClassKeyed(pcc.getKeyName());
        this.skillRankFacet.set(this.id, sk, localClass, value);
    }

    public Collection<PCClass> getSkillRankClasses(Skill sk) {
        return this.skillRankFacet.getClasses(this.id, sk);
    }

    public Float getRank(Skill sk) {
        return Float.valueOf(this.skillRankFacet.getRank(this.id, sk));
    }

    public boolean isAllowDebt() {
        Boolean ad = (Boolean)this.allowDebtFacet.get(this.id);
        return ad == null ? SettingsHandler.getGearTab_AllowDebt() : ad;
    }

    public boolean isIgnoreCost() {
        Boolean ic = (Boolean)this.ignoreCostFacet.get(this.id);
        return ic == null ? SettingsHandler.getGearTab_IgnoreCost() : ic;
    }

    public Double getSkillRankForClass(Skill sk, PCClass pcc) {
        PCClass localClass = pcc == null ? null : this.getClassKeyed(pcc.getKeyName());
        return this.getSkillRankForLocalClass(sk, localClass);
    }

    public Double getSkillRankForLocalClass(Skill sk, PCClass localClass) {
        return this.skillRankFacet.get(this.id, sk, localClass);
    }

    public int getKnownSpellCountForLevel(CDOMList<Spell> list, int level) {
        return this.knownSpellFacet.getSize(this.id, list, level);
    }

    public Collection<Spell> getSpellsIn(CDOMList<Spell> list, int level) {
        return this.availSpellFacet.getSet(this.id, list, level);
    }

    public List<Spell> getAllSpellsInLists(List<? extends CDOMList<Spell>> spellLists) {
        ArrayList<Spell> spellList = new ArrayList<Spell>();
        for (CDOMList list : this.availSpellFacet.getScopes1(this.id)) {
            if (!spellLists.contains(list)) continue;
            Iterator i$ = this.availSpellFacet.getScopes2(this.id, list).iterator();
            while (i$.hasNext()) {
                int lvl = (Integer)i$.next();
                for (Spell spell : this.availSpellFacet.getSet(this.id, list, lvl)) {
                    spellList.add(spell);
                }
            }
        }
        return spellList;
    }

    public void calculateKnownSpellsForClassLevel(PCClass pcc) {
        if (!pcc.containsListFor(ListKey.KNOWN_SPELLS) || this.isImporting() || !this.getAutoSpells()) {
            return;
        }
        List<? extends CDOMList<Spell>> spellLists = this.getSpellLists(pcc);
        SpellSupportForPCClass spellSupport = this.getSpellSupport(pcc);
        spellSupport.calcCastPerDayMapForLevel(this);
        int maxCastableLevel = spellSupport.getMaxCastLevel();
        for (CDOMList<Spell> cDOMList : spellLists) {
            Iterator i$ = this.availSpellFacet.getScopes2(this.id, cDOMList).iterator();
            while (i$.hasNext()) {
                int spellLevel = (Integer)i$.next();
                if (spellLevel > maxCastableLevel) continue;
                for (Spell spell : this.availSpellFacet.getSet(this.id, cDOMList, spellLevel)) {
                    if (!spellSupport.isAutoKnownSpell(spell, spellLevel, true, this)) continue;
                    CharacterSpell cs = this.getCharacterSpellForSpell(pcc, spell, pcc);
                    if (cs == null) {
                        cs = new CharacterSpell(pcc, spell);
                        cs.addInfo(spellLevel, 1, Globals.getDefaultSpellBook());
                        this.addCharacterSpell(pcc, cs);
                        continue;
                    }
                    if (cs.getSpellInfoFor(Globals.getDefaultSpellBook(), spellLevel) != null) continue;
                    cs.addInfo(spellLevel, 1, Globals.getDefaultSpellBook());
                }
            }
        }
        for (Domain domain : this.getDomainSet()) {
            if (!pcc.getKeyName().equals(this.getDomainSource(domain).getPcclass().getKeyName())) continue;
            DomainApplication.addSpellsToClassForLevels(this, domain, pcc, 0, maxCastableLevel);
        }
    }

    public void removeKnownSpellsForClassLevel(PCClass pcc) {
        if (!pcc.containsListFor(ListKey.KNOWN_SPELLS) || this.isImporting() || !this.getAutoSpells()) {
            return;
        }
        if (!this.hasCharacterSpells(pcc)) {
            return;
        }
        SpellSupportForPCClass spellSupport = this.getSpellSupport(pcc);
        List<? extends CDOMList<Spell>> lists = this.getSpellLists(pcc);
        ArrayList<CharacterSpell> spellsToBeRemoved = new ArrayList<CharacterSpell>();
        for (CharacterSpell characterSpell : this.getCharacterSpells(pcc)) {
            Spell aSpell = characterSpell.getSpell();
            Integer[] spellLevels = SpellLevel.levelForKey(aSpell, lists, this);
            Integer i = 0;
            while (i < spellLevels.length) {
                boolean isKnownAtThisLevel;
                int spellLevel = spellLevels[i];
                if (spellLevel != -1 && !(isKnownAtThisLevel = spellSupport.isAutoKnownSpell(aSpell, spellLevel, true, this))) {
                    spellsToBeRemoved.add(characterSpell);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        for (CharacterSpell characterSpell : spellsToBeRemoved) {
            this.removeCharacterSpell(pcc, characterSpell);
        }
    }

    public void addTemplateFeat(CDOMObject template, CNAbilitySelection as) {
        this.templateFeatFacet.add(this.id, as, template);
    }

    public List<? extends CNAbilitySelection> getTemplateFeatList(CDOMObject template) {
        return this.templateFeatFacet.getSet(this.id, template);
    }

    public Collection<CNAbility> getCNAbilities() {
        HashSet<CNAbility> set = new HashSet<CNAbility>();
        set.addAll(this.grantedAbilityFacet.getCNAbilities(this.id));
        return set;
    }

    public Collection<CNAbility> getCNAbilities(Category<Ability> cat, Nature n) {
        if (!cat.getParentCategory().equals(cat)) {
            throw new IllegalArgumentException("Category for getCNAbilities must be parent category");
        }
        HashSet<CNAbility> set = new HashSet<CNAbility>();
        set.addAll(this.grantedAbilityFacet.getCNAbilities(this.id, cat, n));
        return set;
    }

    public List<?> getDetailedAssociations(ChooseDriver cd) {
        ChooseInformation<?> chooseInfo = cd.getChooseInfo();
        return chooseInfo.getChoiceActor().getCurrentlySelected(cd, this);
    }

    public List<CNAbility> getMatchingCNAbilities(Ability ability) {
        ArrayList<CNAbility> list = new ArrayList<CNAbility>();
        list.addAll(this.grantedAbilityFacet.getCNAbilities(this.id, ability));
        return list;
    }

    public List<CNAbility> getCNAbilities(Category<Ability> cat) {
        if (!cat.getParentCategory().equals(cat)) {
            throw new IllegalArgumentException("Category for getCNAbilities must be parent category, was: " + cat);
        }
        ArrayList<CNAbility> list = new ArrayList<CNAbility>();
        list.addAll(this.grantedAbilityFacet.getCNAbilities(this.id, cat));
        return list;
    }

    public List<CNAbility> getPoolAbilities(Category<Ability> cat) {
        ArrayList<CNAbility> list = new ArrayList<CNAbility>();
        list.addAll(this.grantedAbilityFacet.getPoolAbilities(this.id, cat));
        return list;
    }

    public Collection<CNAbility> getPoolAbilities(Category<Ability> cat, Nature n) {
        HashSet<CNAbility> set = new HashSet<CNAbility>();
        set.addAll(this.grantedAbilityFacet.getPoolAbilities(this.id, cat, n));
        return set;
    }

    public void addSavedAbility(CNAbilitySelection choice) {
        this.svAbilityFacet.add(this.id, choice);
    }

    public Collection<CNAbilitySelection> getSaveAbilities() {
        return this.svAbilityFacet.getSet(this.id);
    }

    public CNAbility getBonusLanguageAbility() {
        return this.bonusLanguageAbility;
    }

    public void setAllowInteraction(boolean b) {
        if (!b && !this.allowInteraction) {
            Logging.errorPrint("Internal Error: Re-entrant prohibition of interaction");
        }
        this.allowInteraction = b;
    }

    public boolean isAllowInteraction() {
        return this.allowInteraction;
    }

    public void associateSelection(AbilitySelection as, CNAbilitySelection cnas) {
        this.astocnasFacet.set(this.id, as, cnas);
    }

    public CNAbilitySelection getAssociatedSelection(AbilitySelection as) {
        return (CNAbilitySelection)this.astocnasFacet.get(this.id, as);
    }

    public void addSavedAbility(CNAbilitySelection cnas, Object owner, Object location) {
        this.svAbilityFacet.add(this.id, cnas);
        this.addAbility(cnas, owner, location);
    }

    public void addAbility(CNAbilitySelection cnas, Object owner, Object location) {
        if (cnas.hasPrerequisites()) {
            this.conditionalFacet.add(this.id, cnas, location);
        } else {
            this.directAbilityFacet.add(this.id, cnas, location);
        }
        if (!this.isImporting()) {
            AbilityUtilities.finaliseAbility(this, cnas);
        }
    }

    public void removeAbility(CNAbilitySelection cnas, Object owner, Object location) {
        if (cnas.hasPrerequisites()) {
            this.conditionalFacet.remove(this.id, cnas, location);
        } else {
            this.directAbilityFacet.remove(this.id, cnas, location);
        }
        CDOMObjectUtilities.removeAdds(cnas.getCNAbility().getAbility(), this);
        this.setDirty(true);
        this.calcActiveBonuses();
    }

    public void removeSavedAbility(CNAbilitySelection cnas, Object owner, Object location) {
        this.svAbilityFacet.remove(this.id, cnas);
        this.removeAbility(cnas, owner, location);
    }

    public List<String> getConsolidatedAssociationList(CDOMObject cdo) {
        if (cdo instanceof Ability) {
            ArrayList<String> list = new ArrayList<String>();
            List<CNAbility> cnabilities = this.getMatchingCNAbilities((Ability)cdo);
            for (CNAbility cna : cnabilities) {
                list.addAll(this.getAssociationList(cna));
            }
            return list;
        }
        if (cdo instanceof ChooseDriver) {
            return this.getAssociationList((ChooseDriver)((Object)cdo));
        }
        return Collections.emptyList();
    }

    public boolean hasAbilityInPool(AbilityCategory aCategory) {
        return this.grantedAbilityFacet.hasAbilityInPool(this.id, aCategory);
    }

    private static class CasterLevelSpellBonus {
        private int bonus;
        private String type;

        public CasterLevelSpellBonus(int b, String t) {
            this.bonus = b;
            this.type = t;
        }

        public int getBonus() {
            return this.bonus;
        }

        public String getType() {
            return this.type;
        }

        public void setBonus(int newBonus) {
            this.bonus = newBonus;
        }

        public String toString() {
            return "bonus: " + this.bonus + "    type: " + this.type;
        }
    }
}

