/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.facade.core.ChooserFacade;
import pcgen.system.LanguageBundle;
import pcgen.util.SignedInteger;
import pcgen.util.chooser.ChooserFactory;

public class EquipmentChoiceDriver {
    public static boolean getChoice(int pool, Equipment parent, EquipmentModifier eqMod, boolean bAdd, PlayerCharacter pc) {
        String choiceString = eqMod.getSafe(StringKey.CHOICE_STRING);
        if (choiceString.length() == 0) {
            return true;
        }
        boolean forEqBuilder = choiceString.startsWith("EQBUILDER.");
        if (bAdd && forEqBuilder) {
            return true;
        }
        ArrayList<Object> selectedList = new ArrayList<String>(parent.getAssociationList(eqMod));
        EquipmentChoice equipChoice = EquipmentChoiceDriver.buildEquipmentChoice(pool, parent, eqMod, bAdd, forEqBuilder, selectedList.size(), pc);
        int effectiveChoices = equipChoice.isBAdd() ? selectedList.size() + equipChoice.getMaxSelect() : selectedList.size();
        String title = LanguageBundle.getFormattedString("in_equipChoiceMod", equipChoice.getTitle(), eqMod.getDisplayName(), "|");
        CDOMChooserFacadeImpl<String> chooserFacade = new CDOMChooserFacadeImpl<String>(title, equipChoice.getAvailableList(), selectedList, effectiveChoices);
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        chooserFacade.setAllowsDups(equipChoice.isAllowDuplicates());
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        selectedList = chooserFacade.getFinalSelected();
        EquipmentChoiceDriver.setChoice(parent, eqMod, selectedList, equipChoice);
        return parent.hasAssociations(eqMod);
    }

    public static void setChoice(Equipment parent, EquipmentModifier eqMod, String choice, EquipmentChoice equipChoice) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(choice);
        EquipmentChoiceDriver.setChoice(parent, eqMod, tempList, equipChoice);
    }

    private static void setChoice(Equipment parent, EquipmentModifier eqMod, List<Object> selectedList, EquipmentChoice equipChoice) {
        parent.removeAllAssociations(eqMod);
        for (int i = 0; i < selectedList.size(); ++i) {
            int idx;
            String aString = String.valueOf(selectedList.get(i));
            if (equipChoice.getMinValue() < equipChoice.getMaxValue() && (idx = aString.indexOf(124)) < 0) {
                ArrayList<SignedInteger> secondaryChoice = new ArrayList<SignedInteger>();
                for (int j = equipChoice.getMinValue(); j <= equipChoice.getMaxValue(); j += equipChoice.getIncValue()) {
                    if (j == 0) continue;
                    secondaryChoice.add(new SignedInteger(j));
                }
                String title = LanguageBundle.getFormattedString("in_equipChoiceSelectMod", aString);
                CDOMChooserFacadeImpl chooserFacade = new CDOMChooserFacadeImpl(title, secondaryChoice, new ArrayList(), 1);
                chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
                chooserFacade.setAllowsDups(equipChoice.isAllowDuplicates());
                ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
                List chosenList = chooserFacade.getFinalSelected();
                if (chosenList.size() == 0) continue;
                aString = aString + '|' + ((SignedInteger)chosenList.get(0)).toString();
            }
            if (!equipChoice.isAllowDuplicates() && parent.containsAssociated(eqMod, aString)) continue;
            parent.addAssociation(eqMod, aString);
        }
    }

    public static EquipmentChoice buildEquipmentChoice(int pool, Equipment parent, EquipmentModifier eqMod, boolean bAdd, boolean forEqBuilder, int numSelected, PlayerCharacter pc) {
        EquipmentChoice equipChoice = new EquipmentChoice(bAdd, pool);
        String choiceString = eqMod.getSafe(StringKey.CHOICE_STRING);
        if (choiceString.length() == 0) {
            return equipChoice;
        }
        equipChoice.constructFromChoiceString(choiceString, parent, pool, numSelected, forEqBuilder, pc);
        return equipChoice;
    }
}

