/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.logging.LogRecord;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.CursorControlUtilities;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.util.StatusWorker;
import pcgen.gui2.util.SwingWorker;
import pcgen.system.PCGenTask;
import pcgen.util.Logging;

public final class PCGenStatusBar
extends JPanel {
    private PCGenFrame frame;
    private JLabel messageLabel;
    private JProgressBar progressBar;
    private JLabel loadStatusLabel;

    public PCGenStatusBar(PCGenFrame frame) {
        this.frame = frame;
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.loadStatusLabel = new JLabel();
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.messageLabel);
        this.add(Box.createHorizontalGlue());
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        this.add(this.progressBar);
        this.add(this.loadStatusLabel);
        this.loadStatusLabel.addMouseListener(new LoadStatusMouseAdapter());
    }

    public void setContextMessage(String message) {
        this.messageLabel.setText(message);
    }

    public String getContextMessage() {
        return this.messageLabel.getText();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setSourceLoadErrors(List<LogRecord> errors) {
        if (errors != null && !errors.isEmpty()) {
            int nerrors = 0;
            int nwarnings = 0;
            for (LogRecord logRecord : errors) {
                if (logRecord.getLevel().intValue() > Logging.WARNING.intValue()) {
                    ++nerrors;
                    continue;
                }
                if (logRecord.getLevel().intValue() <= Logging.INFO.intValue()) continue;
                ++nwarnings;
            }
            if (nerrors > 0) {
                this.loadStatusLabel.setIcon(Icons.Stop16.getImageIcon());
            } else if (nwarnings > 0) {
                this.loadStatusLabel.setIcon(Icons.Alert16.getImageIcon());
            } else {
                this.loadStatusLabel.setIcon(Icons.Ok16.getImageIcon());
            }
            this.loadStatusLabel.setToolTipText(nerrors + " errors and " + nwarnings + " warnings occurred while loading the sources");
        }
    }

    public SwingWorker<List<LogRecord>> createWorker(String taskName, PCGenTask task) {
        return new StatusWorker(taskName, task, this);
    }

    public PCGenFrame getFrame() {
        return this.frame;
    }

    public void startShowingProgress(String msg, boolean indeterminate) {
        if (!this.isValid()) {
            return;
        }
        this.setVisible(true);
        CursorControlUtilities.startWaitCursor(this);
        this.setContextMessage(msg);
        this.getProgressBar().setVisible(true);
        this.getProgressBar().setIndeterminate(indeterminate);
        this.getProgressBar().setStringPainted(true);
        this.getProgressBar().setString(msg);
    }

    public void endShowingProgress() {
        CursorControlUtilities.stopWaitCursor(this);
        this.setContextMessage(null);
        this.getProgressBar().setString(null);
        this.getProgressBar().setVisible(false);
    }

    private class LoadStatusMouseAdapter
    extends MouseAdapter {
        private LoadStatusMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            PCGenStatusBar.this.frame.getActionMap().get("tools.log").actionPerformed(null);
        }
    }
}

