/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.PCClass;
import pcgen.core.SubClass;
import pcgen.core.SubstitutionClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMCompatibilityToken;
import pcgen.rules.persistence.token.CDOMToken;
import pcgen.rules.persistence.token.ParseResult;

public class ClassWrappedToken
implements CDOMCompatibilityToken<PCClassLevel> {
    private static int wrapIndex = Integer.MIN_VALUE;
    private static final Integer ONE = 1;
    private final CDOMToken<PCClass> wrappedToken;
    private final int priority = wrapIndex++;

    @Override
    public Class<PCClassLevel> getTokenClass() {
        return PCClassLevel.class;
    }

    public ClassWrappedToken(CDOMToken<PCClass> tok) {
        this.wrappedToken = tok;
    }

    @Override
    public ParseResult parseToken(LoadContext context, PCClassLevel obj, String value) {
        if (ONE.equals(obj.get(IntegerKey.LEVEL))) {
            PCClass parent = (PCClass)obj.get(ObjectKey.TOKEN_PARENT);
            if (parent instanceof SubClass || parent instanceof SubstitutionClass) {
                return new ParseResult.Fail("Data used token: " + value + " which is a Class token, " + "but it was used in a class level for a " + parent.getClass().getSimpleName(), context);
            }
            return this.wrappedToken.parseToken(context, parent, value);
        }
        return new ParseResult.Fail("Data used token: " + value + " which is a Class token, " + "but it was used in a class level line other than level 1", context);
    }

    @Override
    public String getTokenName() {
        return this.wrappedToken.getTokenName();
    }

    @Override
    public int compatibilityLevel() {
        return 5;
    }

    @Override
    public int compatibilityPriority() {
        return this.priority;
    }

    @Override
    public int compatibilitySubLevel() {
        return 14;
    }
}

