/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.ExtendedHTMLDocument;
import gmgen.gui.ExtendedHTMLEditorKit;
import gmgen.gui.FlippingSplitPane;
import gmgen.gui.ImageFileChooser;
import gmgen.io.SimpleFileFilter;
import gmgen.util.LogReceiver;
import gmgen.util.LogUtilities;
import gmgen.util.MiscUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import pcgen.cdom.base.Constants;
import pcgen.core.SettingsHandler;
import pcgen.gui2.tools.CommonMenuText;
import pcgen.gui2.tools.Icons;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import plugin.notes.NotesPlugin;
import plugin.notes.gui.JIcon;
import plugin.notes.gui.NotesTreeNode;

public class NotesView
extends JPanel {
    private static final String EXTENSION = ".gmn";
    private static final String OPTION_NAME_LASTFILE = "Notes.LastFile";
    protected DropTarget editAreaDT;
    protected DropTarget filesBarDT;
    protected DropTarget treeDT;
    protected ExtendedHTMLEditorKit.InsertListAction actionListOrdered = new ExtendedHTMLEditorKit.InsertListAction("InsertOLItem", HTML.Tag.OL);
    protected ExtendedHTMLEditorKit.InsertListAction actionListUnordered = new ExtendedHTMLEditorKit.InsertListAction("InsertULItem", HTML.Tag.UL);
    protected NotesPlugin plugin;
    protected NotesTreeNode root;
    protected RedoAction redoAction = new RedoAction();
    protected File dataDir;
    protected UndoAction undoAction = new UndoAction();
    protected UndoManager undo = new UndoManager();
    protected final String[] extsIMG = new String[]{"gif", "jpg", "jpeg", "png"};
    private JButton boldButton;
    private JButton bulletButton;
    private JButton centerJustifyButton;
    private JButton colorButton;
    private JButton copyButton;
    private JButton cutButton;
    private JButton deleteButton;
    private JButton enumButton;
    private JButton exportButton;
    private JButton fileLeft;
    private JButton fileRight;
    private JButton imageButton;
    private JButton italicButton;
    private JButton leftJustifyButton;
    private JButton newButton;
    private JButton pasteButton;
    private JButton revertButton;
    private JButton rightJustifyButton;
    private JButton saveButton;
    private JButton underlineButton;
    private JComboBox sizeCB;
    private JPanel filePane;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private FlippingSplitPane jSplitPane1;
    private JTextPane editor;
    private JToolBar alignmentBar;
    private JToolBar clipboardBar;
    private JToolBar fileBar;
    private JToolBar filesBar;
    private JToolBar formatBar;
    private JTree notesTree;

    public NotesView(File dataDir, NotesPlugin plugin) {
        this.plugin = plugin;
        this.dataDir = dataDir;
        this.initComponents();
        this.initEditingComponents();
        this.initDnDComponents();
        this.initTree();
        this.initFileBar(new ArrayList<File>());
        this.initLogging();
        this.notesTree.setSelectionRow(0);
    }

    public Action getActionByName(JTextComponent textComponent, String name) {
        for (Action a : textComponent.getActions()) {
            if (!a.getValue("Name").equals(name)) continue;
            return a;
        }
        return null;
    }

    public void handleOpen() {
        String sFile = SettingsHandler.getGMGenOption(OPTION_NAME_LASTFILE, System.getProperty("user.dir"));
        File defaultFile = new File(sFile);
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(defaultFile);
        for (FileFilter filter : this.plugin.getFileTypes()) {
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
        }
        chooser.setMultiSelectionEnabled(true);
        GMGenSystem component = GMGenSystem.inst;
        Cursor originalCursor = component.getCursor();
        ((Component)component).setCursor(Cursor.getPredefinedCursor(3));
        int option = chooser.showOpenDialog(GMGenSystem.inst);
        if (option == 0) {
            for (File noteFile : chooser.getSelectedFiles()) {
                SettingsHandler.setGMGenOption(OPTION_NAME_LASTFILE, noteFile.toString());
                if (!noteFile.toString().endsWith(EXTENSION)) continue;
                this.openGMN(noteFile);
            }
        }
        GMGenSystem.inst.setCursor(originalCursor);
        this.refreshTree();
    }

    public void initEditMenu(JMenu editMenu) {
        JMenuItem paste = new JMenuItem();
        CommonMenuText.name(paste, "mnuEditPaste", new Object[0]);
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.pasteButtonActionPerformed(evt);
            }
        });
        editMenu.insert(paste, 0);
        JMenuItem copy = new JMenuItem();
        CommonMenuText.name(copy, "mnuEditCopy", new Object[0]);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.copyButtonActionPerformed(evt);
            }
        });
        editMenu.insert(copy, 0);
        JMenuItem cut = new JMenuItem();
        CommonMenuText.name(cut, "mnuEditCut", new Object[0]);
        cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.cutButtonActionPerformed(evt);
            }
        });
        editMenu.insert(cut, 0);
        editMenu.insertSeparator(0);
        editMenu.insert(this.redoAction, 0);
        editMenu.insert(this.undoAction, 0);
    }

    public void openGMN(File notesFile) {
        try {
            Object obj = this.notesTree.getLastSelectedPathComponent();
            if (obj instanceof NotesTreeNode) {
                ZipEntry e;
                int choice;
                NotesTreeNode node = (NotesTreeNode)obj;
                if (node != this.root && (choice = JOptionPane.showConfirmDialog(this, "Importing note " + notesFile.getName() + " into a node other then root, Continue?", "Importing to a node other then root", 0, 3)) == 1) {
                    return;
                }
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(notesFile));
                ZipInputStream zin = new ZipInputStream(in);
                ProgressMonitor pm = new ProgressMonitor(GMGenSystem.inst, "Reading Notes Export", "Reading", 1, 1000);
                int progress = 1;
                while ((e = zin.getNextEntry()) != null) {
                    this.unzip(zin, e.getName(), node.getDir());
                    if (++progress > 99) {
                        progress = 99;
                    }
                    pm.setProgress(progress);
                }
                zin.close();
                pm.close();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error Reading File" + notesFile.getName());
            Logging.errorPrint("Error Reading File" + notesFile.getName());
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    public void refreshTree() {
        this.root.refresh();
        this.notesTree.updateUI();
    }

    public void windowClosed() {
        if (this.root.isTreeDirty()) {
            GMGenSystemView.getTabPane().setSelectedComponent(this);
        }
        this.root.checkSave();
    }

    protected void exportFile(NotesTreeNode node) {
        JFileChooser fLoad = new JFileChooser();
        String sFile = SettingsHandler.getGMGenOption(OPTION_NAME_LASTFILE, "");
        new File(sFile);
        FileFilter ff = NotesPlugin.getFileType();
        fLoad.addChoosableFileFilter(ff);
        fLoad.setFileFilter(ff);
        int returnVal = fLoad.showSaveDialog(this);
        try {
            if (returnVal == 0) {
                int choice;
                File expFile;
                String fileName = fLoad.getSelectedFile().getName();
                String dirName = fLoad.getSelectedFile().getParent();
                String extension = EXTENSION;
                if (fileName.indexOf(extension) < 0) {
                    fileName = fileName + extension;
                }
                if ((expFile = new File(dirName + File.separator + fileName)).exists() && (choice = JOptionPane.showConfirmDialog(this, "File Exists, Overwrite?", "File Exists", 0, 3)) == 1) {
                    return;
                }
                SettingsHandler.setGMGenOption(OPTION_NAME_LASTFILE, expFile.toString());
                this.writeNotesFile(expFile, node);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error Writing File");
            Logging.errorPrint("Error Writing to file: " + e.getMessage(), e);
        }
    }

    protected int fileCount(File count) {
        int num = 0;
        for (File f : count.listFiles()) {
            if (f.isDirectory()) {
                num += this.fileCount(f);
                continue;
            }
            ++num;
        }
        return num;
    }

    protected void highlightButton(JButton button) {
        button.setBorder(new BevelBorder(1));
    }

    protected void performTextPaneAction(String name, ActionEvent evt) {
        Action action = this.getActionByName(this.editor, name);
        action.actionPerformed(evt);
        this.editor.grabFocus();
        int cp = this.editor.getCaretPosition();
        this.updateButtons(this.editor, cp);
    }

    protected void stdButton(JButton button) {
        button.setBorder(new EtchedBorder(1));
    }

    protected void unzip(ZipInputStream zin, String entry, File homeDir) throws IOException {
        File outFile = new File(homeDir.getPath() + File.separator + entry);
        File parentDir = outFile.getParentFile();
        parentDir.mkdirs();
        outFile.createNewFile();
        FileOutputStream out = new FileOutputStream(outFile);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
    }

    protected void updateButtons(JTextPane textPane, int pos) {
        StyledDocument doc = textPane.getStyledDocument();
        AttributeSet set = doc.getCharacterElement(pos - 1).getAttributes();
        AttributeSet set1 = doc.getCharacterElement(pos).getAttributes();
        if (StyleConstants.isBold(set) && StyleConstants.isBold(set1)) {
            this.highlightButton(this.boldButton);
        } else {
            this.stdButton(this.boldButton);
        }
        if (StyleConstants.isItalic(set) && StyleConstants.isItalic(set1)) {
            this.highlightButton(this.italicButton);
        } else {
            this.stdButton(this.italicButton);
        }
        if (StyleConstants.isUnderline(set) && StyleConstants.isUnderline(set1)) {
            this.highlightButton(this.underlineButton);
        } else {
            this.stdButton(this.underlineButton);
        }
        int align = StyleConstants.getAlignment(set);
        this.stdButton(this.leftJustifyButton);
        this.stdButton(this.rightJustifyButton);
        this.stdButton(this.centerJustifyButton);
        if (align == 0) {
            this.highlightButton(this.leftJustifyButton);
        } else if (align == 2) {
            this.highlightButton(this.rightJustifyButton);
        } else if (align == 1) {
            this.highlightButton(this.centerJustifyButton);
        }
        int fontSize = StyleConstants.getFontSize(set);
        for (int i = 0; i < this.sizeCB.getItemCount(); ++i) {
            String value = (String)this.sizeCB.getItemAt(i);
            if (!value.equals(Integer.toString(fontSize))) continue;
            this.sizeCB.setSelectedItem(value);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeNotesDir(ZipOutputStream out, File parentDir, File currentDir, ProgressMonitor pm, int progress) throws IOException {
        byte[] buffer = new byte[4096];
        int returnValue = progress;
        for (File f : currentDir.listFiles()) {
            if (pm.isCanceled()) {
                return 0;
            }
            if (f.isDirectory()) {
                returnValue = this.writeNotesDir(out, parentDir, f, pm, returnValue);
                continue;
            }
            FileInputStream in = new FileInputStream(f);
            try {
                int bytes_read;
                String parentPath = parentDir.getParentFile().getAbsolutePath();
                ZipEntry entry = new ZipEntry(f.getAbsolutePath().substring(parentPath.length() + 1));
                out.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            ++returnValue;
        }
        pm.setProgress(returnValue);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeNotesFile(File exportFile, NotesTreeNode node) throws IOException {
        File dir = node.getDir();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(exportFile));
        int max = this.fileCount(dir);
        ProgressMonitor pm = new ProgressMonitor(GMGenSystem.inst, "Writing out Notes Export", "Writing", 0, max);
        try {
            this.writeNotesDir(out, dir, dir, pm, 0);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
        pm.close();
    }

    private File getCurrentDir() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            return node.getDir();
        }
        return null;
    }

    private File getImageFromChooser(String startDir, String[] exts, String desc) {
        ImageFileChooser jImageDialog = new ImageFileChooser(startDir);
        jImageDialog.setDialogType(2);
        jImageDialog.setFileFilter(new SimpleFileFilter(exts, desc));
        jImageDialog.setDialogTitle("Select an Image to Insert");
        int optionSelected = 1;
        optionSelected = jImageDialog.showDialog(this, "Insert");
        if (optionSelected == 0) {
            return jImageDialog.getSelectedFile();
        }
        return null;
    }

    private void notesTreeNodesChanged() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            try {
                node.rename((String)node.getUserObject());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void boldButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("font-bold", evt);
    }

    private void centerJustifyButtonActionPerformed(ActionEvent evt) {
        StyledEditorKit.AlignmentAction action = new StyledEditorKit.AlignmentAction("Align Centre", 1);
        action.actionPerformed(evt);
        this.editor.grabFocus();
        int cp = this.editor.getCaretPosition();
        this.updateButtons(this.editor, cp);
    }

    private void colorButtonActionPerformed() {
        AttributeSet as = this.editor.getCharacterAttributes();
        SimpleAttributeSet sas = new SimpleAttributeSet(as);
        Color newColor = JColorChooser.showDialog(GMGenSystem.inst, "Choose Text Color", this.editor.getStyledDocument().getForeground(as));
        if (newColor != null) {
            StyleConstants.setForeground(sas, newColor);
            this.editor.setCharacterAttributes(sas, true);
        }
        this.editor.repaint();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("copy-to-clipboard", evt);
    }

    private void cutButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("cut-to-clipboard", evt);
    }

    private void deleteButtonActionPerformed() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            node.delete();
        }
        this.notesTree.updateUI();
    }

    private void editorCaretUpdate(CaretEvent evt) {
        int dot = evt.getDot();
        this.updateButtons(this.editor, dot);
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            if (node.isDirty()) {
                this.revertButton.setEnabled(true);
            } else {
                this.revertButton.setEnabled(false);
            }
        }
    }

    private void editorKeyTyped(KeyEvent evt) {
        this.editor.getCaretPosition();
        this.editor.getStyledDocument();
        if (evt.getKeyChar() == '\b') {
            this.handleBackspace();
        } else if (evt.getKeyChar() == '\n') {
            this.handleEnter();
        }
    }

    private void editorUndoableEditHappened(UndoableEditEvent e) {
        this.undo.addEdit(e.getEdit());
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    private void exportButtonActionPerformed() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            this.exportFile(node);
        }
    }

    private void fileLeftActionPerformed() {
        if (this.filesBar.getComponentCount() > 1) {
            Component c = this.filesBar.getComponent(this.filesBar.getComponentCount() - 1);
            this.filesBar.remove(c);
            this.filesBar.add(c, 0);
        }
        this.filesBar.updateUI();
    }

    private void fileRightActionPerformed() {
        if (this.filesBar.getComponentCount() > 1) {
            Component c = this.filesBar.getComponent(0);
            this.filesBar.remove(c);
            this.filesBar.add(c);
        }
        this.filesBar.updateUI();
    }

    private void handleBackspace() {
        int pos = this.editor.getCaretPosition();
        ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)this.editor.getStyledDocument();
        try {
            if (pos > 0) {
                if (this.editor.getSelectedText() != null) {
                    ExtendedHTMLEditorKit.delete(this.editor);
                    return;
                }
                int sOffset = htmlDoc.getParagraphElement(pos).getStartOffset();
                if (sOffset == this.editor.getSelectionStart()) {
                    boolean content = true;
                    if (ExtendedHTMLEditorKit.checkParentsTag(htmlDoc.getParagraphElement(this.editor.getCaretPosition()), HTML.Tag.LI)) {
                        int eo;
                        Element elem = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(this.editor.getCaretPosition()));
                        content = false;
                        int so = elem.getStartOffset();
                        if (so + 1 < (eo = elem.getEndOffset())) {
                            char[] temp = this.editor.getText(so, eo - so).toCharArray();
                            for (int i = 0; i < temp.length; ++i) {
                                if (Character.isWhitespace(temp[i])) continue;
                                content = true;
                            }
                        }
                        if (!content) {
                            elem.getParentElement();
                            ExtendedHTMLEditorKit.removeTag(this.editor, elem, true);
                            this.editor.setCaretPosition(sOffset - 1);
                            return;
                        }
                        this.editor.setCaretPosition(this.editor.getCaretPosition() - 1);
                        this.editor.moveCaretPosition(this.editor.getCaretPosition() - 2);
                        this.editor.replaceSelection("");
                        return;
                    }
                }
                this.editor.replaceSelection("");
                return;
            }
        }
        catch (BadLocationException ble) {
            Logging.errorPrint(ble.getMessage(), ble);
        }
    }

    private void handleEnter() {
        int pos = this.editor.getCaretPosition();
        int repos = -1;
        ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)this.editor.getStyledDocument();
        try {
            if (ExtendedHTMLEditorKit.checkParentsTag(htmlDoc.getParagraphElement(this.editor.getCaretPosition()), HTML.Tag.UL) || ExtendedHTMLEditorKit.checkParentsTag(htmlDoc.getParagraphElement(this.editor.getCaretPosition()), HTML.Tag.OL)) {
                Element elem = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(this.editor.getCaretPosition()));
                int so = elem.getStartOffset();
                int eo = elem.getEndOffset();
                char[] temp = this.editor.getText(so, eo - so).toCharArray();
                boolean content = false;
                for (int i = 0; i < temp.length; ++i) {
                    if (Character.isWhitespace(temp[i])) continue;
                    content = true;
                }
                if (content) {
                    int end = -1;
                    int j = temp.length;
                    do {
                        if (!Character.isLetterOrDigit(temp[--j])) continue;
                        end = j;
                    } while (end == -1 && j >= 0);
                    j = end;
                    do {
                        if (Character.isSpaceChar(temp[++j])) continue;
                        repos = j - end - 1;
                    } while (repos == -1 && j < temp.length);
                    if (repos == -1) {
                        repos = 0;
                    }
                }
                if (elem.getStartOffset() == elem.getEndOffset() || !content) {
                    this.manageListElement(htmlDoc);
                } else if (this.editor.getCaretPosition() + 1 == elem.getEndOffset()) {
                    ExtendedHTMLEditorKit.insertListElement(this.editor, "");
                    this.editor.setCaretPosition(pos - repos);
                } else {
                    int caret = this.editor.getCaretPosition();
                    String tempString = this.editor.getText(caret, eo - caret);
                    this.editor.select(caret, eo - 1);
                    this.editor.replaceSelection("");
                    ExtendedHTMLEditorKit.insertListElement(this.editor, tempString);
                    Element newLi = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(this.editor.getCaretPosition()));
                    this.editor.setCaretPosition(newLi.getEndOffset());
                }
            }
        }
        catch (BadLocationException ble) {
            Logging.errorPrint(ble.getMessage(), ble);
        }
    }

    private void imageButtonActionPerformed() {
        try {
            this.insertLocalImage(null);
        }
        catch (Exception e) {
            Logging.errorPrint(e.getMessage(), e);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new FlippingSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.notesTree = new JTree();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.editor = new JTextPane();
        this.jPanel2 = new JPanel();
        this.fileBar = new JToolBar();
        this.newButton = new JButton();
        this.saveButton = new JButton();
        this.exportButton = new JButton();
        this.revertButton = new JButton();
        this.deleteButton = new JButton();
        this.clipboardBar = new JToolBar();
        this.cutButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.formatBar = new JToolBar();
        this.sizeCB = new JComboBox();
        this.boldButton = new JButton();
        this.italicButton = new JButton();
        this.underlineButton = new JButton();
        this.colorButton = new JButton();
        this.bulletButton = new JButton();
        this.enumButton = new JButton();
        this.imageButton = new JButton();
        this.alignmentBar = new JToolBar();
        this.leftJustifyButton = new JButton();
        this.centerJustifyButton = new JButton();
        this.rightJustifyButton = new JButton();
        this.filePane = new JPanel();
        this.fileLeft = new JButton();
        this.fileRight = new JButton();
        this.filesBar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(175);
        this.jSplitPane1.setDividerSize(5);
        this.jScrollPane1.setViewportView(this.notesTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jPanel1.setLayout(new BorderLayout());
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                NotesView.this.editorCaretUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.editor);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.newButton.setIcon(Icons.stock_new.getImageIcon());
        this.newButton.setToolTipText("New Node");
        this.newButton.setBorder(new EtchedBorder());
        this.newButton.setEnabled(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.newButtonActionPerformed();
            }
        });
        this.fileBar.add(this.newButton);
        this.saveButton.setIcon(Icons.stock_save.getImageIcon());
        this.saveButton.setToolTipText("Save Node");
        this.saveButton.setBorder(new EtchedBorder());
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.saveButtonActionPerformed();
            }
        });
        this.fileBar.add(this.saveButton);
        this.exportButton.setIcon(Icons.stock_export.getImageIcon());
        this.exportButton.setToolTipText("Export");
        this.exportButton.setBorder(new EtchedBorder());
        this.exportButton.setEnabled(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.exportButtonActionPerformed();
            }
        });
        this.fileBar.add(this.exportButton);
        this.revertButton.setIcon(Icons.stock_revert.getImageIcon());
        this.revertButton.setToolTipText("Revert to Saved");
        this.revertButton.setBorder(new EtchedBorder());
        this.revertButton.setEnabled(false);
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.revertButtonActionPerformed();
            }
        });
        this.fileBar.add(this.revertButton);
        this.deleteButton.setIcon(Icons.stock_broken_image.getImageIcon());
        this.deleteButton.setToolTipText("Delete Node");
        this.deleteButton.setBorder(new EtchedBorder());
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.deleteButtonActionPerformed();
            }
        });
        this.fileBar.add(this.deleteButton);
        this.jPanel2.add(this.fileBar);
        this.cutButton.setIcon(Icons.stock_cut.getImageIcon());
        this.cutButton.setToolTipText("Cut");
        this.cutButton.setBorder(new EtchedBorder());
        this.cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.cutButtonActionPerformed(evt);
            }
        });
        this.clipboardBar.add(this.cutButton);
        this.copyButton.setIcon(Icons.stock_copy.getImageIcon());
        this.copyButton.setToolTipText("Copy");
        this.copyButton.setBorder(new EtchedBorder());
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.copyButtonActionPerformed(evt);
            }
        });
        this.clipboardBar.add(this.copyButton);
        this.pasteButton.setIcon(Icons.stock_paste.getImageIcon());
        this.pasteButton.setToolTipText("Paste");
        this.pasteButton.setBorder(new EtchedBorder());
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.pasteButtonActionPerformed(evt);
            }
        });
        this.clipboardBar.add(this.pasteButton);
        this.jPanel2.add(this.clipboardBar);
        this.sizeCB.setToolTipText("Size");
        this.sizeCB.setBorder(new EtchedBorder());
        this.sizeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.sizeCBActionPerformed(evt);
            }
        });
        this.formatBar.add(this.sizeCB);
        this.boldButton.setIcon(Icons.stock_text_bold.getImageIcon());
        this.boldButton.setToolTipText("Bold");
        this.boldButton.setBorder(new EtchedBorder());
        this.boldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.boldButtonActionPerformed(evt);
            }
        });
        this.formatBar.add(this.boldButton);
        this.italicButton.setIcon(Icons.stock_text_italic.getImageIcon());
        this.italicButton.setToolTipText("Italic");
        this.italicButton.setBorder(new EtchedBorder());
        this.italicButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.italicButtonActionPerformed(evt);
            }
        });
        this.formatBar.add(this.italicButton);
        this.underlineButton.setIcon(Icons.stock_text_underline.getImageIcon());
        this.underlineButton.setToolTipText("Underline");
        this.underlineButton.setBorder(new EtchedBorder());
        this.underlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.underlineButtonActionPerformed(evt);
            }
        });
        this.formatBar.add(this.underlineButton);
        this.colorButton.setForeground(new Color(0, 0, 0));
        this.colorButton.setIcon(Icons.createImageIcon("menu-mode-RGB-alt.png"));
        this.colorButton.setToolTipText("Color");
        this.colorButton.setBorder(new EtchedBorder());
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.colorButtonActionPerformed();
            }
        });
        this.formatBar.add(this.colorButton);
        this.bulletButton.setIcon(Icons.stock_list_bulet.getImageIcon());
        this.bulletButton.setToolTipText("Bulleted List");
        this.bulletButton.setAction(this.actionListUnordered);
        this.bulletButton.setBorder(new EtchedBorder());
        this.formatBar.add(this.bulletButton);
        this.enumButton.setIcon(Icons.stock_list_enum.getImageIcon());
        this.enumButton.setToolTipText("Numbered List");
        this.enumButton.setAction(this.actionListOrdered);
        this.enumButton.setBorder(new EtchedBorder());
        this.formatBar.add(this.enumButton);
        this.imageButton.setIcon(Icons.stock_insert_graphic.getImageIcon());
        this.imageButton.setBorder(new EtchedBorder());
        this.imageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.imageButtonActionPerformed();
            }
        });
        this.formatBar.add(this.imageButton);
        this.jPanel2.add(this.formatBar);
        this.leftJustifyButton.setIcon(Icons.stock_text_align_left.getImageIcon());
        this.leftJustifyButton.setToolTipText("Left Justify");
        this.leftJustifyButton.setBorder(new EtchedBorder());
        this.leftJustifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.leftJustifyButtonActionPerformed(evt);
            }
        });
        this.alignmentBar.add(this.leftJustifyButton);
        this.centerJustifyButton.setIcon(Icons.stock_text_align_center.getImageIcon());
        this.centerJustifyButton.setToolTipText("Center");
        this.centerJustifyButton.setBorder(new EtchedBorder());
        this.centerJustifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.centerJustifyButtonActionPerformed(evt);
            }
        });
        this.alignmentBar.add(this.centerJustifyButton);
        this.rightJustifyButton.setIcon(Icons.stock_text_align_right.getImageIcon());
        this.rightJustifyButton.setToolTipText("Right Justify");
        this.rightJustifyButton.setBorder(new EtchedBorder());
        this.rightJustifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.rightJustifyButtonActionPerformed(evt);
            }
        });
        this.alignmentBar.add(this.rightJustifyButton);
        this.jPanel2.add(this.alignmentBar);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.filePane.setLayout(new BoxLayout(this.filePane, 0));
        this.fileLeft.setText("<");
        this.fileLeft.setBorder(new EtchedBorder());
        this.fileLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.fileLeftActionPerformed();
            }
        });
        this.filePane.add(this.fileLeft);
        this.fileRight.setText(">");
        this.fileRight.setBorder(new EtchedBorder());
        this.fileRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesView.this.fileRightActionPerformed();
            }
        });
        this.filePane.add(this.fileRight);
        this.filePane.add(this.filesBar);
        this.jPanel1.add((Component)this.filePane, "South");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void initDnDComponents() {
        this.filesBarDT = new DropTarget(this.filesBar, new DropBarListener());
        this.treeDT = new DropTarget(this.notesTree, new DropTreeListener());
    }

    private void initEditingComponents() {
        this.bulletButton.setIcon(Icons.stock_list_bulet.getImageIcon());
        this.bulletButton.setToolTipText("Bulleted List");
        this.enumButton.setIcon(Icons.stock_list_enum.getImageIcon());
        this.enumButton.setToolTipText("Numbered List");
        this.enumButton.setText("");
        this.bulletButton.setText("");
        Vector<String> fontVector = new Vector<String>();
        fontVector.add("8");
        fontVector.add("10");
        fontVector.add("12");
        fontVector.add("14");
        fontVector.add("16");
        fontVector.add("18");
        fontVector.add("24");
        fontVector.add("36");
        fontVector.add("48");
        DefaultComboBoxModel cbModel = new DefaultComboBoxModel(fontVector);
        this.sizeCB.setModel(cbModel);
        this.sizeCB.setBorder(new EtchedBorder(1));
        this.stdButton(this.boldButton);
        this.stdButton(this.italicButton);
        this.stdButton(this.underlineButton);
        this.stdButton(this.colorButton);
        this.stdButton(this.leftJustifyButton);
        this.stdButton(this.centerJustifyButton);
        this.stdButton(this.rightJustifyButton);
        this.stdButton(this.newButton);
        this.stdButton(this.saveButton);
        this.stdButton(this.deleteButton);
        this.stdButton(this.cutButton);
        this.stdButton(this.copyButton);
        this.stdButton(this.pasteButton);
    }

    private void initFileBar(List<File> files) {
        this.filePane.removeAll();
        this.filesBar.removeAll();
        if (files.size() > 0) {
            this.filePane.add(this.fileLeft);
            this.filePane.add(this.fileRight);
            this.filePane.add(this.filesBar);
            for (File f : files) {
                this.filesBar.add(new JIcon(f, this.plugin));
            }
        }
        this.filePane.updateUI();
    }

    private void initLogging() {
        LogUtilities.inst().addReceiver(new NotesLogReciever());
    }

    private void initTree() {
        this.dataDir.listFiles();
        this.root = new NotesTreeNode(this.dataDir.getName(), this.dataDir, this.notesTree);
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.notesTree.setModel(model);
        this.notesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                NotesView.this.notesTreeActionPerformed();
            }
        });
        this.notesTree.getSelectionModel().setSelectionMode(1);
        this.notesTree.setEditable(true);
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                NotesView.this.notesTreeNodesChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    private void insertLocalImage(File whatImage) throws IOException, BadLocationException, RuntimeException {
        File dir;
        File newImage;
        File image = whatImage;
        if (whatImage == null && (newImage = this.getImageFromChooser((dir = this.getCurrentDir()).getPath(), this.extsIMG, "Image File")) != null && newImage.exists() && !(image = new File(dir.getAbsolutePath() + File.separator + newImage.getName())).exists()) {
            MiscUtilities.copy(newImage, image);
        }
        if (image != null) {
            int caretPos = this.editor.getCaretPosition();
            ExtendedHTMLEditorKit htmlKit = (ExtendedHTMLEditorKit)this.editor.getEditorKit();
            ExtendedHTMLDocument htmlDoc = (ExtendedHTMLDocument)this.editor.getStyledDocument();
            htmlKit.insertHTML(htmlDoc, caretPos, "<IMG SRC=\"" + image + "\">", 0, 0, HTML.Tag.IMG);
            this.editor.setCaretPosition(caretPos + 1);
        }
    }

    private void italicButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("font-italic", evt);
    }

    private void leftJustifyButtonActionPerformed(ActionEvent evt) {
        StyledEditorKit.AlignmentAction action = new StyledEditorKit.AlignmentAction("Left Justify", 0);
        action.actionPerformed(evt);
        this.editor.grabFocus();
        int cp = this.editor.getCaretPosition();
        this.updateButtons(this.editor, cp);
    }

    private void manageListElement(ExtendedHTMLDocument htmlDoc) {
        Element h = ExtendedHTMLEditorKit.getListItemParent(htmlDoc.getCharacterElement(this.editor.getCaretPosition()));
        h.getParentElement();
        ExtendedHTMLEditorKit.removeTag(this.editor, h, true);
    }

    private void newButtonActionPerformed() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            node.createChild();
        }
        this.refreshTree();
    }

    private void notesTreeActionPerformed() {
        this.refreshTreeNodes();
    }

    private void pasteButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("paste-from-clipboard", evt);
    }

    private void refreshTreeNodes() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            this.editor = node.getTextPane();
            this.root.checkCache();
            JViewport vp = new JViewport();
            vp.setView(this.editor);
            this.jScrollPane2.setViewport(vp);
            this.editAreaDT = new DropTarget(this.editor, new DropEditorListener());
            this.editor.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent evt) {
                    NotesView.this.editorCaretUpdate(evt);
                }
            });
            this.editor.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    NotesView.this.editorKeyTyped(e);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.editor.getStyledDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent evt) {
                    NotesView.this.editorUndoableEditHappened(evt);
                }
            });
            if (node.isLeaf()) {
                this.deleteButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
            }
            if (node == this.root) {
                this.exportButton.setEnabled(false);
            } else {
                this.exportButton.setEnabled(true);
            }
            if (node.isDirty()) {
                this.revertButton.setEnabled(true);
            } else {
                this.revertButton.setEnabled(false);
            }
            this.initFileBar(node.getFiles());
            this.saveButton.setEnabled(true);
            this.newButton.setEnabled(true);
        } else if (obj == null) {
            this.deleteButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.revertButton.setEnabled(false);
            this.newButton.setEnabled(false);
        }
    }

    private void revertButtonActionPerformed() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            node.revert();
            this.refreshTreeNodes();
            this.notesTree.updateUI();
        }
    }

    private void rightJustifyButtonActionPerformed(ActionEvent evt) {
        StyledEditorKit.AlignmentAction action = new StyledEditorKit.AlignmentAction("Right Justify", 2);
        action.actionPerformed(evt);
        this.editor.grabFocus();
        int cp = this.editor.getCaretPosition();
        this.updateButtons(this.editor, cp);
    }

    private void saveButtonActionPerformed() {
        Object obj = this.notesTree.getLastSelectedPathComponent();
        if (obj instanceof NotesTreeNode) {
            NotesTreeNode node = (NotesTreeNode)obj;
            node.save();
        }
        this.revertButton.setEnabled(false);
        this.notesTree.updateUI();
    }

    private void sizeCBActionPerformed(ActionEvent evt) {
        if (this.sizeCB.hasFocus()) {
            String fontS = (String)this.sizeCB.getSelectedItem();
            this.performTextPaneAction("font-size-" + fontS, evt);
        }
    }

    private void underlineButtonActionPerformed(ActionEvent evt) {
        this.performTextPaneAction("font-underline", evt);
    }

    private static String getLocalizedRedo() {
        return LanguageBundle.getString("in_mnuEditRedo");
    }

    private static String getLocalizedUndo() {
        return LanguageBundle.getString("in_mnuEditUndo");
    }

    protected class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(NotesView.getLocalizedUndo());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                NotesView.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                Logging.errorPrint("Unable to undo: " + ex.getMessage(), ex);
            }
            this.updateUndoState();
            NotesView.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (NotesView.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", NotesView.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", NotesView.getLocalizedUndo());
            }
        }
    }

    protected class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(NotesView.getLocalizedRedo());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                NotesView.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                Logging.errorPrint("Unable to redo: " + ex);
            }
            this.updateRedoState();
            NotesView.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (NotesView.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", NotesView.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", NotesView.getLocalizedRedo());
            }
        }
    }

    public class NotesLogReciever
    implements LogReceiver {
        NotesTreeNode log;

        @Override
        public void logMessage(String owner, String message) {
            if (this.log == null) {
                this.log = this.getChildNode("Logs", NotesView.this.root);
            }
            NotesTreeNode node = this.getChildNode(owner, this.log);
            DateFormat dateFmt = DateFormat.getDateTimeInstance(1, 1);
            node.appendText("<br>" + Constants.LINE_SEPARATOR + "<b>" + dateFmt.format(Calendar.getInstance().getTime()) + "</b> " + message);
        }

        @Override
        public void logMessage(String message) {
            this.logMessage("Misc", message);
        }

        private NotesTreeNode getChildNode(String name, NotesTreeNode parentNode) {
            Enumeration<MutableTreeNode> newNodes = parentNode.children();
            while (newNodes.hasMoreElements()) {
                NotesTreeNode node = (NotesTreeNode)newNodes.nextElement();
                if (!node.getUserObject().equals(NotesTreeNode.checkName(name))) continue;
                return node;
            }
            return parentNode.createChild(name);
        }
    }

    public class DropTreeListener
    extends DropListener {
        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point p = dtde.getLocation();
            TreePath path = NotesView.this.notesTree.getPathForLocation(p.x, p.y);
            if (path == null) {
                dtde.rejectDrop();
                return;
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof NotesTreeNode) {
                NotesTreeNode node = (NotesTreeNode)obj;
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.dropComplete(node.handleDropJavaFileList(dtde));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dtde.rejectDrop();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }

    public class DropEditorListener
    extends DropListener {
        public boolean isImageFile(File image) {
            for (int i = 0; i < NotesView.this.extsIMG.length; ++i) {
                if (!image.getName().endsWith(NotesView.this.extsIMG[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Object obj = NotesView.this.notesTree.getLastSelectedPathComponent();
            if (obj instanceof NotesTreeNode) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.dropComplete(this.handleDropJavaFileListAsImage(dtde));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dtde.rejectDrop();
                }
            } else {
                dtde.rejectDrop();
            }
        }

        public boolean handleDropJavaFileListAsImage(DropTargetDropEvent dtde) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable t = dtde.getTransferable();
            try {
                List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                File dir = NotesView.this.getCurrentDir();
                for (int i = 0; i < fileList.size(); ++i) {
                    File newFile = (File)fileList.get(i);
                    if (!newFile.exists()) continue;
                    File destFile = new File(dir.getAbsolutePath() + File.separator + newFile.getName());
                    if (!this.isImageFile(destFile) || !destFile.exists()) {
                        MiscUtilities.copy(newFile, destFile);
                    }
                    NotesView.this.editor.setCaretPosition(NotesView.this.editor.viewToModel(dtde.getLocation()));
                    this.handleImageDropInsertion(destFile);
                }
            }
            catch (Exception e) {
                Logging.errorPrint(e.getMessage(), e);
                return false;
            }
            return true;
        }

        public void handleImageDropInsertion(File image) {
            for (String s : NotesView.this.extsIMG) {
                if (!image.getName().endsWith(s)) continue;
                try {
                    NotesView.this.insertLocalImage(image);
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                }
                break;
            }
        }
    }

    public class DropBarListener
    extends DropListener {
        @Override
        public void drop(DropTargetDropEvent dtde) {
            Object obj = NotesView.this.notesTree.getLastSelectedPathComponent();
            if (obj instanceof NotesTreeNode) {
                NotesTreeNode node = (NotesTreeNode)obj;
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.dropComplete(node.handleDropJavaFileList(dtde));
                    NotesView.this.refreshTreeNodes();
                } else {
                    dtde.rejectDrop();
                }
            } else {
                dtde.rejectDrop();
            }
        }
    }

    public abstract class DropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public abstract void drop(DropTargetDropEvent var1);

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

