/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.LinkedList;
import java.util.List;
import pcgen.base.graph.base.GraphEdge;

public class DefaultGraphEdge<N>
implements GraphEdge<N> {
    private final N firstNode;
    private final N secondNode;

    public DefaultGraphEdge(N node1, N node2) {
        if (node1 == null) {
            throw new IllegalArgumentException("(First) GraphNode of DefaultGraphEdge cannot be null");
        }
        if (node2 == null) {
            throw new IllegalArgumentException("(Second) GraphNode of DefaultGraphEdge cannot be null");
        }
        this.firstNode = node1;
        this.secondNode = node2;
    }

    @Override
    public N getNodeAt(int index) {
        if (index == 0) {
            return this.firstNode;
        }
        if (index == 1) {
            return this.secondNode;
        }
        throw new IndexOutOfBoundsException("GraphEdge does not contain a Node at " + index);
    }

    @Override
    public N getOppositeNode(N node) {
        if (this.firstNode.equals(node)) {
            return this.secondNode;
        }
        if (this.secondNode.equals(node)) {
            return this.firstNode;
        }
        return null;
    }

    @Override
    public DefaultGraphEdge<N> createReplacementEdge(N node1, N node2) {
        return new DefaultGraphEdge<N>(node1, node2);
    }

    @Override
    public List<N> getAdjacentNodes() {
        LinkedList<N> l = new LinkedList<N>();
        l.add(this.firstNode);
        l.add(this.secondNode);
        return l;
    }

    @Override
    public boolean isAdjacentNode(N node) {
        return this.firstNode.equals(node) || this.secondNode.equals(node);
    }

    @Override
    public int getAdjacentNodeCount() {
        return 2;
    }
}

