/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.base.graph.base.Edge;
import pcgen.base.graph.base.Graph;
import pcgen.base.graph.base.GraphChangeListener;
import pcgen.base.graph.inst.GraphChangeSupport;

public class SimpleListGraph<N, ET extends Edge<N>>
implements Graph<N, ET> {
    private final List<N> nodeList;
    private final List<ET> edgeList = new ArrayList<ET>();
    private final GraphChangeSupport<N, ET> gcs;

    public SimpleListGraph() {
        this.nodeList = new ArrayList<N>();
        this.gcs = new GraphChangeSupport(this);
    }

    @Override
    public boolean addNode(N v) {
        if (v == null) {
            return false;
        }
        if (this.nodeList.contains(v)) {
            return false;
        }
        this.nodeList.add(v);
        this.gcs.fireGraphNodeChangeEvent(v, 0);
        return true;
    }

    @Override
    public boolean addEdge(ET e) {
        if (e == null) {
            return false;
        }
        if (this.edgeList.contains(e)) {
            return false;
        }
        List graphNodes = e.getAdjacentNodes();
        for (Object node : graphNodes) {
            if (this.nodeList.contains(node)) continue;
            this.addNode(node);
        }
        this.edgeList.add(e);
        this.gcs.fireGraphEdgeChangeEvent(e, 0);
        return true;
    }

    @Override
    public boolean containsNode(Object v) {
        return this.nodeList.contains(v);
    }

    @Override
    public boolean containsEdge(Edge<?> e) {
        return this.edgeList.contains(e);
    }

    @Override
    public List<N> getNodeList() {
        return new ArrayList<N>(this.nodeList);
    }

    @Override
    public List<ET> getEdgeList() {
        return new ArrayList<ET>(this.edgeList);
    }

    @Override
    public boolean removeNode(N gn) {
        if (gn == null) {
            return false;
        }
        if (!this.containsNode(gn)) {
            return false;
        }
        boolean successful = true;
        for (Edge edge : this.getAdjacentEdges((Object)gn)) {
            successful &= this.removeEdge(edge);
        }
        if (successful) {
            successful &= this.nodeList.remove(gn);
        }
        if (successful) {
            this.gcs.fireGraphNodeChangeEvent(gn, 1);
        }
        return successful;
    }

    @Override
    public boolean removeEdge(ET ge) {
        if (ge == null) {
            return false;
        }
        if (this.edgeList.remove(ge)) {
            this.gcs.fireGraphEdgeChangeEvent(ge, 1);
            return true;
        }
        return false;
    }

    @Override
    public Set<ET> getAdjacentEdges(N gn) {
        if (!this.containsNode(gn)) {
            return null;
        }
        HashSet<Edge> adjacentEdgeList = new HashSet<Edge>();
        block0: for (Edge ge : this.edgeList) {
            List graphNodes = ge.getAdjacentNodes();
            for (Object node : graphNodes) {
                if (!node.equals(gn)) continue;
                adjacentEdgeList.add(ge);
                continue block0;
            }
        }
        return adjacentEdgeList;
    }

    @Override
    public void addGraphChangeListener(GraphChangeListener<N, ET> arg0) {
        this.gcs.addGraphChangeListener(arg0);
    }

    @Override
    public GraphChangeListener<N, ET>[] getGraphChangeListeners() {
        return this.gcs.getGraphChangeListeners();
    }

    @Override
    public void removeGraphChangeListener(GraphChangeListener<N, ET> arg0) {
        this.gcs.removeGraphChangeListener(arg0);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph otherGraph = (Graph)other;
        List otherNodeList = otherGraph.getNodeList();
        int thisNodeSize = this.nodeList.size();
        if (thisNodeSize != otherNodeList.size()) {
            return false;
        }
        if ((otherNodeList = new ArrayList(otherNodeList)).retainAll(this.nodeList)) {
            return false;
        }
        List otherEdgeList = otherGraph.getEdgeList();
        int thisEdgeSize = this.edgeList.size();
        if (thisEdgeSize != otherEdgeList.size()) {
            return false;
        }
        return !(otherEdgeList = new ArrayList(otherEdgeList)).retainAll(this.edgeList);
    }

    @Override
    public int hashCode() {
        return this.nodeList.size() + this.edgeList.size() * 23;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeList.isEmpty() && this.edgeList.isEmpty();
    }

    @Override
    public int getNodeCount() {
        return this.nodeList.size();
    }

    @Override
    public void clear() {
        this.nodeList.clear();
        this.edgeList.clear();
    }
}

