/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.Capacity;
import pcgen.core.Equipment;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.BigDecimalHelper;

public class ContainsToken
extends AbstractTokenWithSeparator<Equipment>
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "CONTAINS";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Equipment eq, String value) {
        BigDecimal weightCap;
        int percentLoc;
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        context.getObjectContext().removeList((CDOMObject)eq, ListKey.CAPACITY);
        String weightCapacity = pipeTok.nextToken();
        boolean hadAsterisk = false;
        if (weightCapacity.charAt(0) == '*') {
            hadAsterisk = true;
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.CONTAINER_CONSTANT_WEIGHT, (Object)Boolean.TRUE);
            weightCapacity = weightCapacity.substring(1);
        }
        if ((percentLoc = weightCapacity.indexOf("%")) != weightCapacity.lastIndexOf("%")) {
            return new ParseResult.Fail("Cannot have two weight reduction characters (indicated by %): " + value, context);
        }
        if (percentLoc != -1) {
            if (hadAsterisk) {
                return new ParseResult.Fail("Cannot have Constant Weight (indicated by *) and weight reduction (indicated by %): " + value, context);
            }
            String redString = weightCapacity.substring(0, percentLoc);
            weightCapacity = weightCapacity.substring(percentLoc + 1);
            try {
                context.getObjectContext().put((CDOMObject)eq, IntegerKey.CONTAINER_REDUCE_WEIGHT, Integer.valueOf(redString));
            }
            catch (NumberFormatException ex) {
                return new ParseResult.Fail("Weight Reduction (indicated by %) must be an integer: " + value, context);
            }
        }
        if ("UNLIM".equals(weightCapacity)) {
            weightCap = Capacity.UNLIMITED;
        } else {
            try {
                weightCap = BigDecimalHelper.trimBigDecimal((BigDecimal)new BigDecimal(weightCapacity));
                if (BigDecimal.ZERO.compareTo(weightCap) > 0) {
                    return new ParseResult.Fail("Weight Capacity must be >= 0: " + weightCapacity + "\n  Use 'UNLIM' (not -1) for unlimited Count", context);
                }
            }
            catch (NumberFormatException ex) {
                return new ParseResult.Fail("Weight Capacity must be 'UNLIM or a number >= 0: " + weightCapacity, context);
            }
        }
        context.getObjectContext().put((CDOMObject)eq, ObjectKey.CONTAINER_WEIGHT_CAPACITY, (Object)weightCap);
        Capacity totalCap = null;
        boolean limited = true;
        if (!pipeTok.hasMoreTokens()) {
            limited = false;
            totalCap = Capacity.ANY;
        }
        BigDecimal limitedCapacity = BigDecimal.ZERO;
        while (pipeTok.hasMoreTokens()) {
            BigDecimal itemNumber;
            String typeString = pipeTok.nextToken();
            int equalLoc = typeString.indexOf("=");
            if (equalLoc != typeString.lastIndexOf("=")) {
                return new ParseResult.Fail("Two many = signs", context);
            }
            if (equalLoc == -1) {
                limited = false;
                context.getObjectContext().addToList((CDOMObject)eq, ListKey.CAPACITY, (Object)new Capacity(typeString, Capacity.UNLIMITED));
                continue;
            }
            String itemType = typeString.substring(0, equalLoc);
            String itemNumString = typeString.substring(equalLoc + 1);
            if ("UNLIM".equals(itemNumString)) {
                limited = false;
                itemNumber = Capacity.UNLIMITED;
            } else {
                try {
                    itemNumber = BigDecimalHelper.trimBigDecimal((BigDecimal)new BigDecimal(itemNumString));
                }
                catch (NumberFormatException ex) {
                    return new ParseResult.Fail("Item Number for " + itemType + " must be 'UNLIM' or a number > 0: " + itemNumString, context);
                }
                if (BigDecimal.ZERO.compareTo(itemNumber) >= 0) {
                    return new ParseResult.Fail("Cannot have negative quantity of " + itemType + ": " + value, context);
                }
            }
            if (limited) {
                limitedCapacity = limitedCapacity.add(itemNumber);
            }
            context.getObjectContext().addToList((CDOMObject)eq, ListKey.CAPACITY, (Object)new Capacity(itemType, itemNumber));
        }
        if (totalCap == null) {
            BigDecimal totalCapacity = limited ? limitedCapacity : Capacity.UNLIMITED;
            totalCap = Capacity.getTotalCapacity((BigDecimal)totalCapacity);
        }
        context.getObjectContext().put((CDOMObject)eq, ObjectKey.TOTAL_CAPACITY, (Object)totalCap);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        BigDecimal cap;
        Integer reducePercent;
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)eq, ListKey.CAPACITY);
        Capacity totalCapacity = (Capacity)context.getObjectContext().getObject((CDOMObject)eq, ObjectKey.TOTAL_CAPACITY);
        if (totalCapacity == null && (changes == null || changes.isEmpty())) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Boolean b = (Boolean)context.getObjectContext().getObject((CDOMObject)eq, ObjectKey.CONTAINER_CONSTANT_WEIGHT);
        if (b != null && b.booleanValue()) {
            sb.append('*');
        }
        if ((reducePercent = context.getObjectContext().getInteger((CDOMObject)eq, IntegerKey.CONTAINER_REDUCE_WEIGHT)) != null) {
            sb.append(reducePercent).append("%");
        }
        if ((cap = (BigDecimal)context.getObjectContext().getObject((CDOMObject)eq, ObjectKey.CONTAINER_WEIGHT_CAPACITY)) == null) {
            return null;
        }
        if (Capacity.UNLIMITED.equals(cap)) {
            sb.append("UNLIM");
        } else {
            sb.append(cap);
        }
        Collection capacityList = changes.getAdded();
        if (capacityList == null && Capacity.UNLIMITED.equals(totalCapacity.getCapacity())) {
            return new String[]{sb.toString()};
        }
        BigDecimal limitedCapacity = BigDecimal.ZERO;
        boolean limited = true;
        for (Capacity c : capacityList) {
            String capType = c.getType();
            sb.append("|");
            BigDecimal thisCap = c.getCapacity();
            sb.append(capType);
            if (Capacity.UNLIMITED.equals(thisCap)) {
                limited = false;
                continue;
            }
            if (limited) {
                limitedCapacity = limitedCapacity.add(thisCap);
            }
            sb.append("=").append(thisCap);
        }
        if (!limitedCapacity.equals(totalCapacity.getCapacity()) && !Capacity.UNLIMITED.equals(totalCapacity.getCapacity())) {
            sb.append("Total").append("=").append(totalCapacity.getCapacity());
        }
        return new String[]{sb.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

