//**************************************************************************************************
//                                          PrcCalc.cpp                                            *
//                                         -------------                                           *
// Started     : 2020-09-30                                                                        *
// Last Update : 2020-09-30                                                                        *
// Copyright   : (C) 2020-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#include "PrcCalc.hpp"

//**************************************************************************************************
// Allocate storage for static data members.

wxArrayString  PrcCalc::m_osaCalcBinLst;

//**************************************************************************************************
// Constructor.

PrcCalc::PrcCalc( void ) : PrcBase( wxPROCESS_REDIRECT )
{
}

//**************************************************************************************************
// Destructor.

PrcCalc::~PrcCalc( )
{
}

//**************************************************************************************************
// Load the class list attribute m_osaCalcBinLst with possible calculator binary names.

void  PrcCalc::InitCalcBinLst( void )
{
  SysScan  oSysScan;
  int      i1;

  // Load the binary list with all possible calculator application binaries
#ifndef __WXMSW__
  m_osaCalcBinLst.Add( "extcalc" );
  m_osaCalcBinLst.Add( "free42" );
  m_osaCalcBinLst.Add( "galculator" );
  m_osaCalcBinLst.Add( "hpprime" );
  m_osaCalcBinLst.Add( "kcalc" );
  m_osaCalcBinLst.Add( "nonpareil" );
  m_osaCalcBinLst.Add( "qalculate" );
  m_osaCalcBinLst.Add( "rpcalc" );
  m_osaCalcBinLst.Add( "speedcrunch" );
  m_osaCalcBinLst.Add( "xcalc" );
#else
  m_osaCalcBinLst.Add( "extcalc.exe" );
  m_osaCalcBinLst.Add( "free42.exe" );
  m_osaCalcBinLst.Add( "galculator.exe" );
  m_osaCalcBinLst.Add( "hpprime.exe" );
  m_osaCalcBinLst.Add( "kcalc.exe" );
  m_osaCalcBinLst.Add( "nonpareil.exe" );
  m_osaCalcBinLst.Add( "qalculate.exe" );
  m_osaCalcBinLst.Add( "rpcalc.exe" );
  m_osaCalcBinLst.Add( "speedcrunch.exe" );
  m_osaCalcBinLst.Add( "xcalc.exe" );
#endif // __WXMSW__

  // Delete from the binary list any that aren't currently installed on the system
  // (need to go thro. the list backwards otherwise item positions change when an item is deleted)
  for( i1=m_osaCalcBinLst.GetCount( )-1; i1>=0; i1-- )
    if( ! oSysScan.bIsInstalled( m_osaCalcBinLst.Item( (size_t) i1 ) ) )
      m_osaCalcBinLst.RemoveAt( (size_t) i1 );
}

//**************************************************************************************************
// Start the calculator application.
//
// Return Values:
//   true  - Success
//   false - Failure

bool  PrcCalc::bExec( void )
{
  wxString  os1;

  // Execute the process
  if( ! PrcBase::bExecAsync( ) ) return( false );

  return( true );
}

//**************************************************************************************************
