/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeSelection;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.CommandlineRunnable;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class ASEvaluation
implements Serializable,
CapabilitiesHandler,
CapabilitiesIgnorer,
RevisionHandler,
CommandlineRunnable,
OptionHandler {
    private static final long serialVersionUID = 2091705669885950849L;
    protected boolean m_DoNotCheckCapabilities = false;

    public String doNotCheckCapabilitiesTipText() {
        return "If set, evaluator capabilities are not checked before evaluator is built (Use with caution to reduce runtime).";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = Option.listOptionsForClassHierarchy(this.getClass(), ASEvaluation.class);
        result.addElement(new Option("\tIf set, evaluator capabilities are not checked before evaluator is built\n\t(use with caution).", "-do-not-check-capabilities", 0, "-do-not-check-capabilities"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        Option.setOptionsForHierarchy(options, this, ASEvaluation.class);
        this.setDoNotCheckCapabilities(Utils.getFlag("do-not-check-capabilities", options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        for (String s : Option.getOptionsForHierarchy(this, ASEvaluation.class)) {
            result.add(s);
        }
        if (this.getDoNotCheckCapabilities()) {
            result.add("-do-not-check-capabilities");
        }
        return result.toArray(new String[result.size()]);
    }

    public abstract void buildEvaluator(Instances var1) throws Exception;

    public int[] postProcess(int[] attributeSet) throws Exception {
        return attributeSet;
    }

    public static ASEvaluation forName(String evaluatorName, String[] options) throws Exception {
        return (ASEvaluation)Utils.forName(ASEvaluation.class, evaluatorName, options);
    }

    public static ASEvaluation[] makeCopies(ASEvaluation model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model evaluator set");
        }
        ASEvaluation[] evaluators = new ASEvaluation[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < evaluators.length; ++i) {
            evaluators[i] = (ASEvaluation)so.getObject();
        }
        return evaluators;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAll();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 15520 $");
    }

    public void clean() {
    }

    public static void runEvaluator(ASEvaluation evaluator, String[] options) {
        try {
            evaluator.preExecution();
            System.out.println(AttributeSelection.SelectAttributes(evaluator, options));
        }
        catch (Exception e) {
            String msg = e.toString().toLowerCase();
            if (msg.indexOf("help requested") == -1 && msg.indexOf("no training file given") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
        try {
            evaluator.postExecution();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void run(Object toRun, String[] options) throws Exception {
        if (!(toRun instanceof ASEvaluation)) {
            throw new IllegalArgumentException("Object to run is not an instance of ASEValuation!");
        }
        this.preExecution();
        ASEvaluation.runEvaluator((ASEvaluation)toRun, options);
        this.postExecution();
    }

    @Override
    public void postExecution() throws Exception {
    }
}

