/* 
    TowBowlTactics: Adaptation of the tabletop game Blood Bowl

    Copyright (C) 2001-2003 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SQUARE_H
#define SQUARE_H

#include "global.h"

/**
 * Classe representant un case sur le plateau de jeu
 * @doc 
 * @author Toweld
 * @version 0.5
 */

class Square{
 public:
	/**
	* Constructeur par defaut
	*/
	Square();
	/**
	* Constructeur a 2 parametres
	* @param a abscisse de la case
	* @param b ordonnee de la case
	*/
	Square(int,int);

	~Square(void);
	/**
	* Obtenir l'abscisse d'une case
	* @return abscissse 
	*/
	int get_x();
	/**
	* Obtenir l'ordonnee d'une case
	* @return ordonnee
	*/
	int get_y();
	/**
	* Definir l'absicsse d'une case
	* @param a abscisse
	*/
	void set_x(int);
	/**
	* Definir l'ordonnee d'une case
	* @param a ordonnee
	*/
	void set_y(int);
	/**
	* Definir l'absicsse/ordonnee d'une case
	* @param a abscisse
	* @param b ordonnee
	*/
	void set_xy(int,int);
	/**
	* Operateur de comparaison de deux cases (en friendly) 
	* @param s1 premiere operande
	* @param s2 premiere operande
	* @return true, si abscisses ET ordonnees egales
	*/
	friend int operator == (Square&,Square&);
  
	void move(int,int);

	void save_state(FILE *,int);

protected:
	int x;
	int y;
};
#endif












