/*
 * Decompiled with CFR 0.152.
 */
package net.yura.lobby.model;

import java.util.HashSet;
import java.util.Set;
import net.yura.lobby.model.GameType;
import net.yura.lobby.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Game
implements Comparable<Game> {
    public static final int STATE_CAN_JOIN = 1;
    public static final int STATE_CAN_LEAVE = 2;
    public static final int STATE_CAN_WATCH = 3;
    public static final int STATE_CAN_PLAY = 4;
    private String name;
    private GameType type;
    private int maxPlayers;
    private int gameID = -1;
    private String options;
    private Set players = new HashSet();
    private int timeout;
    private String whosTurn;
    private int inGame = -1;

    public Game() {
    }

    public Game(String name, String options, int maxPlayers, int timeout) {
        this.name = name;
        this.options = options;
        this.maxPlayers = maxPlayers;
        this.timeout = timeout;
    }

    public void setId(int gameID) {
        this.gameID = gameID;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setType(GameType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public GameType getType() {
        return this.type;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getId() {
        return this.gameID;
    }

    public String getOptions() {
        return this.options;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getWhosTurn() {
        return this.whosTurn;
    }

    public void setWhosTurn(String whosTurn) {
        this.whosTurn = whosTurn;
    }

    public int getInGame() {
        return this.inGame;
    }

    public void setInGame(int inGame) {
        this.inGame = inGame;
    }

    public Set getPlayers() {
        return this.players;
    }

    public void setPlayers(Set players) {
        this.players = players;
    }

    public int getNumOfPlayers() {
        return this.players.size();
    }

    public boolean hasPlayer(String username) {
        for (Player player : this.players) {
            if (!player.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public int getState(String myusername) {
        boolean hasPlayer = this.hasPlayer(myusername);
        int state = this.getNumOfPlayers() < this.getMaxPlayers() ? (hasPlayer ? 2 : 1) : (hasPlayer ? 4 : 3);
        return state;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Game other = (Game)obj;
        return this.gameID == other.gameID;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.gameID;
        return hash;
    }

    @Override
    public int compareTo(Game o) {
        return o.gameID - this.gameID;
    }
}

