/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceLabel;

public class ChoiceGroup
extends Item
implements Choice {
    private int type;
    private Vector group;
    private int fitPolicy;
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            ChoiceGroup.this.notifyChanged();
        }
    };

    public ChoiceGroup(String label, int type) {
        super(label);
        this.type = type;
        if (type == 1 || type == 4) {
            this.group = new Vector();
        }
    }

    public ChoiceGroup(String label, int type, String[] stringItems, Image[] imageItems) {
        this(label, type);
        for (int i = 0; i < stringItems.length; ++i) {
            this.append(stringItems[i], imageItems == null ? null : imageItems[i]);
        }
    }

    private ScmDeviceLabel getLabel(int i) {
        return (ScmDeviceLabel)this.lines.elementAt(i + 1);
    }

    public int append(String stringItem, Image imageItem) {
        this.insert(this.size(), stringItem, imageItem);
        return this.size() - 1;
    }

    public void delete(int index) {
        int i = this.delete();
        if (this.group != null) {
            this.group.removeElementAt(index);
        }
        this.lines.removeElementAt(index + 1);
        if (i != -1) {
            this.form.insert(i, this);
        }
        this.readd(i);
    }

    public void deleteAll() {
        while (this.size() > 0) {
            this.delete(this.size() - 1);
        }
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public Font getFont(int elementNum) {
        Font font = this.getLabel((int)elementNum).midpFont;
        return font == null ? Font.getFont(0, 0, 0) : font;
    }

    public Image getImage(int index) {
        return (Image)this.getLabel((int)index).object;
    }

    public int getSelectedFlags(boolean[] flags) {
        int i;
        int count = 0;
        for (i = 0; i < this.size(); ++i) {
            flags[i] = this.getLabel(i).selected();
            if (!flags[i]) continue;
            ++count;
        }
        for (i = this.size(); i < flags.length; ++i) {
            flags[i] = false;
        }
        return count;
    }

    public int getSelectedIndex() {
        if (this.type != 2) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.getLabel(i).selected()) continue;
                return i;
            }
        }
        return -1;
    }

    public String getString(int index) {
        return this.getLabel(index).getText();
    }

    public void insert(int index, String stringItem, Image imageItem) {
        int i = this.delete();
        ScmDeviceLabel cb = new ScmDeviceLabel("choiceGroup", this, true);
        cb.addActionListener(this.listener);
        cb.selectButtonRequired = true;
        cb.checkbox = true;
        if (imageItem != null) {
            cb.image = imageItem._image;
            cb.object = imageItem;
        }
        cb.setText(stringItem);
        cb.highlight = true;
        if (this.group != null) {
            this.group.insertElementAt(cb, index);
            cb.group = this.group;
            if (this.group.size() == 1) {
                cb.select(true);
            }
        }
        this.lines.insertElementAt(cb, index + 1);
        cb.invalidate();
        this.readd(i);
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).selected();
    }

    public void set(int index, String str, Image img) {
        boolean sel = this.isSelected(index);
        this.delete(index);
        this.insert(index, str, img);
        this.setSelectedIndex(index, sel);
    }

    public void setFitPolicy(int fitPolicy) {
        this.fitPolicy = fitPolicy;
    }

    public void setFont(int elementNum, Font font) {
        this.getLabel((int)elementNum).midpFont = font;
    }

    public void setLabel(int index, String s) {
        this.getLabel(index).setText(s);
    }

    public void setSelectedFlags(boolean[] flags) {
        boolean notify = false;
        for (int i = 0; i < this.size(); ++i) {
            if (flags[i] != this.getLabel((int)i).selected) {
                this.getLabel(i).select(flags[i]);
                notify = true;
            }
            if (!flags[i] || this.group == null) continue;
            this.notifyChanged();
            return;
        }
        if (this.group != null && this.size() > 0) {
            this.setSelectedIndex(0, true);
        } else if (notify) {
            this.notifyChanged();
        }
    }

    public void setSelectedIndex(int index, boolean state) {
        if (this.getLabel((int)index).selected == state) {
            return;
        }
        this.getLabel(index).select(state);
        this.notifyChanged();
    }

    public int size() {
        return this.lines.size() - 1;
    }
}

