/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.chunk;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

record ChunkOperation(Operation operation, URI src, URI dst, String id, Element topicref, List<ChunkOperation> children) {
    @Override
    public String toString() {
        return "ChunkOperation{operation=" + String.valueOf((Object)this.operation) + ", src=" + String.valueOf(this.src) + ", dst=" + String.valueOf(this.dst) + ", id=" + this.id + ", children=" + String.valueOf(this.children) + "}";
    }

    public static ChunkBuilder builder(Operation operation) {
        return new ChunkBuilder(operation);
    }

    public static enum Operation {
        COMBINE("combine"),
        SPLIT("split");

        public final String name;

        private Operation(String name) {
            this.name = name;
        }
    }

    public static class ChunkBuilder {
        private final Operation operation;
        private URI src;
        private URI dst;
        private String id;
        private Element topicref;
        private List<ChunkBuilder> children = new ArrayList<ChunkBuilder>();

        public ChunkBuilder(Operation operation) {
            this.operation = operation;
        }

        public ChunkBuilder(ChunkOperation orig) {
            this.operation = orig.operation;
            this.src = orig.src;
            this.dst = orig.dst;
            this.id = orig.id;
            this.topicref = orig.topicref;
            this.children = orig.children.stream().map(ChunkBuilder::new).collect(Collectors.toList());
        }

        public ChunkBuilder src(URI src) {
            this.src = src;
            return this;
        }

        public ChunkBuilder dst(URI dst) {
            this.dst = dst;
            return this;
        }

        public ChunkBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ChunkBuilder topicref(Element topicref) {
            this.topicref = topicref;
            return this;
        }

        public ChunkBuilder addChild(ChunkBuilder child) {
            this.children.add(child);
            return this;
        }

        public ChunkOperation build() {
            URI src = this.src;
            URI dst = this.dst;
            List<ChunkOperation> cos = this.children.stream().map(ChunkBuilder::build).toList();
            return new ChunkOperation(this.operation, src, dst, this.id, this.topicref, cos);
        }
    }
}

