/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.common.impl.lc;

import org.apache.groovy.contracts.common.base.BaseLifecycle;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.generation.ClassInvariantGenerator;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;

public class ClassInvariantLifecycle
extends BaseLifecycle {
    @Override
    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!CandidateChecks.isClassInvariantCandidate(classNode, methodNode)) {
            return;
        }
        if (processingContextInformation.contract().hasDefaultClassInvariant()) {
            return;
        }
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(processingContextInformation.readerSource());
        classInvariantGenerator.addInvariantAssertionStatement(classNode, methodNode);
    }

    @Override
    public void afterProcessingConstructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        if (!CandidateChecks.isClassInvariantCandidate(classNode, constructorNode)) {
            return;
        }
        if (!processingContextInformation.isConstructorAssertionsEnabled()) {
            return;
        }
        if (processingContextInformation.contract().hasDefaultClassInvariant()) {
            return;
        }
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(processingContextInformation.readerSource());
        classInvariantGenerator.addInvariantAssertionStatement(classNode, constructorNode);
    }
}

