/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BoundsBuilder
extends AbstractShapeBuilder {
    private long fixpMinX;
    private long fixpMinY;
    private long fixpMaxX;
    private long fixpMaxY;

    public BoundsBuilder(TechPool techPool) {
        this.setup(techPool);
        this.clear();
    }

    public BoundsBuilder(CellBackup cellBackup) {
        this.setup(cellBackup, null, false, true, false, null);
        this.clear();
    }

    public void clear() {
        this.fixpMinY = Long.MAX_VALUE;
        this.fixpMinX = Long.MAX_VALUE;
        this.fixpMaxY = Long.MIN_VALUE;
        this.fixpMaxX = Long.MIN_VALUE;
    }

    public boolean genBoundsEasy(ImmutableArcInst a, long[] gridCoords) {
        ArcProto protoType = this.getTechPool().getArcProto(a.protoId);
        CellBackup cellBackup = this.getCellBackup();
        if (cellBackup != null ? cellBackup.isHardArc(a.arcId) : !protoType.isEasyShape(a, false)) {
            return false;
        }
        long gridExtendOverMin = a.getGridExtendOverMin();
        long minLayerExtend = gridExtendOverMin + protoType.getMinLayerExtend().getGrid();
        if (minLayerExtend == 0L) {
            assert (protoType.getNumArcLayers() == 1);
            long x1 = a.tailLocation.getGridX();
            long y1 = a.tailLocation.getGridY();
            long x2 = a.headLocation.getGridX();
            long y2 = a.headLocation.getGridY();
            if (x1 <= x2) {
                gridCoords[0] = x1;
                gridCoords[2] = x2;
            } else {
                gridCoords[0] = x2;
                gridCoords[2] = x1;
            }
            if (y1 <= y2) {
                gridCoords[1] = y1;
                gridCoords[3] = y2;
            } else {
                gridCoords[1] = y2;
                gridCoords[3] = y1;
            }
        } else {
            boolean headExtended;
            boolean tailExtended;
            AbstractShapeBuilder.Shrinkage shrinkage = this.getShrinkage();
            if (shrinkage == null) {
                tailExtended = a.isTailExtended();
                headExtended = a.isHeadExtended();
            } else {
                tailExtended = false;
                if (a.isTailExtended()) {
                    short shrinkT = this.getShrinkage().get(a.tailNodeId);
                    if (shrinkT == 0) {
                        tailExtended = true;
                    } else if (shrinkT != 1) {
                        return false;
                    }
                }
                headExtended = false;
                if (a.isHeadExtended()) {
                    short shrinkH = this.getShrinkage().get(a.headNodeId);
                    if (shrinkH == 0) {
                        headExtended = true;
                    } else if (shrinkH != 1) {
                        return false;
                    }
                }
            }
            a.makeGridBox(gridCoords, tailExtended, headExtended, gridExtendOverMin + protoType.getMaxLayerExtend().getGrid());
        }
        return true;
    }

    public ERectangle makeBounds() {
        if (this.fixpMinX <= this.fixpMaxX) {
            long gridMinX = this.fixpMinX >> 20;
            long gridMinY = this.fixpMinY >> 20;
            long gridMaxX = -(-this.fixpMaxX >> 20);
            long gridMaxY = -(-this.fixpMaxY >> 20);
            return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
        }
        return null;
    }

    public ERectangle makeBounds(EPoint anchor, ERectangle oldBounds) {
        long gridMaxY;
        long gridMaxX;
        long gridMinY;
        long gridMinX;
        if (this.fixpMinX <= this.fixpMaxX) {
            gridMinX = this.fixpMinX >> 20;
            gridMinY = this.fixpMinY >> 20;
            gridMaxX = -(-this.fixpMaxX >> 20);
            gridMaxY = -(-this.fixpMaxY >> 20);
        } else {
            gridMinX = gridMaxX = anchor.getGridX();
            gridMinY = gridMaxY = anchor.getGridX();
        }
        if (oldBounds != null && gridMinX == oldBounds.getGridMinX() && gridMinY == oldBounds.getGridMinY() && gridMaxX == oldBounds.getGridMaxX() && gridMaxY == oldBounds.getGridMaxY()) {
            return oldBounds;
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    @Override
    public void addPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            Point2D.Double p1 = new Point2D.Double(this.coords[2], this.coords[3]);
            Point2D.Double p2 = new Point2D.Double(this.coords[4], this.coords[5]);
            Point2D.Double p0 = new Point2D.Double(this.coords[0], this.coords[1]);
            Rectangle2D bounds = GenMath.arcBBox(p1, p2, p0);
            if (bounds.getMinX() < (double)this.fixpMinX) {
                this.fixpMinX = (long)Math.rint(bounds.getMinX());
                if (bounds.getMinX() < (double)this.fixpMinX) {
                    --this.fixpMinX;
                }
            }
            if (bounds.getMinY() < (double)this.fixpMinY) {
                this.fixpMinY = (long)Math.rint(bounds.getMinY());
                if (bounds.getMinY() < (double)this.fixpMinY) {
                    --this.fixpMinY;
                }
            }
            if (bounds.getMaxX() > (double)this.fixpMaxX) {
                this.fixpMaxX = (long)Math.rint(bounds.getMaxX());
                if (bounds.getMaxX() > (double)this.fixpMaxX) {
                    ++this.fixpMaxX;
                }
            }
            if (bounds.getMaxY() > (double)this.fixpMaxY) {
                this.fixpMaxY = (long)Math.rint(bounds.getMaxY());
                if (bounds.getMaxY() > (double)this.fixpMaxY) {
                    ++this.fixpMaxY;
                }
            }
            return;
        }
        if (style == Poly.Type.CIRCLE || style == Poly.Type.THICKCIRCLE || style == Poly.Type.DISC) {
            long fixpCX = this.coords[0];
            long fixpCY = this.coords[1];
            long radius = fixpCX == this.coords[2] ? Math.abs(this.coords[3] - fixpCY) : (fixpCY == this.coords[3] ? Math.abs(this.coords[2] - fixpCX) : GenMath.ceilLong(Point2D.distance(fixpCX, fixpCY, this.coords[2], this.coords[3])));
            this.fixpMinX = Math.min(this.fixpMinX, fixpCX - radius);
            this.fixpMinY = Math.min(this.fixpMinY, fixpCY - radius);
            this.fixpMaxX = Math.max(this.fixpMaxX, fixpCX + radius);
            this.fixpMaxY = Math.max(this.fixpMaxY, fixpCY + radius);
            return;
        }
        for (int i = 0; i < numPoints; ++i) {
            long x = this.coords[i * 2];
            long y = this.coords[i * 2 + 1];
            this.fixpMinX = Math.min(this.fixpMinX, x);
            this.fixpMinY = Math.min(this.fixpMinY, y);
            this.fixpMaxX = Math.max(this.fixpMaxX, x);
            this.fixpMaxY = Math.max(this.fixpMaxY, y);
        }
    }

    @Override
    public void addBox(Layer layer) {
        this.fixpMinX = Math.min(this.fixpMinX, this.coords[0]);
        this.fixpMinY = Math.min(this.fixpMinY, this.coords[1]);
        this.fixpMaxX = Math.max(this.fixpMaxX, this.coords[2]);
        this.fixpMaxY = Math.max(this.fixpMaxY, this.coords[3]);
    }
}

