/* glDbRep.c was originally generated by the autoSql program, which also 
 * generated glDbRep.h and glDbRep.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "jksql.h"
#include "glDbRep.h"


void glStaticLoad(char **row, struct gl *ret)
/* Load a row from gl table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->frag = row[0];
ret->start = sqlUnsigned(row[1]);
ret->end = sqlUnsigned(row[2]);
strcpy(ret->strand, row[3]);
}

struct gl *glLoad(char **row)
/* Load a gl from row fetched with select * from gl
 * from database.  Dispose of this with glFree(). */
{
struct gl *ret;

AllocVar(ret);
ret->frag = cloneString(row[0]);
ret->start = sqlUnsigned(row[1]);
ret->end = sqlUnsigned(row[2]);
strcpy(ret->strand, row[3]);
return ret;
}

struct gl *glCommaIn(char **pS, struct gl *ret)
/* Create a gl out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gl */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->frag = sqlStringComma(&s);
ret->start = sqlUnsignedComma(&s);
ret->end = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
*pS = s;
return ret;
}

void glFree(struct gl **pEl)
/* Free a single dynamically allocated gl such as created
 * with glLoad(). */
{
struct gl *el;

if ((el = *pEl) == NULL) return;
freeMem(el->frag);
freez(pEl);
}

void glFreeList(struct gl **pList)
/* Free a list of dynamically allocated gl's */
{
struct gl *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    glFree(&el);
    }
*pList = NULL;
}

void glOutput(struct gl *el, FILE *f, char sep, char lastSep) 
/* Print out gl.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->frag);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->start);
fputc(sep,f);
fprintf(f, "%u", el->end);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

