/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.IEditorHistory;
import org.xmind.ui.internal.EditorHistoryPersistenceService;
import org.xmind.ui.internal.MindMapUIPlugin;

@Deprecated
public class EditorHistory
implements IEditorHistory {
    private static final String THUMBNAIL_DIR_NAME = "thumbnailHistory";
    private static final String PIN = "favor";
    protected static final int MAX_SIZE = 100;
    private List<URI> inputURIs = new ArrayList<URI>();
    private Map<URI, String> inputToInfo = new HashMap<URI, String>();
    private ListenerList listeners = new ListenerList();

    protected EditorHistory() {
        List<String> historyRepository = EditorHistoryPersistenceService.load();
        for (String inputAndInfo : historyRepository) {
            int index = inputAndInfo.indexOf("#$#");
            if (index < 0) continue;
            String input = inputAndInfo.substring(0, index);
            String info = inputAndInfo.substring(index + "#$#".length());
            try {
                URI inputURI = new URI(input);
                this.inputURIs.add(inputURI);
                this.inputToInfo.put(inputURI, info);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    @Override
    public synchronized URI[] getAllInputURIs() {
        return this.inputURIs.toArray(new URI[this.inputURIs.size()]);
    }

    @Override
    public synchronized URI[] getRecentInputURIs(int size) {
        size = Math.max(0, Math.min(size, this.inputURIs.size()));
        return this.inputURIs.subList(0, size).toArray(new URI[size]);
    }

    @Override
    public void pin(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        boolean isPin = this.isPin(inputURI);
        String info = this.getInfo(inputURI);
        if (!isPin) {
            this.inputToInfo.put(inputURI, this.appendPinContent(info));
        }
        this.add(inputURI);
    }

    @Override
    public void unPin(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        boolean isPin = this.isPin(inputURI);
        String thumbnail = this.getThumbnail(inputURI);
        if (isPin) {
            this.inputToInfo.put(inputURI, thumbnail);
        }
        this.fireChanged();
    }

    @Override
    public boolean isPin(URI inputURI) {
        boolean isPin = false;
        if (inputURI == null) {
            return isPin;
        }
        String info = this.inputToInfo.get(inputURI);
        if (info != null) {
            isPin = info.contains(PIN);
        }
        return isPin;
    }

    @Override
    public void add(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        this.remove(inputURI);
        this.inputURIs.add(0, inputURI);
        while (this.inputURIs.size() > 100) {
            this.inputURIs.remove(this.inputURIs.size() - 1);
        }
        this.fireChanged();
    }

    @Override
    public String getInfo(URI inputURI) {
        if (inputURI == null) {
            return null;
        }
        return this.inputToInfo.get(inputURI);
    }

    @Override
    public String getThumbnail(URI inputURI) {
        int sepPos;
        String info;
        if (inputURI == null) {
            return null;
        }
        String thumbnail = info = this.inputToInfo.get(inputURI);
        if (info != null && (sepPos = info.indexOf(44)) > 0) {
            thumbnail = info.substring(0, sepPos);
        }
        return thumbnail;
    }

    @Override
    public void addThumbnail(URI inputURI, String originThumbnailPath) {
        if (inputURI == null) {
            return;
        }
        File originThumbnailFile = new File(originThumbnailPath);
        if (!originThumbnailFile.exists()) {
            return;
        }
        String thumbnailName = String.valueOf(UUID.randomUUID().toString()) + originThumbnailFile.getName();
        File thumbnailDir = this.getThumbnailDir();
        if (thumbnailDir == null) {
            return;
        }
        if (!thumbnailDir.exists()) {
            thumbnailDir.mkdirs();
        }
        String thumbnailPath = String.valueOf(thumbnailDir.getAbsolutePath()) + File.separator + thumbnailName;
        File thumbnailFile = new File(thumbnailPath);
        boolean isPin = this.isPin(inputURI);
        this.removeThumbnail(inputURI);
        this.inputToInfo.put(inputURI, isPin ? this.appendPinContent(thumbnailPath) : thumbnailPath);
        this.saveThumbnailFile(originThumbnailFile, thumbnailFile);
        while (this.inputToInfo.values().size() > 100) {
            this.removeThumbnail(inputURI);
        }
        this.fireChanged();
    }

    private String appendPinContent(String source) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(source);
        buffer.append(",");
        buffer.append(PIN);
        return buffer.toString();
    }

    private File getThumbnailDir() {
        IPath basePath = MindMapUIPlugin.getDefault().getStateLocation();
        if (basePath == null) {
            return null;
        }
        IPath filePath = basePath.append(THUMBNAIL_DIR_NAME);
        return filePath.toFile();
    }

    private void saveThumbnailFile(File source, File targetFile) {
        try {
            FileUtils.transfer((InputStream)new FileInputStream(source), (OutputStream)new FileOutputStream(targetFile), (boolean)true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeThumbnail(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        String existedThumbnail = this.getThumbnail(inputURI);
        if (existedThumbnail == null) {
            return;
        }
        this.inputToInfo.remove(inputURI);
        File existedThumbnailFile = new File(existedThumbnail);
        if (existedThumbnailFile.exists()) {
            existedThumbnailFile.delete();
        }
    }

    @Override
    public synchronized void remove(URI inputURI) {
        if (inputURI == null) {
            return;
        }
        int oldSize = this.inputURIs.size();
        Iterator<URI> iter = this.inputURIs.iterator();
        while (iter.hasNext()) {
            URI oldURI = iter.next();
            if (!inputURI.equals(oldURI)) continue;
            iter.remove();
        }
        if (oldSize != this.inputURIs.size()) {
            this.fireChanged();
        }
    }

    @Override
    public synchronized void clear() {
        int oldSize = this.inputURIs.size();
        this.inputURIs.clear();
        if (oldSize != this.inputURIs.size()) {
            this.fireChanged();
        }
        this.inputToInfo.clear();
        File thumbnailDir = this.getThumbnailDir();
        if (thumbnailDir != null && thumbnailDir.exists()) {
            File[] listFiles;
            File[] fileArray = listFiles = thumbnailDir.listFiles();
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists()) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    @Override
    public void addEditorHistoryListener(IEditorHistory.IEditorHistoryListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeEditorHistoryListener(IEditorHistory.IEditorHistoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void fireChanged() {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IEditorHistory.IEditorHistoryListener)listener).editorHistoryChanged();
                }
            });
            ++n2;
        }
    }
}

