/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.util.MindMapUtils;

public class InsertImageAction
extends PageAction
implements ISelectionAction {
    private static final String PNG_FORMAT = "png";
    private static final String JPG_FORMAT = "jpg";
    private static final String JPEG_FORMAT = "jpeg";

    public InsertImageAction(IGraphicalEditorPage page) {
        super(MindMapActionFactory.INSERT_IMAGE.getId(), page);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        EditDomain domain = this.getEditDomain();
        if (domain == null) {
            return;
        }
        IGraphicalViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        ISelection selection = viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        IPart part = viewer.findPart(o);
        ITopic topic = (ITopic)part.getAdapter(ITopic.class);
        if (topic == null) {
            return;
        }
        IPart topicPart = viewer.findPart((Object)topic);
        if (topicPart == null) {
            return;
        }
        FileDialog dialog = new FileDialog(control.getShell(), 4096);
        DialogUtils.makeDefaultImageSelectorDialog(dialog, true);
        dialog.setText(DialogMessages.SelectImageDialog_title);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        String lowerPath = path.toLowerCase();
        boolean converted = false;
        if (lowerPath.endsWith(JPG_FORMAT) || lowerPath.endsWith(JPEG_FORMAT)) {
            path = InsertImageAction.convertJpegToPng(path);
            converted = true;
        }
        this.insertImage(path, topicPart, (IViewer)viewer, domain);
        if (converted) {
            FileUtils.delete((File)new File(path));
        }
    }

    protected void insertImage(String path, IPart topicPart, IViewer viewer, EditDomain domain) {
        Request request = new Request("add_image");
        request.setViewer(viewer);
        request.setPrimaryTarget(topicPart);
        request.setParameter("paths", (Object)new String[]{path});
        domain.handleRequest(request);
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isSingleTopic(selection));
    }

    private static final String convertJpegToPng(String jpg) {
        try {
            BufferedImage source = ImageIO.read(new File(jpg));
            String png = String.valueOf(jpg.substring(0, jpg.lastIndexOf(46) - 1)) + PNG_FORMAT;
            ImageIO.write((RenderedImage)source, PNG_FORMAT, new File(png));
            return png;
        }
        catch (Exception exception) {
            return jpg;
        }
    }
}

