/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.PathData;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class Path
extends org.eclipse.swt.graphics.Path {
    private static final float CORNER_CONTROL_RATIO = 0.447715f;

    public Path(Device device) {
        super(device);
    }

    public Path(Device device, PathData data) {
        super(device, data);
    }

    public void moveTo(PrecisionPoint p) {
        super.moveTo((float)p.x, (float)p.y);
    }

    public void moveTo(Point p) {
        super.moveTo((float)p.x, (float)p.y);
    }

    public void lineTo(PrecisionPoint p) {
        super.lineTo((float)p.x, (float)p.y);
    }

    public void lineTo(Point p) {
        super.lineTo((float)p.x, (float)p.y);
    }

    public void cubicTo(PrecisionPoint control1, PrecisionPoint control2, PrecisionPoint dest) {
        super.cubicTo((float)control1.x, (float)control1.y, (float)control2.x, (float)control2.y, (float)dest.x, (float)dest.y);
    }

    public void cubicTo(Point control1, Point control2, Point dest) {
        super.cubicTo((float)control1.x, (float)control1.y, (float)control2.x, (float)control2.y, (float)dest.x, (float)dest.y);
    }

    public void quadTo(PrecisionPoint control, PrecisionPoint dest) {
        super.quadTo((float)control.x, (float)control.y, (float)dest.x, (float)dest.y);
    }

    public void quadTo(Point control, Point dest) {
        super.quadTo((float)control.x, (float)control.y, (float)dest.x, (float)dest.y);
    }

    public void addArc(PrecisionRectangle bounds, float startAngle, float arcAngle) {
        super.addArc((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, startAngle, arcAngle);
    }

    public void addArc(Rectangle bounds, float startAngle, float arcAngle) {
        super.addArc((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, startAngle, arcAngle);
    }

    public void addRectangle(PrecisionRectangle bounds) {
        super.addRectangle((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height);
    }

    public void addRectangle(Rectangle bounds) {
        super.addRectangle((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height);
    }

    public void addRoundedRectangle(Rectangle bounds, float corner) {
        this.addRoundedRectangle(bounds.x, bounds.y, bounds.width, bounds.height, corner);
    }

    public void addRoundedRectangleByRatio(Rectangle bounds, float cornerRatio) {
        this.addRoundedRectangle(bounds.x, bounds.y, bounds.width, bounds.height, (float)Math.min(bounds.width, bounds.height) * cornerRatio);
    }

    public void addRoundedRectangle(PrecisionRectangle bounds, float corner) {
        this.addRoundedRectangle((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height, corner);
    }

    public void addRoundedRectangle(float x, float y, float width, float height, float corner) {
        float r = x + width;
        float b = y + height;
        float x0 = x + width / 2.0f;
        float y0 = y + height / 2.0f;
        float x1 = Math.min(x + corner, x0);
        this.moveTo(x1, y);
        float y1 = Math.min(y + corner, y0);
        float cx1 = x + (x1 - x) * 0.447715f;
        float cy1 = y + (y1 - y) * 0.447715f;
        this.cubicTo(cx1, y, x, cy1, x, y1);
        float y2 = Math.max(b - corner, y0);
        this.lineTo(x, y2);
        float cy2 = b - (b - y2) * 0.447715f;
        this.cubicTo(x, cy2, cx1, b, x1, b);
        float x2 = Math.max(r - corner, x0);
        this.lineTo(x2, b);
        float cx2 = r - (r - x2) * 0.447715f;
        this.cubicTo(cx2, b, r, cy2, r, y2);
        this.lineTo(r, y1);
        this.cubicTo(r, cy1, cx2, y, x2, y);
        this.close();
    }

    public void addRoundedPolygon(float corner, PrecisionPoint ... points) {
        if (points == null || points.length < 3) {
            return;
        }
        float[] locs = new float[points.length * 2];
        int i = 0;
        while (i < points.length) {
            PrecisionPoint p = points[i];
            locs[i * 2] = (float)p.x;
            locs[i * 2 + 1] = (float)p.y;
            ++i;
        }
        this.addRoundedPolygon(corner, locs);
    }

    public void addRoundedPolygon(float corner, float ... locs) {
        if (locs == null || locs.length < 6) {
            return;
        }
        float qc = corner / 4.0f;
        int len = locs.length;
        float[] last = null;
        int i = 0;
        while (i < len - 1) {
            float y3;
            float x1 = locs[i];
            float y1 = locs[i + 1];
            float x2 = i < len - 2 ? locs[i + 2] : locs[i - len + 2];
            float y2 = i < len - 2 ? locs[i + 3] : locs[i - len + 3];
            float x3 = i < len - 4 ? locs[i + 4] : locs[i - len + 4];
            float f = y3 = i < len - 4 ? locs[i + 5] : locs[i - len + 5];
            if (last == null) {
                last = this.calcPoint(x1, y1, x2, y2, corner);
                this.moveTo(last[0], last[1]);
            }
            float[] p1 = this.calcPoint(x2, y2, x1, y1, corner);
            this.lineTo(p1[0], p1[1]);
            float[] c1 = this.calcPoint(x2, y2, x1, y1, qc);
            float[] c2 = this.calcPoint(x2, y2, x3, y3, qc);
            float[] p2 = this.calcPoint(x2, y2, x3, y3, corner);
            this.cubicTo(c1[0], c1[1], c2[0], c2[1], p2[0], p2[1]);
            last = p2;
            i += 2;
        }
        this.close();
    }

    private float[] calcPoint(float x1, float y1, float x2, float y2, float dist) {
        float y;
        float x;
        if (x1 == x2) {
            x = x1;
            y = y1 == y2 ? y1 : y1 + dist;
        } else if (y1 == y2) {
            y = y1;
            x = x1 + dist;
        } else {
            float d = (x2 - x1) / (y2 - y1);
            float r = (float)((double)dist / Math.sqrt(d * d + 1.0f));
            if (y2 < y1) {
                r = -r;
            }
            y = r + y1;
            x = (y - y1) * d + x1;
        }
        return new float[]{x, y};
    }

    public void addString(String text, PrecisionPoint loc, Font font) {
        super.addString(text, (float)loc.x, (float)loc.y, font);
    }

    public void addString(String text, Point loc, Font font) {
        super.addString(text, (float)loc.x, (float)loc.y, font);
    }

    public PrecisionPoint getCurrentPoint() {
        float[] current = new float[2];
        this.getCurrentPoint(current);
        return new PrecisionPoint(current[0], current[1]);
    }
}

