/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.ui.properties.IEditingListener;

public abstract class PropertyEditor {
    public static final String COPY = "copy";
    public static final String CUT = "cut";
    public static final String PASTE = "paste";
    public static final String SELECT_ALL = "selectAll";
    public static final String DELETE = "delete";
    public static final String UNDO = "undo";
    public static final String REDO = "redo";
    public static final String VALUE = "value";
    public static final String ACTIVATED = "activated";
    public static final String DIRTY = "dirty";
    private Control control = null;
    private Object value = null;
    private boolean activated = false;
    private boolean dirty = false;
    private ListenerList editingListeners = new ListenerList();
    private ListenerList propertyChangeListeners = new ListenerList();
    private Map<String, Boolean> actionEnabilities = new HashMap<String, Boolean>(7);

    public void create(Composite parent) {
        this.control = this.createControl(parent);
        Assert.isNotNull((Object)this.control);
        this.deactivateWidget();
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        this.control = null;
    }

    protected abstract Control createControl(Composite var1);

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setFocus();
        }
    }

    public void setBackground(Color color) {
    }

    public void setForeground(Color color) {
    }

    public void setFont(Font font) {
    }

    protected static void setAllControlsBackground(Control control, Color color) {
        if (control != null && !control.isDisposed()) {
            control.setBackground(color);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    PropertyEditor.setAllControlsBackground(c, color);
                    ++n2;
                }
            }
        }
    }

    protected static void setAllControlsForeground(Control control, Color color) {
        if (control != null && !control.isDisposed()) {
            control.setForeground(color);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    PropertyEditor.setAllControlsForeground(c, color);
                    ++n2;
                }
            }
        }
    }

    protected static void setAllControlsFont(Control control, Font font) {
        if (control != null && !control.isDisposed()) {
            control.setFont(font);
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    PropertyEditor.setAllControlsFont(c, font);
                    ++n2;
                }
            }
        }
    }

    public void setValue(Object value) {
        Object oldValue = this.getValue();
        this.internalSetValue(value);
        this.setValueToWidget(value);
        this.clearDirty();
        Object newValue = this.getValue();
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            this.firePropertyChange(VALUE, oldValue, newValue);
        }
    }

    protected void changeValue(Object newValue) {
        Object oldValue = this.getValue();
        this.internalSetValue(newValue);
        this.markDirty();
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            this.firePropertyChange(VALUE, oldValue, newValue);
        }
    }

    protected final void internalSetValue(Object value) {
        this.value = value;
    }

    protected abstract void setValueToWidget(Object var1);

    public Object getValue() {
        return this.value;
    }

    public void activate() {
        if (this.isActivated()) {
            return;
        }
        this.activated = true;
        this.activateWidget();
        this.firePropertyChange(ACTIVATED, false, true);
    }

    public void deactivate() {
        if (!this.isActivated()) {
            return;
        }
        this.activated = false;
        this.deactivateWidget();
        this.firePropertyChange(ACTIVATED, true, false);
    }

    protected void activateWidget() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(true);
        }
    }

    protected void deactivateWidget() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        boolean oldDirty = this.dirty;
        this.dirty = true;
        if (oldDirty != this.dirty) {
            this.firePropertyChange(DIRTY, oldDirty, this.dirty);
        }
    }

    protected void clearDirty() {
        boolean oldDirty = this.dirty;
        this.dirty = false;
        if (oldDirty != this.dirty) {
            this.firePropertyChange(DIRTY, oldDirty, this.dirty);
        }
    }

    public void addEditingListener(IEditingListener listener) {
        this.editingListeners.add((Object)listener);
    }

    public void removeEditingListener(IEditingListener listener) {
        this.editingListeners.remove((Object)listener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.remove((Object)listener);
    }

    public void performAction(String actionId) {
    }

    public boolean isActionEnabled(String actionId) {
        Boolean enabled = this.actionEnabilities.get(actionId);
        return enabled != null && enabled != false;
    }

    protected void setActionEnabled(String actionId, boolean enabled) {
        boolean oldEnabled = this.isActionEnabled(actionId);
        this.actionEnabilities.put(actionId, enabled);
        boolean newEnabled = this.isActionEnabled(actionId);
        if (oldEnabled != newEnabled) {
            this.firePropertyChange(actionId, oldEnabled, newEnabled);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        Object[] listeners = this.propertyChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    protected void fireApplyEditorValue() {
        Object[] listeners = this.editingListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IEditingListener listener = (IEditingListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.editingFinished();
                }
            });
            ++i;
        }
    }

    protected void fireCancelEditing() {
        Object[] listeners = this.editingListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IEditingListener listener = (IEditingListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.editingCanceled();
                }
            });
            ++i;
        }
    }
}

