/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImageListViewer
extends StructuredViewer {
    private static Color selectionBackground = null;
    private Composite list;
    private List<Object> listMap = new ArrayList<Object>();
    private List<ImageItem> items = new ArrayList<ImageItem>();

    protected static Color getSelectionBackground() {
        if (selectionBackground == null) {
            selectionBackground = Display.getCurrent().getSystemColor(35);
        }
        return selectionBackground;
    }

    public ImageListViewer(final Composite parent, int style) {
        this.list = new Composite(parent, style){

            public boolean setFocus() {
                return super.setFocus();
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size;
                if (ImageListViewer.this.getItemCount() == 0) {
                    size = new Point(0, 0);
                    if (wHint != -1) {
                        size.x = wHint;
                    }
                    if (hHint != -1) {
                        size.y = hHint;
                    }
                    Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
                    size = new Point(trim.width, trim.height);
                } else {
                    size = super.computeSize(parent.getBounds().width, -1, true);
                }
                return size;
            }
        };
        this.list.setTabList(new Control[0]);
        this.list.setBackground(parent.getBackground());
        RowLayoutFactory.fillDefaults().spacing(0).wrap(true).applyTo(this.list);
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageListViewer.this.handleDispose(e);
            }
        });
    }

    public int getItemCount() {
        return this.listGetItemCount();
    }

    protected int listGetItemCount() {
        return this.items.size();
    }

    protected ImageItem listAdd(Image image, Object data, int index) {
        ImageItem newItem = new ImageItem(this, this.list);
        RowDataFactory.swtDefaults().hint(-1, 80).applyTo(newItem.getControl());
        newItem.setImage(image);
        newItem.setData(data);
        this.list.layout();
        if (index < 0 || index >= this.listGetItemCount()) {
            this.items.add(newItem);
        } else {
            ImageItem oldItem = this.items.get(index);
            this.items.add(index, newItem);
            newItem.getControl().moveAbove(oldItem.getControl());
        }
        return newItem;
    }

    protected ImageItem listRemove(int index) {
        if (index < 0 || index >= this.listGetItemCount()) {
            return null;
        }
        ImageItem item = this.items.remove(index);
        if (item != null) {
            item.dispose();
        }
        return item;
    }

    protected void listRemoveAll() {
        for (ImageItem item : this.items) {
            item.dispose();
        }
        this.items.clear();
    }

    protected void listSetItem(Image image, Object data, int index) {
        if (index < 0 || index >= this.listGetItemCount()) {
            return;
        }
        ImageItem item = this.items.get(index);
        if (!item.isDisposed()) {
            item.setImage(image);
            item.setData(data);
        }
    }

    protected int getElementIndex(Object element) {
        IElementComparer comparer = this.getComparer();
        if (comparer == null) {
            return this.listMap.indexOf(element);
        }
        int size = this.listMap.size();
        int i = 0;
        while (i < size) {
            if (comparer.equals(element, this.listMap.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.listMap.size()) {
            return this.listMap.get(index);
        }
        return null;
    }

    public int indexForElement(Object element) {
        ViewerComparator comparator = this.getComparator();
        if (comparator == null) {
            return this.listGetItemCount();
        }
        int count = this.listGetItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.listMap.get(mid);
            int compare = comparator.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.listMap.get(mid);
                    compare = comparator.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    public void inputChanged(Object input, Object oldInput) {
        this.listMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        this.listRemoveAll();
        int i = 0;
        while (i < size) {
            Object el = children[i];
            Image image = this.getImage((ILabelProvider)this.getLabelProvider(), el);
            ImageItem item = this.listAdd(image, el, -1);
            this.listMap.add(el);
            this.mapElement(el, (Widget)item.getControl());
            ++i;
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        if (elements.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                ImageListViewer.this.internalRemove(elements);
            }
        });
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            int ix = this.getElementIndex(elements[i]);
            if (ix >= 0) {
                ImageItem item = this.listRemove(ix);
                this.listMap.remove(ix);
                this.unmapElement(elements[i], (Widget)item.getControl());
            }
            ++i;
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        int index;
        if (element != null && (index = this.getElementIndex(element)) >= 0) {
            return this.items.get(index).getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.getElementIndex(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            Image image = this.getImage(labelProvider, element);
            this.listSetItem(image, element, ix);
        }
    }

    protected List getSelectionFromWidget() {
        ArrayList list = new ArrayList();
        return list;
    }

    protected void internalRefresh(Object element) {
        Control list = this.getControl();
        if (element == null || this.equals(element, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List selection = this.getSelectionFromWidget();
            int topIndex = -1;
            if (selection == null || selection.isEmpty()) {
                topIndex = this.listGetTopIndex();
            }
            list.setRedraw(false);
            this.listRemoveAll();
            Object[] children = this.getSortedChildren(this.getRoot());
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            int i = 0;
            while (i < children.length) {
                Object el = children[i];
                Image image = this.getImage(labelProvider, el);
                ImageItem item = this.listAdd(image, el, -1);
                this.listMap.add(el);
                this.mapElement(el, (Widget)item.getControl());
                ++i;
            }
            list.setRedraw(true);
            if (topIndex == -1) {
                this.setSelectionToWidget(selection, false);
            }
        } else {
            this.doUpdateItem((Widget)list, element, true);
        }
    }

    public void reveal(Object element) {
        IWorkbenchPage page;
        if (element == null) {
            return;
        }
        IEditorPart activeEditor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            activeEditor = page.getActiveEditor();
        }
        if (activeEditor == null) {
            return;
        }
        activeEditor.getSite().getPage().activate(activeEditor);
        ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        if (in != null && in.size() != 0) {
            int n = in.size();
            int[] ixs = new int[n];
            int count = 0;
            int i = 0;
            while (i < n) {
                Object el = in.get(i);
                int ix = this.getElementIndex(el);
                if (ix >= 0) {
                    ixs[count++] = ix;
                }
                ++i;
            }
            if (count < n) {
                int[] nArray = ixs;
                ixs = new int[count];
                System.arraycopy(nArray, 0, ixs, 0, count);
            }
        }
    }

    public Control getControl() {
        return this.list;
    }

    public Composite getListComposite() {
        return this.list;
    }

    protected int listGetTopIndex() {
        return -1;
    }

    private Image getImage(ILabelProvider labelProvider, Object element) {
        Image image = labelProvider.getImage(element);
        ImageData imageData = image.getImageData();
        if (imageData.height > 80) {
            return new Image(null, imageData.scaledTo(imageData.width * 80 / imageData.height, 80));
        }
        return image;
    }

    protected static class ImageItem {
        private ImageListViewer listViewer;
        private Object data;
        private Composite bar;
        private Label imageLabel;

        public ImageItem(ImageListViewer listViewer, Composite parent) {
            this.listViewer = listViewer;
            this.bar = new Composite(parent, 0);
            this.bar.setBackground(parent.getBackground());
            this.bar.setData((Object)this);
            RowLayoutFactory.fillDefaults().wrap(true).extendedMargins(5, 5, 1, 1).applyTo(this.bar);
            this.imageLabel = new Label(this.bar, 0);
            this.imageLabel.setImage(null);
            this.imageLabel.setBackground(this.bar.getBackground());
            RowDataFactory.swtDefaults().hint(-1, 80).applyTo((Control)this.imageLabel);
            this.addControlListeners();
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public ImageListViewer getListViewer() {
            return this.listViewer;
        }

        public Control getControl() {
            return this.bar;
        }

        protected Composite getBarComposite() {
            return this.bar;
        }

        public Image getImage() {
            return this.imageLabel.getImage();
        }

        public void setImage(Image image) {
            this.imageLabel.setImage(image);
        }

        private void addControlListeners() {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    int type = event.type;
                    switch (type) {
                        case 7: {
                            this.userExit(event);
                            break;
                        }
                        case 8: {
                            if (OpenStrategy.getOpenMethod() != 0) break;
                            this.userOpen(event);
                            break;
                        }
                        case 5: {
                            this.userSelect(event);
                            break;
                        }
                        case 3: {
                            this.userSelect(event);
                        }
                    }
                }
            };
            this.bar.addListener(8, listener);
            this.bar.addListener(5, listener);
            this.bar.addListener(7, listener);
            this.bar.addListener(3, listener);
            this.imageLabel.addListener(8, listener);
            this.imageLabel.addListener(5, listener);
            this.imageLabel.addListener(7, listener);
            this.imageLabel.addListener(3, listener);
        }

        protected void userOpen(Event e) {
            this.getListViewer().reveal(this.data);
        }

        protected void userSelect(Event e) {
            this.bar.redraw();
            this.bar.setBackground(ImageListViewer.getSelectionBackground());
            this.imageLabel.setBackground(ImageListViewer.getSelectionBackground());
        }

        protected void userExit(Event event) {
            this.bar.redraw();
            Color background = this.bar.getParent().getBackground();
            this.bar.setBackground(background);
            this.imageLabel.setBackground(background);
        }

        public void dispose() {
            this.bar.dispose();
        }

        public boolean isDisposed() {
            return this.bar.isDisposed();
        }
    }
}

