/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.xmind.core.ISheet;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.properties.PropertyMessages;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.util.ImageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WallpaperPopup
extends PopupDialog
implements IOpenListener {
    private static final Dimension FRAME_IMAGE_SIZE = new Dimension(64, 64);
    private static String WallpapersPath = null;
    private IGraphicalViewer viewer;
    private GalleryViewer galleryViewer;
    private Map<Object, Image> wallpaperPreviewImages;
    private List<String> allImageFiles;
    private List<String> loadedImageFiles;
    private Job imageLoader;
    private boolean isOpenFileDialog = false;

    public WallpaperPopup(IGraphicalViewer viewer) {
        this(viewer.getControl().getShell());
        this.viewer = viewer;
    }

    private WallpaperPopup(Shell parent) {
        super(parent, 2064, true, true, true, false, false, "Wallpapaer", null);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                event.display.asyncExec(new Runnable(){

                    public void run() {
                        WallpaperPopup.this.close();
                    }
                });
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WallpaperPopup.this.imageLoader != null) {
                    WallpaperPopup.this.imageLoader.cancel();
                    WallpaperPopup.this.imageLoader = null;
                }
                if (WallpaperPopup.this.wallpaperPreviewImages != null) {
                    WallpaperPopup.this.wallpaperPreviewImages.clear();
                }
                if (WallpaperPopup.this.allImageFiles != null) {
                    WallpaperPopup.this.allImageFiles.clear();
                }
                if (WallpaperPopup.this.loadedImageFiles != null) {
                    WallpaperPopup.this.loadedImageFiles.clear();
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.galleryViewer = new GalleryViewer();
        Properties properties = this.galleryViewer.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.FALSE);
        this.galleryViewer.setLabelProvider((IBaseLabelProvider)new WallpaperLabelProvider());
        this.galleryViewer.addOpenListener((IOpenListener)this);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        this.galleryViewer.setEditDomain(editDomain);
        this.galleryViewer.createControl(composite);
        GridData galleryData = new GridData(4, 4, true, true);
        galleryData.widthHint = 360;
        galleryData.heightHint = 300;
        this.galleryViewer.getControl().setLayoutData((Object)galleryData);
        final Display display = parent.getDisplay();
        if (this.allImageFiles != null && this.loadedImageFiles != null && this.loadedImageFiles.containsAll(this.allImageFiles)) {
            this.galleryViewer.setInput((Object)this.loadedImageFiles.toArray());
        } else {
            this.galleryViewer.setInput((Object)new Object[0]);
            display.asyncExec(new Runnable(){

                public void run() {
                    if (WallpaperPopup.this.galleryViewer.getControl() != null && !WallpaperPopup.this.galleryViewer.getControl().isDisposed()) {
                        WallpaperPopup.this.startLoadingImages(display);
                    }
                }
            });
        }
        Composite bottom = new Composite(composite, 0);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.marginWidth = 0;
        bottomLayout.marginHeight = 0;
        bottom.setLayout((Layout)bottomLayout);
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
        Button chooseFromLocalButton = new Button(bottom, 8);
        chooseFromLocalButton.setText(PropertyMessages.LocalImage_text);
        chooseFromLocalButton.setLayoutData((Object)new GridData(2, 2, true, false));
        chooseFromLocalButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WallpaperPopup.this.isOpenFileDialog = true;
                WallpaperPopup.this.openLocalImageFileDialog();
                WallpaperPopup.this.isOpenFileDialog = false;
            }
        });
        return composite;
    }

    public boolean close() {
        if (this.isOpenFileDialog) {
            return false;
        }
        return super.close();
    }

    private void startLoadingImages(final Display display) {
        if (this.imageLoader != null) {
            this.imageLoader.cancel();
            this.imageLoader = null;
        }
        this.imageLoader = new Job(PropertyMessages.LoadWallpapers_jobName){
            private Runnable refreshJob;
            {
                super($anonymous0);
                this.refreshJob = null;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (WallpaperPopup.this.allImageFiles == null) {
                    this.collectImageFiles(WallpaperPopup.getWallpapersPath());
                    if (WallpaperPopup.this.allImageFiles == null) {
                        WallpaperPopup.this.allImageFiles = Collections.emptyList();
                    }
                }
                if (WallpaperPopup.this.allImageFiles.isEmpty()) {
                    if (WallpaperPopup.this.loadedImageFiles == null || !WallpaperPopup.this.loadedImageFiles.isEmpty()) {
                        WallpaperPopup.this.loadedImageFiles = Collections.emptyList();
                    }
                    this.refreshViewer(display);
                } else if (WallpaperPopup.this.loadedImageFiles != null && WallpaperPopup.this.loadedImageFiles.containsAll(WallpaperPopup.this.allImageFiles)) {
                    this.refreshViewer(display);
                } else {
                    monitor.beginTask(null, WallpaperPopup.this.allImageFiles.size());
                    if (WallpaperPopup.this.loadedImageFiles == null) {
                        WallpaperPopup.this.loadedImageFiles = new ArrayList(WallpaperPopup.this.allImageFiles.size());
                    }
                    long lastRefresh = System.currentTimeMillis();
                    Object[] objectArray = WallpaperPopup.this.allImageFiles.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (monitor.isCanceled()) break;
                        if (!WallpaperPopup.this.loadedImageFiles.contains(o)) {
                            String path = (String)o;
                            monitor.subTask(new File(path).getName());
                            Image image = WallpaperPopup.this.getWallpaperPreviewImage(display, path);
                            if (image != null) {
                                WallpaperPopup.this.loadedImageFiles.add(path);
                            } else {
                                WallpaperPopup.this.allImageFiles.remove(path);
                            }
                        }
                        monitor.worked(1);
                        if (System.currentTimeMillis() - lastRefresh > 50L) {
                            this.refreshViewer(display);
                            lastRefresh = System.currentTimeMillis();
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        ++n2;
                    }
                }
                if (!monitor.isCanceled()) {
                    monitor.done();
                }
                WallpaperPopup.this.imageLoader = null;
                this.refreshViewer(display);
                return new Status(0, "org.xmind.ui.mindmap", 0, "Wallpaper images loaded.", null);
            }

            private void refreshViewer(Display display2) {
                if (this.refreshJob != null) {
                    return;
                }
                this.refreshJob = new Runnable(){

                    public void run() {
                        if (WallpaperPopup.this.galleryViewer != null && WallpaperPopup.this.galleryViewer.getControl() != null && !WallpaperPopup.this.galleryViewer.getControl().isDisposed() && WallpaperPopup.this.loadedImageFiles != null) {
                            WallpaperPopup.this.galleryViewer.setInput((Object)WallpaperPopup.this.loadedImageFiles.toArray());
                            WallpaperPopup.this.galleryViewer.getControl().getParent().layout();
                        }
                        refreshJob = null;
                    }
                };
                display2.asyncExec(this.refreshJob);
            }

            private void collectImageFiles(String path) {
                String ext;
                ImageFormat format;
                File file = new File(path);
                if (file.isDirectory() && path.equals(WallpaperPopup.getWallpapersPath())) {
                    String[] stringArray = file.list();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        this.collectImageFiles(new File(file, name).getAbsolutePath());
                        ++n2;
                    }
                } else if (file.isFile() && (format = ImageFormat.findByExtension((String)(ext = FileUtils.getExtension((String)path)), null)) != null) {
                    if (WallpaperPopup.this.allImageFiles == null) {
                        WallpaperPopup.this.allImageFiles = new ArrayList();
                    }
                    WallpaperPopup.this.allImageFiles.add(path);
                }
            }
        };
        this.imageLoader.schedule();
    }

    private Image getWallpaperPreviewImage(Object element) {
        return this.getWallpaperPreviewImage(Display.getCurrent(), element);
    }

    private Image getWallpaperPreviewImage(Display display, Object element) {
        Image image = null;
        if (this.wallpaperPreviewImages != null) {
            image = this.wallpaperPreviewImages.get(element);
        }
        if (image == null) {
            if (element instanceof String) {
                Image filled;
                String path = (String)element;
                try {
                    image = new Image((Device)display, path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (SWTException sWTException) {
                }
                catch (SWTError sWTError) {}
                if (image != null && (filled = WallpaperPopup.createFilledImage(display, image, FRAME_IMAGE_SIZE)) != null) {
                    image.dispose();
                    image = filled;
                }
            }
            if (image != null) {
                this.cacheWallpaperPreviewImage(element, image);
            }
        }
        return image;
    }

    private void cacheWallpaperPreviewImage(Object element, Image image) {
        if (this.wallpaperPreviewImages == null) {
            this.wallpaperPreviewImages = new HashMap<Object, Image>();
        }
        this.wallpaperPreviewImages.put(element, image);
    }

    private void openLocalImageFileDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4100);
        DialogUtils.makeDefaultImageSelectorDialog((FileDialog)dialog, (boolean)true);
        dialog.setFilterPath(WallpaperPopup.getWallpapersPath());
        dialog.setText(PropertyMessages.WallpaperDialog_title);
        String path = dialog.open();
        if (path != null) {
            this.changeWallpaper(path);
        }
    }

    private static String getWallpapersPath() {
        if (WallpapersPath == null) {
            WallpapersPath = WallpaperPopup.createWallpapersPath();
        }
        return WallpapersPath;
    }

    private static String createWallpapersPath() {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui"), (IPath)new Path("wallpaper"), null);
        try {
            url = FileLocator.toFileURL((URL)url);
        }
        catch (IOException iOException) {}
        String path = url.getFile();
        if ("".equals(path)) {
            path = new File(System.getProperty("user.home"), "Pictures").getAbsolutePath();
        }
        return path;
    }

    private void changeWallpaper(String path) {
        if (this.viewer == null) {
            return;
        }
        Request request = new Request("modify_style").setViewer((IViewer)this.viewer);
        request.setParameter("commandLabel", (Object)CommandMessages.Command_ModifySheetBackgroundColor);
        request.setParameter("styleProperty.background", (Object)path);
        request.setTargets(this.fillParts());
        this.viewer.getEditDomain().handleRequest(request);
    }

    private List<IPart> fillParts() {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        Object input = this.viewer.getInput();
        if (input instanceof IMindMap) {
            ISheet sheet = ((IMindMap)input).getSheet();
            IPart part = this.viewer.findPart((Object)sheet);
            parts.add(part);
        }
        return parts;
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(50, 50);
    }

    public void open(OpenEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof String) {
            String path = (String)o;
            this.close();
            this.changeWallpaper(path);
        }
    }

    private static Image createFilledImage(Display display, Image src, Dimension size) {
        int y;
        int x;
        int height = size.height;
        int width = size.width;
        ImageData srcData = src.getImageData();
        int srcWidth = srcData.width;
        int srcHeight = srcData.height;
        if (srcWidth == width && srcHeight == height) {
            return null;
        }
        ImageData destData = new ImageData(width, height, srcData.depth, srcData.palette);
        destData.type = srcData.type;
        destData.transparentPixel = srcData.transparentPixel;
        destData.alpha = srcData.alpha;
        if (srcData.transparentPixel != -1) {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setPixel(x, y, srcData.transparentPixel);
                    ++y;
                }
                ++x;
            }
        } else {
            x = 0;
            while (x < width) {
                y = 0;
                while (y < height) {
                    destData.setAlpha(x, y, 0);
                    ++y;
                }
                ++x;
            }
        }
        int[] pixels = new int[srcWidth];
        byte[] alphas = null;
        int startX = 0;
        while (startX < width) {
            int length = Math.min(srcWidth, width - startX);
            if (length > 0) {
                int startY = 0;
                while (startY < height) {
                    int y2 = 0;
                    while (y2 < srcHeight && startY + y2 < height) {
                        int i;
                        srcData.getPixels(0, y2, srcWidth, pixels, 0);
                        destData.setPixels(startX, startY + y2, length, pixels, 0);
                        if (srcData.alpha == -1 && srcData.alphaData != null) {
                            if (alphas == null) {
                                alphas = new byte[srcWidth];
                            }
                            srcData.getAlphas(0, y2, srcWidth, alphas, 0);
                        } else if (srcData.alpha != -1 && alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = (byte)srcData.alpha;
                                ++i;
                            }
                        } else if (alphas == null) {
                            alphas = new byte[srcWidth];
                            i = 0;
                            while (i < alphas.length) {
                                alphas[i] = -1;
                                ++i;
                            }
                        }
                        destData.setAlphas(startX, startY + y2, length, alphas, 0);
                        ++y2;
                    }
                    startY += srcHeight;
                }
            }
            startX += srcWidth;
        }
        Image image = new Image((Device)display, destData);
        return image;
    }

    private class WallpaperLabelProvider
    extends LabelProvider {
        private WallpaperLabelProvider() {
        }

        public Image getImage(Object element) {
            return WallpaperPopup.this.getWallpaperPreviewImage(element);
        }
    }
}

