/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;
import org.xmind.ui.viewers.ImageCachedLabelProvider;
import org.xmind.ui.viewers.MComboViewer;

public class TaskTreePriorityEditableTracker
extends TaskTreeEditableTracker {
    private static final Object NONE = new Object();

    public TaskTreePriorityEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    protected void edit() {
        this.editPriority();
    }

    private void editPriority() {
        MComboViewer priorityCombo = this.createPriorityCombo((Composite)this.canvas);
        final Control control = priorityCombo.getControl();
        this.locateEditor(control, this.target, this.canvas.getViewport());
        control.forceFocus();
        priorityCombo.open();
        Menu menu = priorityCombo.getMenu();
        if (menu != null) {
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuHidden(MenuEvent e) {
                    TaskTreePriorityEditableTracker.this.preCancelEditing();
                    e.display.asyncExec(new Runnable(){

                        public void run() {
                            if (control != null && !control.isDisposed()) {
                                control.dispose();
                            }
                        }
                    });
                }
            });
        }
    }

    protected MComboViewer createPriorityCombo(Composite parent) {
        MComboViewer priorityCombo = new MComboViewer(parent, 0);
        priorityCombo.getControl().setBackground(parent.getBackground());
        priorityCombo.setLabelProvider((IBaseLabelProvider)new PriorityLabelProvider());
        priorityCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        priorityCombo.setEmptySelectionImitation((Object)this);
        ArrayList<Object> input = new ArrayList<Object>(MindMapUI.getResourceManager().getSystemMarkerSheet().findMarkerGroup("priorityMarkers").getMarkers());
        input.add(0, NONE);
        priorityCombo.setInput(input);
        priorityCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TaskTreePriorityEditableTracker.this.topic == null) {
                    return;
                }
                TaskTreePriorityEditableTracker.this.changePriorityMarker(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        return priorityCombo;
    }

    private void changePriorityMarker(Object ele) {
        if (ele == NONE) {
            TaskInfoUtils.changePriorityMarker((ITopic)this.topic, (ICommandStack)this.getCommandStack(), null);
        } else if (ele instanceof IMarker) {
            TaskInfoUtils.changePriorityMarker((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (IMarker)((IMarker)ele));
        }
    }

    private class MarkerLabelProvider
    extends ImageCachedLabelProvider {
        private MarkerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IMarker) {
                ISheet sheet;
                if (TaskTreePriorityEditableTracker.this.topic != null && (sheet = TaskTreePriorityEditableTracker.this.topic.getOwnedSheet()) != null) {
                    return sheet.getLegend().getMarkerDescription(((IMarker)element).getId());
                }
                return ((IMarker)element).getName();
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            if (element instanceof IMarker) {
                return MarkerImageDescriptor.createFromMarker((IMarker)((IMarker)element), (int)16, (int)16).createImage(false);
            }
            return null;
        }
    }

    private class PriorityLabelProvider
    extends MarkerLabelProvider
    implements IColorProvider {
        private PriorityLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NONE) {
                return TaskMessages.NonePriority_text;
            }
            if (element == TaskTreePriorityEditableTracker.this) {
                return TaskMessages.SelectPriority_text;
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element == TaskTreePriorityEditableTracker.this) {
                return invalidColor;
            }
            return validColor;
        }
    }
}

