/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.search.web;

import java.util.List;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.search.SearchPlugin;
import org.xmind.ui.internal.search.web.SearchEngineRegistry;
import org.xmind.ui.internal.search.workbooks.SearchMessages;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;
import org.xmind.ui.search.ISearchEngineDescriptor;

public class SearchEnginesPreferenceSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    public static final String ID = "cn.brainy.standard.prefs.searchEngines";
    String[][] engineStringList = null;

    private SearchEngineRegistry getRegistry() {
        return SearchEngineRegistry.getInstance();
    }

    protected void createFieldEditors() {
        List<ISearchEngineDescriptor> enginesList = this.getRegistry().getVisibleEngines();
        if (this.engineStringList == null) {
            this.engineStringList = new String[enginesList.size()][2];
        }
        for (ISearchEngineDescriptor searchEngine : enginesList) {
            int index = enginesList.indexOf(searchEngine);
            this.engineStringList[index][0] = searchEngine.getShortName();
            this.engineStringList[index][1] = searchEngine.getUrl();
        }
        this.addField((FieldEditor)new ComboFieldEditor("defaultEngine", SearchMessages.SearchEnginesPrefPage_ChooseSearchEngine_label, this.engineStringList, this.getDecratorParentComposite()));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SearchPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        SearchEngineRegistry.getInstance().refreshDefaultEngine();
        return super.performOk();
    }

    public void performDefaults() {
        this.getPreferenceStore().setToDefault("defaultEngine");
        SearchEngineRegistry.getInstance().refreshDefaultEngine();
        super.performDefaults();
    }
}

