/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.document;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.MSExportWizardPage;
import org.xmind.ui.internal.aspose.exports.document.WordExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class WordExportWizard
extends DocumentExportWizard {
    private static final String PAGE_NAME = "org.xmind.ui.export.wordExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.word";
    private static final String DOC_EXT = ".doc";
    private static final String DOCX_EXT = ".docx";
    private FileDialog fileDialog;
    private WordExportPage page;

    public WordExportWizard() {
        this.setWindowTitle(ExportMessages.WordWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToWord", ExportMessages.WordExportJob_Name));
        this.page = new WordExportPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean needsPreviousAndNextButtons() {
        if (!super.needsPreviousAndNextButtons()) {
            return false;
        }
        int count = 0;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof VerifyWizardPage20141031) {
                ++count;
            }
            ++n2;
        }
        return this.getPages().length - count > 1;
    }

    protected String getFormatName() {
        if (this.getExtension() == 2) {
            return ExportMessages.Word2007Wizard_FormatName;
        }
        return ExportMessages.WordWizard_FormatName;
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        ITopic centralTopic = mindmap.getCentralTopic();
        ISheet sheet = mindmap.getSheet();
        int version = this.getExtension();
        WordExporter exporter = new WordExporter(sheet, centralTopic, this.getTargetPath(), version, this.getDialogSettings(), this.getSourceEditor());
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && (DOC_EXT.equalsIgnoreCase(extension) || DOCX_EXT.equalsIgnoreCase(extension));
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private int getExtension() {
        if (this.fileDialog == null) {
            return 1;
        }
        int filterIndex = this.fileDialog.getFilterIndex();
        String filterExtension = this.fileDialog.getFilterExtensions()[filterIndex];
        if (filterExtension.equals("*.docx")) {
            String target = this.getTargetPath();
            if (!target.contains(DOCX_EXT)) {
                this.setTargetPath(String.valueOf(target) + "x");
            }
            return 2;
        }
        return 1;
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + DOC_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToWordCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WordExportPage
    extends MSExportWizardPage {
        public WordExportPage() {
            super(WordExportWizard.PAGE_NAME, ExportMessages.WordPage_Title);
            this.setDescription(ExportMessages.WordPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.Word2007Page_FilterName);
            filterNames.add(0, ExportMessages.WordPage_FilterName);
            filterExtensions.add(0, "*.docx");
            filterExtensions.add(0, "*.doc");
            WordExportWizard.this.fileDialog = dialog;
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.createContentControls();
            this.createNumberControls();
        }
    }
}

