# GNU Enterprise Forms - GF Object Hierarchy - Static text objects
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFLabel.py 9956 2009-10-11 18:54:57Z reinhard $
"""
A class wrapping static text objects
"""

from gnue.forms.GFObjects.GFObj import GFObj

# =============================================================================
# A generic text class
# =============================================================================

class GFLabel(GFObj):

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent=None):

        GFObj.__init__(self, parent, 'GFLabel')

        # Default attributes (these may be replaced by parser)
        self.alignment = "left"


    # -------------------------------------------------------------------------
    # Implementation of virtual methods
    # -------------------------------------------------------------------------

    def _phase_1_init_ (self):
        """
        On phase 1 initialization make sure to get the current value of the
        rows- and rowSpacer-attribute. Since a GFLabel has no block it won't be
        set otherwise.
        """

        GFObj._phase_1_init_(self)

        if not hasattr(self, 'Char__height'):
            self.Char__height = int(gConfigForms('widgetHeight'))
        if not getattr(self, 'Char__width', 0):
            self.Char__width  = len(self.text)

        self._rows = getattr(self, 'rows', self._rows)
        self._gap  = getattr(self, 'rowSpacer', self._gap)
