# GNU Enterprise Forms - Curses UI Driver - VBox Widget
#
# Copyright 2000-2009 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: $

import curses

from _base import ManagedBox, box

__all__ = ['UIVBox']

# =============================================================================
# VBox class
# =============================================================================

class UIVBox(ManagedBox):
    """
    A vertical box container
    """

    vertical = True

    # -------------------------------------------------------------------------
    # Create the widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):

        ManagedBox._create_widget_(self, event, spacer)

        self._parent = event.container
        self._container = self._parent


    # -------------------------------------------------------------------------
    # Virtual methods
    # -------------------------------------------------------------------------

    def _decoration_size_(self):

        if self._gfObject.label:
            return (2, 2)
        else:
            return (0, 0)

    # -------------------------------------------------------------------------

    def _add_decoration_(self):

        if self._gfObject.label:
            attr = self._uiDriver.attr['background']
            box(self._parent, attr, self.left, self.top, self.right,
                    self.bottom, self._gfObject.label)

    # -------------------------------------------------------------------------

    def _vertical_offset_(self):

        if self._gfObject.label:
            return 1
        else:
            return 0

    # -------------------------------------------------------------------------

    def _horizontal_offset_(self):

        if self._gfObject.label:
            return 2
        else:
            return 0


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass'  : UIVBox,
  'provides'   : 'GFVBox',
  'container'  : 0,
}
