# GNU Enterprise Forms - GTK UI Driver - UIbox widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: box.py 9956 2009-10-11 18:54:57Z reinhard $

import gtk

from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

# =============================================================================
# Create a border box widget
# =============================================================================

class UIBox (UIHelper):
    
  # ---------------------------------------------------------------------------
  # Create the GTK widget
  # ---------------------------------------------------------------------------

  def _create_widget (self, event, spacer):
    gfObject = event.object
    text     = None
    if hasattr (gfObject, 'label') and len (gfObject.label):
      text = " %s " % self._makeSafe (gfObject.label)
    
    w = int (event.widgetWidth / 2)
    h = int (event.widgetHeight / 8)

    newWidget = gtk.Frame (text)
    newWidget.set_size_request (self.itemWidth - 2 * w, self.itemHeight - 8 * h)
    event.container.put (newWidget, self.itemX + w, self.itemY + h)
    newWidget.show ()

    return newWidget


# -----------------------------------------------------------------------------
# Configuration data 
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UIBox,
  'provides'   : 'GFBox',
  'container'  : 0,
}

