#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# FILE:
# uidrivers/html/UIdriver.py
#
# DESCRIPTION:
#
# NOTES:
#

import sys
import string

from gnue.forms.uidrivers._base import Exceptions
from gnue.forms.uidrivers._base.UIdriver import GFUserInterfaceBase

from gnue.common import events
from gnue.common.apps import GConfig

from gnue.forms import VERSION
from gnue.forms.GFForm import *

from gnue.forms.uidrivers.html.GFhtmlApp import *


class GFUserInterface(GFUserInterfaceBase):
    _WidgetToGFObj = {}
    _WidgetToUIObj = {}
    _IdToWidget = {}
    

    # ---------------------------------------------------------------------------
    # Constructor
    # ---------------------------------------------------------------------------
  
    def __init__ (self, *args, **params):

        GFUserInterfaceBase.__init__ (self, *args, **params)
        self.name = "HTML"
        # self._display = ...

        # self.app = getApp ()
        self._htmlapp = gethtmlApp(self)


        self.textWidth    = 12  # The pixel width of text inside a widget
        self.textHeight   = 24  # The pixel height of text inside a widget
        self.widgetWidth  = self.textWidth  # The pixel width of a 1 char widget (for things like buttons)
        self.widgetHeight = self.textHeight + 5  # The pixel height of a 1 char widget (for things like buttons)

        assert gDebug (6, "Metrics %s x %s" % (self.textWidth, self.textHeight))
   

    def mainLoop(self):
        self._htmlapp.MainLoop() # simply call the wxApp's MainLoop method

    def show(self):
        pass

    def __repr__(self):
        return "class GFUserInterface for the GNUe Forms HTML UI driver"

    # ---------------------------------------------------------------------------
    # create a modal dialog box, asking for user input
    # ---------------------------------------------------------------------------

    def _getInput (self, title, fields, cancel):
        message = ("Input required by: >>%s<<\n" % title) +\
                  "Input routines currently not supported!"
        self._UIform._ui_show_message_(message, "", title, cancel)
        # FIXME: connect to current open form
        return None
        
        
    # ---------------------------------------------------------------------------
    # create a modal message box
    # ---------------------------------------------------------------------------

    def _ui_show_error_(self, message):

        msg = u_("The following error occured in GNU Enterprise:\n%s") % message
        print msg # FIXME: use logging function
        
        self._UIform._ui_show_message_(msg, "error", "Error Message", true)


    # ---------------------------------------------------------------------------
    # Show an exception dialog
    # ---------------------------------------------------------------------------

    def _ui_show_exception_(self, group, name, message, detail):
        msg  = u_("Title: %s") % "GNU Enterprise"
        msg += u_("Group: %s") % group
        msg += u_("Name: %s") % name
        msg += u_("Message: %s") % message
        msg += u_("Detail: %s ") % detail
        print msg # FIXME: use logging function
        
        self._UIform._ui_show_message_(msg, "error", "System Error", true)
        
    # ---------------------------------------------------------------------------
    # Exit the application
    # ---------------------------------------------------------------------------

    def _ui_exit_(self):
        """
        Exit the application.
        """

        assert gEnter(6)

        self._htmlapp.quit ()

        assert gLeave(6)
