# GNU Enterprise Forms - QT3 UI driver - VBox widgets
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: vbox.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from gnue.forms.uidrivers.qt3.widgets._base import ManagedBox

__all__ = ['UIVBox']

# =============================================================================
# Interface implementation for a box widget
# =============================================================================

class UIVBox(ManagedBox):
    """
    Implementation of the <vbox> tag
    """

    # -------------------------------------------------------------------------
    # Add an item to the box
    # -------------------------------------------------------------------------

    def add_widgets(self, ui_widget, spacer):
        """
        Add a given UI widget to the vertical box.  The following widgets span
        both columns: vbox, hbox, grid and checkboxes

        @param ui_widget: widget to add
        @param spacer: not used for boxes
        """

        both = isinstance(ui_widget, ManagedBox) or \
                isinstance(ui_widget.widget, qt.QCheckBox)
        add = False

        if ui_widget.label:
            add = True
            self.sizer.addMultiCellWidget(ui_widget.label, self.last_item,
                    self.last_item, 0, 0, qt.Qt.AlignLeft | qt.Qt.AlignTop)

        if ui_widget.widget:
            add = True

            span = 0
            row = self.last_item
            left = self._entry_pos - 1
            right = left + span

            if both and not ui_widget.label:
                left = 0
                span = 1

            self.sizer.addMultiCellWidget(ui_widget.widget, row, row, left,
                    right)

        if add and ui_widget.growable:
            self.sizer.setRowStretch(self.last_item, ui_widget.stretch)

        self.last_item += int(add)


# =============================================================================
# Configuration
# =============================================================================

configuration = {
  'baseClass': UIVBox,
  'provides' : 'GFVBox',
  'container': 0
}
