[Setup]
AppId=GNUe-Navigator
AppName=GNU Enterprise Navigator
AppVerName=GNU Enterprise Navigator 0.1.0
AppPublisher=GNU Enterprise
AppPublisherURL=http://www.gnuenterprise.org
AppSupportURL=http://www.gnuenterprise.org
AppUpdatesURL=http://www.gnuenterprise.org
DefaultDirName={pf}\GNUe\
DefaultGroupName=GNUe
AllowNoIcons=true
LicenseFile=
ChangesAssociations=true
CreateAppDir=true
ShowLanguageDialog=yes
OutputBaseFilename=gnue-navigator-0.1.0.py25-win32
DisableDirPage=true
AppendDefaultDirName=false

[Files]
Source: C:\TMP\GNUe\Bin\gnue-navigator.exe; DestDir: {app}\Bin; Components: main; Flags: ignoreversion
Source: C:\TMP\GNUe\Bin\gnue\navigator\*.*; DestDir: {app}\Bin\gnue\navigator; Flags: recursesubdirs ignoreversion; Components: main
Source: C:\TMP\GNUe\share\locale\gnue-navigator.mo; DestDir: {app}\share\locale\; Flags: recursesubdirs createallsubdirs; Components: translations
Source: C:\TMP\GNUe\share\doc\gnue-navigator\*.*; DestDir: {app}\share\doc\gnue-navigator; Flags: recursesubdirs; Components: doc

[Registry]
; These four associations associate GPD files with GNUe Navigator
Root: HKCR; Subkey: .gpd; ValueType: string; ValueName: ; ValueData: GNUeNavigatorClient; Flags: uninsdeletekey deletekey
Root: HKCR; Subkey: GNUeNavigatorClient; ValueType: string; ValueName: ; ValueData: GNUe Navigator Definition; Flags: uninsdeletekey deletekey
;when we get a nifty icon, that's set here :)
Root: HKCR; Subkey: GNUeNavigatorClient\DefaultIcon; ValueType: string; ValueName: ; ValueData: {app}\bin\GNUE-NAVIGATOR.EXE,0
Root: HKCR; Subkey: GNUeNavigatorClient\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\bin\GNUE-NAVIGATOR.EXE"" ""%1"""; Flags: deletekey

[UninstallDelete]
Name: {app}\Bin\gnue\navigator\*.*; Type: filesandordirs

[Components]
Name: main; Description: Shared Program Files; Types: full compact custom; Flags: fixed
Name: doc; Description: Documentation; Types: full
Name: translations; Description: Translations; Types: full

[Code]
function GetPathInstalled(AppID: String): String;
var
  sPrevPath: String;
begin
  sPrevPath := '';
  if not RegQueryStringValue( HKLM,
    'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1',
    'Inno Setup: App Path', sPrevpath) then
    RegQueryStringValue( HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1' ,
      'Inno Setup: App Path', sPrevpath);
  Result := sPrevPath;
end;


function InitializeSetup(): Boolean;
var
  sPrevPath: String;
  sPrevID: String;
begin
  sPrevID := 'GNUe-Tools';
  sPrevPath := GetPathInstalled( sprevID );
  if ( Length(sPrevPath) > 0 ) then
    Result := true
  else begin
    MsgBox( 'GNUe-Runtime-Environment is not installed!', mbInformation, MB_OK );
    Result := false;
  end;
  if (Length(GetPathInstalled('GNUe-Common')) > 0) then
    Result := true
  else begin
    MsgBox('GNUe-Common is not installed!  Please install the GNUe-Common package in order to setup GNUe-Navigator.', mbInformation, MB_OK);
    Result := false;
  end;
  if (Length(GetPathInstalled('GNUe-Forms')) > 0) then
      Result := true
  else begin
      MsgBox('GNUe-Forms is not installed!  Please install the GNUe-Forms package in order to setup GNUe-Navigator.', mbInformation, MB_OK);
      Result := false;
  end;
end;
